/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.VideoEngine;
import org.apache.log4j.Logger;

public class BufferVertexReader {
    private static Logger log = VideoEngine.log;
    private ComponentInfo textureComponentInfo = new ComponentInfo();
    private ComponentInfo colorComponentInfo = new ComponentInfo();
    private ComponentInfo vertexComponentInfo = new ComponentInfo();
    private ComponentInfo normalComponentInfo = new ComponentInfo();
    private ComponentInfo weightComponentInfo = new ComponentInfo();

    public void setTextureComponentInfo(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.setComponentInfo(this.textureComponentInfo, size, type, stride, bufferSize, buffer);
    }

    public void setColorComponentInfo(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.setComponentInfo(this.colorComponentInfo, size, type, stride, bufferSize, buffer);
    }

    public void setVertexComponentInfo(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.setComponentInfo(this.vertexComponentInfo, size, type, stride, bufferSize, buffer);
    }

    public void setNormalComponentInfo(int type, int stride, int bufferSize, Buffer buffer) {
        this.setComponentInfo(this.normalComponentInfo, 3, type, stride, bufferSize, buffer);
    }

    public void setWeightComponentInfo(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.setComponentInfo(this.weightComponentInfo, size, type, stride, bufferSize, buffer);
    }

    private void setComponentInfo(ComponentInfo componentInfo, int size, int type, int stride, int bufferSize, Buffer buffer) {
        componentInfo.enabled = true;
        componentInfo.size = size;
        componentInfo.type = type;
        componentInfo.stride = stride;
        componentInfo.offset = buffer.position();
        componentInfo.buffer = buffer;
    }

    public void readVertex(int index, VertexState v) {
        this.readComponent(this.weightComponentInfo, index, v.boneWeights);
        this.readComponent(this.textureComponentInfo, index, v.t);
        this.readComponent(this.colorComponentInfo, index, v.c);
        this.readComponent(this.normalComponentInfo, index, v.n);
        this.readComponent(this.vertexComponentInfo, index, v.p);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Vertex %d:", index));
            if (this.weightComponentInfo.enabled) {
                log.trace((Object)String.format("  Weights(%d) %f, %f, %f, %f, %f, %f, %f, %f", this.weightComponentInfo.size, Float.valueOf(v.boneWeights[0]), Float.valueOf(v.boneWeights[1]), Float.valueOf(v.boneWeights[2]), Float.valueOf(v.boneWeights[3]), Float.valueOf(v.boneWeights[4]), Float.valueOf(v.boneWeights[5]), Float.valueOf(v.boneWeights[6]), Float.valueOf(v.boneWeights[7])));
            }
            if (this.textureComponentInfo.enabled) {
                log.trace((Object)String.format("  Texture %f, %f", Float.valueOf(v.t[0]), Float.valueOf(v.t[1])));
            }
            if (this.colorComponentInfo.enabled) {
                log.trace((Object)String.format("  Color 0x%08X", PixelColor.getColor(v.c)));
            }
            if (this.normalComponentInfo.enabled) {
                log.trace((Object)String.format("  Normal %f, %f, %f", Float.valueOf(v.n[0]), Float.valueOf(v.n[1]), Float.valueOf(v.n[2])));
            }
            if (this.vertexComponentInfo.enabled) {
                log.trace((Object)String.format("  Position %f, %f, %f", Float.valueOf(v.p[0]), Float.valueOf(v.p[1]), Float.valueOf(v.p[2])));
            }
        }
    }

    private void readComponent(ComponentInfo componentInfo, int index, float[] values) {
        if (!componentInfo.enabled) {
            return;
        }
        switch (componentInfo.type) {
            case 6: {
                for (int i = 0; i < componentInfo.size; ++i) {
                    values[i] = this.readFloat(componentInfo, index, i);
                }
                break;
            }
        }
    }

    private int getPosition(ComponentInfo componentInfo, int index, int n) {
        return componentInfo.stride * index / IRenderingEngine.sizeOfType[componentInfo.type] + n + componentInfo.offset;
    }

    private float readFloat(ComponentInfo componentInfo, int index, int n) {
        if (componentInfo.buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)componentInfo.buffer;
            return floatBuffer.get(this.getPosition(componentInfo, index, n));
        }
        if (componentInfo.buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)componentInfo.buffer;
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            return floatBuffer.get(this.getPosition(componentInfo, index, n));
        }
        return 0.0f;
    }

    private static class ComponentInfo {
        public boolean enabled = false;
        public int size;
        public int type;
        public int stride;
        public int offset;
        public Buffer buffer;

        private ComponentInfo() {
        }
    }
}

