/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.RE.software.PixelState;
import jpcsp.graphics.RE.software.PrimarySecondaryColors;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public final class Lighting {
    protected static final Logger log = VideoEngine.log;
    protected static final boolean disableLighting = false;
    private final int materialEmission;
    private final int ambient;
    private final int ambientAlpha;
    private final boolean[] lightEnabled = new boolean[4];
    private final boolean someLightsEnabled;
    private final float[][] ecLightPosition = new float[4][3];
    private final int[] lightKind = new int[4];
    private final int[] lightAmbientColor = new int[4];
    private final int[] lightDiffuseColor = new int[4];
    private final int[] lightSpecularColor = new int[4];
    private final float[] constantAttenuation = new float[4];
    private final float[] linearAttenuation = new float[4];
    private final float[] quadraticAttenuation = new float[4];
    private final float[] spotCutoff = new float[4];
    private final float[] spotCosCutoff = new float[4];
    private final float[][] ecSpotDirection = new float[4][3];
    private final float[] spotExponent = new float[4];
    private float shininess;
    private boolean separateSpecularColor;
    private boolean[] isSpotLight = new boolean[4];
    private boolean[] isDirectionalLight = new boolean[4];
    private boolean hasSomeNonDirectionalLight;
    private final float[] L = new float[3];
    private final float[] H = new float[3];
    private final float[] nL = new float[3];
    private final float[] nH = new float[3];
    private final float[] nSD = new float[3];
    private final float[] Ve = new float[3];
    private final float[] Ne = new float[3];
    private int Al;
    private int Dl;
    private int Sl;
    private boolean hasNormal;

    public Lighting(float[] viewMatrix, float[] materialEmission, float[] ambient, GeContext.EnableDisableFlag[] lightEnabled, float[][] lightPosition, int[] lightKind, int[] lightType, float[][] lightAmbientColor, float[][] lightDiffuseColor, float[][] lightSpecularColor, float[] constantAttenuation, float[] linearAttenuation, float[] quadraticAttenuation, float[] spotCutoff, float[] spotCosCutoff, float[][] spotDirection, float[] spotExponent, float shininess, int lightMode, boolean hasNormal) {
        this.materialEmission = PixelColor.getColor(materialEmission);
        this.ambient = PixelColor.getColor(ambient);
        this.ambientAlpha = PixelColor.getAlpha(this.ambient);
        this.shininess = shininess;
        this.separateSpecularColor = lightMode == 1;
        this.hasNormal = hasNormal;
        boolean someLightsEnabled = false;
        boolean hasSomeNonDirectionalLight = false;
        for (int l = 0; l < 4; ++l) {
            boolean isLightEnabled;
            this.lightEnabled[l] = isLightEnabled = lightEnabled[l].isEnabled();
            if (!isLightEnabled) continue;
            someLightsEnabled |= isLightEnabled;
            this.lightKind[l] = lightKind[l];
            this.lightAmbientColor[l] = PixelColor.getColor(lightAmbientColor[l]);
            this.lightDiffuseColor[l] = PixelColor.getColor(lightDiffuseColor[l]);
            this.lightSpecularColor[l] = PixelColor.getColor(lightSpecularColor[l]);
            this.constantAttenuation[l] = constantAttenuation[l];
            this.linearAttenuation[l] = linearAttenuation[l];
            this.quadraticAttenuation[l] = quadraticAttenuation[l];
            this.spotCutoff[l] = spotCutoff[l];
            this.spotCosCutoff[l] = spotCosCutoff[l];
            this.spotExponent[l] = spotExponent[l];
            this.isSpotLight[l] = lightType[l] == 2 && spotCutoff[l] < 180.0f;
            this.isDirectionalLight[l] = lightType[l] == 0;
            hasSomeNonDirectionalLight |= !this.isDirectionalLight[l];
            Utilities.vectorMult34(this.ecLightPosition[l], viewMatrix, lightPosition[l]);
            Utilities.vectorMult34(this.ecSpotDirection[l], viewMatrix, spotDirection[l]);
        }
        this.someLightsEnabled = someLightsEnabled;
        this.hasSomeNonDirectionalLight = hasSomeNonDirectionalLight;
    }

    private final void computeLight(int l) {
        boolean isDirectionalLight = this.isDirectionalLight[l];
        if (!this.hasNormal && isDirectionalLight) {
            this.Al = PixelColor.addBGR(this.Al, this.lightAmbientColor[l]);
            return;
        }
        float att = 1.0f;
        this.L[0] = this.ecLightPosition[l][0];
        this.L[1] = this.ecLightPosition[l][1];
        this.L[2] = this.ecLightPosition[l][2];
        if (!isDirectionalLight) {
            this.L[0] = this.L[0] - this.Ve[0];
            this.L[1] = this.L[1] - this.Ve[1];
            this.L[2] = this.L[2] - this.Ve[2];
            float d = Utilities.length3(this.L);
            att = Utilities.clamp(1.0f / (this.constantAttenuation[l] + (this.linearAttenuation[l] + this.quadraticAttenuation[l] * d) * d), 0.0f, 1.0f);
            if (this.isSpotLight[l]) {
                Utilities.normalize3(this.nSD, this.ecSpotDirection[l]);
                float spot = Utilities.dot3(this.nSD, -this.L[0], -this.L[1], -this.L[2]);
                att *= spot < this.spotCosCutoff[l] ? 0.0f : Utilities.pow(spot, this.spotExponent[l]);
            }
        }
        if (this.hasNormal) {
            this.H[0] = this.L[0];
            this.H[1] = this.L[1];
            this.H[2] = this.L[2] + 1.0f;
            Utilities.normalize3(this.nL, this.L);
            float NdotL = Utilities.max(Utilities.dot3(this.nL, this.Ne), 0.0f);
            Utilities.normalize3(this.nH, this.H);
            float NdotH = Utilities.max(Utilities.dot3(this.nH, this.Ne), 0.0f);
            float k = this.shininess;
            float Dk = this.lightKind[l] == 2 ? Utilities.max(Utilities.pow(NdotL, k), 0.0f) : NdotL;
            float Sk = this.lightKind[l] != 0 ? Utilities.max(Utilities.pow(NdotH, k), 0.0f) : 0.0f;
            this.Dl = PixelColor.addBGR(this.Dl, PixelColor.multiplyBGR(this.lightDiffuseColor[l], att * Dk));
            this.Sl = PixelColor.addBGR(this.Sl, PixelColor.multiplyBGR(this.lightSpecularColor[l], att * Sk));
        }
        this.Al = PixelColor.addBGR(this.Al, PixelColor.multiplyBGR(this.lightAmbientColor[l], att));
    }

    public final void applyLighting(PrimarySecondaryColors colors, PixelState pixel) {
        if (!(this.ambient != -1 || pixel.materialAmbient != -1 || this.someLightsEnabled && this.separateSpecularColor && this.hasNormal)) {
            colors.primaryColor = this.ambient;
            colors.secondaryColor = 0;
            return;
        }
        int primary = this.materialEmission;
        int secondary = 0;
        this.Al = this.ambient;
        if (this.someLightsEnabled) {
            if (this.hasSomeNonDirectionalLight) {
                pixel.getVe(this.Ve);
            }
            if (this.hasNormal) {
                pixel.getNormalizedNe(this.Ne);
            }
            this.Dl = 0;
            this.Sl = 0;
            for (int l = 0; l < 4; ++l) {
                if (!this.lightEnabled[l]) continue;
                this.computeLight(l);
            }
            if (this.Dl != 0) {
                primary = PixelColor.addBGR(primary, PixelColor.multiplyBGR(this.Dl, pixel.materialDiffuse));
            }
            if (this.Sl != 0) {
                if (this.separateSpecularColor) {
                    secondary = PixelColor.multiplyBGR(this.Sl, pixel.materialSpecular);
                } else {
                    primary = PixelColor.addBGR(primary, PixelColor.multiplyBGR(this.Sl, pixel.materialSpecular));
                }
            }
        }
        if (this.Al != 0) {
            primary = PixelColor.addBGR(primary, PixelColor.multiplyBGR(this.Al, pixel.materialAmbient));
        }
        colors.primaryColor = primary = PixelColor.setAlpha(primary, PixelColor.multiplyComponent(this.ambientAlpha, PixelColor.getAlpha(pixel.materialAmbient)));
        colors.secondaryColor = secondary;
    }
}

