/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.graphics.DisplayScreen;
import jpcsp.graphics.FrameBufferSettings;
import jpcsp.graphics.GEProfiler;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureManager;
import jpcsp.graphics.textures.GETexture;
import jpcsp.graphics.textures.GETextureManager;
import jpcsp.memory.IMemoryReaderWriter;
import jpcsp.memory.MemoryReaderWriter;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GLX;
import org.lwjgl.opengl.WGL;
import org.lwjgl.system.Platform;
import org.lwjgl.system.linux.X11;
import org.lwjgl.system.linux.XVisualInfo;
import org.lwjgl.system.windows.User32;

public class VideoEngineUtilities {
    public static Logger log = VideoEngine.log;
    public static final int internalTextureFormat = 3;
    private static boolean glfwInit;
    private static float monitorContentScaleX;
    private static float monitorContentScaleY;
    private static float viewportResizeScaleFactor;
    private static int viewportResizeScaleFactorInt;
    private static boolean viewportResizeScaleFactorChanged;
    private static int drawBuffer;
    private static DurationStatistics statisticsCopyGeToMemory;
    private static DurationStatistics statisticsCopyMemoryToGe;
    private static final int[] stencilPixelMasks;
    private static final int[] stencilValueMasks;
    private static final int[] stencilValueShifts;
    private static final Object geTextureLock;
    private static int geTextureId;
    private static int geTextureBufferWidth;
    private static int geTextureWidth;
    private static int geTextureHeight;
    private static int geTexturePixelFormat;

    public static void start() {
        statisticsCopyGeToMemory = new DurationStatistics("Copy GE to Memory");
        statisticsCopyMemoryToGe = new DurationStatistics("Copy Memory to GE");
    }

    public static void exit() {
    }

    public static void stop() {
        drawBuffer = 0;
        geTextureId = 0;
    }

    public static int getPixelFormatBytes(int pixelformat) {
        return IRenderingEngine.sizeOfTextureType[pixelformat];
    }

    public static void updateMonitorContentScale() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.8.") || javaVersion.startsWith("1.7.")) {
            return;
        }
        if (!glfwInit && GLFW.glfwInit()) {
            glfwInit = true;
        }
        float[] x = new float[1];
        float[] y = new float[1];
        x[0] = 1.0f;
        y[0] = 1.0f;
        GLFW.glfwGetMonitorContentScale((long)GLFW.glfwGetPrimaryMonitor(), (float[])x, (float[])y);
        monitorContentScaleX = x[0];
        monitorContentScaleY = y[0];
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("monitorContentScaleX=%f, monitorContentScaleY=%f", Float.valueOf(monitorContentScaleX), Float.valueOf(monitorContentScaleY)));
        }
    }

    public static float getMonitorContentScaleX() {
        return monitorContentScaleX;
    }

    public static float getMonitorContentScaleY() {
        return monitorContentScaleY;
    }

    public static float getViewportResizeScaleFactor() {
        return viewportResizeScaleFactor;
    }

    public static void setViewportResizeScaleFactor(float value) {
        if (value != viewportResizeScaleFactor) {
            viewportResizeScaleFactor = value;
            viewportResizeScaleFactorInt = Math.round((float)Math.ceil(value));
            viewportResizeScaleFactorChanged = true;
        }
    }

    public static int getViewportResizeScaleFactorInt() {
        return viewportResizeScaleFactorInt;
    }

    public static DisplayScreen getDisplayScreen() {
        return Modules.sceDisplayModule.getDisplayScreen();
    }

    public static void updateDisplaySize() {
        float scaleFactor = viewportResizeScaleFactor;
        VideoEngineUtilities.setDisplayMinimumSize();
        Emulator.getMainGUI().setDisplaySize(VideoEngineUtilities.getResizedWidth(VideoEngineUtilities.getDisplayScreen().getWidth()), VideoEngineUtilities.getResizedHeight(VideoEngineUtilities.getDisplayScreen().getHeight()));
        if (viewportResizeScaleFactorChanged) {
            viewportResizeScaleFactorChanged = false;
            Modules.sceDisplayModule.forceSetViewportResizeScaleFactor(scaleFactor);
        }
    }

    public static void setDisplayMinimumSize() {
        Emulator.getMainGUI().setDisplayMinimumSize(VideoEngineUtilities.getDisplayScreen().getWidth(), VideoEngineUtilities.getDisplayScreen().getHeight());
    }

    public static void drawTexture(IRenderingEngine re, int drawBufferId, int pixelFormat, int x, int y, int width, int height, int viewportWidth, int viewportHeight, float textureLowerRightS, float textureLowerRightT, float textureLowerLeftS, float textureLowerLeftT, float textureUpperLeftS, float textureUpperLeftT, float textureUpperRightS, float textureUpperRightT, boolean invert, boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        re.startDirectRendering(true, false, true, true, !invert, width, height);
        re.setColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
        re.setViewport(0, 0, viewportWidth, viewportHeight);
        re.setTextureFormat(pixelFormat, false);
        IREBufferManager bufferManager = re.getBufferManager();
        ByteBuffer drawByteBuffer = bufferManager.getBuffer(drawBufferId);
        if (drawByteBuffer == null) {
            return;
        }
        drawByteBuffer.clear();
        FloatBuffer drawFloatBuffer = drawByteBuffer.asFloatBuffer();
        drawFloatBuffer.clear();
        drawFloatBuffer.put(textureLowerRightS);
        drawFloatBuffer.put(textureLowerRightT);
        drawFloatBuffer.put(x + width);
        drawFloatBuffer.put(y + height);
        drawFloatBuffer.put(textureLowerLeftS);
        drawFloatBuffer.put(textureLowerLeftT);
        drawFloatBuffer.put(x);
        drawFloatBuffer.put(y + height);
        drawFloatBuffer.put(textureUpperLeftS);
        drawFloatBuffer.put(textureUpperLeftT);
        drawFloatBuffer.put(x);
        drawFloatBuffer.put(y);
        drawFloatBuffer.put(textureUpperRightS);
        drawFloatBuffer.put(textureUpperRightT);
        drawFloatBuffer.put(x + width);
        drawFloatBuffer.put(y);
        if (re.isVertexArrayAvailable()) {
            re.bindVertexArray(0);
        }
        re.setVertexInfo(null, false, false, true, false, 7);
        re.enableClientState(0);
        re.disableClientState(1);
        re.disableClientState(2);
        re.enableClientState(3);
        bufferManager.setTexCoordPointer(re, drawBufferId, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 0);
        bufferManager.setVertexPointer(re, drawBufferId, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 2 * VideoEngine.SIZEOF_FLOAT);
        bufferManager.setBufferData(re, 0, drawBufferId, drawFloatBuffer.position() * VideoEngine.SIZEOF_FLOAT, drawByteBuffer.rewind(), 6);
        re.drawArrays(7, 0, 4);
        re.endDirectRendering();
    }

    public static void drawFrameBuffer(IRenderingEngine re) {
        VideoEngineUtilities.drawFrameBuffer(re, true, true, Modules.sceDisplayModule.getBufferWidthFb(), Modules.sceDisplayModule.getPixelFormatFb(), Modules.sceDisplayModule.getWidthFb(), Modules.sceDisplayModule.getHeightFb());
    }

    public static void drawFrameBuffer(IRenderingEngine re, boolean keepOriginalSize, boolean invert, int bufferWidth, int pixelFormat, int width, int height) {
        DisplayScreen displayScreen = VideoEngineUtilities.getDisplayScreen();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("drawFrameBuffer keepOriginalSize=%b, invert=%b, bufferWidth=%d, pixelFormat=%d, width=%d, height=%d, %s", keepOriginalSize, invert, bufferWidth, pixelFormat, width, height, displayScreen));
        }
        float scale = 1.0f;
        int viewportWidth = width;
        int viewportHeight = height;
        if (keepOriginalSize) {
            scale = (float)VideoEngineUtilities.getResizedHeight(height) / (float)VideoEngineUtilities.getResizedHeightPow2(Utilities.makePow2(height));
            float texT = Modules.sceDisplayModule.getTexT();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("drawFrameBuffer scale = %f / %f = %f", Float.valueOf(scale), Float.valueOf(texT), Float.valueOf(scale / texT)));
            }
            scale /= texT;
        } else {
            VideoEngineUtilities.updateMonitorContentScale();
            VideoEngineUtilities.updateDisplaySize();
            viewportWidth = Math.round((float)VideoEngineUtilities.getResizedWidth(width) * monitorContentScaleX);
            viewportHeight = Math.round((float)VideoEngineUtilities.getResizedHeight(height) * monitorContentScaleY);
        }
        if (drawBuffer == 0) {
            drawBuffer = re.getBufferManager().genBuffer(re, 0, 6, 16, 6);
        }
        VideoEngineUtilities.drawTexture(re, drawBuffer, pixelFormat, 0, 0, width, height, viewportWidth, viewportHeight, displayScreen.getTextureLowerRightS() * scale, displayScreen.getTextureLowerRightT() * scale, displayScreen.getTextureLowerLeftS() * scale, displayScreen.getTextureLowerLeftT() * scale, displayScreen.getTextureUpperLeftS() * scale, displayScreen.getTextureUpperLeftT() * scale, displayScreen.getTextureUpperRightS() * scale, displayScreen.getTextureUpperRightT() * scale, invert, true, true, true, true);
    }

    public static void drawFrameBufferFromMemory(IRenderingEngine re, FrameBufferSettings fb, int texFb) {
        VideoEngineUtilities.drawFromMemory(re, texFb, fb.getBufferWidth(), fb.getPixelFormat(), fb.getHeight(), VideoEngineUtilities.getDisplayScreen().getWidth(fb), VideoEngineUtilities.getDisplayScreen().getHeight(fb), fb.getPixels());
    }

    public static void drawFromMemory(IRenderingEngine re, int textureId, int bufferWidth, int pixelFormat, int height, int renderWidth, int renderHeight, Buffer buffer) {
        buffer.clear();
        re.bindTexture(textureId);
        re.setTextureFormat(pixelFormat, false);
        re.setPixelStore(bufferWidth, VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
        int textureSize = bufferWidth * height * VideoEngineUtilities.getPixelFormatBytes(pixelFormat);
        re.setTexSubImage(0, 0, 0, bufferWidth, height, pixelFormat, pixelFormat, textureSize, buffer);
        VideoEngineUtilities.drawFrameBuffer(re, false, true, bufferWidth, pixelFormat, renderWidth, renderHeight);
    }

    public static void copyGeToMemory(IRenderingEngine re, boolean preserveScreen, boolean forceCopyToMemory) {
        VideoEngineUtilities.copyGeToMemory(re, Modules.sceDisplayModule.getTopAddrGe(), preserveScreen, forceCopyToMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyGeToMemory(IRenderingEngine re, int geTopAddress, boolean preserveScreen, boolean forceCopyToMemory) {
        if (Modules.sceDisplayModule.isUsingSoftwareRenderer()) {
            return;
        }
        int bufferWidth = Modules.sceDisplayModule.getBufferWidthGe();
        int width = Modules.sceDisplayModule.getWidthGe();
        int height = Modules.sceDisplayModule.getHeightGe();
        int pixelFormat = Modules.sceDisplayModule.getPixelFormatGe();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copy GE Screen to Memory 0x%08X-0x%08X", geTopAddress, geTopAddress + Modules.sceDisplayModule.getSizeGe()));
        }
        if (statisticsCopyGeToMemory != null) {
            statisticsCopyGeToMemory.start();
        }
        if (Modules.sceDisplayModule.getSaveGEToTexture() && !VideoEngine.getInstance().isVideoTexture(geTopAddress)) {
            GETexture geTexture = GETextureManager.getInstance().getGETexture(re, geTopAddress, bufferWidth, width, height, pixelFormat, true);
            geTexture.copyScreenToTexture(re);
        } else {
            forceCopyToMemory = true;
        }
        if (forceCopyToMemory) {
            Object object;
            int resizedBufferWidth = VideoEngineUtilities.getResizedWidthPow2(bufferWidth);
            int resizedWidth = VideoEngineUtilities.getResizedWidth(width);
            int resizedHeight = VideoEngineUtilities.getResizedHeight(height);
            if (resizedBufferWidth != geTextureBufferWidth || resizedWidth != geTextureWidth || resizedHeight != geTextureHeight || pixelFormat != geTexturePixelFormat) {
                object = geTextureLock;
                synchronized (object) {
                    if (geTextureId != 0) {
                        re.deleteTexture(geTextureId);
                    }
                    geTextureId = re.genTexture();
                    geTexturePixelFormat = pixelFormat;
                    geTextureBufferWidth = resizedBufferWidth;
                    geTextureWidth = resizedWidth;
                    geTextureHeight = resizedHeight;
                    re.bindTexture(geTextureId);
                    re.setTextureFormat(geTexturePixelFormat, false);
                    re.setTexImage(0, 3, resizedBufferWidth, VideoEngineUtilities.getResizedHeightPow2(Utilities.makePow2(height)), VideoEngineUtilities.getTexturePixelFormat(geTexturePixelFormat), VideoEngineUtilities.getTexturePixelFormat(geTexturePixelFormat), 0, null);
                    re.setTextureMipmapMinFilter(0);
                    re.setTextureMipmapMagFilter(0);
                    re.setTextureMipmapMinLevel(0);
                    re.setTextureMipmapMaxLevel(0);
                    re.setTextureWrapMode(1, 1);
                }
            }
            object = geTextureLock;
            synchronized (object) {
                re.bindTexture(geTextureId);
                re.setTextureFormat(pixelFormat, false);
                re.copyTexSubImage(0, 0, 0, 0, 0, Math.min(resizedBufferWidth, resizedWidth), resizedHeight);
                VideoEngineUtilities.drawFrameBuffer(re);
                VideoEngineUtilities.copyGeScreenToPixels(re, Modules.sceDisplayModule.getPixelsGe(geTopAddress), bufferWidth, pixelFormat, width, height);
                if (Modules.sceDisplayModule.isSaveStencilToMemory()) {
                    VideoEngineUtilities.copyStencilToMemory(re);
                }
            }
            if (preserveScreen) {
                object = geTextureLock;
                synchronized (object) {
                    re.bindTexture(geTextureId);
                    VideoEngineUtilities.drawFrameBuffer(re, false, false, Modules.sceDisplayModule.getBufferWidthGe(), Modules.sceDisplayModule.getPixelFormatGe(), Modules.sceDisplayModule.getWidthGe(), Modules.sceDisplayModule.getHeightGe());
                }
            }
        }
        if (statisticsCopyGeToMemory != null) {
            statisticsCopyGeToMemory.end();
        }
        if (GEProfiler.isProfilerEnabled()) {
            GEProfiler.copyGeToMemory();
        }
    }

    private static void copyStencilToMemory(IRenderingEngine re) {
        if (Modules.sceDisplayModule.getPixelFormatGe() >= stencilPixelMasks.length) {
            log.warn((Object)String.format("copyGeToMemory: unimplemented pixelformat %d for Stencil buffer copy", Modules.sceDisplayModule.getPixelFormatGe()));
            return;
        }
        if (stencilValueMasks[Modules.sceDisplayModule.getPixelFormatGe()] == 0) {
            return;
        }
        VideoEngine videoEngine = VideoEngine.getInstance();
        int stencilWidth = Math.min(Modules.sceDisplayModule.getWidthGe(), Modules.sceDisplayModule.getBufferWidthGe());
        int stencilHeight = Math.min(Modules.sceDisplayModule.getHeightGe(), videoEngine.getMaxSpriteHeight());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copy stencil to GE: pixelFormat=%d, %dx%d, maxSprite=%dx%d", Modules.sceDisplayModule.getPixelFormatGe(), stencilWidth, stencilHeight, videoEngine.getMaxSpriteWidth(), videoEngine.getMaxSpriteHeight()));
        }
        int stencilBufferSize = stencilWidth * stencilHeight;
        ByteBuffer tempByteBuffer = Modules.sceDisplayModule.getTempByteBuffer();
        tempByteBuffer.clear();
        re.setPixelStore(stencilWidth, 1);
        re.readStencil(0, 0, stencilWidth, stencilHeight, stencilBufferSize, tempByteBuffer);
        int bytesPerPixel = IRenderingEngine.sizeOfTextureType[Modules.sceDisplayModule.getPixelFormatGe()];
        IMemoryReaderWriter memoryReaderWriter = MemoryReaderWriter.getMemoryReaderWriter(Modules.sceDisplayModule.getTopAddrGe(), stencilHeight * Modules.sceDisplayModule.getBufferWidthGe() * bytesPerPixel, bytesPerPixel);
        tempByteBuffer.rewind();
        int stencilPixelMask = stencilPixelMasks[Modules.sceDisplayModule.getPixelFormatGe()];
        int stencilValueMask = stencilValueMasks[Modules.sceDisplayModule.getPixelFormatGe()];
        int stencilValueShift = stencilValueShifts[Modules.sceDisplayModule.getPixelFormatGe()];
        for (int y = 0; y < stencilHeight; ++y) {
            tempByteBuffer.position((stencilHeight - y - 1) * stencilWidth);
            for (int x = 0; x < stencilWidth; ++x) {
                int pixel = memoryReaderWriter.readCurrent();
                int stencilValue = tempByteBuffer.get() & stencilValueMask;
                pixel = pixel & stencilPixelMask | stencilValue << stencilValueShift;
                memoryReaderWriter.writeNext(pixel);
            }
            if (stencilWidth >= Modules.sceDisplayModule.getBufferWidthGe()) continue;
            memoryReaderWriter.skip(Modules.sceDisplayModule.getBufferWidthGe() - stencilWidth);
        }
        memoryReaderWriter.flush();
        if (GEProfiler.isProfilerEnabled()) {
            GEProfiler.copyStencilToMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyGeScreenToPixels(IRenderingEngine re, Buffer pixels, int bufferWidth, int pixelFormat, int width, int height) {
        Buffer temp = Modules.sceDisplayModule.getTempBuffer();
        Buffer buffer = pixels.capacity() >= temp.capacity() ? pixels : temp;
        buffer.clear();
        Object object = geTextureLock;
        synchronized (object) {
            re.bindTexture(geTextureId);
            re.setTextureFormat(pixelFormat, false);
            re.setPixelStore(bufferWidth, VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
            re.copyTexSubImage(0, 0, 0, 0, 0, Math.min(bufferWidth, width), height);
            re.getTexImage(0, pixelFormat, pixelFormat, buffer);
        }
        if (buffer == temp) {
            Buffer srcBuffer;
            temp.clear();
            pixels.clear();
            temp.limit(pixels.limit());
            if (temp instanceof ByteBuffer) {
                srcBuffer = (ByteBuffer)temp;
                ByteBuffer dstBuffer = (ByteBuffer)pixels;
                dstBuffer.put((ByteBuffer)srcBuffer);
            } else if (temp instanceof IntBuffer) {
                srcBuffer = (IntBuffer)temp;
                IntBuffer dstBuffer = (IntBuffer)pixels;
                VideoEngine videoEngine = VideoEngine.getInstance();
                if (videoEngine.isUsingTRXKICK() && videoEngine.getMaxSpriteHeight() < Integer.MAX_VALUE) {
                    int srcBufferWidth = bufferWidth;
                    int dstBufferWidth = bufferWidth;
                    int pixelsPerElement = 4 / VideoEngineUtilities.getPixelFormatBytes(pixelFormat);
                    int maxHeight = videoEngine.getMaxSpriteHeight();
                    int maxWidth = videoEngine.getMaxSpriteWidth();
                    int textureAlignment = pixelsPerElement == 1 ? 3 : 7;
                    maxHeight = maxHeight + textureAlignment & ~textureAlignment;
                    maxWidth = maxWidth + textureAlignment & ~textureAlignment;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("maxSpriteHeight=%d, maxSpriteWidth=%d", maxHeight, maxWidth));
                    }
                    if (maxHeight > height) {
                        maxHeight = height;
                    }
                    if (maxWidth > width) {
                        maxWidth = width;
                    }
                    VideoEngineUtilities.copyBufferByLines(dstBuffer, (IntBuffer)srcBuffer, dstBufferWidth, srcBufferWidth, pixelFormat, maxWidth, maxHeight);
                } else {
                    dstBuffer.put((IntBuffer)srcBuffer);
                }
            } else {
                throw new RuntimeException("unhandled buffer type");
            }
        }
    }

    private static void copyBufferByLines(IntBuffer dstBuffer, IntBuffer srcBuffer, int dstBufferWidth, int srcBufferWidth, int pixelFormat, int width, int height) {
        int pixelsPerElement = 4 / VideoEngineUtilities.getPixelFormatBytes(pixelFormat);
        for (int y = 0; y < height; ++y) {
            int srcStartOffset = y * srcBufferWidth / pixelsPerElement;
            int dstStartOffset = y * dstBufferWidth / pixelsPerElement;
            srcBuffer.limit(srcStartOffset + (width + 1) / pixelsPerElement);
            srcBuffer.position(srcStartOffset);
            dstBuffer.position(dstStartOffset);
            if (srcBuffer.remaining() >= dstBuffer.remaining()) continue;
            dstBuffer.put(srcBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGEToScreen(IRenderingEngine re) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reloading GE Memory (0x%08X-0x%08X) to screen (%dx%d)", Modules.sceDisplayModule.getTopAddrGe(), Modules.sceDisplayModule.getBottomAddrGe(), Modules.sceDisplayModule.getWidthGe(), Modules.sceDisplayModule.getHeightGe()));
        }
        if (statisticsCopyMemoryToGe != null) {
            statisticsCopyMemoryToGe.start();
        }
        if (Modules.sceDisplayModule.getSaveGEToTexture() && !VideoEngine.getInstance().isVideoTexture(Modules.sceDisplayModule.getTopAddrGe())) {
            GETexture geTexture = GETextureManager.getInstance().getGETexture(re, Modules.sceDisplayModule.getTopAddrGe(), Modules.sceDisplayModule.getBufferWidthGe(), Modules.sceDisplayModule.getWidthGe(), Modules.sceDisplayModule.getHeightGe(), Modules.sceDisplayModule.getPixelFormatGe(), true);
            geTexture.copyTextureToScreen(re);
        } else {
            if (re.isVertexArrayAvailable()) {
                re.bindVertexArray(0);
            }
            Object object = geTextureLock;
            synchronized (object) {
                VideoEngineUtilities.drawFromMemory(re, geTextureId, Math.min(Modules.sceDisplayModule.getBufferWidthGe(), geTextureBufferWidth), Modules.sceDisplayModule.getPixelFormatGe(), Math.min(Modules.sceDisplayModule.getHeightGe(), geTextureHeight), Math.min(Modules.sceDisplayModule.getWidthGe(), geTextureWidth), Modules.sceDisplayModule.getHeightGe(), Modules.sceDisplayModule.getPixelsGe());
            }
        }
        if (statisticsCopyMemoryToGe != null) {
            statisticsCopyMemoryToGe.end();
        }
    }

    public static boolean canShareContext() {
        switch (Platform.get()) {
            case WINDOWS: 
            case LINUX: {
                return true;
            }
        }
        return false;
    }

    public static long createContext() {
        long newContext;
        long displayWindow = Modules.sceDisplayModule.getCanvas().getDisplayWindow();
        switch (Platform.get()) {
            case WINDOWS: {
                long dc = User32.GetDC(displayWindow);
                newContext = WGL.wglCreateContext((long)dc);
                long currentContext = WGL.wglGetCurrentContext();
                if (!WGL.wglShareLists((long)currentContext, (long)newContext)) {
                    log.error((Object)String.format("VideoEngineUtilities.createContext: Cannot share context 0x%X with 0x%X", currentContext, newContext));
                }
                User32.ReleaseDC(displayWindow, dc);
                break;
            }
            case LINUX: {
                int screen = X11.XDefaultScreen(displayWindow);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("XDefaultScreen displayWindow=0x%X, screen=%d", displayWindow, screen));
                }
                XVisualInfo visualInfo = GLX.glXChooseVisual((long)displayWindow, (int)screen, (int[])new int[]{4, 5, 0});
                long currentContext = GLX.glXGetCurrentContext();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("glxCurrentContext=0x%X, XVisualInfo=%s", currentContext, visualInfo));
                }
                newContext = GLX.glXCreateContext((long)displayWindow, (XVisualInfo)visualInfo, (long)currentContext, (boolean)true);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("videoEngineContext=0x%X", newContext));
                break;
            }
            default: {
                log.error((Object)String.format("VideoEngineUtilities.createContext: Unsupported platform %s", Platform.get().getName()));
                newContext = 0L;
            }
        }
        return newContext;
    }

    public static void setContext(long context) {
        long displayWindow = Modules.sceDisplayModule.getCanvas().getDisplayWindow();
        switch (Platform.get()) {
            case WINDOWS: {
                long dc = User32.GetDC(displayWindow);
                if (!WGL.wglMakeCurrent((long)dc, (long)context)) {
                    log.error((Object)String.format("VideoEngineUtilities.setContext: Cannot make context 0x%X current", context));
                }
                User32.ReleaseDC(displayWindow, dc);
                break;
            }
            case LINUX: {
                long drawable = Modules.sceDisplayModule.getCanvas().getDisplayDrawable();
                if (GLX.glXMakeCurrent((long)displayWindow, (long)drawable, (long)context)) break;
                log.error((Object)String.format("VideoEngineUtilities.setContext: Cannot make context 0x%X current", context));
                break;
            }
            default: {
                log.error((Object)String.format("VideoEngineUtilities.setContext: Unsupported platform %s", Platform.get().getName()));
            }
        }
    }

    public static int createTexture(IRenderingEngine re, FrameBufferSettings fb, int textureId, boolean isResized) {
        if (textureId != -1) {
            re.deleteTexture(textureId);
        }
        textureId = re.genTexture();
        re.bindTexture(textureId);
        re.setTextureFormat(fb.getPixelFormat(), false);
        re.setTexImage(0, 3, isResized ? VideoEngineUtilities.getResizedWidthPow2(fb.getBufferWidth()) : fb.getBufferWidth(), isResized ? VideoEngineUtilities.getResizedHeightPow2(Utilities.makePow2(fb.getHeight())) : Utilities.makePow2(fb.getHeight()), VideoEngineUtilities.getTexturePixelFormat(fb.getPixelFormat()), VideoEngineUtilities.getTexturePixelFormat(fb.getPixelFormat()), 0, null);
        re.setTextureMipmapMinFilter(0);
        re.setTextureMipmapMagFilter(0);
        re.setTextureMipmapMinLevel(0);
        re.setTextureMipmapMaxLevel(0);
        re.setTextureWrapMode(1, 1);
        return textureId;
    }

    public static int getResizedWidth(int width) {
        return Math.round((float)width * VideoEngineUtilities.getViewportResizeScaleFactor());
    }

    public static int getResizedWidthPow2(int widthPow2) {
        return widthPow2 * VideoEngineUtilities.getViewportResizeScaleFactorInt();
    }

    public static int getResizedHeight(int height) {
        return Math.round((float)height * VideoEngineUtilities.getViewportResizeScaleFactor());
    }

    public static int getResizedHeightPow2(int heightPow2) {
        return heightPow2 * VideoEngineUtilities.getViewportResizeScaleFactorInt();
    }

    public static int getTexturePixelFormat(int pixelFormat) {
        return 3;
    }

    public static void dumpDepthBufferImage(IRenderingEngine re) {
        Buffer buffer;
        GeContext context = VideoEngine.getInstance().getContext();
        int zbp = context.zbp;
        int zbw = context.zbw;
        int height = Modules.sceDisplayModule.getHeightGe();
        int pixelFormat = 15;
        int depthBufferSize = zbw * height * IRenderingEngine.sizeOfTextureType[pixelFormat];
        if (Modules.sceDisplayModule.isUsingSoftwareRenderer()) {
            buffer = Memory.getInstance().getBuffer(zbp, depthBufferSize);
        } else {
            buffer = Modules.sceDisplayModule.getTempByteBuffer().clear();
            re.setTextureMipmapMinFilter(0);
            re.setTextureMipmapMagFilter(0);
            re.setTextureMipmapMinLevel(0);
            re.setTextureMipmapMaxLevel(0);
            re.setTextureWrapMode(1, 1);
            re.setPixelStore(zbw, VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
            re.readDepth(0, 0, zbw, height, depthBufferSize, buffer);
            buffer.rewind();
        }
        CaptureManager.dumpImage(zbp, 0, buffer, zbw, height, zbw, pixelFormat, false, 0, true, false);
    }

    static {
        monitorContentScaleX = 1.0f;
        monitorContentScaleY = 1.0f;
        viewportResizeScaleFactor = 1.0f;
        viewportResizeScaleFactorInt = 1;
        stencilPixelMasks = new int[]{0, Short.MAX_VALUE, 4095, 0xFFFFFF};
        stencilValueMasks = new int[]{0, 128, 240, 255};
        stencilValueShifts = new int[]{0, 8, 8, 24};
        geTextureLock = new Object();
    }
}

