/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.capture.CaptureManager;
import org.apache.log4j.Logger;

public class CaptureGeContext {
    public static Logger log = CaptureManager.log;
    private GeContext context;
    private int region_x1;
    private int region_y1;
    private int region_x2;
    private int region_y2;
    private int region_width;
    private int region_height;
    private int scissor_x1;
    private int scissor_y1;
    private int scissor_x2;
    private int scissor_y2;
    private int scissor_width;
    private int scissor_height;
    private int offset_x;
    private int offset_y;
    public int viewport_width;
    public int viewport_height;
    public int viewport_cx;
    public int viewport_cy;
    private boolean alphaTestFlag;
    private boolean depthTestFlag;
    private boolean scissorTestFlag;
    private boolean stencilTestFlag;
    private boolean blendFlag;
    private boolean cullFaceFlag;
    private boolean ditherFlag;
    private boolean fogFlag;
    private boolean clipPlanesFlag;
    private boolean textureFlag;
    private boolean lightingFlag;
    private boolean[] lightFlags = new boolean[4];
    private boolean lineSmoothFlag;
    private boolean patchCullFaceFlag;
    private boolean colorTestFlag;
    private boolean colorLogicOpFlag;
    private boolean faceNormalReverseFlag;
    private boolean patchFaceFlag;
    private boolean fragment2xFlag;
    private boolean reColorMaterial;
    private boolean reTextureGenS;
    private boolean reTextureGenT;
    private final float[] morph_weigth = new float[8];

    private CaptureGeContext() {
    }

    public CaptureGeContext(GeContext context) {
        this.context = context;
    }

    public void write(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(5);
        out.writeInt(this.context.region_x1);
        out.writeInt(this.context.region_y1);
        out.writeInt(this.context.region_x2);
        out.writeInt(this.context.region_y2);
        out.writeInt(this.context.region_width);
        out.writeInt(this.context.region_height);
        out.writeInt(this.context.scissor_x1);
        out.writeInt(this.context.scissor_y1);
        out.writeInt(this.context.scissor_x2);
        out.writeInt(this.context.scissor_y2);
        out.writeInt(this.context.scissor_width);
        out.writeInt(this.context.scissor_height);
        out.writeInt(this.context.offset_x);
        out.writeInt(this.context.offset_y);
        out.writeInt(this.context.viewport_width);
        out.writeInt(this.context.viewport_height);
        out.writeInt(this.context.viewport_cx);
        out.writeInt(this.context.viewport_cy);
        out.writeBoolean(this.context.alphaTestFlag.isEnabled());
        out.writeBoolean(this.context.depthTestFlag.isEnabled());
        out.writeBoolean(this.context.scissorTestFlag.isEnabled());
        out.writeBoolean(this.context.stencilTestFlag.isEnabled());
        out.writeBoolean(this.context.blendFlag.isEnabled());
        out.writeBoolean(this.context.cullFaceFlag.isEnabled());
        out.writeBoolean(this.context.ditherFlag.isEnabled());
        out.writeBoolean(this.context.fogFlag.isEnabled());
        out.writeBoolean(this.context.clipPlanesFlag.isEnabled());
        out.writeBoolean(this.context.textureFlag.isEnabled());
        out.writeBoolean(this.context.lightingFlag.isEnabled());
        for (i = 0; i < this.lightFlags.length; ++i) {
            out.writeBoolean(this.context.lightFlags[i].isEnabled());
        }
        out.writeBoolean(this.context.lineSmoothFlag.isEnabled());
        out.writeBoolean(this.context.patchCullFaceFlag.isEnabled());
        out.writeBoolean(this.context.colorTestFlag.isEnabled());
        out.writeBoolean(this.context.colorLogicOpFlag.isEnabled());
        out.writeBoolean(this.context.faceNormalReverseFlag.isEnabled());
        out.writeBoolean(this.context.patchFaceFlag.isEnabled());
        out.writeBoolean(this.context.fragment2xFlag.isEnabled());
        out.writeBoolean(this.context.reColorMaterial.isEnabled());
        out.writeBoolean(this.context.reTextureGenS.isEnabled());
        out.writeBoolean(this.context.reTextureGenT.isEnabled());
        for (i = 0; i < this.morph_weigth.length; ++i) {
            out.writeFloat(this.morph_weigth[i]);
        }
    }

    public static CaptureGeContext read(DataInputStream in) throws IOException {
        int i;
        CaptureGeContext captureGeContext = new CaptureGeContext();
        captureGeContext.region_x1 = in.readInt();
        captureGeContext.region_y1 = in.readInt();
        captureGeContext.region_x2 = in.readInt();
        captureGeContext.region_y2 = in.readInt();
        captureGeContext.region_width = in.readInt();
        captureGeContext.region_height = in.readInt();
        captureGeContext.scissor_x1 = in.readInt();
        captureGeContext.scissor_y1 = in.readInt();
        captureGeContext.scissor_x2 = in.readInt();
        captureGeContext.scissor_y2 = in.readInt();
        captureGeContext.scissor_width = in.readInt();
        captureGeContext.scissor_height = in.readInt();
        captureGeContext.offset_x = in.readInt();
        captureGeContext.offset_y = in.readInt();
        captureGeContext.viewport_width = in.readInt();
        captureGeContext.viewport_height = in.readInt();
        captureGeContext.viewport_cx = in.readInt();
        captureGeContext.viewport_cy = in.readInt();
        captureGeContext.alphaTestFlag = in.readBoolean();
        captureGeContext.depthTestFlag = in.readBoolean();
        captureGeContext.scissorTestFlag = in.readBoolean();
        captureGeContext.stencilTestFlag = in.readBoolean();
        captureGeContext.blendFlag = in.readBoolean();
        captureGeContext.cullFaceFlag = in.readBoolean();
        captureGeContext.ditherFlag = in.readBoolean();
        captureGeContext.fogFlag = in.readBoolean();
        captureGeContext.clipPlanesFlag = in.readBoolean();
        captureGeContext.textureFlag = in.readBoolean();
        captureGeContext.lightingFlag = in.readBoolean();
        for (i = 0; i < captureGeContext.lightFlags.length; ++i) {
            captureGeContext.lightFlags[i] = in.readBoolean();
        }
        captureGeContext.lineSmoothFlag = in.readBoolean();
        captureGeContext.patchCullFaceFlag = in.readBoolean();
        captureGeContext.colorTestFlag = in.readBoolean();
        captureGeContext.colorLogicOpFlag = in.readBoolean();
        captureGeContext.faceNormalReverseFlag = in.readBoolean();
        captureGeContext.patchFaceFlag = in.readBoolean();
        captureGeContext.fragment2xFlag = in.readBoolean();
        captureGeContext.reColorMaterial = in.readBoolean();
        captureGeContext.reTextureGenS = in.readBoolean();
        captureGeContext.reTextureGenT = in.readBoolean();
        for (i = 0; i < captureGeContext.morph_weigth.length; ++i) {
            captureGeContext.morph_weigth[i] = in.readFloat();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("CaptureGeContext viewport_cx=%d, viewport_cy=%d, viewport_width=%d, viewport_height=%d", captureGeContext.viewport_cx, captureGeContext.viewport_cy, captureGeContext.viewport_width, captureGeContext.viewport_height));
        }
        return captureGeContext;
    }

    public void commit(IRenderingEngine re, GeContext context) {
        context.region_x1 = this.region_x1;
        context.region_y1 = this.region_y1;
        context.region_x2 = this.region_x2;
        context.region_y2 = this.region_y2;
        context.region_width = this.region_width;
        context.region_height = this.region_height;
        context.scissor_x1 = this.scissor_x1;
        context.scissor_y1 = this.scissor_y1;
        context.scissor_x2 = this.scissor_x2;
        context.scissor_y2 = this.scissor_y2;
        context.scissor_width = this.scissor_width;
        context.scissor_height = this.scissor_height;
        context.offset_x = this.offset_x;
        context.offset_y = this.offset_y;
        context.viewport_width = this.viewport_width;
        context.viewport_height = this.viewport_height;
        context.viewport_cx = this.viewport_cx;
        context.viewport_cy = this.viewport_cy;
        context.alphaTestFlag.setEnabled(re, this.alphaTestFlag);
        context.depthTestFlag.setEnabled(re, this.depthTestFlag);
        context.scissorTestFlag.setEnabled(re, this.scissorTestFlag);
        context.stencilTestFlag.setEnabled(re, this.stencilTestFlag);
        context.blendFlag.setEnabled(re, this.blendFlag);
        context.cullFaceFlag.setEnabled(re, this.cullFaceFlag);
        context.ditherFlag.setEnabled(re, this.ditherFlag);
        context.fogFlag.setEnabled(re, this.fogFlag);
        context.clipPlanesFlag.setEnabled(re, this.clipPlanesFlag);
        context.textureFlag.setEnabled(re, this.textureFlag);
        context.lightingFlag.setEnabled(re, this.lightingFlag);
        for (int i = 0; i < this.lightFlags.length; ++i) {
            context.lightFlags[i].setEnabled(re, this.lightFlags[i]);
        }
        context.lineSmoothFlag.setEnabled(re, this.lineSmoothFlag);
        context.patchCullFaceFlag.setEnabled(re, this.patchCullFaceFlag);
        context.colorTestFlag.setEnabled(re, this.colorTestFlag);
        context.colorLogicOpFlag.setEnabled(re, this.colorLogicOpFlag);
        context.faceNormalReverseFlag.setEnabled(re, this.faceNormalReverseFlag);
        context.patchFaceFlag.setEnabled(re, this.patchFaceFlag);
        context.fragment2xFlag.setEnabled(re, this.fragment2xFlag);
        context.reColorMaterial.setEnabled(re, this.reColorMaterial);
        context.reTextureGenS.setEnabled(re, this.reTextureGenS);
        context.reTextureGenT.setEnabled(re, this.reTextureGenT);
        System.arraycopy(this.morph_weigth, 0, context.morph_weight, 0, this.morph_weigth.length);
    }
}

