/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import java.io.IOException;
import java.util.Random;
import jpcsp.hardware.BatteryUpdateThread;
import jpcsp.settings.Settings;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class Battery {
    private static final int STATE_VERSION = 0;
    private static final String settingsBatterySerialNumber = "batterySerialNumber";
    public static final int BATTERY_SERIAL_NUMBER_SERVICE = -1;
    public static final int BATTERY_SERIAL_NUMBER_AUTOBOOT = 0;
    private static int lifeTime = 300;
    private static int temperature = 28;
    private static int voltage = 4135;
    private static boolean pluggedIn = true;
    private static boolean present = true;
    private static int currentPowerPercent = 100;
    private static final int lowPercent = 12;
    private static final int forceSuspendPercent = 4;
    private static final int fullCapacity = 1800;
    private static boolean charging = false;
    public static final int EEPROM_SIZE = 256;
    private static final byte[] eeprom = new byte[256];

    public static void initialize() {
        int randomBatterySerialNumber;
        Random random = new Random();
        while ((randomBatterySerialNumber = random.nextInt()) == -1 || randomBatterySerialNumber == 0) {
        }
        int batterySerialNumber = Settings.getInstance().readInt(settingsBatterySerialNumber, randomBatterySerialNumber);
        Battery.writeEeprom(15, batterySerialNumber >> 24);
        Battery.writeEeprom(14, batterySerialNumber >> 16);
        Battery.writeEeprom(19, batterySerialNumber >> 8);
        Battery.writeEeprom(18, batterySerialNumber);
        BatteryUpdateThread.initialize();
    }

    private static void batterySerialNumberUpdated() {
        int batterySerialNumber = Battery.readEepromBatterySerialNumber();
        Settings.getInstance().writeIntHex(settingsBatterySerialNumber, batterySerialNumber);
    }

    public static int getLifeTime() {
        return lifeTime;
    }

    public static void setLifeTime(int lifeTime) {
        Battery.lifeTime = lifeTime;
    }

    public static int getTemperature() {
        return temperature;
    }

    public static void setTemperature(int temperature) {
        Battery.temperature = temperature;
    }

    public static int getVoltage() {
        return voltage;
    }

    public static void setVoltage(int voltage) {
        Battery.voltage = voltage;
    }

    public static boolean isPluggedIn() {
        return pluggedIn;
    }

    public static void setPluggedIn(boolean pluggedIn) {
        Battery.pluggedIn = pluggedIn;
    }

    public static boolean isPresent() {
        return present;
    }

    public static void setPresent(boolean present) {
        Battery.present = present;
    }

    public static int getCurrentPowerPercent() {
        return currentPowerPercent;
    }

    public static void setCurrentPowerPercent(int currentPowerPercent) {
        Battery.currentPowerPercent = currentPowerPercent;
    }

    public static boolean isCharging() {
        return charging;
    }

    public static void setCharging(boolean charging) {
        Battery.charging = charging;
    }

    public static int getLowPercent() {
        return 12;
    }

    public static int getForceSuspendPercent() {
        return 4;
    }

    public static int getFullCapacity() {
        return 1800;
    }

    public static int readEeprom(int address) {
        return eeprom[address] & 0xFF;
    }

    public static void writeEeprom(int address, int value) {
        Battery.eeprom[address] = (byte)(value & 0xFF);
        if (address == 14 || address == 15 || address == 18 || address == 19) {
            Battery.batterySerialNumberUpdated();
        }
    }

    public static int readEepromBatterySerialNumber() {
        int batterySerialNumber = 0;
        batterySerialNumber |= Battery.readEeprom(15) << 24;
        batterySerialNumber |= Battery.readEeprom(14) << 16;
        batterySerialNumber |= Battery.readEeprom(19) << 8;
        return batterySerialNumber |= Battery.readEeprom(18);
    }

    public static void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        lifeTime = stream.readInt();
        temperature = stream.readInt();
        voltage = stream.readInt();
        pluggedIn = stream.readBoolean();
        present = stream.readBoolean();
        currentPowerPercent = stream.readInt();
        charging = stream.readBoolean();
        stream.read(eeprom);
    }

    public static void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(lifeTime);
        stream.writeInt(temperature);
        stream.writeInt(voltage);
        stream.writeBoolean(pluggedIn);
        stream.writeBoolean(present);
        stream.writeInt(currentPowerPercent);
        stream.writeBoolean(charging);
        stream.write(eeprom);
    }
}

