/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.mediaengine;

import java.util.HashMap;
import java.util.Map;
import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.HLE.kernel.types.MemoryChunkList;
import jpcsp.mediaengine.MEMemory;
import jpcsp.mediaengine.MEProcessor;
import org.apache.log4j.Logger;

public class MEEmulator {
    public static Logger log = MEProcessor.log;
    private static MEEmulator instance;
    private static final int sizeAlignment = 64;
    private final MemoryChunkList freeMemoryChunks;
    private final Map<Integer, MemoryChunk> allocatedMemoryChunks;

    public static MEEmulator getInstance() {
        if (instance == null) {
            instance = new MEEmulator();
        }
        return instance;
    }

    private MEEmulator() {
        MemoryChunk initialMemory = new MemoryChunk(0, MEMemory.SIZE_ME_RAM);
        this.freeMemoryChunks = new MemoryChunkList(initialMemory);
        this.freeMemoryChunks.allocLow(65536, 64);
        this.allocatedMemoryChunks = new HashMap<Integer, MemoryChunk>();
    }

    public MEProcessor getMEProcessor() {
        return MEProcessor.getInstance();
    }

    public MEMemory getMEMemory() {
        return this.getMEProcessor().getMEMemory();
    }

    public int malloc(int size) {
        MemoryChunk memoryChunk = this.freeMemoryChunks.allocLow(size, 64);
        if (memoryChunk == null) {
            log.warn((Object)String.format("MEEmulator.malloc cannot allocate size=0x%X", size));
            return 0;
        }
        int addr = memoryChunk.addr;
        this.allocatedMemoryChunks.put(addr, memoryChunk);
        return addr;
    }

    public void free(int addr) {
        MemoryChunk memoryChunk = this.allocatedMemoryChunks.remove(addr);
        if (memoryChunk == null) {
            log.warn((Object)String.format("MEEmulator.free cannot free addr=0x%08X", addr));
            return;
        }
        this.freeMemoryChunks.add(memoryChunk);
    }

    public boolean isAllocated(int addr) {
        return this.allocatedMemoryChunks.containsKey(addr);
    }
}

