/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.TPointer8;
import jpcsp.Memory;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class ByteArrayMemory
extends Memory {
    private final byte[] memory;
    private final int offset;
    private final int baseAddress;

    public ByteArrayMemory(byte[] memory) {
        this.memory = memory;
        this.offset = 0;
        this.baseAddress = 0;
    }

    public ByteArrayMemory(byte[] memory, int offset) {
        this.memory = memory;
        this.offset = offset;
        this.baseAddress = 0;
    }

    public ByteArrayMemory(byte[] memory, int offset, int baseAddress) {
        this.memory = memory;
        this.offset = offset;
        this.baseAddress = baseAddress & 0x1FFFFFFF;
    }

    public TPointer getPointer(int address) {
        return new ByteArrayTPointer(this, address).forceNonNull();
    }

    public TPointer getPointer() {
        return this.getPointer(this.baseAddress);
    }

    public TPointer8 getPointer8(int address) {
        return new TPointer8(this, address).forceNonNull();
    }

    public TPointer8 getPointer8() {
        return this.getPointer8(this.baseAddress);
    }

    public TPointer16 getPointer16(int address) {
        return new TPointer16(this, address).forceNonNull();
    }

    public TPointer16 getPointer16() {
        return this.getPointer16(this.baseAddress);
    }

    public TPointer32 getPointer32(int address) {
        return new ByteArrayTPointer32(this, address).forceNonNull();
    }

    public TPointer32 getPointer32() {
        return this.getPointer32(this.baseAddress);
    }

    public TPointer64 getPointer64(int address) {
        return new TPointer64(this, address).forceNonNull();
    }

    public TPointer64 getPointer64() {
        return this.getPointer64(this.baseAddress);
    }

    @Override
    public void Initialise() {
    }

    private int getOffset(int address) {
        return (address & 0x1FFFFFFF) - this.baseAddress + this.offset;
    }

    @Override
    public int read32(int address) {
        return Utilities.readUnaligned32(this.memory, this.getOffset(address));
    }

    @Override
    public int read16(int address) {
        return Utilities.readUnaligned16(this.memory, this.getOffset(address));
    }

    @Override
    public int read8(int address) {
        return Utilities.read8(this.memory, this.getOffset(address));
    }

    @Override
    public void write32(int address, int value) {
        Utilities.writeUnaligned32(this.memory, this.getOffset(address), value);
    }

    @Override
    public void write16(int address, short value) {
        Utilities.writeUnaligned16(this.memory, this.getOffset(address), value & 0xFFFF);
    }

    @Override
    public void write8(int address, byte value) {
        Utilities.write8(this.memory, this.getOffset(address), value & 0xFF);
    }

    @Override
    public void memset(int address, byte data, int length) {
        for (int i = 0; i < length; ++i) {
            this.write8(address + i, data);
        }
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return null;
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        return null;
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        for (int i = 0; i < length; ++i) {
            this.write8(address + i, source.get(i));
        }
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        if (checkOverlap) {
            log.error((Object)String.format("Unimplemented memcpy destination=0x%08X, source=0x%08X, length=0x%X, checkOverlap=%b", destination, source, length, checkOverlap));
        } else {
            for (int i = 0; i < length; ++i) {
                this.write8(destination + i, (byte)this.read8(source + i));
            }
        }
    }

    public int getSize() {
        return this.memory.length - this.offset;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        int size = stream.readInt();
        int length = Math.min(size, this.getSize());
        stream.readBytes(this.memory, this.offset, length);
        if (length < size) {
            stream.skipBytes(size - length);
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        int size = this.getSize();
        stream.writeInt(size);
        stream.writeBytes(this.memory, this.offset, size);
    }

    private static class ByteArrayTPointer
    extends TPointer {
        public ByteArrayTPointer(Memory memory, int address) {
            super(memory, address);
        }

        @Override
        public Memory getNewPointerMemory() {
            return Memory.getInstance();
        }
    }

    private static class ByteArrayTPointer32
    extends TPointer32 {
        public ByteArrayTPointer32(Memory memory, int address) {
            super(memory, address);
        }

        @Override
        public Memory getNewPointerMemory() {
            return Memory.getInstance();
        }
    }
}

