/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.modules.memlmd;
import jpcsp.Memory;
import jpcsp.crypto.KeyVault;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.IMMIOHandler;
import jpcsp.memory.mmio.MMIOHandlerA7F00000;
import jpcsp.memory.mmio.MMIOHandlerAudio;
import jpcsp.memory.mmio.MMIOHandlerCpuBusFrequency;
import jpcsp.memory.mmio.MMIOHandlerDdr;
import jpcsp.memory.mmio.MMIOHandlerDisplayController;
import jpcsp.memory.mmio.MMIOHandlerDisplayControllerSlim;
import jpcsp.memory.mmio.MMIOHandlerDmac;
import jpcsp.memory.mmio.MMIOHandlerDmacplus;
import jpcsp.memory.mmio.MMIOHandlerGe;
import jpcsp.memory.mmio.MMIOHandlerGeEdram;
import jpcsp.memory.mmio.MMIOHandlerGpio;
import jpcsp.memory.mmio.MMIOHandlerI2c;
import jpcsp.memory.mmio.MMIOHandlerInterruptMan;
import jpcsp.memory.mmio.MMIOHandlerKirk;
import jpcsp.memory.mmio.MMIOHandlerLcdControllerSlim;
import jpcsp.memory.mmio.MMIOHandlerLcdc;
import jpcsp.memory.mmio.MMIOHandlerMeController;
import jpcsp.memory.mmio.MMIOHandlerMemoryAccessControl;
import jpcsp.memory.mmio.MMIOHandlerNand;
import jpcsp.memory.mmio.MMIOHandlerNandPage;
import jpcsp.memory.mmio.MMIOHandlerPower;
import jpcsp.memory.mmio.MMIOHandlerProfiler;
import jpcsp.memory.mmio.MMIOHandlerReadWrite;
import jpcsp.memory.mmio.MMIOHandlerSystemControl;
import jpcsp.memory.mmio.MMIOHandlerSystemTime;
import jpcsp.memory.mmio.MMIOHandlerTimer;
import jpcsp.memory.mmio.MMIOHandlerUsb;
import jpcsp.memory.mmio.eflash.MMIOHandlerEFlash;
import jpcsp.memory.mmio.eflash.MMIOHandlerEFlashAta;
import jpcsp.memory.mmio.eflash.MMIOHandlerEFlashDma;
import jpcsp.memory.mmio.memorystick.MMIOHandlerMemoryStick;
import jpcsp.memory.mmio.syscon.MMIOHandlerSyscon;
import jpcsp.memory.mmio.uart.MMIOHandlerUart3;
import jpcsp.memory.mmio.uart.MMIOHandlerUart4;
import jpcsp.memory.mmio.umd.MMIOHandlerAta2;
import jpcsp.memory.mmio.umd.MMIOHandlerUmd;
import jpcsp.memory.mmio.umd.MMIOHandlerUmdAta;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlan;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIO
extends Memory {
    private static final int STATE_VERSION = 0;
    private final Memory mem;
    private final Map<Integer, IMMIOHandler> handlers = new HashMap<Integer, IMMIOHandler>(40000);
    protected static final boolean[] validMemoryPage = new boolean[Memory.validMemoryPage.length];
    private final Map<Integer, IMMIOHandler> sortedHandlers = new TreeMap<Integer, IMMIOHandler>();

    public MMIO(Memory mem) {
        this.mem = mem;
    }

    @Override
    public boolean allocate() {
        System.arraycopy(Memory.validMemoryPage, 0, validMemoryPage, 0, validMemoryPage.length);
        Arrays.fill(validMemoryPage, 770048, 786432, true);
        return true;
    }

    @Override
    public void reset() {
        for (IMMIOHandler handler : this.sortedHandlers.values()) {
            handler.reset();
        }
    }

    public Memory getBackendMemory() {
        return this.mem;
    }

    @Override
    public void Initialise() {
        this.handlers.clear();
        this.addHandler(-1477443584, 36, new MMIOHandlerA7F00000(-1477443584), 4);
        this.addHandlerRW(-1476919296, 8192, 4);
        this.addHandler(-1140850688, 128, new MMIOHandlerMemoryAccessControl(-1140850688));
        this.addHandler(-1139802112, 260, MMIOHandlerSystemControl.getInstance());
        this.addHandler(-1138753536, 8, new MMIOHandlerCpuBusFrequency(-1138753536));
        this.addHandler(-1137704960, 48, MMIOHandlerInterruptMan.getProxyInstance());
        this.addHandler(-1136656384, 84, new MMIOHandlerProfiler(-1136656384));
        this.addHandler(-1135607808, 16, new int[]{256}, new MMIOHandlerTimer(-1135607808, 15));
        this.addHandler(-1135607792, 16, new int[]{256}, new MMIOHandlerTimer(-1135607792, 16));
        this.addHandler(-1135607776, 16, new int[]{256}, new MMIOHandlerTimer(-1135607776, 17));
        this.addHandler(-1135607760, 16, new int[]{256}, new MMIOHandlerTimer(-1135607760, 18));
        this.addHandler(-1134559232, 20, new MMIOHandlerSystemTime(-1134559232));
        this.addHandler(-1132462080, 468, new MMIOHandlerDmacplus(-1132462080));
        this.addHandler(-1131413504, 500, new MMIOHandlerDmac(-1131413504));
        this.addHandler(-1130364928, 500, new MMIOHandlerDmac(-1130364928));
        this.addHandler(-1128267776, 116, new MMIOHandlerMeController(-1128267776));
        this.addHandler(-1124073472, 72, MMIOHandlerDdr.getInstance());
        this.addHandler(-1123020800, 772, MMIOHandlerNand.getInstance());
        this.addHandler(-1121976320, 68, MMIOHandlerMemoryStick.getInstance());
        this.addHandler(-1120927744, 68, MMIOHandlerWlan.getInstance());
        this.addHandler(-1119879168, 3664, MMIOHandlerGe.getInstance());
        this.addHandler(-1118830592, 148, new MMIOHandlerGeEdram(-1118830592));
        this.addHandler(-1117782016, 80, new MMIOHandlerAta2(-1117782016));
        this.addHandler(-1116733440, 15, MMIOHandlerUmdAta.getInstance());
        this.addHandler(-1115684864, 1304, MMIOHandlerUsb.getInstance());
        if (Model.getModel() == 4) {
            this.addHandler(-1114636288, 72, MMIOHandlerEFlash.getInstance());
            this.addHandler(-1113587712, 16, MMIOHandlerEFlashAta.getInstance());
            this.addHandler(-1112539136, 72, new MMIOHandlerEFlashDma(-1112539136));
        }
        this.addHandler(-1109393408, 60, MMIOHandlerKirk.getInstance());
        this.addHandler(-1108344832, 152, MMIOHandlerUmd.getInstance());
        this.addHandler(-1107296256, 128, MMIOHandlerAudio.getInstance());
        this.addHandler(-1105985536, 516, new MMIOHandlerLcdc(-1105985536));
        this.addHandler(-1105199104, 48, new MMIOHandlerI2c(-1105199104));
        this.addHandler(-1104936960, 76, MMIOHandlerGpio.getInstance());
        this.addHandler(-1104150528, 96, new MMIOHandlerPower(-1104150528));
        this.addHandler(-1102315520, 72, new MMIOHandlerUart4(-1102315520));
        this.addHandler(-1102053376, 72, new MMIOHandlerUart3(-1102053376));
        this.addHandler(-1101529088, 40, MMIOHandlerSyscon.getInstance());
        this.addHandler(-1101266944, 40, new MMIOHandlerLcdControllerSlim(-1101266944), 2);
        this.addHandler(-1099694080, 40, MMIOHandlerDisplayController.getInstance());
        this.addHandler(-1099431936, 32, new MMIOHandlerDisplayControllerSlim(-1099431936), 2);
        this.addHandlerRW(-1317011456, 4);
        this.addHandlerRW(-1342177280, 4);
        this.addHandlerRW(-1077936128, 0x100000);
        this.addHandlerRW(-1076887552, 0x100000);
        this.addHandler(-1074790400, 2316, MMIOHandlerNandPage.getInstance());
        this.addHandler(-1611661312, 2316, MMIOHandlerNandPage.getInstance());
        this.initMMIO();
    }

    private void xorKey(int keyAddr, int[] key, int[] xorInts) {
        byte[] xorBytes = memlmd.getKey(xorInts);
        for (int i = 0; i < xorBytes.length; ++i) {
            this.write8(keyAddr + i, (byte)(key[i] ^ xorBytes[i]));
        }
    }

    public static int[] getXorKeyBFD00210() {
        switch (Model.getGeneration()) {
            case 2: {
                return new int[]{1402780727, 2093600028, 1712488534, 1394362737};
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                return new int[]{-628645349, -1741948387, -600670092, 1465564903};
            }
            case 5: {
                return new int[]{721209295, -943176395, -692468113, 693610835};
            }
        }
        return null;
    }

    public static int[] getKeyBFD00210() {
        switch (Model.getGeneration()) {
            case 2: {
                return KeyVault.keys660_k2;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                return KeyVault.keys660_k7;
            }
            case 5: {
                return KeyVault.keys660_k5;
            }
        }
        return null;
    }

    private void initMMIO() {
        switch (Model.getGeneration()) {
            case 1: {
                this.xorKey(-1076887040, KeyVault.keys660_k1, new int[]{607683440, -1251607999, 1219345060, 1407185083});
                break;
            }
            case 2: {
                this.xorKey(-1076887040, KeyVault.keys660_k1, new int[]{-1990106625, -1128774213, 1842641769, 1137142512});
                this.xorKey(-1076887024, MMIO.getKeyBFD00210(), MMIO.getXorKeyBFD00210());
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                this.xorKey(-1076887040, KeyVault.keys660_k1, new int[]{-1460274123, 2139975097, 458118163, 353352348});
                this.xorKey(-1076887024, MMIO.getKeyBFD00210(), MMIO.getXorKeyBFD00210());
                break;
            }
            case 5: {
                this.xorKey(-1076887040, KeyVault.keys660_k1, new int[]{1145912988, 2145265046, 1391617062, -527296820});
                this.xorKey(-1076887024, MMIO.getKeyBFD00210(), MMIO.getXorKeyBFD00210());
                break;
            }
            default: {
                log.error((Object)String.format("Unimplemented MMIO initialization for PSP Model %s", Model.getModelName()));
            }
        }
    }

    protected void addHandler(int baseAddress, int length, IMMIOHandler handler) {
        this.addHandler(baseAddress, length, null, handler);
    }

    protected void addHandler(int baseAddress, int length, IMMIOHandler handler, int minimumGeneration) {
        if (Model.getGeneration() >= minimumGeneration) {
            this.addHandler(baseAddress, length, handler);
        }
    }

    private void addHandler(int baseAddress, int length, int[] additionalOffsets, IMMIOHandler handler) {
        this.sortedHandlers.put(baseAddress, handler);
        for (int i = 0; i < length; ++i) {
            this.handlers.put(baseAddress + i, handler);
        }
        if (additionalOffsets != null) {
            for (int offset : additionalOffsets) {
                this.handlers.put(baseAddress + offset, handler);
            }
        }
    }

    protected void addHandlerRW(int baseAddress, int length) {
        this.addHandlerRW(baseAddress, length, null);
    }

    protected void addHandlerRW(int baseAddress, int length, int minimumGeneration) {
        if (Model.getGeneration() >= minimumGeneration) {
            this.addHandlerRW(baseAddress, length);
        }
    }

    protected void addHandlerRW(int baseAddress, int length, Logger log) {
        MMIOHandlerReadWrite handler = new MMIOHandlerReadWrite(baseAddress, length);
        if (log != null) {
            handler.setLogger(log);
        }
        this.addHandler(baseAddress, length, handler);
    }

    private void removeHandler(int baseAddress, int length) {
        for (int i = 0; i < length; ++i) {
            this.handlers.remove(baseAddress + i);
        }
    }

    @Override
    public void remapMemoryAtProcessorReset() {
        int size = 0x100000;
        this.memcpy(-1077936128, -1076887552, 0x100000);
        RuntimeContext.invalidateRange(-1077936128, 0x100000);
        this.removeHandler(-1076887552, 0x100000);
        RuntimeContext.removeCodeBlocks(-1076887552, 0x100000);
    }

    protected IMMIOHandler getHandler(int address) {
        return this.handlers.get(address);
    }

    private boolean hasHandler(int address) {
        return this.handlers.containsKey(address);
    }

    public static boolean isAddressGood(int address) {
        return validMemoryPage[address >>> 12];
    }

    @Override
    public int normalize(int address) {
        if (this.hasHandler(address)) {
            return address;
        }
        return this.mem.normalize(address);
    }

    public static int normalizeAddress(int addr) {
        if (addr >= 0x1C000000 && addr <= 0x1FFFFFFF) {
            addr |= 0xA0000000;
        }
        return addr;
    }

    @Override
    public int read8(int address) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            return handler.read8(address);
        }
        return this.mem.read8(address);
    }

    @Override
    public int read16(int address) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            return handler.read16(address);
        }
        return this.mem.read16(address);
    }

    @Override
    public int read32(int address) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            return handler.read32(address);
        }
        return this.mem.read32(address);
    }

    @Override
    public int internalRead8(int address) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            return handler.internalRead8(address);
        }
        return this.mem.internalRead8(address);
    }

    @Override
    public int internalRead16(int address) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            return handler.internalRead16(address);
        }
        return this.mem.internalRead16(address);
    }

    @Override
    public int internalRead32(int address) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            return handler.internalRead32(address);
        }
        return this.mem.internalRead32(address);
    }

    @Override
    public void write8(int address, byte data) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            handler.write8(address, data);
        } else {
            this.mem.write8(address, data);
        }
    }

    @Override
    public void write16(int address, short data) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            handler.write16(address, data);
        } else {
            this.mem.write16(address, data);
        }
    }

    @Override
    public void write32(int address, int data) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            handler.write32(address, data);
        } else {
            this.mem.write32(address, data);
        }
    }

    @Override
    public void memset(int address, byte data, int length) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            for (int i = 0; i < length; ++i) {
                handler.write8(address + i, data);
            }
        } else {
            this.mem.memset(address, data, length);
        }
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return this.mem.getMainMemoryByteBuffer();
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            return null;
        }
        return this.mem.getBuffer(address, length);
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        IMMIOHandler handler = this.getHandler(address);
        if (handler != null) {
            for (int i = 0; i < length; ++i) {
                handler.write8(address + i, source.get());
            }
        } else {
            this.mem.copyToMemory(address, source, length);
        }
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        if (((destination | source | length) & 3) == 0 && !checkOverlap) {
            for (int i = 0; i < length; i += 4) {
                this.write32(destination + i, this.read32(source + i));
            }
        } else if (checkOverlap) {
            this.mem.memmove(destination, source, length);
        } else {
            this.mem.memcpy(destination, source, length);
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        for (Integer baseAddress : this.sortedHandlers.keySet()) {
            IMMIOHandler handler = this.sortedHandlers.get(baseAddress);
            handler.read(stream);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Read State for %s at 0x%08X", handler, baseAddress));
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        for (Integer baseAddress : this.sortedHandlers.keySet()) {
            IMMIOHandler handler = this.sortedHandlers.get(baseAddress);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Writing State for %s at 0x%08X", handler, baseAddress));
            }
            handler.write(stream);
        }
    }
}

