/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceAudio;
import jpcsp.hardware.Audio;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerSystemControl;
import jpcsp.memory.mmio.audio.AudioLine;
import jpcsp.memory.mmio.cy27040.CY27040;
import jpcsp.sound.SoundChannel;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerAudio
extends MMIOHandlerBase {
    public static Logger log = sceAudio.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1107296256;
    public static final int AUDIO_HW_FREQUENCY_8000 = 1;
    public static final int AUDIO_HW_FREQUENCY_11025 = 2;
    public static final int AUDIO_HW_FREQUENCY_12000 = 4;
    public static final int AUDIO_HW_FREQUENCY_16000 = 8;
    public static final int AUDIO_HW_FREQUENCY_22050 = 16;
    public static final int AUDIO_HW_FREQUENCY_24000 = 32;
    public static final int AUDIO_HW_FREQUENCY_32000 = 64;
    public static final int AUDIO_HW_FREQUENCY_44100 = 128;
    public static final int AUDIO_HW_FREQUENCY_48000 = 256;
    private static final int BUFFER_SIZE_IN_MILLIS = 100;
    private static MMIOHandlerAudio instance;
    private int busy;
    private int interrupt;
    private int inProgress;
    private int flags10;
    private int flags20;
    private int interruptEnabled;
    private int flags28 = 55;
    private int flags2C;
    private int volume;
    private int frequency0;
    private int frequency1;
    private int frequencyFlags;
    private int hardwareFrequency;
    private final AudioLineState[] audioLineStates = new AudioLineState[2];

    public static MMIOHandlerAudio getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerAudio(-1107296256);
        }
        return instance;
    }

    private MMIOHandlerAudio(int baseAddress) {
        super(baseAddress);
        SoundChannel.init();
        for (int i = 0; i < this.audioLineStates.length; ++i) {
            this.audioLineStates[i] = new AudioLineState(i);
        }
        PollAudioLinesThread pollAudioLinesThread = new PollAudioLinesThread();
        pollAudioLinesThread.setDaemon(true);
        pollAudioLinesThread.setName("Poll Audio Lines Thread");
        pollAudioLinesThread.start();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.busy = stream.readInt();
        this.interrupt = stream.readInt();
        this.inProgress = stream.readInt();
        this.flags10 = stream.readInt();
        this.flags20 = stream.readInt();
        this.interruptEnabled = stream.readInt();
        this.flags28 = stream.readInt();
        this.flags2C = stream.readInt();
        this.volume = stream.readInt();
        this.frequency0 = stream.readInt();
        this.frequency1 = stream.readInt();
        this.frequencyFlags = stream.readInt();
        this.hardwareFrequency = stream.readInt();
        for (int i = 0; i < this.audioLineStates.length; ++i) {
            this.audioLineStates[i].read(stream);
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.busy);
        stream.writeInt(this.interrupt);
        stream.writeInt(this.inProgress);
        stream.writeInt(this.flags10);
        stream.writeInt(this.flags20);
        stream.writeInt(this.interruptEnabled);
        stream.writeInt(this.flags28);
        stream.writeInt(this.flags2C);
        stream.writeInt(this.volume);
        stream.writeInt(this.frequency0);
        stream.writeInt(this.frequency1);
        stream.writeInt(this.frequencyFlags);
        stream.writeInt(this.hardwareFrequency);
        for (int i = 0; i < this.audioLineStates.length; ++i) {
            this.audioLineStates[i].write(stream);
        }
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.busy = 0;
        this.interrupt = 0;
        this.inProgress = 0;
        this.flags10 = 0;
        this.flags20 = 0;
        this.interruptEnabled = 0;
        this.flags28 = 55;
        this.flags2C = 0;
        this.volume = 0;
        this.frequency0 = 0;
        this.frequency1 = 0;
        this.frequencyFlags = 0;
        this.hardwareFrequency = 0;
        for (int i = 0; i < this.audioLineStates.length; ++i) {
            this.audioLineStates[i].reset();
        }
    }

    public int getDmacSyncDelay(int address, int size) {
        int syncDelay;
        switch (address - this.baseAddress) {
            case 96: {
                syncDelay = this.audioLineStates[0].getDmacSyncDelay(size);
                break;
            }
            case 112: {
                syncDelay = this.audioLineStates[1].getDmacSyncDelay(size);
                break;
            }
            default: {
                log.error((Object)String.format("getDmacSyncDelay unimplemented address=0x%08X, size=0x%X", address, size));
                syncDelay = 0;
            }
        }
        return syncDelay;
    }

    public void dmacFlush(int address) {
        switch (address - this.baseAddress) {
            case 96: {
                this.audioLineStates[0].dmacFlush();
                break;
            }
            case 112: {
                this.audioLineStates[1].dmacFlush();
                break;
            }
            default: {
                log.error((Object)String.format("dmacFlush unimplemented address=0x%08X", address));
            }
        }
    }

    private void setInterruptBit(int bit) {
        if (!Utilities.hasBit(this.interrupt, bit)) {
            this.interrupt = Utilities.setBit(this.interrupt, bit);
            this.checkInterrupt();
        }
    }

    private void setInterruptEnabled(int interruptEnabled) {
        this.interruptEnabled = interruptEnabled;
        int oldInterrupt = this.interrupt;
        this.interrupt &= interruptEnabled;
        if (oldInterrupt != this.interrupt) {
            this.checkInterrupt();
        }
    }

    private void checkInterrupt() {
        if (this.interrupt != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Triggering interrupt PSP_AUDIO_INTR");
            }
            RuntimeContextLLE.triggerInterrupt(RuntimeContextLLE.getMainProcessor(), 10);
            RuntimeContextLLE.triggerInterrupt(RuntimeContextLLE.getMediaEngineProcessor(), 12);
        } else {
            RuntimeContextLLE.clearInterrupt(RuntimeContextLLE.getMainProcessor(), 10);
            RuntimeContextLLE.clearInterrupt(RuntimeContextLLE.getMediaEngineProcessor(), 12);
        }
    }

    private void startAudio(int flags) {
        for (int i = 0; i < this.audioLineStates.length; ++i) {
            if (!Utilities.notHasBit(flags, i)) continue;
            this.audioLineStates[i].startAudio();
            this.inProgress = Utilities.setBit(this.inProgress, i);
        }
    }

    private void stopAudio(int flags) {
        for (int i = 0; i < 3; ++i) {
            if (!Utilities.isFallingBit(this.inProgress, flags, i)) continue;
            this.inProgress = Utilities.clearBit(this.inProgress, i);
            this.interrupt = Utilities.clearBit(this.interrupt, i);
        }
    }

    private static int getFrequencyValue(int hwFrequency) {
        switch (hwFrequency) {
            case 1: {
                return 8000;
            }
            case 2: {
                return 11025;
            }
            case 4: {
                return 12000;
            }
            case 8: {
                return 16000;
            }
            case 16: {
                return 22050;
            }
            case 32: {
                return 24000;
            }
            case 64: {
                return 32000;
            }
            case 128: {
                return 44100;
            }
            case 256: {
                return 48000;
            }
        }
        return hwFrequency;
    }

    private void setFrequency0(int frequency0) {
        this.frequency0 = frequency0;
        this.updateAudioFrequency();
    }

    private void setFrequency1(int frequency1) {
        this.frequency1 = frequency1;
        this.updateAudioFrequency();
    }

    private void setHardwareFrequency(int hardwareFrequency) {
        this.hardwareFrequency = hardwareFrequency;
        this.updateAudioFrequency();
    }

    public void updateAudioFrequency() {
        int frequency = CY27040.getInstance().getAudioFreq();
        for (int i = 0; i < this.audioLineStates.length; ++i) {
            this.audioLineStates[i].setFrequency(frequency);
        }
    }

    private void setVolume(int volume) {
        this.volume = volume;
        this.updateAudioLineVolume();
    }

    private void updateAudioLineVolume() {
        for (int i = 0; i < this.audioLineStates.length; ++i) {
            this.audioLineStates[i].setVolume(this.volume);
        }
    }

    private void updateFlags28() {
        this.flags28 = MMIOHandlerSystemControl.getInstance().isClockDeviceEnabled(24) ? Utilities.clearFlag(this.flags28, 2) : Utilities.setFlag(this.flags28, 2);
    }

    private int getFlags28() {
        this.updateFlags28();
        return this.flags28;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.busy;
                break;
            }
            case 12: {
                value = this.inProgress;
                break;
            }
            case 28: {
                value = this.interrupt;
                break;
            }
            case 40: {
                value = this.getFlags28();
                break;
            }
            case 64: {
                value = this.frequencyFlags;
                break;
            }
            case 80: {
                value = 0;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.busy = value;
                break;
            }
            case 4: {
                this.stopAudio(value);
                break;
            }
            case 8: {
                this.startAudio(value);
                break;
            }
            case 16: {
                this.flags10 = value;
                break;
            }
            case 20: {
                if (value == 4616) break;
                super.write32(address, value);
                break;
            }
            case 24: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 32: {
                this.flags20 = value;
                break;
            }
            case 36: {
                this.setInterruptEnabled(value);
                break;
            }
            case 44: {
                this.flags2C = value;
                break;
            }
            case 56: {
                this.setFrequency0(value);
                break;
            }
            case 60: {
                this.setFrequency1(value);
                break;
            }
            case 64: {
                this.frequencyFlags = value;
                break;
            }
            case 68: {
                this.setHardwareFrequency(value);
                break;
            }
            case 80: {
                this.setVolume(value);
                break;
            }
            case 96: {
                this.audioLineStates[0].sendAudioData(value);
                break;
            }
            case 112: {
                this.audioLineStates[1].sendAudioData(value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("busy=0x%X, interrupt=0x%X, inProgress=0x%X, flags10=0x%X, flags20=0x%X, interruptEnabled=0x%X, flags2C=0x%X, volume=0x%X, frequency0=0x%X(%d), frequency1=0x%X(%d), frequencyFlags=0x%X, hardwareFrequency=0x%X(%d)", this.busy, this.interrupt, this.inProgress, this.flags10, this.flags20, this.interruptEnabled, this.flags2C, this.volume, this.frequency0, MMIOHandlerAudio.getFrequencyValue(this.frequency0), this.frequency1, MMIOHandlerAudio.getFrequencyValue(this.frequency1), this.frequencyFlags, this.hardwareFrequency, MMIOHandlerAudio.getFrequencyValue(this.hardwareFrequency));
    }

    private class PollAudioLinesThread
    extends Thread
    implements IAction {
        private volatile boolean exit;
        private volatile boolean end;

        private PollAudioLinesThread() {
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            SoundChannel.setThreadInitContext();
            RuntimeContextLLE.registerExitAction(this);
            while (!this.exit) {
                try {
                    for (int i = 0; i < MMIOHandlerAudio.this.audioLineStates.length && !this.exit; ++i) {
                        MMIOHandlerAudio.this.audioLineStates[i].poll();
                    }
                    if (this.exit) continue;
                    Utilities.sleep(10, 0);
                }
                catch (UnsatisfiedLinkError e) {
                    this.exit = true;
                }
            }
            SoundChannel.clearThreadInitContext();
            this.end = true;
        }

        public void exit() {
            this.exit = true;
            while (!this.end) {
            }
        }

        @Override
        public void execute() {
            this.exit();
        }
    }

    private class AudioLineState
    implements IState {
        private static final int STATE_VERSION = 0;
        private static final int STARTUP_COUNT = 10;
        private final int lineNumber;
        private AudioLine audioLine = new AudioLine();
        private final int[] data = new int[64];
        private int dataIndex;
        private int numberBlockingBufferSamples;
        private boolean stalled;
        private int startup;
        private int frequency;

        public AudioLineState(int lineNumber) {
            this.lineNumber = lineNumber;
            this.setStalled();
            this.updateNumberBlockingBufferSamples();
        }

        @Override
        public synchronized void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.audioLine.read(stream);
            stream.readInts(this.data);
            this.dataIndex = stream.readInt();
            this.stalled = stream.readBoolean();
            this.frequency = stream.readInt();
            this.audioLine.setFrequency(this.frequency);
            this.updateNumberBlockingBufferSamples();
            this.setStalled();
        }

        @Override
        public synchronized void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            this.audioLine.write(stream);
            stream.writeInts(this.data);
            stream.writeInt(this.dataIndex);
            stream.writeBoolean(this.stalled);
            stream.writeInt(this.frequency);
        }

        private void setStalled() {
            this.dataIndex = 0;
            this.stalled = true;
            this.startup = 10;
        }

        public synchronized void poll() {
            if (Utilities.hasBit(MMIOHandlerAudio.this.interruptEnabled, this.lineNumber)) {
                int waitingBufferSamples = this.audioLine.getWaitingBufferSamples();
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("poll waitingBufferSamples=0x%X on %s", waitingBufferSamples, this));
                }
                if (waitingBufferSamples <= 0 && this.dataIndex == 0) {
                    MMIOHandlerAudio.this.setInterruptBit(this.lineNumber);
                    this.setStalled();
                }
            }
        }

        private synchronized void flushAudioData() {
            if (this.dataIndex <= 0) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sendAudioData line#%d:", this.lineNumber));
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.data.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    } else {
                        sb.append("    ");
                    }
                    sb.append(String.format("0x%04X 0x%04X", this.data[i] & 0xFFFF, this.data[i] >>> 16));
                    if ((i + 1) % 4 != 0) continue;
                    log.trace((Object)sb.toString());
                    sb.setLength(0);
                }
            }
            this.audioLine.writeAudioData(this.data, 0, this.dataIndex);
            this.dataIndex = 0;
        }

        private synchronized void sendAudioData(int value) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sendAudioData value=0x%08X, %s", value, this.toString()));
            }
            if (Audio.isMuted()) {
                value = 0;
            }
            this.data[this.dataIndex++] = value;
            if (this.stalled) {
                if (this.dataIndex == 24) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("sendAudioData leaving stalled state after discarding %d data values", this.dataIndex));
                    }
                    this.stalled = false;
                    this.dataIndex = 0;
                } else if (value != 0) {
                    log.warn((Object)String.format("sendAudioData unknown audio data 0x%08X in stalled state, %s", value, this.toString()));
                }
            }
            if (this.dataIndex >= this.data.length) {
                this.flushAudioData();
            }
        }

        public synchronized void startAudio() {
            this.dataIndex = 0;
        }

        private void updateNumberBlockingBufferSamples() {
            this.numberBlockingBufferSamples = Math.round((float)(this.audioLine.getFrequency() * 100) / 1000.0f);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("number of blocking buffer samples=0x%X", this.numberBlockingBufferSamples));
            }
        }

        public synchronized void setFrequency(int frequency) {
            if (this.frequency != frequency) {
                this.frequency = frequency;
                this.audioLine.setFrequency(frequency);
                this.updateNumberBlockingBufferSamples();
            }
        }

        public synchronized void setVolume(int volume) {
            this.audioLine.setVolume(volume);
        }

        public synchronized int getDmacSyncDelay(int size) {
            int syncDelay = 0;
            int waitingBufferSamples = this.audioLine.getWaitingBufferSamples();
            if (waitingBufferSamples >= this.numberBlockingBufferSamples && !Emulator.getClock().isPaused()) {
                int numberSamples = size >> 2;
                int frequency = this.audioLine.getFrequency();
                syncDelay = (int)(1000000L * (long)numberSamples / (long)frequency);
            } else if (this.startup > 0) {
                syncDelay = 5;
                --this.startup;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("syncDelay=0x%X milliseconds, waitingBufferSamples=0x%X", syncDelay, waitingBufferSamples));
            }
            return syncDelay;
        }

        public synchronized void dmacFlush() {
            this.flushAudioData();
        }

        public synchronized void reset() {
            this.setStalled();
        }

        public String toString() {
            return String.format("line#%d, dataIndex=0x%X, stalled=%b, numberBlockingBuffers=%d, waitingBufferSamples=0x%X", this.lineNumber, this.dataIndex, this.stalled, this.numberBlockingBufferSamples, this.audioLine.getWaitingBufferSamples());
        }
    }
}

