/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public abstract class MMIOHandlerBaseAta
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    public static final int ATA_STATUS_ERROR = 1;
    public static final int ATA_STATUS_DATA_REQUEST = 8;
    public static final int ATA_STATUS_DEVICE_READY = 64;
    public static final int ATA_STATUS_BUSY = 128;
    public static final int ATA_INTERRUPT_REASON_CoD = 1;
    public static final int ATA_INTERRUPT_REASON_IO = 2;
    public static final int ATA_CONTROL_SOFT_RESET = 4;
    public static final int ATA_CMD_DEV_RESET = 8;
    public static final int ATA_CMD_PACKET = 160;
    public static final int ATA_CMD_READ = 200;
    public static final int ATA_CMD_WRITE = 202;
    public static final int ATA_CMD_STANDBYNOW1 = 224;
    public static final int ATA_CMD_SLEEP = 230;
    public static final int ATA_CMD_FLUSH = 231;
    public static final int ATA_CMD_ID_ATA = 236;
    public static final int ATA_CMD_SET_FEATURES = 239;
    public static final int ATA_CMD_OP_TEST_UNIT_READY = 0;
    public static final int ATA_CMD_OP_REQUEST_SENSE = 3;
    public static final int ATA_CMD_OP_INQUIRY = 18;
    public static final int ATA_CMD_OP_START_STOP = 27;
    public static final int ATA_CMD_OP_PREVENT_ALLOW = 30;
    public static final int ATA_CMD_OP_READ_BIG = 40;
    public static final int ATA_CMD_OP_SEEK = 43;
    public static final int ATA_CMD_OP_READ_POSITION = 52;
    public static final int ATA_CMD_OP_READ_DISC_INFO = 81;
    public static final int ATA_CMD_OP_MODE_SELECT_BIG = 85;
    public static final int ATA_CMD_OP_MODE_SENSE_BIG = 90;
    public static final int ATA_CMD_OP_READ_STRUCTURE = 173;
    public static final int ATA_CMD_OP_SET_SPEED = 187;
    public static final int ATA_CMD_OP_UNKNOWN_F0 = 240;
    public static final int ATA_CMD_OP_UNKNOWN_F1 = 241;
    public static final int ATA_CMD_OP_UNKNOWN_F7 = 247;
    public static final int ATA_CMD_OP_UNKNOWN_FC = 252;
    public static final int SETFEATURES_XFER = 3;
    public static final int XFER_UDMA_2 = 66;
    public static final int ATA_INQUIRY_PERIPHERAL_DEVICE_TYPE_CDROM = 5;
    public static final int ATA_SENSE_KEY_NO_SENSE = 0;
    public static final int ATA_SENSE_KEY_NOT_READY = 2;
    public static final int ATA_SENSE_ASC_MEDIUM_NOT_PRESENT = 58;
    public static final int ATA_PAGE_CODE_POWER_CONDITION = 26;
    public static final int SECTOR_SIZE = 512;
    private final int[] data = new int[512];
    private int dataIndex;
    private int dataLength;
    private int totalDataLength;
    private int error;
    private int features;
    private int sectorCount;
    private int sectorNumber;
    private int cylinderLow;
    private int cylinderHigh;
    private int drive;
    private int status;
    private int command;
    private int control;
    private int pendingOperationCodeParameters;
    private int logicalBlockAddress;

    protected MMIOHandlerBaseAta(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.data);
        this.dataIndex = stream.readInt();
        this.dataLength = stream.readInt();
        this.totalDataLength = stream.readInt();
        this.error = stream.readInt();
        this.features = stream.readInt();
        this.sectorCount = stream.readInt();
        this.sectorNumber = stream.readInt();
        this.cylinderLow = stream.readInt();
        this.cylinderHigh = stream.readInt();
        this.drive = stream.readInt();
        this.status = stream.readInt();
        this.command = stream.readInt();
        this.control = stream.readInt();
        this.pendingOperationCodeParameters = stream.readInt();
        this.logicalBlockAddress = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.data);
        stream.writeInt(this.dataIndex);
        stream.writeInt(this.dataLength);
        stream.writeInt(this.totalDataLength);
        stream.writeInt(this.error);
        stream.writeInt(this.features);
        stream.writeInt(this.sectorCount);
        stream.writeInt(this.sectorNumber);
        stream.writeInt(this.cylinderLow);
        stream.writeInt(this.cylinderHigh);
        stream.writeInt(this.drive);
        stream.writeInt(this.status);
        stream.writeInt(this.command);
        stream.writeInt(this.control);
        stream.writeInt(this.pendingOperationCodeParameters);
        stream.writeInt(this.logicalBlockAddress);
        super.write(stream);
    }

    protected static String getCommandName(int command) {
        switch (command) {
            case 8: {
                return "ATA_CMD_DEV_RESET";
            }
            case 160: {
                return "ATA_CMD_PACKET";
            }
            case 200: {
                return "ATA_CMD_READ";
            }
            case 202: {
                return "ATA_CMD_WRITE";
            }
            case 224: {
                return "ATA_CMD_STANDBYNOW1";
            }
            case 230: {
                return "ATA_CMD_SLEEP";
            }
            case 231: {
                return "ATA_CMD_FLUSH";
            }
            case 236: {
                return "ATA_CMD_ID_ATA";
            }
            case 239: {
                return "ATA_CMD_SET_FEATURES";
            }
        }
        return String.format("ATA_CMD_UNKNOWN_0x%02X", command);
    }

    protected static String getOperationCodeName(int operationCode) {
        switch (operationCode) {
            case 0: {
                return "TEST_UNIT_READY";
            }
            case 3: {
                return "REQUEST_SENSE";
            }
            case 18: {
                return "INQUIRY";
            }
            case 27: {
                return "START_STOP";
            }
            case 30: {
                return "PREVENT_ALLOW";
            }
            case 40: {
                return "READ_BIG";
            }
            case 43: {
                return "SEEK";
            }
            case 52: {
                return "READ_POSITION";
            }
            case 81: {
                return "READ_DISC_INFO";
            }
            case 85: {
                return "MODE_SELECT_BIG";
            }
            case 90: {
                return "MODE_SENSE_BIG";
            }
            case 173: {
                return "READ_STRUCTURE";
            }
            case 187: {
                return "SET_SPEED";
            }
        }
        return String.format("UNKNOWN_OP_0x%02X", operationCode);
    }

    protected abstract int getInterruptNumber();

    protected abstract boolean supportsCmdPacket();

    protected void setLogicalBlockAddress(int logicalBlockAddress) {
        this.logicalBlockAddress = logicalBlockAddress;
    }

    @Override
    public void reset() {
        super.reset();
        this.sectorCount = 1;
        this.sectorNumber = 1;
        if (this.supportsCmdPacket()) {
            this.cylinderLow = 20;
            this.cylinderHigh = 235;
        } else {
            this.cylinderLow = 0;
            this.cylinderHigh = 0;
        }
        this.drive = 0;
        this.dataIndex = 0;
        this.dataLength = 0;
        this.totalDataLength = 0;
        this.pendingOperationCodeParameters = -1;
        this.logicalBlockAddress = 0;
    }

    private void setByteCount(int byteCount) {
        this.cylinderLow = byteCount & 0xFF;
        this.cylinderHigh = byteCount >> 8 & 0xFF;
    }

    protected void setInterruptReason(boolean CoD, boolean io) {
        this.sectorCount = CoD ? (this.sectorCount |= 1) : (this.sectorCount &= 0xFFFFFFFE);
        this.sectorCount = io ? (this.sectorCount |= 2) : (this.sectorCount &= 0xFFFFFFFD);
    }

    protected abstract void executePacketCommand(int[] var1);

    protected abstract void executeCommand(int var1, int[] var2, int var3, int var4, boolean var5);

    protected abstract void executeCommandWithData(int var1, int var2, int[] var3, int var4, boolean var5, boolean var6);

    protected void prepareDataReceive(int length, int totalDataLength) {
        this.status |= 0x80;
        this.setInterruptReason(true, false);
        this.status |= 8;
        this.status &= 0xFFFFFF7F;
        this.dataLength = length;
        this.totalDataLength = totalDataLength;
        this.pendingOperationCodeParameters = -1;
    }

    private void setCommand(int command) {
        this.command = command;
        this.dataIndex = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerBaseAta.setCommand command 0x%02X(%s)", command, MMIOHandlerBaseAta.getCommandName(this.command)));
        }
        switch (command) {
            case 160: {
                if (this.supportsCmdPacket()) {
                    this.prepareDataReceive(12, 12);
                    break;
                }
                this.log.error((Object)String.format("MMIOHandlerBaseAta.setCommand unsupported ATA_CMD_PACKET", new Object[0]));
                break;
            }
            case 8: 
            case 224: 
            case 230: 
            case 231: 
            case 236: 
            case 239: {
                this.executeCommand(command, this.data, 0, 0, true);
                break;
            }
            case 200: 
            case 202: {
                if (this.supportsCmdPacket()) {
                    this.log.error((Object)String.format("MMIOHandlerBaseAta.setCommand unsupported command=0x%X(%s)", command, MMIOHandlerBaseAta.getCommandName(command)));
                    break;
                }
                this.executeCommand(command, this.data, 0, 0, true);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseAta.setCommand unknown command 0x%02X", command));
            }
        }
    }

    private void setControl(int control) {
        this.control = control;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerBaseAta.setControl control 0x%02X", this.control));
        }
        if ((control & 4) != 0) {
            this.reset();
        }
    }

    private void setFeatures(int features) {
        this.features = features;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerBaseAta.setFeatures features 0x%02X", this.features));
        }
    }

    protected int getFeatures() {
        return this.features;
    }

    protected int getSectorCount() {
        return this.sectorCount;
    }

    protected int getLBA() {
        return this.sectorNumber | this.cylinderLow << 8 | this.cylinderHigh << 16 | (this.drive & 0xF) << 24;
    }

    protected boolean isLBA() {
        return Utilities.hasBit(this.drive, 6);
    }

    protected int getCommand() {
        return this.command;
    }

    private void writeData16(int data16) {
        if (this.dataIndex < this.dataLength) {
            this.data[this.dataIndex++] = data16 & 0xFF;
            if (this.dataIndex < this.dataLength) {
                this.data[this.dataIndex++] = data16 >> 8 & 0xFF;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerBaseAta.writeData 0x%04X", data16));
        }
        if (this.dataIndex >= this.dataLength) {
            this.totalDataLength -= this.dataIndex;
            this.dataIndex = 0;
            if (this.totalDataLength > 0) {
                this.dataLength = Math.min(this.totalDataLength, 512);
                this.executeCommandWithData(this.command, this.pendingOperationCodeParameters, this.data, this.dataLength, false, false);
            } else {
                this.status &= 0xFFFFFFF7;
                this.status |= 0x80;
                this.executeCommandWithData(this.command, this.pendingOperationCodeParameters, this.data, this.dataLength, false, true);
                this.pendingOperationCodeParameters = -1;
            }
        }
    }

    private int getData16() {
        int originalDataIndex = this.dataIndex;
        int data16 = 0;
        if (this.dataIndex < this.dataLength) {
            data16 = this.data[this.dataIndex++];
            if (this.dataIndex < this.dataLength) {
                data16 |= this.data[this.dataIndex++] << 8;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("MMIOHandlerBaseAta.getData16 dataIndex=0x%X, dataLength=0x%X, totalDataLength=0x%X returning 0x%04X", originalDataIndex, this.dataLength, this.totalDataLength, data16));
        }
        if (this.dataIndex >= this.dataLength) {
            this.commandCompleted();
        }
        return data16;
    }

    protected void prepareDataInit(int allocationLength) {
        this.dataIndex = 0;
        Arrays.fill(this.data, 0, allocationLength, 0);
    }

    protected void prepareDataEnd(int allocationLength, int totalDataLength) {
        this.dataLength = Math.min(allocationLength, this.dataIndex);
        this.totalDataLength = Math.max(this.dataLength, totalDataLength);
        this.dataIndex = 0;
        this.setByteCount(this.dataLength);
        this.setInterruptReason(false, true);
        this.status |= 8;
        this.status &= 0xFFFFFF7F;
        if (this.getInterruptNumber() >= 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), this.getInterruptNumber());
        }
    }

    protected void prepareDataEndWithDelay(int allocationLength, int totalDataLength, int delayUs) {
        if (delayUs <= 0) {
            this.prepareDataEnd(allocationLength, totalDataLength);
        } else {
            Scheduler.getInstance().addAction(Scheduler.getNow() + (long)delayUs, new PrepareDataEndAction(allocationLength, totalDataLength));
        }
    }

    protected void prepareData8(int data8) {
        this.data[this.dataIndex++] = data8 & 0xFF;
    }

    protected void prepareData16(int data16) {
        this.prepareData8(data16 >> 8);
        this.prepareData8(data16);
    }

    protected void prepareData24(int data24) {
        this.prepareData8(data24 >> 16);
        this.prepareData8(data24 >> 8);
        this.prepareData8(data24);
    }

    protected void prepareData32(int data32) {
        this.prepareData8(data32 >> 24);
        this.prepareData8(data32 >> 16);
        this.prepareData8(data32 >> 8);
        this.prepareData8(data32);
    }

    protected void prepareData(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                this.prepareData8(s.charAt(i));
            }
        }
    }

    public void commandCompleted() {
        this.totalDataLength -= this.dataIndex;
        this.dataIndex = 0;
        if (this.totalDataLength > 0) {
            this.dataLength = Math.min(this.totalDataLength, 512);
            this.executeCommand(this.command, this.data, this.dataLength, this.totalDataLength, false);
        } else {
            this.dataLength = 0;
            this.status &= 0xFFFFFFF7;
            this.status &= 0xFFFFFF7F;
            this.status |= 0x40;
            this.setInterruptReason(true, true);
            if (this.getInterruptNumber() >= 0) {
                RuntimeContextLLE.triggerInterrupt(this.getProcessor(), this.getInterruptNumber());
            }
        }
    }

    public void commandCompletedWithDelay(int delayUs) {
        if (delayUs <= 0) {
            this.commandCompleted();
        } else {
            Scheduler.getInstance().addAction(Scheduler.getNow() + (long)delayUs, new CommandCompletedAction());
        }
    }

    public int getLogicalBlockAddress() {
        return this.logicalBlockAddress;
    }

    protected void preparePacketCommandParameterList(int parameterListLength, int operationCode) {
        this.dataIndex = 0;
        this.dataLength = parameterListLength;
        this.setByteCount(parameterListLength);
        this.pendingOperationCodeParameters = operationCode;
        this.setInterruptReason(false, false);
        this.status &= 0xFFFFFF7F;
        this.status |= 8;
        if (this.getInterruptNumber() >= 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), this.getInterruptNumber());
        }
    }

    private void endOfData(int value) {
        if (value != 0) {
            this.log.error((Object)String.format("MMIOHandlerBaseAta.endOfData unknown value=0x%02X", value));
        }
    }

    private int getRegularStatus() {
        if (this.getInterruptNumber() >= 0) {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), this.getInterruptNumber());
        }
        return this.status;
    }

    private int getAlternateStatus() {
        return this.status;
    }

    @Override
    public int read8(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 1: {
                value = this.error;
                break;
            }
            case 2: {
                value = this.sectorCount;
                break;
            }
            case 3: {
                value = this.sectorNumber;
                break;
            }
            case 4: {
                value = this.cylinderLow;
                break;
            }
            case 5: {
                value = this.cylinderHigh;
                break;
            }
            case 6: {
                value = this.drive;
                break;
            }
            case 7: {
                value = this.getRegularStatus();
                break;
            }
            case 14: {
                value = this.getAlternateStatus();
                break;
            }
            default: {
                value = super.read8(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read8(0x%08X) returning 0x%02X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write8(int address, byte value) {
        int value8 = value & 0xFF;
        switch (address - this.baseAddress) {
            case 1: {
                this.setFeatures(value8);
                break;
            }
            case 2: {
                this.sectorCount = value8;
                break;
            }
            case 3: {
                this.sectorNumber = value8;
                break;
            }
            case 4: {
                this.cylinderLow = value8;
                break;
            }
            case 5: {
                this.cylinderHigh = value8;
                break;
            }
            case 6: {
                this.drive = value8;
                break;
            }
            case 7: {
                this.setCommand(value8);
                break;
            }
            case 8: {
                this.endOfData(value8);
                break;
            }
            case 14: {
                this.setControl(value8);
                break;
            }
            default: {
                super.write8(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write8(0x%08X, 0x%02X) on %s", this.getPc(), address, value8, this));
        }
    }

    @Override
    public void write16(int address, short value) {
        int value16 = value & 0xFFFF;
        switch (address - this.baseAddress) {
            case 0: {
                this.writeData16(value16);
                break;
            }
            default: {
                super.write16(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write16(0x%08X, 0x%04X) on %s", this.getPc(), address, value16, this));
        }
    }

    @Override
    public int read16(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.getData16();
                break;
            }
            default: {
                value = super.read16(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read16(0x%08X) returning 0x%04X", this.getPc(), address, value));
        }
        return value;
    }

    private class CommandCompletedAction
    implements IAction {
        @Override
        public void execute() {
            MMIOHandlerBaseAta.this.commandCompleted();
        }
    }

    private class PrepareDataEndAction
    implements IAction {
        private int allocationLength;
        private int totalDataLength;

        public PrepareDataEndAction(int allocationLength, int totalDataLength) {
            this.allocationLength = allocationLength;
            this.totalDataLength = totalDataLength;
        }

        @Override
        public void execute() {
            MMIOHandlerBaseAta.this.prepareDataEnd(this.allocationLength, this.totalDataLength);
        }
    }
}

