/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.modules.sceMeCore;
import jpcsp.Memory;
import jpcsp.media.codec.ICodec;
import jpcsp.mediaengine.MEMemory;
import jpcsp.mediaengine.MEProcessor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerMeCore {
    public static Logger log = sceMeCore.log;
    public static final int BASE_ADDRESS = -1077934592;
    private static MMIOHandlerMeCore instance;

    public static MMIOHandlerMeCore getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerMeCore();
        }
        return instance;
    }

    private MMIOHandlerMeCore() {
    }

    public void hleStartMeCommand() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Starting %s", this));
        }
    }

    public void hleCompleteMeCommand() {
        MEMemory meMemory = MEProcessor.getInstance().getMEMemory();
        Memory mem = Memory.getInstance();
        switch (this.getCmd()) {
            case 2: {
                int mp4Data = this.getParameter(1);
                int mp4Size = this.getParameter(2);
                TPointer buffer2 = this.getParameterPointer(3);
                TPointer mpegAvcYuvStruct = this.getParameterPointer(4);
                TPointer buffer3 = this.getParameterPointer(5);
                TPointer decodeSEI = this.getParameterPointer(6);
                int result = Modules.sceVideocodecModule.videocodecDecodeType0(meMemory, mp4Data, mp4Size, buffer2, mpegAvcYuvStruct, buffer3, decodeSEI);
                this.setResult(result);
                break;
            }
            case 4: {
                Modules.sceVideocodecModule.videocodecDelete();
                break;
            }
            case 9: {
                TPointer decodeSEI = this.getParameterPointer(1);
                Modules.sceVideocodecModule.videocodecGetSEIType0(decodeSEI);
                break;
            }
            case 103: {
                int edram = this.getParameter(4);
                Modules.sceAudiocodecModule.initCodec(edram, 4096, this.getParameter(2) + 2, this.getParameter(1), this.getParameter(3), 0);
                break;
            }
            case 96: {
                TPointer workArea = this.getParameterPointer(0);
                int edram = workArea.getValue32(12);
                int inputBufferSize = workArea.getValue32(48) == 0 ? workArea.getValue32(64) + 2 : 4106;
                ICodec audioCodec = Modules.sceAudiocodecModule.getCodec(edram);
                int inputBuffer = workArea.getValue32(24);
                int outputBuffer = workArea.getValue32(32);
                if (mem.read8(inputBuffer) == 15 && mem.read8(inputBuffer + 1) == 208) {
                    int audioFrameLength;
                    int frameHeader23 = mem.read8(inputBuffer + 2) << 8 | mem.read8(inputBuffer + 3);
                    inputBufferSize = audioFrameLength = (frameHeader23 & 0x3FF) << 3;
                    inputBuffer += 8;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("ME_CMD_AT3P_DECODE inputBuffer: %s", Utilities.getMemoryDump(inputBuffer, inputBufferSize)));
                }
                int result = audioCodec != null ? audioCodec.decode(meMemory, inputBuffer, inputBufferSize, meMemory, outputBuffer) : inputBufferSize;
                this.setResult(result);
                if (!log.isDebugEnabled()) break;
                if (result < 0) {
                    log.debug((Object)String.format("ME_CMD_AT3P_DECODE audiocodec.decode returned error 0x%08X, data: %s", result, Utilities.getMemoryDump(inputBuffer, inputBufferSize)));
                    break;
                }
                log.debug((Object)String.format("ME_CMD_AT3P_DECODE audiocodec.decode bytesConsumed=0x%X", result));
                break;
            }
            case 139: {
                int edram = this.getParameter(0);
                Modules.sceAudiocodecModule.initCodec(edram, 4098, 0, 2, 2, 0);
                break;
            }
            case 140: {
                TPointer workArea = this.getParameterPointer(0);
                int edram = workArea.getValue32(12);
                int inputBufferSize = workArea.getValue32(40);
                ICodec audioCodec = Modules.sceAudiocodecModule.getCodec(edram);
                int inputBuffer = workArea.getValue32(24);
                int outputBuffer = workArea.getValue32(32);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("ME_CMD_MP3_DECODE inputBuffer: %s", Utilities.getMemoryDump(inputBuffer, inputBufferSize)));
                }
                int result = audioCodec != null ? audioCodec.decode(mem, inputBuffer, inputBufferSize, mem, outputBuffer) : inputBufferSize;
                this.setResult(result);
                if (!log.isDebugEnabled()) break;
                if (result < 0) {
                    log.debug((Object)String.format("ME_CMD_MP3_DECODE audiocodec.decode returned error 0x%08X, data: %s", result, Utilities.getMemoryDump(inputBuffer, inputBufferSize)));
                    break;
                }
                log.debug((Object)String.format("ME_CMD_MP3_DECODE audiocodec.decode bytesConsumed=0x%X", result));
            }
        }
    }

    private int read32(int offset) {
        return RuntimeContextLLE.getMMIO().read32(-1077934592 + offset);
    }

    private void write32(int offset, int value) {
        RuntimeContextLLE.getMMIO().write32(-1077934592 + offset, value);
    }

    public int getCmd() {
        return this.read32(0);
    }

    public int getUnknown() {
        return this.read32(4);
    }

    public int getParameter(int index) {
        return this.read32(8 + (index << 2));
    }

    public TPointer getParameterPointer(int index) {
        return new TPointer(Memory.getInstance(), this.getParameter(index));
    }

    public int getResult() {
        return this.read32(40);
    }

    public void setResult(int result) {
        this.write32(40, result);
    }

    public String toString() {
        int cmd = this.getCmd();
        StringBuilder s = new StringBuilder(String.format("cmd=0x%X(%s), result=0x%08X", cmd, MECommand.getCommandName(cmd), this.getResult()));
        int numberOfParameters = MECommand.getNumberOfParameters(cmd);
        for (int i = 0; i < numberOfParameters; ++i) {
            s.append(String.format(", parameters[%d]=0x%08X", i, this.getParameter(i)));
        }
        return s.toString();
    }

    public static enum MECommand {
        ME_CMD_VIDEOCODEC_OPEN_TYPE0(0, 1),
        ME_CMD_VIDEOCODEC_INIT_TYPE0(1, 3),
        ME_CMD_VIDEOCODEC_DECODE_TYPE0(2, 8),
        ME_CMD_VIDEOCODEC_STOP_TYPE0(3, 3),
        ME_CMD_VIDEOCODEC_DELETE_TYPE0(4, 1),
        ME_CMD_VIDEOCODEC_SET_MEMORY_TYPE0(5, 6),
        ME_CMD_VIDEOCODEC_GET_VERSION_TYPE0(6, 1),
        ME_CMD_AVC_SELECT_CLOCK(7, 1),
        ME_CMD_AVC_POWER_ENABLE(8, 0),
        ME_CMD_VIDEOCODEC_GET_SEI_TYPE0(9, 2),
        ME_CMD_VIDEOCODEC_GET_FRAME_CROP_TYPE0(10, 2),
        ME_CMD_VIDEOCODEC_GET_UNKNOWN_TYPE0(11, 2),
        ME_CMD_VIDEOCODEC_UNKNOWN_CMD_0x10(16, 1),
        ME_CMD_VIDEOCODEC_DECODE_TYPE1(32, 4),
        ME_CMD_VIDEOCODEC_STOP_TYPE1(33, 1),
        ME_CMD_VIDEOCODEC_DELETE_TYPE1(34, 1),
        ME_CMD_VIDEOCODEC_OPEN_TYPE1_STEP2(35, 3),
        ME_CMD_VIDEOCODEC_OPEN_TYPE1(36, 0),
        ME_CMD_VIDEOCODEC_INIT_TYPE1(37, 8),
        ME_CMD_VIDEOCODEC_SCAN_HEADER_TYPE1(38, 2),
        ME_CMD_VIDEOCODEC_GET_VERSION_TYPE1(39, 8),
        ME_CMD_AT3P_DECODE(96, 1),
        ME_CMD_AT3P_GET_INFO3(97, 0),
        ME_CMD_AT3P_CHECK_NEED_MEM1(99, 4),
        ME_CMD_AT3P_SET_UNK68(100, 2),
        ME_CMD_AT3P_CHECK_NEED_MEM2(102, 3),
        ME_CMD_AT3P_SETUP_CHANNEL(103, 5),
        ME_CMD_AT3P_CHECK_UNK20(104, 2),
        ME_CMD_AT3P_SET_UNK44(105, 2),
        ME_CMD_AT3P_GET_INTERNAL_ERROR(106, 2),
        ME_CMD_AT3_DECODE(112, 1),
        ME_CMD_AT3_GET_INTERNAL_ERROR(113, 2),
        ME_CMD_AT3_CHECK_NEED_MEM(114, 3),
        ME_CMD_AT3_INIT(115, 4),
        ME_CMD_AT3_GET_INFO3(116, 0),
        ME_CMD_MP3_GET_INFO3(129, 0),
        ME_CMD_MP3_GET_INFO2(130, 4),
        ME_CMD_MP3_SET_VALUE_FOR_INFO2(137, 2),
        ME_CMD_MP3_CHECK_NEED_MEM(138, 3),
        ME_CMD_MP3_INIT(139, 1),
        ME_CMD_MP3_DECODE(140, 1),
        ME_CMD_AAC_DECODE(144, 5),
        ME_CMD_AAC_GET_INTERNAL_ERROR(145, 2),
        ME_CMD_AAC_CHECK_NEED_MEM(146, 0),
        ME_CMD_AAC_INIT(147, 2),
        ME_CMD_AAC_GET_INFO3(148, 0),
        ME_CMD_AAC_INIT_UNK44(149, 2),
        ME_CMD_AAC_INIT_UNK44_STEP2(151, 4),
        ME_CMD_WMA_GET_INFO3(225, 0),
        ME_CMD_WMA_CHECK_NEED_MEM(226, 0),
        ME_CMD_WMA_INIT(227, 2),
        ME_CMD_WMA_DECODE(229, 7),
        ME_CMD_WMA_GET_INTERNAL_ERROR(230, 2),
        ME_CMD_SASCORE(256, 4),
        ME_CMD_SASCORE_WITH_MIX(257, 6),
        ME_CMD_MALLOC(384, 1),
        ME_CMD_FREE(385, 1),
        ME_CMD_CALLOC(386, 2),
        ME_CMD_AW_EDRAM_BUS_CLOCK_ENABLE(387, 0),
        ME_CMD_AW_EDRAM_BUS_CLOCK_DISABLE(388, 0),
        ME_CMD_BOOT(389, 1),
        ME_CMD_CPU(390, 2),
        ME_CMD_POWER(391, 2),
        ME_CMD_STANDBY(399, 2);

        private int cmd;
        private int numberOfParameters;

        private MECommand(int cmd, int numberOfParameters) {
            this.cmd = cmd;
            this.numberOfParameters = numberOfParameters;
        }

        public int getCmd() {
            return this.cmd;
        }

        public int getNumberOfParameters() {
            return this.numberOfParameters;
        }

        public static MECommand getMECommand(int cmd) {
            for (MECommand meCommand : MECommand.values()) {
                if (meCommand.getCmd() != cmd) continue;
                return meCommand;
            }
            return null;
        }

        public static String getCommandName(int cmd) {
            MECommand meCommand = MECommand.getMECommand(cmd);
            if (meCommand == null) {
                return String.format("ME_CMD_UNKNOWN_%X", cmd);
            }
            return meCommand.name();
        }

        public static int getNumberOfParameters(int cmd) {
            MECommand meCommand = MECommand.getMECommand(cmd);
            if (meCommand == null) {
                return 8;
            }
            return meCommand.getNumberOfParameters();
        }
    }
}

