/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class MMIOHandlerProfiler
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    private static final int PROFILER_REGISTER_COUNT = 21;
    private final int[] registers = new int[21];

    public MMIOHandlerProfiler(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.registers);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.registers);
        super.write(stream);
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: {
                value = this.registers[address - this.baseAddress >> 2];
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: {
                this.registers[address - this.baseAddress >> 2] = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

