/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.memory.FastMemory;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class MMIOHandlerReadWrite
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    private final int[] memory;
    private Level logLevel = Level.TRACE;

    public MMIOHandlerReadWrite(int baseAddress, int length) {
        super(baseAddress);
        this.memory = new int[length >> 2];
    }

    public MMIOHandlerReadWrite(int baseAddress, int length, int[] memory) {
        super(baseAddress);
        this.memory = memory;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.memory);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.memory);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.memory, 0);
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public int[] getInternalMemory() {
        return this.memory;
    }

    protected String getTraceFormatRead32() {
        return "0x%08X - read32(0x%08X)=0x%08X";
    }

    protected String getTraceFormatRead16() {
        return "0x%08X - read16(0x%08X)=0x%04X";
    }

    protected String getTraceFormatRead8() {
        return "0x%08X - read8(0x%08X)=0x%02X";
    }

    @Override
    public int read32(int address) {
        int data = this.internalRead32(address);
        if (this.log.isEnabledFor((Priority)this.logLevel)) {
            this.log.log((Priority)this.logLevel, (Object)String.format(this.getTraceFormatRead32(), this.getPc(), address, data));
        }
        return data;
    }

    @Override
    public int read16(int address) {
        int data = this.internalRead16(address);
        if (this.log.isEnabledFor((Priority)this.logLevel)) {
            this.log.log((Priority)this.logLevel, (Object)String.format(this.getTraceFormatRead16(), this.getPc(), address, data));
        }
        return data;
    }

    @Override
    public int read8(int address) {
        int data = this.internalRead8(address);
        if (this.log.isEnabledFor((Priority)this.logLevel)) {
            this.log.log((Priority)this.logLevel, (Object)String.format(this.getTraceFormatRead8(), this.getPc(), address, data));
        }
        return data;
    }

    @Override
    public int internalRead8(int address) {
        return this.memory[address - this.baseAddress >> 2] >> FastMemory.memory8Shift[address & 3] & 0xFF;
    }

    @Override
    public int internalRead16(int address) {
        return this.memory[address - this.baseAddress >> 2] >> FastMemory.memory16Shift[address & 2] & 0xFFFF;
    }

    @Override
    public int internalRead32(int address) {
        return this.memory[address - this.baseAddress >> 2];
    }

    protected String getTraceFormatWrite32() {
        return "0x%08X - write32(0x%08X, 0x%08X)";
    }

    protected String getTraceFormatWrite16() {
        return "0x%08X - write16(0x%08X, 0x%04X)";
    }

    protected String getTraceFormatWrite8() {
        return "0x%08X - write8(0x%08X, 0x%02X)";
    }

    @Override
    public void write32(int address, int value) {
        if (this.log.isEnabledFor((Priority)this.logLevel)) {
            this.log.log((Priority)this.logLevel, (Object)String.format(this.getTraceFormatWrite32(), this.getPc(), address, value));
        }
        this.memory[address - this.baseAddress >> 2] = value;
    }

    @Override
    public void write16(int address, short value) {
        int memData;
        if (this.log.isEnabledFor((Priority)this.logLevel)) {
            this.log.log((Priority)this.logLevel, (Object)String.format(this.getTraceFormatWrite16(), this.getPc(), address, value & 0xFFFF));
        }
        int index = address & 2;
        this.memory[address - this.baseAddress >> 2] = memData = this.memory[address - this.baseAddress >> 2] & FastMemory.memory16Mask[index] | (value & 0xFFFF) << FastMemory.memory16Shift[index];
    }

    @Override
    public void write8(int address, byte value) {
        int memData;
        if (this.log.isEnabledFor((Priority)this.logLevel)) {
            this.log.log((Priority)this.logLevel, (Object)String.format(this.getTraceFormatWrite8(), this.getPc(), address, value & 0xFF));
        }
        int index = address & 3;
        this.memory[address - this.baseAddress >> 2] = memData = this.memory[address - this.baseAddress >> 2] & FastMemory.memory8Mask[index] | (value & 0xFF) << FastMemory.memory8Shift[index];
    }
}

