/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class MMIOHandlerSystemTime
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    private long alarm;
    private TriggerAlarmInterruptAction triggerAlarmInterruptAction;

    public MMIOHandlerSystemTime(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.setAlarm((int)(stream.readLong() + (long)this.getSystemTime()));
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeLong(this.alarm - (long)this.getSystemTime());
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.alarm = 0L;
    }

    private int getSystemTime() {
        return (int)SystemTimeManager.getSystemTime();
    }

    private void setAlarm(int alarm) {
        Scheduler scheduler = Emulator.getScheduler();
        if (this.triggerAlarmInterruptAction == null) {
            this.triggerAlarmInterruptAction = new TriggerAlarmInterruptAction();
        } else {
            scheduler.removeAction(this.alarm, this.triggerAlarmInterruptAction);
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 19);
        }
        this.alarm = (long)alarm & 0xFFFFFFFFL;
        scheduler.addAction(this.alarm, this.triggerAlarmInterruptAction);
    }

    private void triggerAlarmInterrupt() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Triggering PSP_THREAD0_INTR interrupt for %s", this));
        }
        RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 19);
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.getSystemTime();
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 4: {
                this.setAlarm(value);
                break;
            }
            case 8: {
                if (value == 48) break;
                super.write32(address, value);
                break;
            }
            case 12: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            case 16: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("MMIOHandlerSystemTime systemTime=0x%08X, alarm=0x%08X", this.getSystemTime(), this.alarm);
    }

    private class TriggerAlarmInterruptAction
    implements IAction {
        private TriggerAlarmInterruptAction() {
        }

        @Override
        public void execute() {
            MMIOHandlerSystemTime.this.triggerAlarmInterrupt();
        }
    }
}

