/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.battery;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.TPointer;
import jpcsp.hardware.Battery;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.battery.BatteryMemory;
import jpcsp.memory.mmio.battery.MMIOHandlerBatteryFirmwareSfr;
import jpcsp.memory.mmio.syscon.SysconBatteryEmulator;
import jpcsp.memory.mmio.syscon.SysconEmulator;
import jpcsp.nec78k0.INec78k0HLECall;
import jpcsp.nec78k0.Nec78k0Instructions;
import jpcsp.nec78k0.Nec78k0Interpreter;
import jpcsp.nec78k0.Nec78k0Memory;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class BatteryEmulator {
    public static Logger log = Logger.getLogger((String)"battery");
    public static final int BATTERY_MODEL_FAT = 0;
    public static final int BATTERY_MODEL_2000 = 1;
    public static final int BATTERY_MODEL_3000 = 2;
    public static final int BATTERY_MODEL_STREET = 3;
    public static final int BATTERY_MODEL_GO = 4;
    private static final int HLE_ADDR1 = 65208;
    private static final int HLE_ADDR2 = 65212;
    private static int batteryModel = -1;
    private static boolean isEnabled;
    private static int initializedModel;
    private final BatteryMemory mem = new BatteryMemory(log);
    private final Nec78k0Processor processor = new Nec78k0Processor(this.mem);
    private final Nec78k0Interpreter interpreter = new Nec78k0Interpreter(this.processor);
    private BatteryProcessorThread thread;
    private volatile boolean exit;

    public static int getBatteryModel() {
        if (batteryModel < 0) {
            switch (Model.getModel()) {
                case 0: {
                    batteryModel = 0;
                    break;
                }
                case 1: {
                    batteryModel = 1;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    batteryModel = 2;
                    break;
                }
                case 7: {
                    batteryModel = 3;
                    break;
                }
                case 4: {
                    batteryModel = 4;
                    break;
                }
                default: {
                    log.error((Object)String.format("Unknown Battery model for PSP model %s", Model.getModelName()));
                    batteryModel = 1;
                }
            }
        }
        return batteryModel;
    }

    public static String getFirmwareFileName() {
        switch (BatteryEmulator.getBatteryModel()) {
            case 1: {
                return "Battery-2000.bin";
            }
            case 2: {
                return "Battery-3000.bin";
            }
        }
        return null;
    }

    public static boolean isEnabled() {
        if (initializedModel != Model.getModel()) {
            File firmwareFile;
            String firmwareFileName = BatteryEmulator.getFirmwareFileName();
            isEnabled = firmwareFileName == null ? false : (firmwareFile = new File(firmwareFileName)).canRead() && firmwareFile.length() >= 16384L;
            initializedModel = Model.getModel();
        }
        return isEnabled;
    }

    public MMIOHandlerBatteryFirmwareSfr getBatterySfr() {
        return (MMIOHandlerBatteryFirmwareSfr)this.mem.getSfr();
    }

    public static void load(BatteryMemory mem, Nec78k0Interpreter interpreter) {
        String firmwareFileName = BatteryEmulator.getFirmwareFileName();
        log.info((Object)String.format("Loading the Battery firmware from %s for %s", firmwareFileName, Model.getModelName()));
        File inputFile = new File(firmwareFileName);
        int length = (int)inputFile.length();
        byte[] buffer = new byte[length];
        try {
            FileInputStream in = new FileInputStream(inputFile);
            length = in.read(buffer);
            in.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        int baseAddress = 0;
        length = Math.min(length, 65247);
        for (int i = 0; i < length; i += 4) {
            mem.write32(baseAddress + i, Utilities.readUnaligned32(buffer, i));
        }
        SysconEmulator.loadBootloader(mem);
        BatteryEmulator.patchFirmware(mem, interpreter);
    }

    private static void patchCallt(BatteryMemory mem, int callt, int address, String name) {
        mem.setRamKnown(callt, 2);
        mem.write16(callt, (short)address);
        Nec78k0Instructions.registerFunctionName(callt, name);
    }

    private static void patchInterrupt(BatteryMemory mem, int vectorTableAddress, int address) {
        mem.setRamKnown(vectorTableAddress, 2);
        mem.write16(vectorTableAddress, (short)address);
        Nec78k0Instructions.registerFunctionName(address, Nec78k0Sfr.getInterruptName(vectorTableAddress));
    }

    private static void store(Nec78k0Memory mem, int addr, int[] data) {
        for (int i = 0; i < data.length; ++i) {
            mem.write8(addr + i, (byte)data[i]);
        }
    }

    private static void patchFirmware(BatteryMemory mem, Nec78k0Interpreter interpreter) {
        BatteryEmulator.patchCallt(mem, 64, 1301, "allocStack");
        BatteryEmulator.patchCallt(mem, 66, 1316, "freeStack");
        BatteryEmulator.patchCallt(mem, 68, 1329, "add16");
        BatteryEmulator.patchCallt(mem, 70, 1336, "zero8");
        BatteryEmulator.patchCallt(mem, 72, 1339, "one8");
        BatteryEmulator.patchCallt(mem, 74, 1342, "u8_to_u16");
        BatteryEmulator.patchCallt(mem, 76, 1345, "zero16");
        BatteryEmulator.patchCallt(mem, 78, 1349, "u16_to_u32");
        BatteryEmulator.patchCallt(mem, 80, 1353, "one16");
        BatteryEmulator.patchCallt(mem, 82, 1357, "s8_to_s16");
        BatteryEmulator.patchCallt(mem, 84, 1362, "read16");
        BatteryEmulator.patchCallt(mem, 86, 1367, "write16");
        BatteryEmulator.patchCallt(mem, 88, 1373, "read32");
        BatteryEmulator.patchCallt(mem, 90, 1386, "read32_to_FEB8");
        BatteryEmulator.patchCallt(mem, 92, 1400, "read32_to_FEBC");
        BatteryEmulator.patchCallt(mem, 94, 1412, "write32");
        BatteryEmulator.patchCallt(mem, 96, 1426, "write32_from_FEB8");
        BatteryEmulator.patchCallt(mem, 98, 1445, "isZero8");
        BatteryEmulator.patchCallt(mem, 100, 1448, "isOne8");
        BatteryEmulator.patchCallt(mem, 102, 1451, "isZeroC");
        BatteryEmulator.patchCallt(mem, 104, 1454, "incr8");
        BatteryEmulator.patchCallt(mem, 106, 1458, "decr8");
        Nec78k0Instructions.registerFunctionName(1070, "div16_FEB8");
        Nec78k0Instructions.registerFunctionName(1171, "add32_FEB8_FEBC");
        Nec78k0Instructions.registerFunctionName(1192, "sub32_FEB8_FEBC");
        Nec78k0Instructions.registerFunctionName(1247, "ror32_FEB8");
        Nec78k0Instructions.registerFunctionName(1217, "rol32_FEB8");
        Nec78k0Instructions.registerFunctionName(1278, "cmp16_FEB8");
        Nec78k0Instructions.registerFunctionName(1462, "memcpy");
        Nec78k0Instructions.registerFunctionName(3291, "readSeedFromSecureFlash");
        interpreter.registerHLECall(630, new HLE_s32_to_s16());
        interpreter.registerHLECall(655, new HLE_mul16());
        interpreter.registerHLECall(684, new HLE_mul32());
        interpreter.registerHLECall(763, new HLE_divs16());
        interpreter.registerHLECall(867, new HLE_div32());
        interpreter.registerHLECall(957, new HLE_div_rem());
        mem.setRamKnown(516, 17);
        new TPointer(mem, 516).setStringNZ(17, "SonyEnergyDevices");
        mem.setRamKnown(206, 200);
        mem.write16(404, (short)4096);
        mem.write16(402, (short)2048);
        mem.setRamKnown(406, 32);
        mem.write16(406, (short)256);
        mem.write16(408, (short)16);
        mem.setRamKnown(438, 32);
        mem.write16(438, (short)16);
        mem.getSfr().getSecureFlash().write8(2032, SysconBatteryEmulator.challenge1secret8[0]);
        mem.getSfr().getSecureFlash().write8(2034, SysconBatteryEmulator.challenge1secret10[0]);
        mem.getSfr().getSecureFlash().write8(2037, SysconBatteryEmulator.challenge1secret13[0]);
        int baseChallenge1SecretAddr = 0;
        int baseChallenge2SecretAddr = 0;
        if (batteryModel == 2) {
            baseChallenge1SecretAddr = 64718;
            baseChallenge2SecretAddr = 468;
        } else if (batteryModel == 1) {
            baseChallenge1SecretAddr = 64772;
            baseChallenge2SecretAddr = 468;
        }
        if (baseChallenge1SecretAddr != 0) {
            mem.setRamKnown(baseChallenge1SecretAddr, 64);
            BatteryEmulator.store(mem, baseChallenge1SecretAddr + 0, SysconBatteryEmulator.challenge1secret8);
            BatteryEmulator.store(mem, baseChallenge1SecretAddr + 16, SysconBatteryEmulator.challenge1secret10);
            BatteryEmulator.store(mem, baseChallenge1SecretAddr + 40, SysconBatteryEmulator.challenge1secret13);
        }
        if (baseChallenge2SecretAddr != 0) {
            mem.setRamKnown(baseChallenge2SecretAddr, 64);
            BatteryEmulator.store(mem, baseChallenge2SecretAddr + 0, SysconBatteryEmulator.challenge2secret8);
            BatteryEmulator.store(mem, baseChallenge2SecretAddr + 16, SysconBatteryEmulator.challenge2secret10);
            BatteryEmulator.store(mem, baseChallenge2SecretAddr + 40, SysconBatteryEmulator.challenge2secret13);
        }
        int mainLoopAddr = -1;
        int bootAddr = -1;
        if (batteryModel == 2) {
            Nec78k0Instructions.registerFunctionName(1571, "memset");
            Nec78k0Instructions.registerFunctionName(12411, "processCommandReceivedFromSyscon");
            Nec78k0Instructions.registerFunctionName(10917, "readBatteryEEPROMWithRetry");
            Nec78k0Instructions.registerFunctionName(10545, "EEPROM_tickClock");
            Nec78k0Instructions.registerFunctionName(10645, "EEPROM_send8bits");
            Nec78k0Instructions.registerFunctionName(10698, "EEPROM_receive16bits");
            Nec78k0Instructions.registerFunctionName(10554, "EEPROM_EraseWriteEnable");
            Nec78k0Instructions.registerFunctionName(10608, "EEPROM_EraseWriteDisable");
            Nec78k0Instructions.registerFunctionName(10826, "EEPROM_Write");
            Nec78k0Instructions.registerFunctionName(10764, "EEPROM_Read");
            Nec78k0Instructions.registerFunctionName(11048, "mainLoop");
            Nec78k0Instructions.registerFunctionName(12017, "readAD");
            BatteryEmulator.patchInterrupt(mem, 20, 15755);
            BatteryEmulator.patchInterrupt(mem, 22, 16092);
            BatteryEmulator.patchInterrupt(mem, 36, 12093);
            BatteryEmulator.patchInterrupt(mem, 10, 12239);
            BatteryEmulator.patchInterrupt(mem, 32, 16153);
            BatteryEmulator.patchInterrupt(mem, 28, 11953);
            BatteryEmulator.patchInterrupt(mem, 26, 12222);
            mainLoopAddr = 11048;
            bootAddr = 16232;
        } else if (batteryModel == 1) {
            Nec78k0Instructions.registerFunctionName(12380, "processCommandReceivedFromSyscon");
            Nec78k0Instructions.registerFunctionName(10890, "readBatteryEEPROMWithRetry");
            Nec78k0Instructions.registerFunctionName(10518, "EEPROM_tickClock");
            Nec78k0Instructions.registerFunctionName(10618, "EEPROM_send8bits");
            Nec78k0Instructions.registerFunctionName(10671, "EEPROM_receive16bits");
            Nec78k0Instructions.registerFunctionName(10527, "EEPROM_EraseWriteEnable");
            Nec78k0Instructions.registerFunctionName(10581, "EEPROM_EraseWriteDisable");
            Nec78k0Instructions.registerFunctionName(10799, "EEPROM_Write");
            Nec78k0Instructions.registerFunctionName(10737, "EEPROM_Read");
            Nec78k0Instructions.registerFunctionName(11021, "mainLoop");
            Nec78k0Instructions.registerFunctionName(11986, "readAD");
            BatteryEmulator.patchInterrupt(mem, 20, 15697);
            BatteryEmulator.patchInterrupt(mem, 22, 16034);
            BatteryEmulator.patchInterrupt(mem, 36, 12062);
            BatteryEmulator.patchInterrupt(mem, 10, 12208);
            BatteryEmulator.patchInterrupt(mem, 32, 16095);
            BatteryEmulator.patchInterrupt(mem, 28, 11922);
            BatteryEmulator.patchInterrupt(mem, 26, 12191);
            mainLoopAddr = 11021;
            bootAddr = 16174;
        } else {
            log.error((Object)String.format("Unsupported Battery model %d", batteryModel));
        }
        int resetAddr = 32512;
        int spAddr = 32256;
        BatteryEmulator.patchInterrupt(mem, 0, 32512);
        int addr = 32512;
        Utilities.writeUnaligned16(mem, addr, 7406);
        Utilities.writeUnaligned16(mem, addr += 2, 32256);
        mem.write8(addr += 2, (byte)-102);
        Utilities.writeUnaligned16(mem, ++addr, bootAddr);
        Utilities.writeUnaligned16(mem, addr += 2, 113);
        mem.write8(addr += 2, (byte)-102);
        Utilities.writeUnaligned16(mem, ++addr, mainLoopAddr);
        mem.write8(addr += 2, (byte)-81);
        ++addr;
    }

    public void boot() {
        if (this.thread == null) {
            this.thread = new BatteryProcessorThread();
            this.thread.setName("Battery NEC 78k0 Processor Thread");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            log.error((Object)String.format("BatteryEmulator.boot() BatteryProcessorThread already running", new Object[0]));
        }
    }

    public void exit() {
        this.exit = true;
        this.interpreter.exitInterpreter();
        while (this.thread != null) {
            Utilities.sleep(1, 0);
        }
    }

    public static int readEeprom16(int address) {
        int value = Battery.readEeprom(address << 1) << 8 | Battery.readEeprom((address << 1) + 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("EEPROM Read address=0x%02X: 0x%04X", address, value));
        }
        return value;
    }

    public static void writeEeprom16(int address, int value) {
        value &= 0xFFFF;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("EEPROM Write address=0x%02X: 0x%04X", address, value));
        }
        Battery.writeEeprom((address << 1) + 0, value >> 8);
        Battery.writeEeprom((address << 1) + 1, value);
    }

    static {
        initializedModel = -1;
    }

    private class BatteryProcessorThread
    extends Thread {
        private BatteryProcessorThread() {
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            BatteryEmulator.load(BatteryEmulator.this.mem, BatteryEmulator.this.interpreter);
            BatteryEmulator.this.processor.reset();
            while (!Emulator.pause && !BatteryEmulator.this.exit) {
                BatteryEmulator.this.interpreter.setHalted(false);
                BatteryEmulator.this.interpreter.run();
            }
            BatteryEmulator.this.thread = null;
        }
    }

    private static class HLE_div_rem
    implements INec78k0HLECall {
        private HLE_div_rem() {
        }

        @Override
        public void call(Nec78k0Processor processor, int insn) {
            int value1 = processor.mem.read32(65208);
            int value2 = processor.mem.read16(65212) | processor.getRegisterPair(0) << 16;
            short quotient16 = (short)(value2 == 0 ? value1 : value1 / value2);
            short remainder16 = (short)(value2 == 0 ? value1 : value1 % value2);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unknown03BD div_rem 0x%08X / 0x%08X = 0x%04X, remainder 0x%04X", value1, value2, (int)quotient16, (int)remainder16));
            }
            processor.mem.write16(65208, quotient16);
            processor.mem.write16(65210, remainder16);
        }
    }

    private static class HLE_div32
    implements INec78k0HLECall {
        private HLE_div32() {
        }

        @Override
        public void call(Nec78k0Processor processor, int insn) {
            int result;
            int value1 = processor.mem.read32(65208);
            int value2 = processor.mem.read16(65212) | processor.getRegisterPair(0) << 16;
            int n = result = value2 == 0 ? value1 : value1 / value2;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("HLE_div32 0x%08X / 0x%08X = 0x%08X", value1, value2, result));
            }
            processor.mem.write32(65208, result);
        }
    }

    private static class HLE_divs16
    implements INec78k0HLECall {
        private HLE_divs16() {
        }

        @Override
        public void call(Nec78k0Processor processor, int insn) {
            int result;
            int value1 = processor.mem.read16(65208);
            short value2 = (short)processor.getRegisterPair(0);
            int n = result = value2 == 0 ? value1 : value1 / value2;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("HLE_divs16 0x%04X / 0x%04X = 0x%04X", value1, (int)value2, result));
            }
            processor.setRegisterPair(0, result);
        }
    }

    private static class HLE_mul32
    implements INec78k0HLECall {
        private HLE_mul32() {
        }

        @Override
        public void call(Nec78k0Processor processor, int insn) {
            int value1 = processor.mem.read32(65208);
            int value2 = processor.mem.read32(65212) | processor.getRegisterPair(0) << 16;
            int result = value1 * value2;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("HLE_mul32 0x%08X * 0x%08X = 0x%08X", value1, value2, result));
            }
            processor.mem.write32(65208, result);
        }
    }

    private static class HLE_mul16
    implements INec78k0HLECall {
        private HLE_mul16() {
        }

        @Override
        public void call(Nec78k0Processor processor, int insn) {
            int value1 = processor.mem.read16(65208);
            int value2 = processor.getRegisterPair(0);
            int result = value1 * value2 & 0xFFFF;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("HLE_mul16 0x%04X * 0x%04X = 0x%04X", value1, value2, result));
            }
            processor.setRegisterPair(0, result);
        }
    }

    private static class HLE_s32_to_s16
    implements INec78k0HLECall {
        private HLE_s32_to_s16() {
        }

        @Override
        public void call(Nec78k0Processor processor, int insn) {
            int value1 = processor.mem.read32(65208);
            short result = (short)value1;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("HLE_s32_to_s16 0x%08X = 0x%04X", value1, (int)result));
            }
            processor.mem.write16(65208, result);
        }
    }
}

