/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.battery;

import jpcsp.memory.mmio.syscon.SysconBatteryEmulator;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterface;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceUART6;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;

public class BatteryToSysconSerialInterface
extends Nec78k0SerialInterface {
    private final Nec78k0Sfr sysconSfr;
    private final int[] buffer = new int[21];
    private int index;

    public BatteryToSysconSerialInterface(Nec78k0Sfr sfr, Nec78k0SerialInterfaceUART6 serialInterface, Nec78k0Sfr sysconSfr) {
        super(sfr, serialInterface);
        this.sysconSfr = sysconSfr;
    }

    private Nec78k0SerialInterface getSysconSerialInterface() {
        return this.sysconSfr.getSerialInterfaceUART6().getConnectedSerialInterface();
    }

    @Override
    public synchronized void startTransmission() {
        this.getSysconSerialInterface().startReception();
        super.startTransmission();
    }

    private void debugTransmit(int value) {
        if (value == 165) {
            this.index = 0;
        }
        this.buffer[this.index++] = value;
        if (this.index >= 2 && this.index == this.buffer[1] + 2 && this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 Battery response %s", SysconBatteryEmulator.intsToString(this.buffer, 0, this.index)));
        }
    }

    @Override
    public synchronized void transmit(int value) {
        this.debugTransmit(value);
        this.getSysconSerialInterface().received(value);
        super.transmit(value);
    }
}

