/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.battery;

import java.io.IOException;
import jpcsp.memory.mmio.battery.BatteryAdConverter;
import jpcsp.memory.mmio.battery.BatteryEmulator;
import jpcsp.memory.mmio.battery.BatterySerialInterface;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class MMIOHandlerBatteryFirmwareSfr
extends Nec78k0Sfr {
    private static final int STATE_VERSION = 0;
    private int eepromValue;
    private int eepromBitCount;
    private int eepromBitExpected;
    private boolean eepromEraseWriteEnabled;

    public MMIOHandlerBatteryFirmwareSfr(int baseAddress) {
        super(baseAddress);
        this.adConverter = new BatteryAdConverter(this, this.scheduler);
        if (BatteryEmulator.isEnabled()) {
            this.serialInterfaceUART6.setSerialInterface(null);
        } else {
            this.serialInterfaceUART6.setSerialInterface(new BatterySerialInterface(this, this.serialInterfaceUART6));
        }
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.eepromValue = 0;
        this.eepromBitCount = 0;
        this.eepromBitExpected = 11;
        this.eepromEraseWriteEnabled = false;
        this.setPortInputBit(12, 0);
    }

    private void processEeprom(int port) {
        int dataPortBit = 3;
        if (this.isInputPort(port, 3)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("EEPROM read value=0x%X, count=%d", this.eepromValue, this.eepromBitCount));
            }
            if (Utilities.hasBit(this.eepromValue, this.eepromBitExpected - 1)) {
                this.setPortInputBit(port, 3);
            } else {
                this.clearPortInputBit(port, 3);
            }
            this.eepromValue = this.eepromValue << 1 & 0xFFFF;
            ++this.eepromBitCount;
            if (this.eepromBitCount == this.eepromBitExpected) {
                this.eepromBitCount = 0;
                this.eepromValue = 0;
                this.eepromBitExpected = 11;
            }
        } else {
            this.eepromValue <<= 1;
            if (this.getPortOutputBit(port, 3)) {
                this.eepromValue |= 1;
            }
            ++this.eepromBitCount;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("EEPROM write value=0x%X, count=%d", this.eepromValue, this.eepromBitCount));
            }
            if (this.eepromBitCount == this.eepromBitExpected) {
                int instruction = this.eepromValue >> this.eepromBitExpected - 3 & 7;
                int address = this.eepromValue >> this.eepromBitExpected - 11 & 0xFF;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("EEPROM instruction=0x%X, address=0x%02X", instruction, address));
                }
                switch (instruction) {
                    case 6: {
                        this.eepromValue = BatteryEmulator.readEeprom16(address);
                        this.eepromBitCount = 0;
                        this.eepromBitExpected = 16;
                        break;
                    }
                    case 4: {
                        int subInstruction = address >> 6 & 3;
                        switch (subInstruction) {
                            case 0: {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)String.format("EEPROM Erase Write Disable", new Object[0]));
                                }
                                this.eepromEraseWriteEnabled = false;
                                break;
                            }
                            case 1: {
                                this.log.error((Object)String.format("EEPROM unimplemented Write All instruction", new Object[0]));
                                break;
                            }
                            case 2: {
                                this.log.error((Object)String.format("EEPROM unimplemented Erase All instruction", new Object[0]));
                                break;
                            }
                            case 3: {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)String.format("EEPROM Erase Write Enable", new Object[0]));
                                }
                                this.eepromEraseWriteEnabled = true;
                            }
                        }
                        this.eepromValue = 0;
                        this.eepromBitCount = 0;
                        this.eepromBitExpected = 11;
                        break;
                    }
                    case 5: {
                        if (this.eepromBitExpected == 27) {
                            if (!this.eepromEraseWriteEnabled) {
                                this.log.debug((Object)String.format("EEPROM Write not enabled for address=0x%02X: 0x%04X", address, this.eepromValue & 0xFFFF));
                            } else {
                                BatteryEmulator.writeEeprom16(address, this.eepromValue);
                            }
                            this.eepromValue = 0;
                            this.eepromBitCount = 0;
                            this.eepromBitExpected = 11;
                            break;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)String.format("EEPROM Write address=0x%02X: collecting 16-bit data", address));
                        }
                        this.eepromBitExpected += 16;
                        break;
                    }
                    default: {
                        this.eepromValue = 0;
                        this.eepromBitCount = 0;
                        this.eepromBitExpected = 11;
                        this.log.error((Object)String.format("EEPROM unimplemented instruction=0x%X, address=0x%02X", instruction, address));
                    }
                }
            }
        }
    }

    @Override
    protected void setPortOutput(int port, int value) {
        int oldValue;
        if (port == 3 && Utilities.isRaisingBit(oldValue = this.getPortOutput(port), value, 0)) {
            this.processEeprom(port);
        }
        super.setPortOutput(port, value);
    }

    @Override
    public String toString() {
        return String.format("Battery SFR %s", this.debugInterruptRequests());
    }
}

