/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.syscon;

import java.io.IOException;
import jpcsp.State;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.MMIOHandlerGpio;
import jpcsp.memory.mmio.battery.BatteryEmulator;
import jpcsp.memory.mmio.syscon.MMIOHandlerSyscon;
import jpcsp.memory.mmio.syscon.SysconAdConverter;
import jpcsp.memory.mmio.syscon.SysconBatteryEmulator;
import jpcsp.memory.mmio.syscon.SysconBootloaderEmulator;
import jpcsp.memory.mmio.syscon.SysconEmulator;
import jpcsp.memory.mmio.syscon.SysconI2c;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class MMIOHandlerSysconFirmwareSfr
extends Nec78k0Sfr {
    private static final int STATE_VERSION = 0;
    public static boolean dummyTesting = false;
    private int keyPowerStartup;
    private int bootloaderP1_4_switch;

    public MMIOHandlerSysconFirmwareSfr(int baseAddress) {
        super(baseAddress);
        this.i2c = new SysconI2c(this);
        this.adConverter = new SysconAdConverter(this, this.scheduler);
        if (SysconEmulator.firmwareBootloader) {
            this.serialInterfaceUART6.setSerialInterface(new SysconBootloaderEmulator(this, this.serialInterfaceUART6));
        } else if (BatteryEmulator.isEnabled()) {
            this.serialInterfaceUART6.setSerialInterface(null);
        } else {
            this.serialInterfaceUART6.setSerialInterface(new SysconBatteryEmulator(this, this.serialInterfaceUART6));
        }
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.keyPowerStartup = stream.readInt();
        this.bootloaderP1_4_switch = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.keyPowerStartup);
        stream.writeInt(this.bootloaderP1_4_switch);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.setPortInputBit(12, 0);
        this.setPortInputBit(1, 6);
        this.keyPowerStartup = 0;
        this.bootloaderP1_4_switch = 0;
        this.setInterruptRequest(PIF1);
    }

    public void startSysconCmd(int[] data) {
        this.getSerialInterface().setReceiveBuffer(data);
        this.setInterruptRequest(PIF2);
    }

    public void endSysconCmd() {
        MMIOHandlerSyscon.getInstance().clearData();
        int[] data = new int[16];
        int length = this.getSerialInterface().getSendBuffer(data);
        for (int i = 0; i < length; ++i) {
            MMIOHandlerSyscon.getInstance().setDataValue(i, data[i]);
        }
        if (this.log.isDebugEnabled()) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(String.format("0x%02X", data[i]));
            }
            this.log.debug((Object)String.format("End of syscon cmd: %s", s));
        }
    }

    private void updateButtonsPortInput(int port) {
        State.controller.hleControllerPoll();
        int buttons = State.controller.getButtons();
        switch (port) {
            case 2: {
                if (!this.isKE2()) break;
                this.setButtonPortInput(2, 0, 65536, buttons);
                this.setButtonPortInput(2, 1, 131072, buttons);
                break;
            }
            case 3: {
                int keyPowerStartupCount;
                int n = keyPowerStartupCount = Model.getModel() == 0 ? 10 : 20;
                if (this.keyPowerStartup > keyPowerStartupCount) {
                    this.setButtonPortInput(3, 0, 131072, buttons);
                    break;
                }
                if (this.keyPowerStartup == 10) {
                    this.setPortInputBit(3, 0);
                } else {
                    this.clearPortInputBit(3, 0);
                }
                ++this.keyPowerStartup;
                break;
            }
            case 4: {
                this.setButtonPortInput(4, 0, 1, buttons);
                this.setButtonPortInput(4, 1, 256, buttons);
                this.setButtonPortInput(4, 2, 512, buttons);
                this.setButtonPortInput(4, 3, 8, buttons);
                if (!this.isKF2()) break;
                this.setButtonPortInput(4, 4, 65536, buttons);
                this.setButtonPortInput(4, 5, 131072, buttons);
                break;
            }
            case 5: {
                this.setButtonPortInput(5, 0, 0x100000, buttons);
                this.setButtonPortInput(5, 1, 0x200000, buttons);
                this.setButtonPortInput(5, 2, 0x400000, buttons);
                this.setButtonPortInput(5, 3, 0x800000, buttons);
                break;
            }
            case 7: {
                this.setButtonPortInput(7, 0, 16, buttons);
                this.setButtonPortInput(7, 1, 32, buttons);
                this.setButtonPortInput(7, 2, 64, buttons);
                this.setButtonPortInput(7, 3, 128, buttons);
                this.setButtonPortInput(7, 4, 4096, buttons);
                this.setButtonPortInput(7, 5, 8192, buttons);
                this.setButtonPortInput(7, 6, 16384, buttons);
                this.setButtonPortInput(7, 7, 32768, buttons);
            }
        }
    }

    private void updatePortInput(int port) {
        switch (port) {
            case 1: {
                if (!SysconEmulator.firmwareBootloader) break;
                if (this.bootloaderP1_4_switch > 0) {
                    if (Utilities.hasBit(this.getPortInput(port), 4)) {
                        this.clearPortInputBit(port, 4);
                    } else {
                        this.setPortInputBit(port, 4);
                    }
                    this.bootloaderP1_4_switch = 0;
                    break;
                }
                ++this.bootloaderP1_4_switch;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.updateButtonsPortInput(port);
            }
        }
    }

    @Override
    protected int getPortValue(int port) {
        this.updatePortInput(port);
        return super.getPortValue(port);
    }

    @Override
    protected void setPortOutput(int port, int value) {
        int tachyonBit;
        int oldValue = this.getPortOutput(port);
        super.setPortOutput(port, value);
        int tachyonPort = this.isKF2() ? 4 : 0;
        int n = tachyonBit = this.isKF2() ? 6 : 4;
        if (port == tachyonPort) {
            if (Utilities.isRaisingBit(oldValue, value, tachyonBit)) {
                MMIOHandlerGpio.getInstance().clearPort(4);
            } else if (Utilities.isFallingBit(oldValue, value, tachyonBit)) {
                this.endSysconCmd();
                MMIOHandlerGpio.getInstance().setPort(4);
            }
        }
    }

    @Override
    protected void setInterruptMaskFlag0(int interruptMaskFlag0) {
        if (dummyTesting && Utilities.hasBit(this.getSerialInterface().getOperationMode(), 7) && Utilities.isFallingBit(this.interruptMaskFlag0, interruptMaskFlag0, PIF2)) {
            this.startSysconCmd(new int[]{1, 2, 252, 0, 0, 0, 0, 0, 0, 0});
        }
        super.setInterruptMaskFlag0(interruptMaskFlag0);
    }

    @Override
    public String toString() {
        return String.format("Syscon SFR %s", this.debugInterruptRequests());
    }
}

