/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.syscon;

import jpcsp.HLE.Modules;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.Nec78k0I2c;

public class SysconI2c
extends Nec78k0I2c {
    public static final int I2C_SLAVE_ADDRESS_POLESTAR = 170;
    public static final int I2C_SLAVE_ADDRESS_POMMEL = 208;

    public SysconI2c(MMIOHandlerSysconFirmwareSfr sfr) {
        super(sfr);
    }

    @Override
    protected void performRead() {
        switch (this.getSlaveAddress()) {
            case 208: {
                int registerNumber = this.buffer[0];
                int registerValue = Modules.sceSysconModule.readPommelRegister(registerNumber);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("readPommelRegister(0x%02X)=0x%04X", registerNumber, registerValue));
                }
                this.buffer[0] = registerValue & 0xFF;
                this.buffer[1] = registerValue >> 8 & 0xFF;
                break;
            }
            case 170: {
                int registerNumber = this.buffer[0];
                int registerValue = Modules.sceSysconModule.readPolestarRegister(registerNumber);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("readPolestarRegister(0x%02X)=0x%04X", registerNumber, registerValue));
                }
                this.buffer[0] = registerValue & 0xFF;
                this.buffer[1] = registerValue >> 8 & 0xFF;
                break;
            }
            default: {
                this.log.error((Object)String.format("I2c unimplemented read from slaveAddress 0x%02X", this.getSlaveAddress()));
            }
        }
    }
}

