/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.umd;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.iso.UmdIsoReaderVirtualFile;
import jpcsp.HLE.modules.sceUmdMan;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerGpio;
import jpcsp.memory.mmio.umd.MMIOHandlerUmdAta;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerUmd
extends MMIOHandlerBase {
    public static Logger log = sceUmdMan.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1108344832;
    private static MMIOHandlerUmd instance;
    private int command;
    private int reset;
    private int interrupt;
    private int interruptEnabled;
    private int totalTransferLength;
    protected final int[] transferAddresses = new int[10];
    protected final int[] transferSizes = new int[10];
    private static final int[] QTGP2;
    private static final int[] QTGP3;
    private String umdFileName;
    private UmdIsoReaderVirtualFile vFile;
    public static final int[] regionCodes;

    public static MMIOHandlerUmd getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerUmd(-1108344832);
        }
        return instance;
    }

    private MMIOHandlerUmd(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.command = stream.readInt();
        this.reset = stream.readInt();
        this.interrupt = stream.readInt();
        this.interruptEnabled = stream.readInt();
        this.totalTransferLength = stream.readInt();
        stream.readInts(this.transferAddresses);
        stream.readInts(this.transferSizes);
        this.umdFileName = stream.readString();
        super.read(stream);
        this.switchUmd(this.umdFileName);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.command);
        stream.writeInt(this.reset);
        stream.writeInt(this.interrupt);
        stream.writeInt(this.interruptEnabled);
        stream.writeInt(this.totalTransferLength);
        stream.writeInts(this.transferAddresses);
        stream.writeInts(this.transferSizes);
        stream.writeString(this.umdFileName);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.command = 0;
        this.reset = 0;
        this.interrupt = 0;
        this.interruptEnabled = 0;
        this.totalTransferLength = 0;
        Arrays.fill(this.transferAddresses, 0);
        Arrays.fill(this.transferSizes, 0);
    }

    private void updateUmd() {
        if (this.vFile != null) {
            MMIOHandlerGpio.getInstance().setPort(26);
        } else {
            MMIOHandlerGpio.getInstance().clearPort(26);
        }
    }

    private void closeFile() {
        this.umdFileName = null;
        if (this.vFile != null) {
            this.vFile.ioClose();
            this.vFile = null;
            this.updateUmd();
        }
    }

    public boolean hasUmdInserted() {
        return this.vFile != null;
    }

    public void switchUmd(String fileName) throws IOException {
        this.closeFile();
        if (fileName != null) {
            log.info((Object)String.format("Using UMD '%s'", fileName));
            this.umdFileName = fileName;
            this.vFile = new UmdIsoReaderVirtualFile(fileName);
        }
        this.updateUmd();
    }

    private void setReset(int reset) {
        this.reset = reset;
        if ((reset & 1) != 0) {
            MMIOHandlerGpio.getInstance().setPort(24);
            this.updateUmd();
        }
    }

    private boolean isUmdFilePresent(String fileName) {
        if (this.vFile == null) {
            return false;
        }
        return this.vFile.hasFile(fileName);
    }

    private boolean isGameUmd() {
        return this.isUmdFilePresent("PSP_GAME/param.sfo");
    }

    private boolean isVideoUmd() {
        return this.isUmdFilePresent("UMD_VIDEO/param.sfo");
    }

    private boolean isAudioUmd() {
        return this.isUmdFilePresent("UMD_AUDIO/param.sfo");
    }

    private void setCommand(int command) {
        this.command = command;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MMIOHandlerUmd.setCommand command 0x%X", command));
        }
        switch (command & 0xFF) {
            case 1: {
                this.interrupt |= 1;
                break;
            }
            case 2: {
                this.interrupt |= 1;
                break;
            }
            case 3: {
                this.interrupt |= 1;
                break;
            }
            case 4: {
                for (int i = 0; i < QTGP2.length && i < this.transferSizes[0]; ++i) {
                    this.getMemory().write8(this.transferAddresses[0] + i, (byte)QTGP2[i]);
                }
                this.interrupt |= 1;
                break;
            }
            case 5: {
                for (int i = 0; i < QTGP3.length && i < this.transferSizes[0]; ++i) {
                    this.getMemory().write8(this.transferAddresses[0] + i, (byte)QTGP3[i]);
                }
                this.interrupt |= 1;
                break;
            }
            case 8: {
                int regionCodeType = 0;
                if (this.isGameUmd()) {
                    regionCodeType = 0;
                } else if (this.isVideoUmd()) {
                    regionCodeType = 32;
                } else if (this.isAudioUmd()) {
                    regionCodeType = 64;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("MMIOHandlerUmd.setCommand command=0x%X, transferLength=0x%X, umdType=0x%X", command, this.totalTransferLength, regionCodeType));
                }
                TPointer result = new TPointer(this.getMemory(), this.transferAddresses[0]);
                result.setValue32(0, 305419896);
                result.setValue32(0, 0);
                result.setValue32(12, 2);
                int regionSize = 24;
                TPointer region = new TPointer(result, 40);
                region.clear(24);
                for (int i = 0; i < regionCodes.length; i += 2) {
                    if ((regionCodes[i] & 0xF0) != regionCodeType) continue;
                    region.setValue32(0, regionCodes[i]);
                    region.setValue32(4, regionCodes[i + 1]);
                    break;
                }
                region.add(24);
                region.clear(24);
                region.setValue32(0, 1);
                region.setValue32(4, 0);
                this.interrupt |= 1;
                MMIOHandlerUmdAta.getInstance().commandCompleted();
                break;
            }
            case 9: {
                this.interrupt |= 1;
                break;
            }
            case 10: {
                int lba = MMIOHandlerUmdAta.getInstance().getLogicalBlockAddress();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("MMIOHandlerUmd.setCommand command=0x%X, transferLength=0x%X, lba=0x%X", command, this.totalTransferLength, lba));
                }
                if (this.vFile == null) {
                    log.error((Object)String.format("MMIOHandlerUmd no UMD loaded", new Object[0]));
                } else {
                    int fileLength = this.totalTransferLength / 2064 * 2048;
                    long offset = ((long)lba & 0xFFFFFFFFL) * 2048L;
                    long seekResult = this.vFile.ioLseek(offset);
                    if (seekResult < 0L) {
                        log.error((Object)String.format("MMIOHandlerUmd.setCommand seek error 0x%08X", seekResult));
                    } else if (seekResult != offset) {
                        log.error((Object)String.format("MMIOHandlerUmd.setCommand incorrect seek: offset=0x%X, seekResult=0x%X", offset, seekResult));
                    } else {
                        for (int i = 0; fileLength > 0 && i < this.transferAddresses.length; ++i) {
                            int transferLength;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("MMIOHandlerUmd.setCommand reading 0x%X bytes at 0x%08X", this.transferSizes[i], this.transferAddresses[i]));
                            }
                            if ((transferLength = this.transferSizes[i]) <= 0) continue;
                            TPointer addr = new TPointer(this.getMemory(), this.transferAddresses[i] & 0xFFFFFFFC);
                            int readResult = this.vFile.ioRead(addr, transferLength);
                            if (readResult < 0) {
                                log.error((Object)String.format("MMIOHandlerUmd.setCommand read error 0x%08X", readResult));
                                break;
                            }
                            if (readResult != transferLength) {
                                log.error((Object)String.format("MMIOHandlerUmd.setCommand uncomplete read: transferLength=0x%X, readLength=0x%X", transferLength, readResult));
                                break;
                            }
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("MMIOHandlerUmd.setCommand read 0x%X bytes: %s", readResult, Utilities.getMemoryDump(addr, readResult)));
                            }
                            fileLength -= transferLength;
                        }
                    }
                }
                this.interrupt |= 1;
                MMIOHandlerUmdAta.getInstance().commandCompleted();
                break;
            }
            case 11: {
                break;
            }
            default: {
                log.error((Object)String.format("MMIOHandlerUmd.setCommand unknown command 0x%X", command));
            }
        }
        this.checkInterrupt();
    }

    private void checkInterrupt() {
        if ((this.interrupt & this.interruptEnabled) != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 6);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 6);
        }
    }

    private void clearInterrupt(int interrupt) {
        this.interrupt &= ~interrupt;
        this.checkInterrupt();
    }

    private void enableInterrupt(int interruptEnabled) {
        this.interruptEnabled |= interruptEnabled;
        this.checkInterrupt();
    }

    private void disableInterrupt(int interruptEnabled) {
        this.interruptEnabled &= ~interruptEnabled;
        this.checkInterrupt();
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 8: {
                value = this.reset;
                break;
            }
            case 16: {
                value = 0;
                break;
            }
            case 20: {
                value = 0;
                break;
            }
            case 24: {
                value = 0;
                break;
            }
            case 28: {
                value = 0;
                break;
            }
            case 32: {
                value = this.interrupt;
                break;
            }
            case 36: {
                value = 0;
                break;
            }
            case 40: {
                value = this.interruptEnabled;
                break;
            }
            case 44: {
                value = 0;
                break;
            }
            case 48: {
                value = 0;
                break;
            }
            case 56: {
                value = 0;
                break;
            }
            case 144: {
                value = this.totalTransferLength;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 8: {
                this.setReset(value);
                break;
            }
            case 16: {
                this.setCommand(value);
                break;
            }
            case 36: {
                this.clearInterrupt(value);
                break;
            }
            case 40: {
                this.enableInterrupt(value);
                break;
            }
            case 44: {
                this.disableInterrupt(value);
                break;
            }
            case 48: {
                if (value == 4) break;
                super.write32(address, value);
                break;
            }
            case 56: {
                if (value == 4) break;
                super.write32(address, value);
                break;
            }
            case 64: {
                this.transferAddresses[0] = value;
                break;
            }
            case 68: {
                this.transferSizes[0] = value;
                break;
            }
            case 72: {
                this.transferAddresses[1] = value;
                break;
            }
            case 76: {
                this.transferSizes[1] = value;
                break;
            }
            case 80: {
                this.transferAddresses[2] = value;
                break;
            }
            case 84: {
                this.transferSizes[2] = value;
                break;
            }
            case 88: {
                this.transferAddresses[3] = value;
                break;
            }
            case 92: {
                this.transferSizes[3] = value;
                break;
            }
            case 96: {
                this.transferAddresses[4] = value;
                break;
            }
            case 100: {
                this.transferSizes[4] = value;
                break;
            }
            case 104: {
                this.transferAddresses[5] = value;
                break;
            }
            case 108: {
                this.transferSizes[5] = value;
                break;
            }
            case 112: {
                this.transferAddresses[6] = value;
                break;
            }
            case 116: {
                this.transferSizes[6] = value;
                break;
            }
            case 120: {
                this.transferAddresses[7] = value;
                break;
            }
            case 124: {
                this.transferSizes[7] = value;
                break;
            }
            case 128: {
                this.transferAddresses[8] = value;
                break;
            }
            case 132: {
                this.transferSizes[8] = value;
                break;
            }
            case 136: {
                this.transferAddresses[9] = value;
                break;
            }
            case 140: {
                this.transferSizes[9] = value;
                break;
            }
            case 144: {
                this.totalTransferLength = value;
                break;
            }
            case 148: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    static {
        QTGP2 = new int[]{18, 52, 86, 120, 154, 188, 222, 240};
        QTGP3 = new int[]{15, 237, 203, 169, 135, 101, 67, 33, 18, 52, 86, 120, 154, 188, 222, 240};
        regionCodes = new int[]{-1, -2147483647, 2, Integer.MIN_VALUE, 15, Integer.MIN_VALUE, 18, Integer.MIN_VALUE, 31, Integer.MIN_VALUE, 34, Integer.MIN_VALUE, 47, Integer.MIN_VALUE, 50, Integer.MIN_VALUE, 63, Integer.MIN_VALUE, 66, Integer.MIN_VALUE, 79, Integer.MIN_VALUE, 0x1000000F, Integer.MIN_VALUE, 0x1000001F, Integer.MIN_VALUE, 268435503, Integer.MIN_VALUE, 268435519, Integer.MIN_VALUE, 268435535, Integer.MIN_VALUE, 0x2000000F, Integer.MIN_VALUE, 1, 0};
    }
}

