/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import jpcsp.arm.ARMProcessor;
import jpcsp.arm.IARMHLECall;
import jpcsp.memory.mmio.wlan.WlanEmulator;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public abstract class BaseHLECall
implements IARMHLECall {
    public static Logger log = WlanEmulator.log;

    protected void jump(ARMProcessor processor, int addr) {
        processor.jumpWithMode(addr);
    }

    protected void returnToLr(ARMProcessor processor) {
        this.jump(processor, processor.getLr());
    }

    protected void returnToLr(ARMProcessor processor, int returnValue) {
        processor.setRegister(0, returnValue);
        this.returnToLr(processor);
    }

    protected int getParameterValue(ARMProcessor processor, int n) {
        int value;
        if (n <= 3) {
            value = processor.getRegister(n);
        } else {
            int sp = processor.getSp();
            int offset = n - 4 << 2;
            value = processor.mem.read32(sp + offset);
        }
        return value;
    }

    protected String readStringZ(ARMProcessor processor, int address) {
        if (address == 0) {
            return null;
        }
        return Utilities.readStringZ(processor.mem, address);
    }

    protected String readStringNZ(ARMProcessor processor, int address, int length) {
        if (address == 0) {
            return null;
        }
        return Utilities.readStringNZ(processor.mem, address, length);
    }

    protected void execute(ARMProcessor processor, int addr, String comment) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Starting CodeBlock 0x%08X for %s", Utilities.clearBit(addr, 0), comment));
        }
        processor.jumpWithMode(addr);
        processor.setLr(-4);
        processor.interpreter.run();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Returning from CodeBlock 0x%08X for %s", Utilities.clearBit(addr, 0), comment));
        }
    }

    protected String getMemoryDump(ARMProcessor processor, int addr, int length) {
        return Utilities.getMemoryDump(processor.mem, addr, length);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

