/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.wlan.BaseHLECall;

public class HLEMemcpy
extends BaseHLECall {
    private String getAdditionalInfo(ARMProcessor processor, int dest, int src, int size) {
        String additionalInfo = "";
        if (size == 6) {
            byte[] macAddress = new byte[6];
            for (int i = 0; i < 6; ++i) {
                macAddress[i] = (byte)processor.mem.internalRead8(src + i);
            }
            if (pspNetMacAddress.isMyMacAddress(macAddress) || pspNetMacAddress.isAnyMacAddress(macAddress)) {
                additionalInfo = String.format("MAC Address %s", pspNetMacAddress.toString(macAddress));
            }
        }
        return additionalInfo;
    }

    @Override
    public void call(ARMProcessor processor, int imm) {
        int dest = this.getParameterValue(processor, 0);
        int src = this.getParameterValue(processor, 1);
        int size = this.getParameterValue(processor, 2);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("memcpy 0x%08X, 0x%08X, 0x%X: %s%s", dest, src, size, this.getAdditionalInfo(processor, dest, src, size), this.getMemoryDump(processor, src, size)));
        }
    }
}

