/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan.threadx;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.wlan.threadx.TXBaseCall;
import jpcsp.memory.mmio.wlan.threadx.TXThreadSchedule;
import jpcsp.memory.mmio.wlan.threadx.hle.TXManager;
import jpcsp.util.Utilities;

public class TXKernelEnter
extends TXBaseCall {
    private int txInitializeLowLevel;
    private int txIrqHandler;
    private int txApplicationDefine;

    public TXKernelEnter(int txInitializeLowLevel, int txIrqHandler, int txApplicationDefine) {
        this.txInitializeLowLevel = txInitializeLowLevel;
        this.txIrqHandler = txIrqHandler;
        this.txApplicationDefine = txApplicationDefine;
    }

    @Override
    public void call(ARMProcessor processor, int imm) {
        RuntimeContext.setLog4jMDC("TX_initialize");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("TXKernelEnter txInitializeLowLevel=0x%08X, txIrqHandler=0x%08X, txApplicationDefine=0x%08X", this.txInitializeLowLevel, this.txIrqHandler, this.txApplicationDefine));
        }
        TXManager txManager = this.getTxManager();
        txManager.disassemble(processor, "Disassembling _tx_initialize_low_level", this.txInitializeLowLevel);
        txManager.disassemble(processor, "Disassembling tx_application_define", this.txApplicationDefine);
        txManager.disassemble(processor, "Disassembling IRQ Handler", this.txIrqHandler);
        txManager.threadSystemState = -252645136;
        this.execute(processor, this.txInitializeLowLevel, "_tx_initialize_low_level");
        txManager.setTxIrqHandler(this.txIrqHandler);
        this.execute(processor, this.txApplicationDefine, "tx_application_define");
        txManager.threadSystemState = 0;
        int threadSchedule = Utilities.setBit(processor.getCurrentInstructionPc() + 2, 0);
        processor.interpreter.installHLECall(threadSchedule, imm, new TXThreadSchedule());
        this.jump(processor, threadSchedule);
    }
}

