/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.settings.Settings;

public class Nec78k0BackendMemory
extends Memory {
    private Nec78k0Processor processor;

    public void setProcessor(Nec78k0Processor processor) {
        this.processor = processor;
    }

    private void invalidMemoryAddress(int address, String value, String prefix, int status) {
        log.error((Object)String.format("0x%08X - %s - Invalid memory address: 0x%08X%s", this.processor.getCurrentInstructionPc(), prefix, address, value));
        if (!Settings.getInstance().readBool("emu.ignoreInvalidMemoryAccess")) {
            Emulator.PauseEmuWithStatus(status);
        }
    }

    @Override
    public void invalidMemoryAddress(int address, String prefix, int status) {
        this.invalidMemoryAddress(address, "", prefix, status);
    }

    @Override
    public void invalidMemoryAddress(int address, int length, String prefix, int status) {
        log.error((Object)String.format("0x%08X - %s - Invalid memory address: 0x%08X-0x%08X(length=0x%X)", this.processor.getCurrentInstructionPc(), prefix, address, address + length, length));
        if (!Settings.getInstance().readBool("emu.ignoreInvalidMemoryAccess")) {
            Emulator.PauseEmuWithStatus(status);
        }
    }

    @Override
    public void Initialise() {
    }

    @Override
    public int read8(int address) {
        this.invalidMemoryAddress(address, "read8", 4);
        return 0;
    }

    @Override
    public int read16(int address) {
        this.invalidMemoryAddress(address, "read16", 4);
        return 0;
    }

    @Override
    public int read32(int address) {
        this.invalidMemoryAddress(address, "read32", 4);
        return 0;
    }

    @Override
    public void write8(int address, byte data) {
        this.invalidMemoryAddress(address, String.format(" (0x%02X)", data & 0xFF), "write8", 8);
    }

    @Override
    public void write16(int address, short data) {
        this.invalidMemoryAddress(address, String.format(" (0x%04X)", data & 0xFFFF), "write16", 8);
    }

    @Override
    public void write32(int address, int data) {
        this.invalidMemoryAddress(address, String.format(" (0x%08X)", data), "write32", 8);
    }

    @Override
    public void memset(int address, byte data, int length) {
        this.invalidMemoryAddress(address, length, "memset", 8);
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return null;
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        this.invalidMemoryAddress(address, length, "getBuffer", 4);
        return null;
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        this.invalidMemoryAddress(address, length, "copyToMemory", 8);
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        this.invalidMemoryAddress(destination, length, "memcpy", 8);
    }
}

