/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import jpcsp.nec78k0.Nec78k0MMIOHandlerBase;
import jpcsp.util.Utilities;

public class Nec78k0MMIORegisterBanks
extends Nec78k0MMIOHandlerBase {
    public Nec78k0MMIORegisterBanks() {
        super(65248);
    }

    private int getRegisterNumber(int address) {
        return address & 7;
    }

    private int getRegisterPairNumber(int address) {
        return this.getRegisterNumber(address) >> 1;
    }

    private int getRegisterBankNumber(int address) {
        return 3 - (address >> 3 & 3);
    }

    @Override
    public int read8(int address) {
        return this.processor.getRegister(this.getRegisterNumber(address), this.getRegisterBankNumber(address));
    }

    @Override
    public void write8(int address, byte value) {
        this.processor.setRegister(this.getRegisterNumber(address), this.getRegisterBankNumber(address), Utilities.u8(value));
    }

    @Override
    public int read16(int address) {
        return this.processor.getRegisterPair(this.getRegisterPairNumber(address), this.getRegisterBankNumber(address));
    }

    @Override
    public void write16(int address, short value) {
        this.processor.setRegisterPair(this.getRegisterPairNumber(address), this.getRegisterBankNumber(address), Utilities.u16(value));
    }
}

