/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.Nec78k0Scheduler;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public abstract class AbstractSysconTimerEventCounter
implements IState {
    private static final int STATE_VERSION = 0;
    protected final Nec78k0Sfr sfr;
    protected final Nec78k0Scheduler scheduler;
    protected final String name;
    protected final int overflowValue;
    protected Logger log;
    protected int timerCounter;
    protected int compareValue0;
    protected int compareValue1;
    protected int clockStepNanoSeconds;
    protected boolean enabled;
    protected boolean isFreeRunning;
    protected boolean isIntervalTimer;
    private final SysconTimerEventCounterAction eventCounterAction;

    public AbstractSysconTimerEventCounter(Nec78k0Sfr sfr, Nec78k0Scheduler scheduler, String name, int overflowValue) {
        this.sfr = sfr;
        this.scheduler = scheduler;
        this.name = name;
        this.overflowValue = overflowValue;
        this.log = sfr.log;
        this.eventCounterAction = new SysconTimerEventCounterAction();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.timerCounter = stream.readInt();
        this.compareValue0 = stream.readInt();
        this.compareValue1 = stream.readInt();
        this.clockStepNanoSeconds = stream.readInt();
        this.enabled = stream.readBoolean();
        this.isFreeRunning = stream.readBoolean();
        this.isIntervalTimer = stream.readBoolean();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.timerCounter);
        stream.writeInt(this.compareValue0);
        stream.writeInt(this.compareValue1);
        stream.writeInt(this.clockStepNanoSeconds);
        stream.writeBoolean(this.enabled);
        stream.writeBoolean(this.isFreeRunning);
        stream.writeBoolean(this.isIntervalTimer);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this.timerCounter = 0;
        this.compareValue0 = -1;
        this.compareValue1 = -1;
        this.clockStepNanoSeconds = 0;
        this.enabled = false;
        this.isFreeRunning = false;
        this.isIntervalTimer = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s reset", this.name));
        }
        this.updateScheduler();
    }

    public void setMode(boolean isFreeRunning, boolean isIntervalTimer) {
        this.isFreeRunning = isFreeRunning;
        this.isIntervalTimer = isIntervalTimer;
        this.enabled = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s setMode isFreeRunning=%b, isIntervalTimer=%b", this.name, isFreeRunning, isIntervalTimer));
        }
        this.updateScheduler();
    }

    protected void setCompareValue0(int value) {
        this.compareValue0 = value;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s setCompare0 0x%X", this.name, value));
        }
        this.updateScheduler();
    }

    protected void setCompareValue1(int value) {
        this.compareValue1 = value;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s setCompare1 0x%X", this.name, value));
        }
        this.updateScheduler();
    }

    public void setClockStep(int nanoSeconds) {
        this.clockStepNanoSeconds = nanoSeconds;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s setClockStep %d nanos, %d micros", this.name, nanoSeconds, (nanoSeconds + 500) / 1000));
        }
        this.updateScheduler();
    }

    public void disable() {
        this.enabled = false;
        this.timerCounter = 0;
        this.updateScheduler();
    }

    private int getNextValue(int compareValue) {
        if (compareValue == 0) {
            return 1;
        }
        return compareValue - this.timerCounter;
    }

    private void updateScheduler() {
        int nextValue;
        this.scheduler.removeAction(this.eventCounterAction);
        if (this.clockStepNanoSeconds <= 0 || !this.enabled) {
            return;
        }
        if (this.timerCounter <= this.compareValue0 && this.timerCounter <= this.compareValue1) {
            int compareValue = Math.min(this.compareValue0, this.compareValue1);
            nextValue = this.getNextValue(compareValue);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("%s updateScheduler next schedule of time=0x%X reached for compareValue=0x%X (compareValue0=0x%X, compareValue1=0x%X)", this.name, this.timerCounter, compareValue, this.compareValue0, this.compareValue1));
            }
        } else if (this.timerCounter <= this.compareValue0) {
            nextValue = this.getNextValue(this.compareValue0);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("%s updateScheduler next schedule of time=0x%X reached for compareValue0=0x%X", this.name, this.timerCounter, this.compareValue0));
            }
        } else if (this.timerCounter <= this.compareValue1) {
            nextValue = this.getNextValue(this.compareValue1);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("%s updateScheduler next schedule of time=0x%X reached for compareValue1=0x%X", this.name, this.timerCounter, this.compareValue1));
            }
        } else {
            nextValue = this.getNextValue(this.overflowValue);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("%s updateScheduler next schedule of time=0x%X reached for overflowValue=0x%X", this.name, this.timerCounter, this.overflowValue));
            }
        }
        long start = MMIOHandlerSysconFirmwareSfr.now();
        this.eventCounterAction.setStart(start);
        long schedule = start + (long)((nextValue * this.clockStepNanoSeconds + 500) / 1000);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s updateScheduler now=0x%X, schedule=0x%X", this.name, start, schedule));
        }
        this.scheduler.addAction(schedule, this.eventCounterAction);
    }

    protected abstract void onTimerCounterOverflow();

    protected abstract void onTimerCounterCompare0();

    protected abstract void onTimerCounterCompare1();

    private void actionTriggered() {
        int previousTimerCounter = this.timerCounter;
        this.getTimerCounter(true);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s actionTriggered previousTimerCounter=0x%X, timerCounter=0x%X, compareValue0=0x%X, compareValue1=0x%X, overflowValue=0x%X", this.name, previousTimerCounter, this.timerCounter, this.compareValue0, this.compareValue1, this.overflowValue));
        }
        if (this.isFreeRunning && this.timerCounter > this.overflowValue) {
            this.timerCounter &= this.overflowValue;
            this.onTimerCounterOverflow();
            previousTimerCounter = -1;
        }
        if (previousTimerCounter <= this.compareValue0 && this.timerCounter > this.compareValue0) {
            this.onTimerCounterCompare0();
            if (this.isIntervalTimer && this.compareValue0 != 0) {
                this.timerCounter %= this.compareValue0;
            }
        }
        if (previousTimerCounter <= this.compareValue1 && this.timerCounter > this.compareValue1) {
            this.onTimerCounterCompare1();
        }
        this.updateScheduler();
    }

    private int getTimerCounter(boolean updateTimerCounter) {
        long start = this.eventCounterAction.getStart();
        long now = MMIOHandlerSysconFirmwareSfr.now();
        int duration = this.clockStepNanoSeconds == 0 ? 0 : (int)((now - start) * 1000L / (long)this.clockStepNanoSeconds);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s getTimerCounter now=0x%X, start=0x%X, duration=0x%X, timerCounter=0x%X", this.name, now, start, duration, this.timerCounter + duration));
        }
        if (updateTimerCounter) {
            this.timerCounter += duration;
        }
        return this.timerCounter;
    }

    public int getTimerCounter() {
        return this.getTimerCounter(false);
    }

    public String toString() {
        return this.name;
    }

    private class SysconTimerEventCounterAction
    implements IAction {
        private long start;

        private SysconTimerEventCounterAction() {
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getStart() {
            return this.start;
        }

        @Override
        public void execute() {
            AbstractSysconTimerEventCounter.this.actionTriggered();
        }
    }
}

