/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceUART6;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.RingBuffer;
import org.apache.log4j.Logger;

public class Nec78k0SerialInterface
implements IState {
    private static final int STATE_VERSION = 0;
    protected final Nec78k0Sfr sfr;
    protected final Nec78k0SerialInterfaceUART6 serialInterface;
    protected Logger log;
    protected final RingBuffer receptionBuffer = new RingBuffer(21);
    protected final RingBuffer transmissionBuffer = new RingBuffer(21);
    private boolean hasReadReceived;

    public Nec78k0SerialInterface(Nec78k0Sfr sfr, Nec78k0SerialInterfaceUART6 serialInterface) {
        this.sfr = sfr;
        this.serialInterface = serialInterface;
        if (sfr != null) {
            this.log = sfr.log;
            sfr.setOnInterruptAction(Nec78k0Sfr.SRIF6, new OnReceiveInterruptAction());
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.receptionBuffer.read(stream);
        this.transmissionBuffer.read(stream);
        this.hasReadReceived = stream.readBoolean();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.receptionBuffer.write(stream);
        this.transmissionBuffer.write(stream);
        stream.writeBoolean(this.hasReadReceived);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public synchronized void reset() {
        this.receptionBuffer.clear();
        this.transmissionBuffer.clear();
        this.hasReadReceived = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 reset", new Object[0]));
        }
    }

    public static int computeChecksum(int[] buffer, int offset, int size) {
        int checksum = 0;
        for (int i = 0; i < size; ++i) {
            checksum += buffer[offset + i];
        }
        return checksum & 0xFF ^ 0xFF;
    }

    public static int computeChecksum(RingBuffer buffer, int size) {
        int checksum = 0;
        for (int i = 0; i < size; ++i) {
            checksum += buffer.peek(i);
        }
        return checksum & 0xFF ^ 0xFF;
    }

    public static int computeChecksum(RingBuffer buffer) {
        return Nec78k0SerialInterface.computeChecksum(buffer, buffer.size());
    }

    protected static boolean isValidChecksum(RingBuffer buffer, int checksum, int size) {
        return Nec78k0SerialInterface.computeChecksum(buffer, size) == checksum;
    }

    public synchronized void startReceptionBuffer(int dataLength) {
        this.startReceptionBuffer(dataLength, 6);
    }

    public synchronized void startReceptionBuffer(int dataLength, int errorCode) {
        this.receptionBuffer.clear();
        this.receptionBuffer.write(165);
        this.receptionBuffer.write(dataLength + 2);
        this.receptionBuffer.write(errorCode);
    }

    public synchronized void endReceptionBuffer() {
        int checksum = Nec78k0SerialInterface.computeChecksum(this.receptionBuffer);
        this.receptionBuffer.write(checksum);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 prepared reception buffer: %s", this.receptionBuffer.toString(8)));
        }
        if (this.serialInterface != null && this.serialInterface.isReceptionEnabled()) {
            this.sfr.setInterruptRequest(Nec78k0Sfr.SRIF6);
        }
    }

    public synchronized void received(int data8) {
        this.addReceptionBufferData8(data8);
        if (this.serialInterface != null && this.serialInterface.isReceptionEnabled()) {
            this.sfr.setInterruptRequest(Nec78k0Sfr.SRIF6);
        }
    }

    public synchronized void addReceptionBufferData8(int data8) {
        this.receptionBuffer.write(data8 & 0xFF);
    }

    public synchronized void addReceptionBufferData16(int data16) {
        this.addReceptionBufferData8(data16);
        this.addReceptionBufferData8(data16 >> 8);
    }

    public synchronized void addReceptionBufferData32(int data32) {
        this.addReceptionBufferData8(data32);
        this.addReceptionBufferData8(data32 >> 8);
        this.addReceptionBufferData8(data32 >> 16);
        this.addReceptionBufferData8(data32 >> 24);
    }

    public synchronized void addReceptionBufferData8(int[] data, int offset, int length) {
        if (data != null) {
            for (int i = 0; i < length; ++i) {
                this.addReceptionBufferData8(data[offset + i]);
            }
        }
    }

    public synchronized void startTransmission() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 startTransmission", new Object[0]));
        }
    }

    public synchronized void endTransmission() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 endTransmission", new Object[0]));
        }
    }

    public synchronized void transmit(int value) {
        this.transmissionBuffer.write(value);
    }

    public synchronized void transmitChecksum() {
        this.transmit(Nec78k0SerialInterface.computeChecksum(this.transmissionBuffer));
    }

    public synchronized void startReception() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 startReception", new Object[0]));
        }
        if (this.hasReceived()) {
            this.sfr.setInterruptRequest(Nec78k0Sfr.SRIF6);
        }
    }

    public synchronized void endReception() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 endReception", new Object[0]));
        }
        this.receptionBuffer.clear();
        this.hasReadReceived = false;
    }

    public synchronized boolean isReceptionBufferEmpty() {
        return this.receptionBuffer.isEmpty();
    }

    public synchronized boolean hasReceived() {
        return this.receptionBuffer.size() > 1;
    }

    public synchronized int receive() {
        int value = 0;
        if (!this.receptionBuffer.isEmpty()) {
            value = this.receptionBuffer.peek();
            this.hasReadReceived = true;
        } else {
            this.log.error((Object)String.format("UART6 receive reception buffer empty", new Object[0]));
        }
        return value;
    }

    private class OnReceiveInterruptAction
    implements IAction {
        private OnReceiveInterruptAction() {
        }

        @Override
        public void execute() {
            if (Nec78k0SerialInterface.this.log.isTraceEnabled()) {
                Nec78k0SerialInterface.this.log.trace((Object)String.format("UART6 OnReceiveInterruptAction %s, hasReadReceived=%b", Nec78k0SerialInterface.this.receptionBuffer, Nec78k0SerialInterface.this.hasReadReceived));
            }
            if (!Nec78k0SerialInterface.this.receptionBuffer.isEmpty()) {
                if (Nec78k0SerialInterface.this.hasReadReceived) {
                    Nec78k0SerialInterface.this.receptionBuffer.read();
                    Nec78k0SerialInterface.this.hasReadReceived = false;
                }
                if (Nec78k0SerialInterface.this.hasReceived()) {
                    Nec78k0SerialInterface.this.sfr.setOnInterruptAction(Nec78k0Sfr.SRIF6, this);
                }
            }
        }
    }
}

