/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.hardware.Model;
import jpcsp.nec78k0.Nec78k0MMIOHandlerBase;
import jpcsp.nec78k0.sfr.Nec78k0AdConverter;
import jpcsp.nec78k0.sfr.Nec78k0I2c;
import jpcsp.nec78k0.sfr.Nec78k0InterruptRequestInfo;
import jpcsp.nec78k0.sfr.Nec78k0Scheduler;
import jpcsp.nec78k0.sfr.Nec78k0SecureFlash;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceCSI1n;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceUART6;
import jpcsp.nec78k0.sfr.Nec78k0SfrNames;
import jpcsp.nec78k0.sfr.Nec78k0TimerEventCounter16;
import jpcsp.nec78k0.sfr.Nec78k0TimerEventCounter8;
import jpcsp.nec78k0.sfr.Nec78k0TimerH;
import jpcsp.nec78k0.sfr.Nec78k0WatchTimer;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Nec78k0Sfr
extends Nec78k0MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    public static final int NUMBER_SPECIAL_FUNCTION_REGISTERS = 256;
    public static final int INTLVI = 4;
    public static final int INTP0 = 6;
    public static final int INTP1 = 8;
    public static final int INTP2 = 10;
    public static final int INTP3 = 12;
    public static final int INTP4 = 14;
    public static final int INTP5 = 16;
    public static final int INTSRE6 = 18;
    public static final int INTSR6 = 20;
    public static final int INTST6 = 22;
    public static final int INTCSI10 = 24;
    public static final int INTST0 = 24;
    public static final int INTTMH1 = 26;
    public static final int INTTMH0 = 28;
    public static final int INTTM50 = 30;
    public static final int INTTM000 = 32;
    public static final int INTTM010 = 34;
    public static final int INTAD = 36;
    public static final int INTSR0 = 38;
    public static final int INTWTI = 40;
    public static final int INTTM51 = 42;
    public static final int INTKR = 44;
    public static final int INTWT = 46;
    public static final int INTP6 = 48;
    public static final int INTP7 = 50;
    public static final int INTIIC0 = 52;
    public static final int INTDMU = 52;
    public static final int INTCSI11 = 54;
    public static final int INTTM001 = 56;
    public static final int INTTM011 = 58;
    public static final int INTACSI = 60;
    public static final int WTIIF = Nec78k0Sfr.INTtoIF(40);
    public static final int WTIF = Nec78k0Sfr.INTtoIF(46);
    public static final int IICIF0 = Nec78k0Sfr.INTtoIF(52);
    public static final int PIF0 = Nec78k0Sfr.INTtoIF(6);
    public static final int PIF1 = Nec78k0Sfr.INTtoIF(8);
    public static final int PIF2 = Nec78k0Sfr.INTtoIF(10);
    public static final int PIF3 = Nec78k0Sfr.INTtoIF(12);
    public static final int PIF4 = Nec78k0Sfr.INTtoIF(14);
    public static final int PIF5 = Nec78k0Sfr.INTtoIF(16);
    public static final int PIF6 = Nec78k0Sfr.INTtoIF(48);
    public static final int PIF7 = Nec78k0Sfr.INTtoIF(50);
    public static final int SRIF6 = Nec78k0Sfr.INTtoIF(20);
    public static final int STIF6 = Nec78k0Sfr.INTtoIF(22);
    public static final int TMIFH0 = Nec78k0Sfr.INTtoIF(28);
    public static final int TMIFH1 = Nec78k0Sfr.INTtoIF(26);
    public static final int TMIF50 = Nec78k0Sfr.INTtoIF(30);
    public static final int TMIF000 = Nec78k0Sfr.INTtoIF(32);
    public static final int TMIF010 = Nec78k0Sfr.INTtoIF(34);
    public static final int ADIF = Nec78k0Sfr.INTtoIF(36);
    public static final int TMIF51 = Nec78k0Sfr.INTtoIF(42);
    public static final int CSIIF10 = Nec78k0Sfr.INTtoIF(24);
    public static final int CSIIF11 = Nec78k0Sfr.INTtoIF(54);
    public static final int TMIF001 = Nec78k0Sfr.INTtoIF(56);
    public static final int TMIF011 = Nec78k0Sfr.INTtoIF(58);
    public static final int NUMBER_INTERRUPT_FLAGS = 28;
    protected final Nec78k0Scheduler scheduler;
    private final Nec78k0WatchTimer watchTimer;
    private static final int NUMBER_PORTS = 15;
    private final int[] portOutputs = new int[15];
    private final int[] portInputs = new int[15];
    private final int[] portModes = new int[15];
    private final int[] pullUpResistorOptions = new int[15];
    private int interruptRequestFlag0;
    private int interruptRequestFlag1;
    private final Object interruptRequestFlagsSync = new Object();
    protected int interruptMaskFlag0;
    private int interruptMaskFlag1;
    private final IAction[] onInterruptActions = new IAction[32];
    private int prioritySpecificationFlag0;
    private int prioritySpecificationFlag1;
    protected Nec78k0I2c i2c;
    protected Nec78k0AdConverter adConverter;
    protected final Nec78k0TimerEventCounter16 timer00;
    protected final Nec78k0TimerEventCounter16 timer01;
    protected final Nec78k0TimerEventCounter8 timer50;
    protected final Nec78k0TimerEventCounter8 timer51;
    protected final Nec78k0TimerH timerH0;
    protected final Nec78k0TimerH timerH1;
    protected final Nec78k0SerialInterfaceCSI1n serialInterfaceCSI10;
    protected final Nec78k0SerialInterfaceCSI1n serialInterfaceCSI11;
    protected final Nec78k0SerialInterfaceUART6 serialInterfaceUART6;
    private int internalOscillationMode;
    private int mainClockMode;
    private int mainOscillationControl;
    private int oscillationStabilizationTimeSelect;
    private int processorClockControl;
    private int oscillationStabilizationTimeCounterStatus;
    private int externalInterruptRisingEdgeEnable;
    private int externalInterruptFallingEdgeEnable;
    private int clockOperationModeSelect;
    private int internalMemorySizeSwitching;
    private int internalExpansionRAMSizeSwitching;
    private final Nec78k0SecureFlash secureFlash;

    public Nec78k0Sfr(int baseAddress) {
        super(baseAddress);
        this.scheduler = new Nec78k0Scheduler();
        this.scheduler.setLogger(this.log);
        this.watchTimer = new Nec78k0WatchTimer(this, this.scheduler);
        this.timer00 = new Nec78k0TimerEventCounter16(this, this.scheduler, "Timer00", TMIF000, TMIF010);
        this.timer01 = new Nec78k0TimerEventCounter16(this, this.scheduler, "Timer01", TMIF001, TMIF011);
        this.timer50 = new Nec78k0TimerEventCounter8(this, this.scheduler, "Timer50", TMIF50);
        this.timer51 = new Nec78k0TimerEventCounter8(this, this.scheduler, "Timer51", TMIF51);
        this.timerH0 = new Nec78k0TimerH(this, this.scheduler, "TimerH0", TMIFH0, Nec78k0TimerH.countClockSelectionH0);
        this.timerH1 = new Nec78k0TimerH(this, this.scheduler, "TimerH1", TMIFH1, Nec78k0TimerH.countClockSelectionH1);
        this.serialInterfaceCSI10 = new Nec78k0SerialInterfaceCSI1n(this, "CSI10", CSIIF10);
        this.serialInterfaceCSI11 = new Nec78k0SerialInterfaceCSI1n(this, "CSI11", CSIIF11);
        this.serialInterfaceUART6 = new Nec78k0SerialInterfaceUART6(this);
        this.secureFlash = new Nec78k0SecureFlash(this);
        this.scheduler.setName("NEC 78k0 Scheduler");
        this.scheduler.setDaemon(true);
        this.scheduler.start();
    }

    protected boolean isKE2() {
        return !this.isKF2();
    }

    protected boolean isKF2() {
        return Model.getModel() == 1 || Model.getModel() == 4;
    }

    protected Nec78k0SerialInterfaceCSI1n getSerialInterface() {
        return this.isKF2() ? this.serialInterfaceCSI11 : this.serialInterfaceCSI10;
    }

    public Nec78k0SecureFlash getSecureFlash() {
        return this.secureFlash;
    }

    public Nec78k0SerialInterfaceUART6 getSerialInterfaceUART6() {
        return this.serialInterfaceUART6;
    }

    public Nec78k0TimerEventCounter8 getTimer50() {
        return this.timer50;
    }

    public static int INTtoIF(int vectorTableAddress) {
        return (vectorTableAddress >> 1) - 2;
    }

    public static int IFtoINT(int interruptBit) {
        return interruptBit + 2 << 1;
    }

    @Override
    public void setLogger(Logger log) {
        if (this.processor != null) {
            this.processor.setLogger(log);
        }
        this.scheduler.setLogger(log);
        this.watchTimer.setLogger(log);
        this.timer00.setLogger(log);
        this.timer01.setLogger(log);
        this.timer50.setLogger(log);
        this.timer51.setLogger(log);
        this.timerH0.setLogger(log);
        this.timerH1.setLogger(log);
        if (this.i2c != null) {
            this.i2c.setLogger(log);
        }
        this.adConverter.setLogger(log);
        this.serialInterfaceCSI10.setLogger(log);
        this.serialInterfaceCSI11.setLogger(log);
        this.serialInterfaceUART6.setLogger(log);
        this.secureFlash.setLogger(log);
        super.setLogger(log);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.portInputs);
        stream.readInts(this.portOutputs);
        stream.readInts(this.portModes);
        stream.readInts(this.pullUpResistorOptions);
        this.interruptRequestFlag0 = stream.readInt();
        this.interruptRequestFlag1 = stream.readInt();
        this.interruptMaskFlag0 = stream.readInt();
        this.interruptMaskFlag1 = stream.readInt();
        this.prioritySpecificationFlag0 = stream.readInt();
        this.prioritySpecificationFlag1 = stream.readInt();
        if (this.i2c != null) {
            this.i2c.read(stream);
        }
        if (this.adConverter != null) {
            this.adConverter.read(stream);
        }
        this.timer00.read(stream);
        this.timer01.read(stream);
        this.timer50.read(stream);
        this.timer51.read(stream);
        this.timerH0.read(stream);
        this.timerH1.read(stream);
        this.watchTimer.read(stream);
        this.serialInterfaceCSI10.read(stream);
        this.serialInterfaceCSI11.read(stream);
        this.serialInterfaceUART6.read(stream);
        this.internalOscillationMode = stream.readInt();
        this.mainClockMode = stream.readInt();
        this.mainOscillationControl = stream.readInt();
        this.oscillationStabilizationTimeSelect = stream.readInt();
        this.processorClockControl = stream.readInt();
        this.oscillationStabilizationTimeCounterStatus = stream.readInt();
        this.externalInterruptRisingEdgeEnable = stream.readInt();
        this.externalInterruptFallingEdgeEnable = stream.readInt();
        this.clockOperationModeSelect = stream.readInt();
        this.internalMemorySizeSwitching = stream.readInt();
        this.internalExpansionRAMSizeSwitching = stream.readInt();
        this.secureFlash.read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.portInputs);
        stream.writeInts(this.portOutputs);
        stream.writeInts(this.portModes);
        stream.writeInts(this.pullUpResistorOptions);
        stream.writeInt(this.interruptRequestFlag0);
        stream.writeInt(this.interruptRequestFlag1);
        stream.writeInt(this.interruptMaskFlag0);
        stream.writeInt(this.interruptMaskFlag1);
        stream.writeInt(this.prioritySpecificationFlag0);
        stream.writeInt(this.prioritySpecificationFlag1);
        if (this.i2c != null) {
            this.i2c.write(stream);
        }
        if (this.adConverter != null) {
            this.adConverter.write(stream);
        }
        this.timer00.write(stream);
        this.timer01.write(stream);
        this.timer50.write(stream);
        this.timer51.write(stream);
        this.timerH0.write(stream);
        this.timerH1.write(stream);
        this.watchTimer.write(stream);
        this.serialInterfaceCSI10.write(stream);
        this.serialInterfaceCSI11.write(stream);
        this.serialInterfaceUART6.write(stream);
        stream.writeInt(this.internalOscillationMode);
        stream.writeInt(this.mainClockMode);
        stream.writeInt(this.mainOscillationControl);
        stream.writeInt(this.oscillationStabilizationTimeSelect);
        stream.writeInt(this.processorClockControl);
        stream.writeInt(this.oscillationStabilizationTimeCounterStatus);
        stream.writeInt(this.externalInterruptRisingEdgeEnable);
        stream.writeInt(this.externalInterruptFallingEdgeEnable);
        stream.writeInt(this.clockOperationModeSelect);
        stream.writeInt(this.internalMemorySizeSwitching);
        stream.writeInt(this.internalExpansionRAMSizeSwitching);
        this.secureFlash.write(stream);
        super.write(stream);
    }

    @Override
    public void reset() {
        Arrays.fill(this.portOutputs, 0);
        Arrays.fill(this.portInputs, 0);
        Arrays.fill(this.portModes, 255);
        Arrays.fill(this.pullUpResistorOptions, 0);
        this.interruptRequestFlag0 = 0;
        this.interruptRequestFlag1 = 0;
        this.interruptMaskFlag0 = 65535;
        this.interruptMaskFlag1 = 65535;
        this.prioritySpecificationFlag0 = 65535;
        this.prioritySpecificationFlag1 = 65535;
        if (this.i2c != null) {
            this.i2c.reset();
        }
        if (this.adConverter != null) {
            this.adConverter.reset();
        }
        this.watchTimer.reset();
        this.timer00.reset();
        this.timer01.reset();
        this.timer50.reset();
        this.timer51.reset();
        this.timerH0.reset();
        this.timerH1.reset();
        this.watchTimer.reset();
        this.serialInterfaceCSI10.reset();
        this.serialInterfaceCSI11.reset();
        this.serialInterfaceUART6.reset();
        this.internalOscillationMode = 128;
        this.mainClockMode = 0;
        this.mainOscillationControl = 128;
        this.processorClockControl = 1;
        this.secureFlash.reset();
    }

    public static long now() {
        return Emulator.getClock().microTime();
    }

    public void setPortInputBit(int port, int bit) {
        this.portInputs[port] = Utilities.setBit(this.portInputs[port], bit);
    }

    public void clearPortInputBit(int port, int bit) {
        this.portInputs[port] = Utilities.clearBit(this.portInputs[port], bit);
    }

    protected void setButtonPortInput(int port, int bit, int key, int buttons) {
        if (Utilities.hasFlag(buttons, key)) {
            this.clearPortInputBit(port, bit);
        } else {
            this.setPortInputBit(port, bit);
        }
    }

    protected int getPortValue(int port) {
        return this.portInputs[port] & this.portModes[port] | this.portOutputs[port] & ~this.portModes[port];
    }

    protected int getPortInput(int port) {
        return this.portInputs[port];
    }

    protected int getPortOutput(int port) {
        return this.portOutputs[port];
    }

    protected boolean getPortOutputBit(int port, int bit) {
        return Utilities.hasBit(this.portOutputs[port], bit);
    }

    protected void setPortOutput(int port, int value) {
        this.portOutputs[port] = value;
    }

    private int getPortMode(int port) {
        return this.portModes[port];
    }

    private void setPortMode(int port, int value) {
        this.portModes[port] = value;
    }

    protected boolean isInputPort(int port, int bit) {
        return Utilities.hasBit(this.portModes[port], bit);
    }

    protected boolean isOutputPort(int port, int bit) {
        return Utilities.notHasBit(this.portModes[port], bit);
    }

    private void setWatchdogTimerEnable(int value) {
        if (value == 172 && this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Start Watch Dog Timer", new Object[0]));
        }
    }

    private void setMainOscillationControl(int value) {
        if (Utilities.isFallingBit(this.mainOscillationControl, value, 7)) {
            this.oscillationStabilizationTimeCounterStatus = 0;
        }
        this.mainOscillationControl = value;
    }

    private int getOscillationStabilizationTimeCounterStatus() {
        int status = this.oscillationStabilizationTimeCounterStatus;
        switch (this.oscillationStabilizationTimeCounterStatus) {
            case 0: {
                this.oscillationStabilizationTimeCounterStatus = Utilities.setBit(this.oscillationStabilizationTimeCounterStatus, 4);
                break;
            }
            case 16: {
                this.oscillationStabilizationTimeCounterStatus = Utilities.setBit(this.oscillationStabilizationTimeCounterStatus, 3);
                break;
            }
            case 24: {
                this.oscillationStabilizationTimeCounterStatus = Utilities.setBit(this.oscillationStabilizationTimeCounterStatus, 2);
                break;
            }
            case 28: {
                this.oscillationStabilizationTimeCounterStatus = Utilities.setBit(this.oscillationStabilizationTimeCounterStatus, 1);
                break;
            }
            case 30: {
                this.oscillationStabilizationTimeCounterStatus = Utilities.setBit(this.oscillationStabilizationTimeCounterStatus, 0);
                break;
            }
            case 31: {
                break;
            }
            default: {
                this.log.error((Object)String.format("Invalid oscillationStabilizationTimeCounterStatus=0x%02X", this.oscillationStabilizationTimeCounterStatus));
            }
        }
        return status;
    }

    private void setMainClockMode(int value) {
        this.mainClockMode = Utilities.setBit(value, this.mainClockMode, 1);
        if (Utilities.hasBit(this.mainClockMode, 0) && Utilities.hasBit(this.mainClockMode, 2)) {
            this.mainClockMode = Utilities.setBit(this.mainClockMode, 1);
        }
    }

    private void setProcessorClockControl(int value) {
        this.processorClockControl = Utilities.setBit(value, this.processorClockControl, 5);
        this.processorClockControl = Utilities.hasBit(this.processorClockControl, 4) ? Utilities.setBit(this.processorClockControl, 5) : Utilities.clearBit(this.processorClockControl, 5);
    }

    private int getResetControlFlag() {
        return 0;
    }

    public static String getInterruptName(int vectorTableAddress) {
        switch (vectorTableAddress) {
            case 0: {
                return "RESET";
            }
            case 4: {
                return "INTLVI";
            }
            case 6: {
                return "INTP0";
            }
            case 8: {
                return "INTP1";
            }
            case 10: {
                return "INTP2";
            }
            case 12: {
                return "INTP3";
            }
            case 14: {
                return "INTP4";
            }
            case 16: {
                return "INTP5";
            }
            case 18: {
                return "INTSRE6";
            }
            case 20: {
                return "INTSR6";
            }
            case 22: {
                return "INTST6";
            }
            case 24: {
                return "INTCSI10";
            }
            case 26: {
                return "INTTMH1";
            }
            case 28: {
                return "INTTMH0";
            }
            case 30: {
                return "INTTM50";
            }
            case 32: {
                return "INTTM000";
            }
            case 34: {
                return "INTTM010";
            }
            case 36: {
                return "INTAD";
            }
            case 38: {
                return "INTSR0";
            }
            case 40: {
                return "INTWTI";
            }
            case 42: {
                return "INTTM51";
            }
            case 44: {
                return "INTKR";
            }
            case 46: {
                return "INTWT";
            }
            case 48: {
                return "INTP6";
            }
            case 50: {
                return "INTP7";
            }
            case 52: {
                return "INTIIC0";
            }
            case 54: {
                return "INTCSI11";
            }
            case 56: {
                return "INTTM001";
            }
            case 58: {
                return "INTTM011";
            }
            case 60: {
                return "INTACSI";
            }
            case 62: {
                return "BRK";
            }
        }
        return String.format("INT_0x%02X", vectorTableAddress);
    }

    private void checkInterrupts(Nec78k0InterruptRequestInfo info, int interruptRequestFlag, int interruptMaskFlag, int prioritySpecificationFlag, int baseInterruptVectorTableAddress, int numberInterrupts, int baseInterruptNumber) {
        if ((interruptRequestFlag = Utilities.clearFlag(interruptRequestFlag, interruptMaskFlag)) == 0) {
            return;
        }
        int firstBit = Integer.numberOfTrailingZeros(interruptRequestFlag);
        int afterLastBit = Math.min(numberInterrupts, 32 - Integer.numberOfLeadingZeros(interruptRequestFlag));
        int i = firstBit;
        int flag = Utilities.getFlagFromBit(firstBit);
        while (i < afterLastBit) {
            if (Utilities.hasFlag(interruptRequestFlag, flag)) {
                int interruptVectorTableAddress = baseInterruptVectorTableAddress + (i << 1);
                if (Utilities.hasFlag(prioritySpecificationFlag, flag)) {
                    if (!info.highPriority) {
                        info.vectorTableAddress = interruptVectorTableAddress;
                        info.highPriority = true;
                        info.interruptRequestBit = baseInterruptNumber + i;
                        break;
                    }
                } else if (this.processor.isInServicePriority()) {
                    info.vectorTableAddress = interruptVectorTableAddress;
                    info.highPriority = false;
                    info.interruptRequestBit = baseInterruptNumber + i;
                }
            }
            ++i;
            flag <<= 1;
        }
    }

    public String debugInterruptRequests() {
        int i;
        boolean first;
        StringBuilder s = new StringBuilder();
        for (int i2 = 0; i2 < 28; ++i2) {
            if (!this.hasInterruptRequest(i2)) continue;
            if (s.length() == 0) {
                s.append("InterruptRequests: ");
            } else {
                s.append("|");
            }
            s.append(Nec78k0Sfr.getInterruptName(Nec78k0Sfr.IFtoINT(i2)));
        }
        if (this.interruptMaskFlag0 != 65535 || this.interruptMaskFlag1 != 65535) {
            first = true;
            for (i = 0; i < 28; ++i) {
                if (this.hasInterruptMask(i)) continue;
                if (first) {
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    s.append("Non-masked Interrupts: ");
                    first = false;
                } else {
                    s.append("|");
                }
                s.append(Nec78k0Sfr.getInterruptName(Nec78k0Sfr.IFtoINT(i)));
            }
        }
        if (this.prioritySpecificationFlag0 != 65535 || this.prioritySpecificationFlag1 != 65535) {
            first = true;
            for (i = 0; i < 28; ++i) {
                if (this.hasPrioritySpecificationFlag(i)) continue;
                if (first) {
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    s.append("Low-priority Interrupts: ");
                    first = false;
                } else {
                    s.append("|");
                }
                s.append(Nec78k0Sfr.getInterruptName(Nec78k0Sfr.IFtoINT(i)));
            }
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInterrupts(Nec78k0InterruptRequestInfo info) {
        Object object = this.interruptRequestFlagsSync;
        synchronized (object) {
            this.checkInterrupts(info, this.interruptRequestFlag0, this.interruptMaskFlag0, this.prioritySpecificationFlag0, 4, 16, 0);
            if (!info.highPriority) {
                this.checkInterrupts(info, this.interruptRequestFlag1, this.interruptMaskFlag1, this.prioritySpecificationFlag1, 36, 12, 16);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterruptRequest(int bit) {
        Object object = this.interruptRequestFlagsSync;
        synchronized (object) {
            if (bit < 16) {
                this.interruptRequestFlag0 = Utilities.setBit(this.interruptRequestFlag0, bit);
            } else if (bit < 32) {
                this.interruptRequestFlag1 = Utilities.setBit(this.interruptRequestFlag1, bit - 16);
            }
        }
        if (this.processor != null) {
            this.processor.interpreter.setHalted(false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setInterruptRequest bit=0x%X(%s), interrupts %s, %s", bit, Nec78k0Sfr.getInterruptName(Nec78k0Sfr.IFtoINT(bit)), this.processor == null ? "" : (this.processor.isInterruptEnabled() ? "enabled" : "disabled"), this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInterruptRequest(int bit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("clearInterruptRequest bit=0x%X(%s)", bit, Nec78k0Sfr.getInterruptName(Nec78k0Sfr.IFtoINT(bit))));
        }
        Object object = this.interruptRequestFlagsSync;
        synchronized (object) {
            if (bit < 16) {
                this.interruptRequestFlag0 = Utilities.clearBit(this.interruptRequestFlag0, bit);
            } else if (bit < 32) {
                this.interruptRequestFlag1 = Utilities.clearBit(this.interruptRequestFlag1, bit - 16);
            }
        }
        IAction action = this.onInterruptActions[bit];
        if (action != null) {
            action.execute();
        }
    }

    public void setOnInterruptAction(int bit, IAction action) {
        this.onInterruptActions[bit] = action;
    }

    public boolean hasInterruptRequest(int bit) {
        if (bit < 16) {
            return Utilities.hasBit(this.interruptRequestFlag0, bit);
        }
        if (bit < 32) {
            return Utilities.hasBit(this.interruptRequestFlag1, bit - 16);
        }
        return false;
    }

    public boolean hasInterruptMask(int bit) {
        if (bit < 16) {
            return Utilities.hasBit(this.interruptMaskFlag0, bit);
        }
        if (bit < 32) {
            return Utilities.hasBit(this.interruptMaskFlag1, bit - 16);
        }
        return false;
    }

    public boolean hasPrioritySpecificationFlag(int bit) {
        if (bit < 16) {
            return Utilities.hasBit(this.prioritySpecificationFlag0, bit);
        }
        if (bit < 32) {
            return Utilities.hasBit(this.prioritySpecificationFlag0, bit - 16);
        }
        return false;
    }

    protected void setInterruptMaskFlag0(int interruptMaskFlag0) {
        this.interruptMaskFlag0 = interruptMaskFlag0;
    }

    private void setInterruptMaskFlag1(int interruptMaskFlag1) {
        this.interruptMaskFlag1 = interruptMaskFlag1;
    }

    public boolean read1(int address, int bit) {
        boolean value = Utilities.hasBit(this.internalRead8(address), bit);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%04X - read1(%s, %s) returning %b", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), Nec78k0SfrNames.getSfr1Name(address, bit), value));
        }
        return value;
    }

    @Override
    public int internalRead8(int address) {
        int value;
        switch (address) {
            case 65280: {
                value = this.getPortValue(0);
                break;
            }
            case 65281: {
                value = this.getPortValue(1);
                break;
            }
            case 65282: {
                value = this.getPortValue(2);
                break;
            }
            case 65283: {
                value = this.getPortValue(3);
                break;
            }
            case 65284: {
                value = this.getPortValue(4);
                break;
            }
            case 65285: {
                value = this.getPortValue(5);
                break;
            }
            case 65286: {
                value = this.getPortValue(6);
                break;
            }
            case 65287: {
                value = this.getPortValue(7);
                break;
            }
            case 65288: {
                value = Utilities.getByte0(this.adConverter.getResult());
                break;
            }
            case 65289: {
                value = Utilities.getByte1(this.adConverter.getResult());
                break;
            }
            case 65290: {
                value = this.serialInterfaceUART6.getReceiveRegister();
                break;
            }
            case 65292: {
                value = this.getPortValue(12);
                break;
            }
            case 65293: {
                value = this.getPortValue(13);
                break;
            }
            case 65294: {
                value = this.getPortValue(14);
                break;
            }
            case 65295: {
                value = this.serialInterfaceCSI10.getIOShift();
                break;
            }
            case 65296: {
                value = Utilities.getByte0(this.timer00.getTimerCounter());
                break;
            }
            case 65297: {
                value = Utilities.getByte1(this.timer00.getTimerCounter());
                break;
            }
            case 65302: {
                value = this.timer50.getTimerCounter();
                break;
            }
            case 65310: {
                value = this.processor.getPsw();
                break;
            }
            case 65311: {
                value = this.timer51.getTimerCounter();
                break;
            }
            case 65312: {
                value = this.getPortMode(0);
                break;
            }
            case 65313: {
                value = this.getPortMode(1);
                break;
            }
            case 65314: {
                value = this.getPortMode(2);
                break;
            }
            case 65315: {
                value = this.getPortMode(3);
                break;
            }
            case 65316: {
                value = this.getPortMode(4);
                break;
            }
            case 65317: {
                value = this.getPortMode(5);
                break;
            }
            case 65318: {
                value = this.getPortMode(6);
                break;
            }
            case 65319: {
                value = this.getPortMode(7);
                break;
            }
            case 65320: {
                value = this.adConverter.getMode();
                break;
            }
            case 65324: {
                value = this.getPortMode(12);
                break;
            }
            case 65326: {
                value = this.getPortMode(14);
                break;
            }
            case 65328: {
                value = this.pullUpResistorOptions[0];
                break;
            }
            case 65329: {
                value = this.pullUpResistorOptions[1];
                break;
            }
            case 65331: {
                value = this.pullUpResistorOptions[3];
                break;
            }
            case 65332: {
                value = this.pullUpResistorOptions[4];
                break;
            }
            case 65333: {
                value = this.pullUpResistorOptions[5];
                break;
            }
            case 65334: {
                value = this.pullUpResistorOptions[6];
                break;
            }
            case 65335: {
                value = this.pullUpResistorOptions[7];
                break;
            }
            case 65340: {
                value = this.pullUpResistorOptions[12];
                break;
            }
            case 65342: {
                value = this.pullUpResistorOptions[14];
                break;
            }
            case 65347: {
                value = this.timer51.getTimerModeControl();
                break;
            }
            case 65354: {
                value = this.serialInterfaceCSI11.getIOShift();
                break;
            }
            case 65356: {
                value = this.serialInterfaceCSI11.getTransmitBuffer();
                break;
            }
            case 65360: {
                value = this.serialInterfaceUART6.getOperationMode();
                break;
            }
            case 65363: {
                value = this.serialInterfaceUART6.getReceptionErrorStatus();
                break;
            }
            case 65365: {
                value = this.serialInterfaceUART6.getTransmissionStatus();
                break;
            }
            case 65366: {
                value = this.serialInterfaceUART6.getClockSelection();
                break;
            }
            case 65367: {
                value = this.serialInterfaceUART6.getBaudRateGeneratorControl();
                break;
            }
            case 65368: {
                value = this.serialInterfaceUART6.getControlRegister();
                break;
            }
            case 65385: {
                value = this.timerH0.getTimerMode();
                break;
            }
            case 65387: {
                value = this.timer50.getTimerModeControl();
                break;
            }
            case 65388: {
                value = this.timerH1.getTimerMode();
                break;
            }
            case 65391: {
                value = this.watchTimer.getOperationMode();
                break;
            }
            case 65408: {
                value = this.serialInterfaceCSI10.getOperationMode();
                break;
            }
            case 65409: {
                value = this.serialInterfaceCSI10.getClockSelection();
                break;
            }
            case 65412: {
                value = this.serialInterfaceCSI10.getTransmitBuffer();
                break;
            }
            case 65416: {
                value = this.serialInterfaceCSI11.getOperationMode();
                break;
            }
            case 65417: {
                value = this.serialInterfaceCSI11.getClockSelection();
                break;
            }
            case 65439: {
                value = this.clockOperationModeSelect;
                break;
            }
            case 65440: {
                value = this.internalOscillationMode;
                break;
            }
            case 65441: {
                value = this.mainClockMode;
                break;
            }
            case 65442: {
                value = this.mainOscillationControl;
                break;
            }
            case 65443: {
                value = this.getOscillationStabilizationTimeCounterStatus();
                break;
            }
            case 65445: {
                value = this.i2c.getShift();
                break;
            }
            case 65446: {
                value = this.i2c.getControl();
                break;
            }
            case 65447: {
                value = this.i2c.getSlaveAddress();
                break;
            }
            case 65448: {
                value = this.i2c.getClockSelection();
                break;
            }
            case 65449: {
                value = this.i2c.getFunctionExpansion();
                break;
            }
            case 65450: {
                value = this.i2c.getStatus();
                break;
            }
            case 65451: {
                value = this.i2c.getFlag();
                break;
            }
            case 65452: {
                value = this.getResetControlFlag();
                break;
            }
            case 65456: {
                value = Utilities.getByte0(this.timer01.getTimerCounter());
                break;
            }
            case 65457: {
                value = Utilities.getByte1(this.timer01.getTimerCounter());
                break;
            }
            case 65462: {
                value = this.timer01.getTimerModeControl();
                break;
            }
            case 65466: {
                value = this.timer00.getTimerModeControl();
                break;
            }
            case 65473: {
                value = this.secureFlash.getUnknown1();
                break;
            }
            case 65476: {
                value = this.secureFlash.getUnknown4();
                break;
            }
            case 65477: {
                value = this.secureFlash.getUnknown5();
                break;
            }
            case 65478: {
                value = this.secureFlash.getUnknown6();
                break;
            }
            case 65479: {
                value = this.secureFlash.getUnknown7();
                break;
            }
            case 65480: {
                value = this.secureFlash.getUnknown8();
                break;
            }
            case 65482: {
                value = this.secureFlash.getFlashProgrammingModeControl();
                break;
            }
            case 65504: {
                value = Utilities.getByte0(this.interruptRequestFlag0);
                break;
            }
            case 65505: {
                value = Utilities.getByte1(this.interruptRequestFlag0);
                break;
            }
            case 65506: {
                value = Utilities.getByte0(this.interruptRequestFlag1);
                break;
            }
            case 65507: {
                value = Utilities.getByte1(this.interruptRequestFlag1);
                break;
            }
            case 65508: {
                value = Utilities.getByte0(this.interruptMaskFlag0);
                break;
            }
            case 65509: {
                value = Utilities.getByte1(this.interruptMaskFlag0);
                break;
            }
            case 65510: {
                value = Utilities.getByte0(this.interruptMaskFlag1);
                break;
            }
            case 65511: {
                value = Utilities.getByte1(this.interruptMaskFlag1);
                break;
            }
            case 65512: {
                value = Utilities.getByte0(this.prioritySpecificationFlag0);
                break;
            }
            case 65513: {
                value = Utilities.getByte1(this.prioritySpecificationFlag0);
                break;
            }
            case 65514: {
                value = Utilities.getByte0(this.prioritySpecificationFlag1);
                break;
            }
            case 65515: {
                value = Utilities.getByte1(this.prioritySpecificationFlag1);
                break;
            }
            case 65525: {
                value = 16;
                break;
            }
            case 65531: {
                value = this.processorClockControl;
                break;
            }
            default: {
                value = super.read8(address);
            }
        }
        return value;
    }

    @Override
    public int read8(int address) {
        int value = this.internalRead8(address);
        if (this.log.isTraceEnabled()) {
            if (Nec78k0SfrNames.hasSfr1Name(address)) {
                this.log.trace((Object)String.format("0x%04X - read8(%s) returning 0x%02X%s", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), value, Nec78k0SfrNames.getSfr1Names(address, value)));
            } else {
                this.log.trace((Object)String.format("0x%04X - read8(%s) returning 0x%02X", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), value));
            }
        }
        return value;
    }

    @Override
    public int internalRead16(int address) {
        int value;
        switch (address) {
            case 65288: {
                value = this.adConverter.getResult();
                break;
            }
            case 65296: {
                value = this.timer00.getTimerCounter();
                break;
            }
            case 65308: {
                value = this.processor.getSp();
                break;
            }
            case 65456: {
                value = this.timer01.getTimerCounter();
                break;
            }
            case 65504: {
                value = this.interruptRequestFlag0;
                break;
            }
            case 65506: {
                value = this.interruptRequestFlag1;
                break;
            }
            case 65508: {
                value = this.interruptMaskFlag0;
                break;
            }
            case 65510: {
                value = this.interruptMaskFlag1;
                break;
            }
            default: {
                value = super.read16(address);
            }
        }
        return value;
    }

    @Override
    public int read16(int address) {
        int value = this.internalRead16(address);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%04X - read16(%s) returning 0x%04X", this.getPc(), Nec78k0SfrNames.getSfr16Name(address), value));
        }
        return value;
    }

    public void write1(int address, int bit, boolean value) {
        int value8 = this.internalRead8(address);
        value8 = value ? Utilities.setBit(value8, bit) : Utilities.clearBit(value8, bit);
        this.internalWrite8(address, (byte)value8);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%04X - write1(%s, %s, %b) on %s", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), Nec78k0SfrNames.getSfr1Name(address, bit), value, this));
        }
    }

    public void set1(int address, int bit) {
        int value8 = this.internalRead8(address);
        value8 = Utilities.setBit(value8, bit);
        this.internalWrite8(address, (byte)value8);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%04X - set1(%s, %s) on %s", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), Nec78k0SfrNames.getSfr1Name(address, bit), this));
        }
    }

    public void clear1(int address, int bit) {
        int value8 = this.internalRead8(address);
        value8 = Utilities.clearBit(value8, bit);
        this.internalWrite8(address, (byte)value8);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%04X - clear1(%s, %s) on %s", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), Nec78k0SfrNames.getSfr1Name(address, bit), this));
        }
    }

    private void internalWrite8(int address, byte value) {
        int value8 = value & 0xFF;
        switch (address) {
            case 65280: {
                this.setPortOutput(0, value8);
                break;
            }
            case 65281: {
                this.setPortOutput(1, value8);
                break;
            }
            case 65282: {
                this.setPortOutput(2, value8);
                break;
            }
            case 65283: {
                this.setPortOutput(3, value8);
                break;
            }
            case 65284: {
                this.setPortOutput(4, value8);
                break;
            }
            case 65285: {
                this.setPortOutput(5, value8);
                break;
            }
            case 65286: {
                this.setPortOutput(6, value8);
                break;
            }
            case 65287: {
                this.setPortOutput(7, value8);
                break;
            }
            case 65291: {
                this.serialInterfaceUART6.setTransmitRegister(value8);
                break;
            }
            case 65292: {
                this.setPortOutput(12, value8);
                break;
            }
            case 65293: {
                this.setPortOutput(13, value8);
                break;
            }
            case 65294: {
                this.setPortOutput(14, value8);
                break;
            }
            case 65303: {
                this.timer50.setCompare(value8);
                break;
            }
            case 65304: {
                this.timerH0.setCompare0(value8);
                break;
            }
            case 65305: {
                this.timerH1.setCompare0(value8);
                break;
            }
            case 65306: {
                this.timerH0.setCompare1(value8);
                break;
            }
            case 65307: {
                this.timerH1.setCompare1(value8);
                break;
            }
            case 65310: {
                this.processor.setPsw(value8);
                break;
            }
            case 65312: {
                this.setPortMode(0, value8);
                break;
            }
            case 65313: {
                this.setPortMode(1, value8);
                break;
            }
            case 65314: {
                this.setPortMode(2, value8);
                break;
            }
            case 65315: {
                this.setPortMode(3, value8);
                break;
            }
            case 65316: {
                this.setPortMode(4, value8);
                break;
            }
            case 65317: {
                this.setPortMode(5, value8);
                break;
            }
            case 65318: {
                this.setPortMode(6, value8);
                break;
            }
            case 65319: {
                this.setPortMode(7, value8);
                break;
            }
            case 65320: {
                this.adConverter.setMode(value8);
                break;
            }
            case 65321: {
                this.adConverter.setAnalogInputChannelSpecification(value8);
                break;
            }
            case 65324: {
                this.setPortMode(12, value8);
                break;
            }
            case 65326: {
                this.setPortMode(14, value8);
                break;
            }
            case 65327: {
                this.adConverter.setPortConfiguration(value8);
                break;
            }
            case 65328: {
                this.pullUpResistorOptions[0] = value8;
                break;
            }
            case 65329: {
                this.pullUpResistorOptions[1] = value8;
                break;
            }
            case 65331: {
                this.pullUpResistorOptions[3] = value8;
                break;
            }
            case 65332: {
                this.pullUpResistorOptions[4] = value8;
                break;
            }
            case 65333: {
                this.pullUpResistorOptions[5] = value8;
                break;
            }
            case 65334: {
                this.pullUpResistorOptions[6] = value8;
                break;
            }
            case 65335: {
                this.pullUpResistorOptions[7] = value8;
                break;
            }
            case 65340: {
                this.pullUpResistorOptions[12] = value8;
                break;
            }
            case 65342: {
                this.pullUpResistorOptions[14] = value8;
                break;
            }
            case 65345: {
                this.timer51.setCompare(value8);
                break;
            }
            case 65347: {
                this.timer51.setTimerModeControl(value8);
                break;
            }
            case 65352: {
                this.externalInterruptRisingEdgeEnable = value8;
                break;
            }
            case 65353: {
                this.externalInterruptFallingEdgeEnable = value8;
                break;
            }
            case 65356: {
                this.serialInterfaceCSI11.setTransmitBuffer(value8);
                break;
            }
            case 65360: {
                this.serialInterfaceUART6.setOperationMode(value8);
                break;
            }
            case 65366: {
                this.serialInterfaceUART6.setClockSelection(value8);
                break;
            }
            case 65367: {
                this.serialInterfaceUART6.setBaudRateGeneratorControl(value8);
                break;
            }
            case 65368: {
                this.serialInterfaceUART6.setControlRegister(value8);
                break;
            }
            case 65385: {
                this.timerH0.setTimerMode(value8);
                break;
            }
            case 65386: {
                this.timer50.setClockSelection(value8);
                break;
            }
            case 65387: {
                this.timer50.setTimerModeControl(value8);
                break;
            }
            case 65388: {
                this.timerH1.setTimerMode(value8);
                break;
            }
            case 65391: {
                this.watchTimer.setOperationMode(value8);
                break;
            }
            case 65408: {
                this.serialInterfaceCSI10.setOperationMode(value8);
                break;
            }
            case 65409: {
                this.serialInterfaceCSI10.setClockSelection(value8);
                break;
            }
            case 65412: {
                this.serialInterfaceCSI10.setTransmitBuffer(value8);
                break;
            }
            case 65416: {
                this.serialInterfaceCSI11.setOperationMode(value8);
                break;
            }
            case 65417: {
                this.serialInterfaceCSI11.setClockSelection(value8);
                break;
            }
            case 65420: {
                this.timer51.setClockSelection(value8);
                break;
            }
            case 65433: {
                this.setWatchdogTimerEnable(value8);
                break;
            }
            case 65439: {
                this.clockOperationModeSelect = value8;
                break;
            }
            case 65440: {
                this.internalOscillationMode = value8;
                break;
            }
            case 65441: {
                this.setMainClockMode(value8);
                break;
            }
            case 65442: {
                this.setMainOscillationControl(value8);
                break;
            }
            case 65444: {
                this.oscillationStabilizationTimeSelect = value8;
                break;
            }
            case 65445: {
                this.i2c.setShift(value8);
                break;
            }
            case 65446: {
                this.i2c.setControl(value8);
                break;
            }
            case 65447: {
                this.i2c.setSlaveAddress(value8);
                break;
            }
            case 65448: {
                this.i2c.setClockSelection(value8);
                break;
            }
            case 65449: {
                this.i2c.setFunctionExpansion(value8);
                break;
            }
            case 65451: {
                this.i2c.setFlag(value8);
                break;
            }
            case 65462: {
                this.timer01.setTimerModeControl(value8);
                break;
            }
            case 65463: {
                this.timer01.setPrescalerMode(value8);
                break;
            }
            case 65464: {
                this.timer01.setCompareControl(value8);
                break;
            }
            case 65465: {
                this.timer01.setOutputControl(value8);
                break;
            }
            case 65466: {
                this.timer00.setTimerModeControl(value8);
                break;
            }
            case 65467: {
                this.timer00.setPrescalerMode(value8);
                break;
            }
            case 65468: {
                this.timer00.setCompareControl(value8);
                break;
            }
            case 65469: {
                this.timer00.setOutputControl(value8);
                break;
            }
            case 65472: {
                this.secureFlash.setFlashProtectCommandRegister(value8);
                break;
            }
            case 65473: {
                this.secureFlash.setUnknown1(value8);
                break;
            }
            case 65476: {
                this.secureFlash.setUnknown4(value8);
                break;
            }
            case 65477: {
                this.secureFlash.setUnknown5(value8);
                break;
            }
            case 65478: {
                this.secureFlash.setUnknown6(value8);
                break;
            }
            case 65479: {
                this.secureFlash.setUnknown7(value8);
                break;
            }
            case 65480: {
                this.secureFlash.setAddress(Utilities.setByte0(this.secureFlash.getAddress(), value8));
                break;
            }
            case 65481: {
                this.secureFlash.setAddress(Utilities.setByte1(this.secureFlash.getAddress(), value8));
                break;
            }
            case 65482: {
                this.secureFlash.setFlashProgrammingModeControlRegister(value8);
                break;
            }
            case 65483: {
                this.secureFlash.setUnknownB(value8);
                break;
            }
            case 65484: {
                this.secureFlash.setWriteData0(value8);
                break;
            }
            case 65485: {
                this.secureFlash.setWriteData1(value8);
                break;
            }
            case 65486: {
                this.secureFlash.setWriteData2(value8);
                break;
            }
            case 65487: {
                this.secureFlash.setWriteData3(value8);
                break;
            }
            case 65504: {
                this.interruptRequestFlag0 = Utilities.setByte0(this.interruptRequestFlag0, value8);
                break;
            }
            case 65505: {
                this.interruptRequestFlag0 = Utilities.setByte1(this.interruptRequestFlag0, value8);
                break;
            }
            case 65506: {
                this.interruptRequestFlag1 = Utilities.setByte0(this.interruptRequestFlag1, value8);
                break;
            }
            case 65507: {
                this.interruptRequestFlag1 = Utilities.setByte1(this.interruptRequestFlag1, value8);
                break;
            }
            case 65508: {
                this.setInterruptMaskFlag0(Utilities.setByte0(this.interruptMaskFlag0, value8));
                break;
            }
            case 65509: {
                this.setInterruptMaskFlag0(Utilities.setByte1(this.interruptMaskFlag0, value8));
                break;
            }
            case 65510: {
                this.setInterruptMaskFlag1(Utilities.setByte0(this.interruptMaskFlag1, value8));
                break;
            }
            case 65511: {
                this.setInterruptMaskFlag1(Utilities.setByte1(this.interruptMaskFlag1, value8));
                break;
            }
            case 65512: {
                this.prioritySpecificationFlag0 = Utilities.setByte0(this.prioritySpecificationFlag0, value8);
                break;
            }
            case 65513: {
                this.prioritySpecificationFlag0 = Utilities.setByte1(this.prioritySpecificationFlag0, value8);
                break;
            }
            case 65514: {
                this.prioritySpecificationFlag1 = Utilities.setByte0(this.prioritySpecificationFlag1, value8);
                break;
            }
            case 65515: {
                this.prioritySpecificationFlag1 = Utilities.setByte1(this.prioritySpecificationFlag1, value8);
                break;
            }
            case 65520: {
                this.internalMemorySizeSwitching = value8;
                break;
            }
            case 65524: {
                this.internalExpansionRAMSizeSwitching = value8;
                break;
            }
            case 65531: {
                this.setProcessorClockControl(value8);
                break;
            }
            default: {
                super.write8(address, value);
            }
        }
    }

    @Override
    public void write8(int address, byte value) {
        this.internalWrite8(address, value);
        if (this.log.isTraceEnabled()) {
            if (Nec78k0SfrNames.hasSfr1Name(address)) {
                this.log.trace((Object)String.format("0x%04X - write8(%s, 0x%02X%s) on %s", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), value & 0xFF, Nec78k0SfrNames.getSfr1Names(address, value), this));
            } else {
                this.log.trace((Object)String.format("0x%04X - write8(%s, 0x%02X) on %s", this.getPc(), Nec78k0SfrNames.getSfr8Name(address), value & 0xFF, this));
            }
        }
    }

    private void internalWrite16(int address, short value) {
        int value16 = value & 0xFFFF;
        switch (address) {
            case 65298: {
                this.timer00.setCompare00(value16);
                break;
            }
            case 65300: {
                this.timer00.setCompare01(value16);
                break;
            }
            case 65308: {
                this.processor.setSp(value16);
                break;
            }
            case 65458: {
                this.timer01.setCompare00(value16);
                break;
            }
            case 65460: {
                this.timer01.setCompare01(value16);
                break;
            }
            case 65480: {
                this.secureFlash.setAddress(value16);
                break;
            }
            case 65484: {
                this.secureFlash.setWriteData2(value16 & 0xFF);
                this.secureFlash.setWriteData3(value16 >> 8);
                break;
            }
            case 65504: {
                this.interruptRequestFlag0 = value16;
                break;
            }
            case 65506: {
                this.interruptRequestFlag1 = value16;
                break;
            }
            case 65508: {
                this.setInterruptMaskFlag0(value16);
                break;
            }
            case 65510: {
                this.setInterruptMaskFlag1(value16);
                break;
            }
            case 65512: {
                this.prioritySpecificationFlag0 = value16;
                break;
            }
            case 65514: {
                this.prioritySpecificationFlag1 = value16;
                break;
            }
            default: {
                super.write16(address, value);
            }
        }
    }

    @Override
    public void write16(int address, short value) {
        this.internalWrite16(address, value);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%04X - write16(%s, 0x%04X) on %s", this.getPc(), Nec78k0SfrNames.getSfr16Name(address), value & 0xFFFF, this));
        }
    }

    @Override
    public String toString() {
        return String.format("Nec78k0 SFR %s", this.debugInterruptRequests());
    }
}

