/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import jpcsp.util.Utilities;

public class Nec78k0SfrNames {
    private static final String[][] sfr1Names = new String[256][8];
    private static final String[] sfr8Names = new String[256];
    private static final String[] sfr16Names = new String[256];
    private static final boolean[] hasSfr1Names = new boolean[256];

    private static void init() {
        Nec78k0SfrNames.addSfrName(65280, "P0");
        Nec78k0SfrNames.addSfrName(65281, "P1");
        Nec78k0SfrNames.addSfrName(65282, "P2");
        Nec78k0SfrNames.addSfrName(65283, "P3");
        Nec78k0SfrNames.addSfrName(65284, "P4");
        Nec78k0SfrNames.addSfrName(65285, "P5");
        Nec78k0SfrNames.addSfrName(65286, "P6");
        Nec78k0SfrNames.addSfrName(65287, "P7");
        Nec78k0SfrNames.addSfrName(65288, "ADCR", null, "ADCRH");
        Nec78k0SfrNames.addSfrName(65290, "RXB6");
        Nec78k0SfrNames.addSfrName(65291, "TXB6");
        Nec78k0SfrNames.addSfrName(65292, "P12");
        Nec78k0SfrNames.addSfrName(65293, "P13");
        Nec78k0SfrNames.addSfrName(65294, "P14");
        Nec78k0SfrNames.addSfrName(65295, "SIO10");
        Nec78k0SfrNames.addSfrName(65296, "TM00", null, null);
        Nec78k0SfrNames.addSfrName(65298, "CR000", null, null);
        Nec78k0SfrNames.addSfrName(65300, "CR010", null, null);
        Nec78k0SfrNames.addSfrName(65302, "TM50");
        Nec78k0SfrNames.addSfrName(65303, "CR50");
        Nec78k0SfrNames.addSfrName(65304, "CMP00");
        Nec78k0SfrNames.addSfrName(65305, "CMP10");
        Nec78k0SfrNames.addSfrName(65306, "CMP01");
        Nec78k0SfrNames.addSfrName(65307, "CMP11");
        Nec78k0SfrNames.addSfrName(65308, "SP", null, null);
        Nec78k0SfrNames.addSfrName(65310, "PSW", new String[]{"CY", "ISP", null, "RBS0", "AC", "RBS1", "Z", "IE"});
        Nec78k0SfrNames.addSfrName(65311, "TM51");
        Nec78k0SfrNames.addSfrName(65312, "PM0");
        Nec78k0SfrNames.addSfrName(65313, "PM1");
        Nec78k0SfrNames.addSfrName(65314, "PM2");
        Nec78k0SfrNames.addSfrName(65315, "PM3");
        Nec78k0SfrNames.addSfrName(65316, "PM4");
        Nec78k0SfrNames.addSfrName(65317, "PM5");
        Nec78k0SfrNames.addSfrName(65318, "PM6");
        Nec78k0SfrNames.addSfrName(65319, "PM7");
        Nec78k0SfrNames.addSfrName(65320, "ADM", new String[]{"ADCE", "LV0", "LV1", "FR0", "FR1", "FR2", null, "ADCS"});
        Nec78k0SfrNames.addSfrName(65321, "ADS", new String[]{"ADS0", "ADS1", "ADS2"});
        Nec78k0SfrNames.addSfrName(65324, "PM12");
        Nec78k0SfrNames.addSfrName(65326, "PM14");
        Nec78k0SfrNames.addSfrName(65327, "ADPC", new String[]{"ADPC0", "ADPC1", "ADPC2", "ADPC3"});
        Nec78k0SfrNames.addSfrName(65328, "PU0");
        Nec78k0SfrNames.addSfrName(65329, "PU1");
        Nec78k0SfrNames.addSfrName(65330, "PU2");
        Nec78k0SfrNames.addSfrName(65331, "PU3");
        Nec78k0SfrNames.addSfrName(65332, "PU4");
        Nec78k0SfrNames.addSfrName(65333, "PU5");
        Nec78k0SfrNames.addSfrName(65334, "PU6");
        Nec78k0SfrNames.addSfrName(65335, "PU7");
        Nec78k0SfrNames.addSfrName(65340, "PU12");
        Nec78k0SfrNames.addSfrName(65342, "PU14");
        Nec78k0SfrNames.addSfrName(65344, "CKS", new String[]{"CCS0", "CCS1", "CCS2", "CCS3", "CLOE"});
        Nec78k0SfrNames.addSfrName(65345, "CR51");
        Nec78k0SfrNames.addSfrName(65347, "TMC51", new String[]{"TOE51", "TMC51", "LVR51", "LVS51", null, null, "TMC516", "TCE51"});
        Nec78k0SfrNames.addSfrName(65352, "EGP");
        Nec78k0SfrNames.addSfrName(65353, "EGN");
        Nec78k0SfrNames.addSfrName(65354, "SIO11");
        Nec78k0SfrNames.addSfrName(65356, "SOTB11");
        Nec78k0SfrNames.addSfrName(65359, "ISC", new String[]{"ISC0", "ISC1"});
        Nec78k0SfrNames.addSfrName(65360, "ASIM6", new String[]{"ISRM6", "SL6", "CL6", "PS60", "PS61", "RXE6", "TXE6", "POWER6"});
        Nec78k0SfrNames.addSfrName(65363, "ASIS6");
        Nec78k0SfrNames.addSfrName(65365, "ASIF6");
        Nec78k0SfrNames.addSfrName(65366, "CKSR6");
        Nec78k0SfrNames.addSfrName(65367, "BRGC6");
        Nec78k0SfrNames.addSfrName(65368, "ASICL6", new String[]{"TXDLV6", "DIR6", "SBL60", "SBL61", "SBL62", "SBTT6", "SBRT6", "SBRF6"});
        Nec78k0SfrNames.addSfrName(65376, "SDR0", "SDR0L", "SDR0H");
        Nec78k0SfrNames.addSfrName(65378, "MDA0L", "MDA0LL", "MDA0LH");
        Nec78k0SfrNames.addSfrName(65380, "MDA0H", "MDA0HL", "MDA0HH");
        Nec78k0SfrNames.addSfrName(65382, "MDB0", "MDB0L", "MDB0H");
        Nec78k0SfrNames.addSfrName(65384, "DMUC0", new String[]{"DMUSEL0", null, null, null, null, null, null, "DMUE"});
        Nec78k0SfrNames.addSfrName(65385, "DMUC0", new String[]{"TOEN0", "TOLEV0", "TMMD00", "TMMD01", "CKS00", "CKS01", "CKS02", "TMHE0"});
        Nec78k0SfrNames.addSfrName(65386, "TCL50", new String[]{"TCL500", "TCL501", "TCL502"});
        Nec78k0SfrNames.addSfrName(65387, "TMC50", new String[]{"TOE50", "TMC501", "LVR50", "LVS50", null, null, "TMC506", "TCE50"});
        Nec78k0SfrNames.addSfrName(65388, "TMHMD1", new String[]{"TOEN1", "TOLEV1", "TMMD10", "TMMD11", "CKS10", "CKS11", "CKS12", "TMHE1"});
        Nec78k0SfrNames.addSfrName(65389, "TMCYC1", new String[]{"NRZ1", "NRZB1", "RMC1"});
        Nec78k0SfrNames.addSfrName(65390, "KRM");
        Nec78k0SfrNames.addSfrName(65391, "WTM");
        Nec78k0SfrNames.addSfrName(65392, "ASIM0", new String[]{null, "SL0", "CL0", "PS00", "PS01", "RXE0", "TXE0", "POWER0"});
        Nec78k0SfrNames.addSfrName(65393, "BRGC0");
        Nec78k0SfrNames.addSfrName(65394, "RXB0");
        Nec78k0SfrNames.addSfrName(65395, "ASIS0");
        Nec78k0SfrNames.addSfrName(65396, "TXS0");
        Nec78k0SfrNames.addSfrName(65408, "CSIM10", new String[]{"CSOT10", null, null, null, "DIR10", null, "TRMD10", "CSIE10"});
        Nec78k0SfrNames.addSfrName(65409, "CSIC10", new String[]{"CKS100", "CKS101", "CKS102", "DAP10", "CKP10"});
        Nec78k0SfrNames.addSfrName(65412, "SOTB10");
        Nec78k0SfrNames.addSfrName(65416, "CSIM11", new String[]{"CSOT11", null, null, null, "DIR11", "SSE11", "TRMD11", "CSIE11"});
        Nec78k0SfrNames.addSfrName(65417, "CSIC11", new String[]{"CKS110", "CKS111", "CKS112", "DAP11", "CKP11"});
        Nec78k0SfrNames.addSfrName(65420, "TCL51", new String[]{"TCL510", "TCL511", "TCL512"});
        Nec78k0SfrNames.addSfrName(65424, "CSIMA0", new String[]{null, "DIR0", "RXEA0", "TXEA0", "MASTER0", "ATM0", "ATE0", "CSIAE0"});
        Nec78k0SfrNames.addSfrName(65425, "CSIS0", new String[]{"TSF0", "ERRF0", "ERRE0", "BUSYLV0", "BUSYE0", "STBE0", "CKS00"});
        Nec78k0SfrNames.addSfrName(65426, "CSIT0", new String[]{"ATSTA0", "ATSTP0"});
        Nec78k0SfrNames.addSfrName(65427, "BRGCA0");
        Nec78k0SfrNames.addSfrName(65428, "ADTP0");
        Nec78k0SfrNames.addSfrName(65429, "ADTI0");
        Nec78k0SfrNames.addSfrName(65430, "SIOA0");
        Nec78k0SfrNames.addSfrName(65431, "ADTC0");
        Nec78k0SfrNames.addSfrName(65433, "WDTE");
        Nec78k0SfrNames.addSfrName(65439, "OSCCTL", new String[]{"AMPH", null, null, null, "OSCSELS", "EXCLKS", "OSCSEL", "EXCLK"});
        Nec78k0SfrNames.addSfrName(65440, "RCM", new String[]{"RSTOP", "LSRSTOP", null, null, null, null, null, "RSTS"});
        Nec78k0SfrNames.addSfrName(65441, "MCM", new String[]{"MCM0", "MCS", "XSEL"});
        Nec78k0SfrNames.addSfrName(65442, "MOC", new String[]{null, null, null, null, null, null, null, "MSTOP"});
        Nec78k0SfrNames.addSfrName(65443, "OSTC", new String[]{"MOST16", "MOST15", "MOST14", "MOST13", "MOST11"});
        Nec78k0SfrNames.addSfrName(65444, "OSTS");
        Nec78k0SfrNames.addSfrName(65445, "IIC0");
        Nec78k0SfrNames.addSfrName(65446, "IICC0", new String[]{"SPT0", "STT0", "ACKE0", "WTIM0", "SPIE0", "WREL0", "LREL0", "IICE0"});
        Nec78k0SfrNames.addSfrName(65447, "SVA0");
        Nec78k0SfrNames.addSfrName(65448, "IICCL0", new String[]{"CL00", "CL01", "DFC0", "SMC0", "DAD0", "CLD0"});
        Nec78k0SfrNames.addSfrName(65449, "IICX0", new String[]{"CLX0"});
        Nec78k0SfrNames.addSfrName(65450, "IICS0", new String[]{"SPD0", "STD0", "ACKD0", "TRC0", "COI0", "EXC0", "ALD0", "MSTS0"});
        Nec78k0SfrNames.addSfrName(65451, "IICF0", new String[]{"IICRSV", "STCEN", null, null, null, null, "IICBSY", "STCF"});
        Nec78k0SfrNames.addSfrName(65452, "RESF");
        Nec78k0SfrNames.addSfrName(65456, "TM01", null, null);
        Nec78k0SfrNames.addSfrName(65458, "CR001", null, null);
        Nec78k0SfrNames.addSfrName(65460, "CR011", null, null);
        Nec78k0SfrNames.addSfrName(65462, "TMC01", new String[]{"OVF01", "TMC011", "TMC012", "TMC013"});
        Nec78k0SfrNames.addSfrName(65463, "PRM01", new String[]{"PRM010", "PRM011", null, null, "ES010", "ES011", "ES110", "ES111"});
        Nec78k0SfrNames.addSfrName(65464, "CRC01", new String[]{"CRC010", "CRC011", "CRC012"});
        Nec78k0SfrNames.addSfrName(65465, "TOC01", new String[]{"TOE01", "TOC011", "LVR01", "LVS01", "TOC014", "OSPE01", "OSPT01"});
        Nec78k0SfrNames.addSfrName(65466, "TMC00", new String[]{"OVF00", "TMC001", "TMC002", "TMC003"});
        Nec78k0SfrNames.addSfrName(65467, "PRM00", new String[]{"PRM000", "PRM001", null, null, "ES000", "ES001", "ES100", "ES101"});
        Nec78k0SfrNames.addSfrName(65468, "CRC00", new String[]{"CRC000", "CRC001", "CRC002"});
        Nec78k0SfrNames.addSfrName(65469, "TOC00", new String[]{"TOE00", "TOC001", "LVR00", "LVS00", "TOC004", "OSPE00", "OSPT00"});
        Nec78k0SfrNames.addSfrName(65470, "LVIM", new String[]{"LVIF", "LVIMD", null, null, "LVISEL", null, null, "LVION"});
        Nec78k0SfrNames.addSfrName(65471, "LVIS", new String[]{"LVIS0", "LVIS1", "LVIS2", "LVIS3"});
        Nec78k0SfrNames.addSfrName(65472, "PFCMD");
        Nec78k0SfrNames.addSfrName(65482, "FLPMC", new String[]{"FLSPM0", "FLSPM1", "FWEPR", "FWEDIS"});
        Nec78k0SfrNames.addSfrName(65504, "IF0", "IF0L", "IF0H", new String[]{"LVIIF", "PIF0", "PIF1", "PIF2", "PIF3", "PIF4", "PIF5", "SREIF6", "SRIF6", "STIF6", "CSIIF10", "TMIFH1", "TMIFH0", "TMIF50", "TMIF000", "TMIF010"});
        Nec78k0SfrNames.addSfrName(65506, "IF1", "IF1L", "IF1H", new String[]{"ADIF", "SRIF0", "WTIIF", "TMIF51", "KRIF", "WTIF", "PIF6", "PIF7", "IICIF0", "CSIIF11", "TMIF001", "TMIF011", "ACSIIF"});
        Nec78k0SfrNames.addSfrName(65508, "MK0", "MK0L", "MK0H", new String[]{"LVIMK", "PMK0", "PMK1", "PMK2", "PMK3", "PMK4", "PMK5", "SREMK6", "SRMK6", "STMK6", "CSIMK10", "TMMKH1", "TMMKH0", "TMMK50", "TMMK000", "TMMK010"});
        Nec78k0SfrNames.addSfrName(65510, "MK1", "MK1L", "MK1H", new String[]{"ADMK", "SRMK0", "WTIMK", "TMMK51", "KRMK", "WTMK", "PMK6", "PMK7", "IICMK0", "CSIMK11", "TMMK001", "TMMK011", "ACSIMK"});
        Nec78k0SfrNames.addSfrName(65512, "PR0", "PR0L", "PR0H", new String[]{"LVIPR", "PPR0", "PPR1", "PPR2", "PPR3", "PPR4", "PPR5", "SREPR6", "SRPR6", "STPR6", "CSIPR10", "TMPRH1", "TMPRH0", "TMPR50", "TMPR000", "TMPR010"});
        Nec78k0SfrNames.addSfrName(65514, "PR1", "PR1L", "PR1H", new String[]{"ADPR", "SRPR0", "WTIPR", "TMPR51", "KRPR", "WTPR", "PPR6", "PPR7", "IICPR0", "CSIPR11", "TMPR001", "TMPR011", "ACSIPR"});
        Nec78k0SfrNames.addSfrName(65520, "IMS");
        Nec78k0SfrNames.addSfrName(65523, "BANK");
        Nec78k0SfrNames.addSfrName(65524, "IXS");
        Nec78k0SfrNames.addSfrName(65531, "PCC", new String[]{"PCC0", "PCC1", "PCC2", null, "CSS", "CLS", "XSTART"});
        String[] defaultBitNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7"};
        for (int i = 0; i < sfr8Names.length; ++i) {
            if (sfr8Names[i] == null) {
                Nec78k0SfrNames.sfr8Names[i] = String.format("0x%04X", 65280 + i);
            }
            if (sfr16Names[i] == null) {
                Nec78k0SfrNames.sfr16Names[i] = sfr8Names[i];
            }
            for (int j = 0; j < 8; ++j) {
                if (sfr1Names[i][j] != null) continue;
                Nec78k0SfrNames.sfr1Names[i][j] = defaultBitNames[j];
            }
        }
    }

    private static void addSfrName(int addr, String name) {
        int n = addr - 65280;
        Nec78k0SfrNames.sfr8Names[n] = name;
    }

    private static void addSfrName(int addr, String name, String[] bitNames) {
        int n = addr - 65280;
        Nec78k0SfrNames.sfr8Names[n] = name;
        System.arraycopy(bitNames, 0, sfr1Names[n], 0, bitNames.length);
        Nec78k0SfrNames.hasSfr1Names[n] = true;
    }

    private static void addSfrName(int addr, String sfr16Name, String sfr8Name0, String sfr8Name1) {
        int n = addr - 65280;
        Nec78k0SfrNames.sfr16Names[n] = sfr16Name;
        Nec78k0SfrNames.sfr8Names[n] = sfr8Name0;
        Nec78k0SfrNames.sfr8Names[n + 1] = sfr8Name1;
    }

    private static void addSfrName(int addr, String sfr16Name, String sfr8Name0, String sfr8Name1, String[] bitNames) {
        int n = addr - 65280;
        Nec78k0SfrNames.sfr16Names[n] = sfr16Name;
        Nec78k0SfrNames.sfr8Names[n] = sfr8Name0;
        Nec78k0SfrNames.sfr8Names[n + 1] = sfr8Name1;
        System.arraycopy(bitNames, 0, sfr1Names[n], 0, 8);
        Nec78k0SfrNames.hasSfr1Names[n] = true;
        System.arraycopy(bitNames, 8, sfr1Names[n + 1], 0, bitNames.length - 8);
        Nec78k0SfrNames.hasSfr1Names[n + 1] = true;
    }

    public static String getSfr8Name(int addr) {
        return sfr8Names[addr - 65280];
    }

    public static String getSfr16Name(int addr) {
        return sfr16Names[addr - 65280];
    }

    public static boolean hasSfr1Name(int addr) {
        return hasSfr1Names[addr - 65280];
    }

    public static String getSfr1Name(int addr, int bit) {
        return sfr1Names[addr - 65280][bit];
    }

    public static String getSfr1Names(int addr, int value) {
        StringBuilder s = new StringBuilder();
        value &= 0xFF;
        int i = 0;
        while (value != 0) {
            if (Utilities.hasFlag(value, 1)) {
                if (s.length() > 0) {
                    s.append("|");
                }
                s.append(Nec78k0SfrNames.getSfr1Name(addr, i));
            }
            ++i;
            value >>= 1;
        }
        if (s.length() > 0) {
            s.insert(0, '(');
            s.append(')');
        }
        return s.toString();
    }

    static {
        Nec78k0SfrNames.init();
    }
}

