/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.network.upnp.UPnP;

public class PortManager {
    private List<String> hosts = new LinkedList<String>();
    private List<PortInfo> portInfos = new LinkedList<PortInfo>();
    private UPnP upnp;
    private String localIPAddress;
    private static final int portLeaseDuration = 0;
    private static final String portDescription = "Jpcsp ProOnline Network";
    private static final boolean SUPPORTS_MAPPING_FOR_MULTIPLE_REMOTE_HOSTS = false;
    private static final String ALL_REMOTE_HOSTS = "";

    public PortManager(UPnP upnp) {
        this.upnp = upnp;
        this.localIPAddress = sceNetApctl.getLocalHostIP();
    }

    protected String getLocalIPAddress() {
        return this.localIPAddress;
    }

    public synchronized void addHost(String host) {
        if (this.hosts.contains(host)) {
            return;
        }
        if (this.hosts.isEmpty()) {
            for (PortInfo portInfo : this.portInfos) {
                this.upnp.getIGD().addPortMapping(this.upnp, ALL_REMOTE_HOSTS, portInfo.port, portInfo.protocol, portInfo.port, this.getLocalIPAddress(), portDescription, 0);
            }
        }
        this.hosts.add(host);
    }

    public synchronized void removeHost(String host) {
        if (!this.hosts.contains(host)) {
            return;
        }
        this.hosts.remove(host);
        if (this.hosts.isEmpty()) {
            for (PortInfo portInfo : this.portInfos) {
                this.upnp.getIGD().deletePortMapping(this.upnp, ALL_REMOTE_HOSTS, portInfo.port, portInfo.protocol);
            }
        }
    }

    public synchronized void addPort(int port, String protocol) {
        PortInfo portInfo = new PortInfo(port, protocol);
        if (this.portInfos.contains(portInfo)) {
            return;
        }
        this.upnp.getIGD().addPortMapping(this.upnp, ALL_REMOTE_HOSTS, port, protocol, port, this.getLocalIPAddress(), portDescription, 0);
        this.portInfos.add(portInfo);
    }

    public synchronized void removePort(int port, String protocol) {
        PortInfo portInfo = new PortInfo(port, protocol);
        if (!this.portInfos.contains(portInfo)) {
            return;
        }
        this.upnp.getIGD().deletePortMapping(this.upnp, ALL_REMOTE_HOSTS, port, protocol);
        this.portInfos.remove(portInfo);
    }

    public synchronized void clear() {
        while (!this.hosts.isEmpty()) {
            String host = this.hosts.get(0);
            this.removeHost(host);
        }
        while (!this.portInfos.isEmpty()) {
            PortInfo portInfo = this.portInfos.get(0);
            this.removePort(portInfo.port, portInfo.protocol);
        }
    }

    private static class PortInfo {
        int port;
        String protocol;

        public PortInfo(int port, String protocol) {
            this.port = port;
            this.protocol = protocol;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PortInfo) {
                PortInfo portInfo = (PortInfo)obj;
                return this.port == portInfo.port && this.protocol.equals(portInfo.protocol);
            }
            return super.equals(obj);
        }
    }
}

