/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoundVoice;

public class SampleSourceWithPitch
implements ISampleSource {
    private ISampleSource sampleSource;
    private SoundVoice voice;
    private int pitchRest;
    private int currentSample;

    public SampleSourceWithPitch(ISampleSource sampleSource, SoundVoice voice) {
        this.sampleSource = sampleSource;
        this.voice = voice;
    }

    private int getPitch() {
        return this.voice.getPitch();
    }

    @Override
    public int getNextSample() {
        while (this.pitchRest <= 0) {
            this.currentSample = this.sampleSource.getNextSample();
            this.pitchRest += 4096;
        }
        this.pitchRest -= this.getPitch();
        return this.currentSample;
    }

    @Override
    public void resetToStart() {
        this.sampleSource.resetToStart();
        this.pitchRest = 0;
    }

    @Override
    public boolean isEnded() {
        return this.sampleSource.isEnded();
    }

    public String toString() {
        return String.format("SampleSourceWithPitch[pitchRest=0x%X, pitch=0x%X, %s]", this.pitchRest, this.getPitch(), this.sampleSource.toString());
    }
}

