/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.autotests.AutoTestsRunner;
import jpcsp.hardware.Battery;
import jpcsp.hardware.Model;
import jpcsp.hardware.Wlan;
import jpcsp.memory.mmio.battery.BatteryEmulator;
import jpcsp.memory.mmio.battery.BatteryMemory;
import jpcsp.memory.mmio.battery.BatterySerialInterface;
import jpcsp.memory.mmio.syscon.SysconBatteryEmulator;
import jpcsp.nec78k0.Nec78k0Disassembler;
import jpcsp.nec78k0.Nec78k0Interpreter;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.util.LWJGLFixer;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Battery78k0Test {
    public static Logger log;

    public static void main(String[] args) {
        LWJGLFixer.fixOnce();
        DOMConfigurator.configure((String)"LogSettings.xml");
        log = BatteryEmulator.log;
        RuntimeContext.setLog4jMDC();
        Wlan.initialize();
        Battery.initialize();
        new Emulator(new AutoTestsRunner.DummyGUI());
        Emulator.getClock().resume();
        RuntimeContext.debugCodeBlockCalls = true;
        Emulator.run = true;
        new Battery78k0Test().testFirmware();
    }

    public void testFirmware() {
        int model = 2;
        Model.setModel(model);
        BatteryMemory mem = new BatteryMemory(log);
        Nec78k0Processor processor = new Nec78k0Processor(mem);
        Nec78k0Interpreter interpreter = new Nec78k0Interpreter(processor);
        Nec78k0Disassembler disassembler = processor.getDisassembler();
        mem.getSfr().getSerialInterfaceUART6().setSerialInterface(new BatterySerialInterface(mem.getSfr(), mem.getSfr().getSerialInterfaceUART6()));
        BatteryEmulator.load(mem, interpreter);
        int batteryModel = BatteryEmulator.getBatteryModel();
        disassembler.setDataRange(16384, Short.MAX_VALUE);
        disassembler.setDataRange(32768, 49151);
        if (batteryModel == 2) {
            disassembler.setDataRange(1600, 2303);
            disassembler.setDataRange(3385, 5151);
            disassembler.setDataRange(16357, 16383);
        } else if (batteryModel == 1) {
            disassembler.setDataRange(1571, 2303);
            disassembler.setDataRange(3385, 5151);
            disassembler.setDataRange(16299, 16383);
        } else {
            log.error((Object)String.format("Unsupported Battery model %d", batteryModel));
        }
        processor.disassemble(mem.read16(0));
        for (int addr = 1024; addr < 16384; ++addr) {
            if (disassembler.disassembledAddresses.contains(addr)) continue;
            processor.disassemble(addr);
        }
        BatteryEmulator.writeEeprom16(0, 1250);
        BatteryEmulator.writeEeprom16(2, 3842);
        BatteryEmulator.writeEeprom16(4, 10);
        BatteryEmulator.writeEeprom16(5, 40);
        BatteryEmulator.writeEeprom16(6, 65);
        BatteryEmulator.writeEeprom16(7, 61527);
        BatteryEmulator.writeEeprom16(9, 17409);
        BatteryEmulator.writeEeprom16(16, 3118);
        BatteryEmulator.writeEeprom16(17, 131);
        BatteryEmulator.writeEeprom16(32, 3);
        BatteryEmulator.writeEeprom16(33, 573);
        BatteryEmulator.writeEeprom16(34, 791);
        BatteryEmulator.writeEeprom16(35, 65481);
        BatteryEmulator.writeEeprom16(36, 636);
        BatteryEmulator.writeEeprom16(37, 635);
        BatteryEmulator.writeEeprom16(48, 1140);
        BatteryEmulator.writeEeprom16(49, 102);
        BatteryEmulator.writeEeprom16(50, 160);
        BatteryEmulator.writeEeprom16(51, 22);
        BatteryEmulator.writeEeprom16(52, 32);
        BatteryEmulator.writeEeprom16(53, 50);
        BatteryEmulator.writeEeprom16(54, 560);
        BatteryEmulator.writeEeprom16(55, 10090);
        BatteryEmulator.writeEeprom16(56, 9943);
        BatteryEmulator.writeEeprom16(57, 8821);
        BatteryEmulator.writeEeprom16(58, 8011);
        BatteryEmulator.writeEeprom16(59, 37689);
        BatteryEmulator.writeEeprom16(64, 0);
        BatteryEmulator.writeEeprom16(65, 0);
        BatteryEmulator.writeEeprom16(121, 14674);
        BatteryEmulator.writeEeprom16(122, 5223);
        BatteryEmulator.writeEeprom16(123, 5236);
        BatteryEmulator.writeEeprom16(124, 1);
        BatteryEmulator.writeEeprom16(125, 2);
        BatteryEmulator.writeEeprom16(126, 3);
        BatteryEmulator.writeEeprom16(127, 43426);
        processor.reset();
        interpreter.run();
        BatterySerialInterface batterySerialInterface = (BatterySerialInterface)mem.getSfr().getSerialInterfaceUART6().getConnectedSerialInterface();
        int keyId = 13;
        int[] cmdParams = new int[]{keyId, 70, 229, 149, 47, 179, 178, 48, 92};
        batterySerialInterface.sendRequest(224, cmdParams);
        SysconBatteryEmulator sysconBatteryEmulator = new SysconBatteryEmulator(null, null);
        sysconBatteryEmulator.setLogger(log);
        sysconBatteryEmulator.transmit(90);
        sysconBatteryEmulator.transmit(cmdParams.length + 2);
        sysconBatteryEmulator.transmit(128);
        for (int i = 0; i < cmdParams.length; ++i) {
            sysconBatteryEmulator.transmit(cmdParams[i]);
        }
        sysconBatteryEmulator.transmitChecksum();
        sysconBatteryEmulator.startReception();
        long minimumDuration = 1000L;
        long start = Battery78k0Test.now();
        while (Battery78k0Test.now() - start < minimumDuration) {
            interpreter.setHalted(false);
            interpreter.run();
        }
    }

    public static long now() {
        return Emulator.getClock().currentTimeMillis();
    }
}

