/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import jpcsp.util.LWJGLFixer;
import org.lwjgl.openal.AL10;

public class OpenAL {
    private static Set<Integer> freeBuffers;
    private static boolean isRawFile;
    private static int sampleRate;

    private static int read8(FileInputStream fis) throws IOException {
        byte[] buffer = new byte[1];
        fis.read(buffer);
        return buffer[0] & 0xFF;
    }

    private static int read32(FileInputStream fis) throws IOException {
        int n1 = OpenAL.read8(fis);
        int n2 = OpenAL.read8(fis);
        int n3 = OpenAL.read8(fis);
        int n4 = OpenAL.read8(fis);
        return n1 | n2 << 8 | n3 << 16 | n4 << 24;
    }

    private static void read(FileInputStream fis, int alSource) {
        try {
            int alBuffer;
            byte[] buffer;
            int length;
            if (isRawFile) {
                int fileSize = OpenAL.read32(fis);
                OpenAL.read32(fis);
                length = fileSize - 8;
                if (length > 0) {
                    buffer = new byte[length];
                    length = fis.read(buffer);
                } else {
                    buffer = null;
                }
            } else {
                buffer = new byte[10240];
                length = fis.read(buffer);
            }
            if (length <= 0) {
                AL10.alSourceStop((int)alSource);
                fis.close();
                return;
            }
            ByteBuffer directBuffer = ByteBuffer.allocateDirect(length);
            directBuffer.put(buffer, 0, length);
            directBuffer.rewind();
            do {
                alBuffer = -1;
                if (freeBuffers.isEmpty()) {
                    int availableBuffers = AL10.alGetSourcei((int)alSource, (int)4118);
                    if (availableBuffers <= 0) continue;
                    alBuffer = AL10.alSourceUnqueueBuffers((int)alSource);
                    continue;
                }
                alBuffer = freeBuffers.iterator().next();
                freeBuffers.remove(alBuffer);
            } while (alBuffer < 0);
            AL10.alBufferData((int)alBuffer, (int)4355, (ByteBuffer)directBuffer, (int)sampleRate);
            AL10.alSourceQueueBuffers((int)alSource, (int)alBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getStateName(int state) {
        switch (state) {
            case 4114: {
                return "Playing";
            }
            case 4115: {
                return "Paused";
            }
            case 4116: {
                return "Stopped";
            }
        }
        return String.format("%d", state);
    }

    private static void displayError(String text) {
        int errorCode = AL10.alGetError();
        if (errorCode != 0) {
            System.out.println(String.format("Error %s %d", text, errorCode));
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("tmp/xxDISCIDxx/Mpeg-nnnn/AudioStream-0.raw");
            isRawFile = true;
            if (isRawFile) {
                OpenAL.read32(fis);
            }
            for (int i = 0; i < 5; ++i) {
                freeBuffers.add(AL10.alGenBuffers());
                OpenAL.displayError("alGenBuffers");
            }
            int alSource = AL10.alGenSources();
            OpenAL.displayError("alGenSources");
            AL10.alSourcei((int)alSource, (int)4103, (int)0);
            OpenAL.displayError("AL_LOOPING");
            OpenAL.read(fis, alSource);
            AL10.alSourcePlay((int)alSource);
            OpenAL.displayError("alSourcePlay");
            int previousState = -1;
            while (true) {
                int state;
                if ((state = AL10.alGetSourcei((int)alSource, (int)4112)) != previousState) {
                    System.out.println(String.format("State %s", OpenAL.getStateName(state)));
                    previousState = state;
                }
                if (state != 4114 && state != 4113) break;
                OpenAL.read(fis, alSource);
            }
            AL10.alSourceStop((int)alSource);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        LWJGLFixer.fixOnce();
        freeBuffers = new HashSet<Integer>();
        isRawFile = false;
        sampleRate = 48000;
    }
}

