/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.filesystems.SeekableRandomFile;
import libchdr.Chd;
import libchdr.ChdHeader;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class TestChdr {
    public static Logger log = Chd.log;

    public static void main(String[] args) {
        DOMConfigurator.configure((String)"LogSettings.xml");
        try {
            new TestChdr().test("umdimages/cube.chd", "tmp/cube.iso", null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void test(String fileName, String outputFileName, String parentFileName) throws FileNotFoundException {
        ChdHeader.ChdError err;
        Chd.ChdFile[] res;
        long start = System.currentTimeMillis();
        new File(outputFileName).delete();
        LocalVirtualFile vFileOut = new LocalVirtualFile(new SeekableRandomFile(outputFileName, "rw"));
        Chd chd = new Chd();
        Chd.ChdFile parent = null;
        if (parentFileName != null) {
            res = new Chd.ChdFile[1];
            err = chd.chd_open_file(parentFileName, 1, null, res);
            parent = res[0];
            log.info((Object)String.format("parent=%s, err=%s", new Object[]{parent, err}));
        }
        res = new Chd.ChdFile[1];
        err = chd.chd_open_file(fileName, 1, parent, res);
        Chd.ChdFile chdFile = res[0];
        log.info((Object)String.format("chdFile=%s, err=%s", new Object[]{chdFile, err}));
        ChdHeader header = chd.chd_get_header(chdFile);
        int numberFrames = header.totalhunks * 8;
        int frameSize = 2448;
        byte[] metadata = new byte[512];
        int[] resultLength = new int[1];
        err = chd.chd_get_metadata(chdFile, ChdHeader.CDROM_TRACK_METADATA2_TAG, 0, metadata, metadata.length, resultLength, null, null);
        if (err == ChdHeader.ChdError.CHDERR_NONE) {
            int metadataLength = resultLength[0];
            String metadataString = new String(metadata, 0, metadataLength);
            Pattern p = Pattern.compile("TRACK:(\\d+) TYPE:(.*) SUBTYPE:(.*) FRAMES:(\\d+) PREGAP:(\\d+)");
            Matcher m = p.matcher(metadataString);
            if (m.find()) {
                int track = Integer.parseInt(m.group(1));
                String type = m.group(2);
                String subtype = m.group(3);
                int frames = Integer.parseInt(m.group(4));
                int pregap = Integer.parseInt(m.group(5));
                log.info((Object)String.format("Track %d, type %s, subtype %s, frames %d, pregap %d", track, type, subtype, frames, pregap));
                numberFrames = frames;
                if ("MODE1".equals(type)) {
                    frameSize = 2048;
                }
            } else {
                log.info((Object)metadataString);
            }
        }
        int totalBytes = header.hunkbytes * header.totalhunks;
        byte[] buffer = new byte[header.hunkbytes];
        int frameCount = 0;
        for (int i = 0; i < header.totalhunks; ++i) {
            log.info((Object)String.format("Reading hunk#%d/%d", i + 1, header.totalhunks));
            err = chd.chd_read(chdFile, i, buffer, 0);
            if (err != ChdHeader.ChdError.CHDERR_NONE) {
                log.error((Object)String.format("chdRead hunknum=%d, err=%s", new Object[]{i, err}));
                continue;
            }
            for (int frame = 0; frame < 8 && frameCount < numberFrames; ++frame, ++frameCount) {
                vFileOut.ioWrite(buffer, frame * 2448, frameSize);
            }
        }
        chd.chd_close(chdFile);
        vFileOut.ioClose();
        long end = System.currentTimeMillis();
        double timeTaken = (double)(end - start) / 1000.0;
        log.info((Object)String.format("Read %d bytes in %f seconds", totalBytes, timeTaken));
    }
}

