/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.IOException;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class RingBuffer
implements IState {
    private static final int STATE_VERSION = 0;
    private int[] buffer;
    private int count;
    private int readIndex;
    private int writeIndex;

    public RingBuffer(int size) {
        this.buffer = new int[size];
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.buffer = stream.readIntsWithLength();
        this.count = stream.readInt();
        this.readIndex = stream.readInt();
        this.writeIndex = stream.readInt();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeIntsWithLength(this.buffer);
        stream.writeInt(this.count);
        stream.writeInt(this.readIndex);
        stream.writeInt(this.writeIndex);
    }

    private int increment(int index, int value) {
        index += value;
        while (index >= this.buffer.length) {
            index -= this.buffer.length;
        }
        while (index < 0) {
            index += this.buffer.length;
        }
        return index;
    }

    private int increment(int index) {
        if (++index >= this.buffer.length) {
            return 0;
        }
        return index;
    }

    public void write(int value) {
        if (this.isFull()) {
            return;
        }
        this.buffer[this.writeIndex] = value;
        this.writeIndex = this.increment(this.writeIndex);
        ++this.count;
    }

    public int read() {
        if (this.isEmpty()) {
            return 0;
        }
        int value = this.buffer[this.readIndex];
        this.readIndex = this.increment(this.readIndex);
        --this.count;
        return value;
    }

    public int peek() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.buffer[this.readIndex];
    }

    public int peek(int index) {
        if (index < 0 || index >= this.count) {
            return 0;
        }
        int value = this.buffer[this.increment(this.readIndex, index)];
        return value;
    }

    public int peek(int index, int[] data, int offset, int length) {
        if (index + length > this.count) {
            length = this.count - index;
        }
        if (length <= 0) {
            return 0;
        }
        if (this.readIndex + index + length <= this.buffer.length) {
            System.arraycopy(this.buffer, this.readIndex + index, data, offset, length);
        } else {
            int size1 = this.buffer.length - (this.readIndex + index);
            int size2 = length - size1;
            System.arraycopy(this.buffer, this.readIndex + index, data, offset, size1);
            System.arraycopy(this.buffer, 0, data, offset + size1, size2);
        }
        return length;
    }

    public int readAll(int[] data, int offset) {
        int readSize = this.peek(0, data, offset, this.count);
        this.clear();
        return readSize;
    }

    public int[] readAll() {
        int[] data = new int[this.size()];
        this.readAll(data, 0);
        return data;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    public boolean isFull() {
        return this.count >= this.buffer.length;
    }

    public void clear() {
        this.count = 0;
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    public String toString(int bits, int offset, int length) {
        String format;
        switch (bits) {
            case 8: {
                format = "0x%02X";
                break;
            }
            case 16: {
                format = "0x%04X";
                break;
            }
            case 32: {
                format = "0x%08X";
                break;
            }
            default: {
                format = "0x%X";
            }
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(String.format(format, this.peek(offset + i)));
        }
        return s.toString();
    }

    public String toString(int bits) {
        return this.toString(bits, 0, this.count);
    }

    public String toString() {
        return String.format("count=%d", this.count);
    }
}

