/*
 * Decompiled with CFR 0.152.
 */
package libchdr;

import jpcsp.util.Utilities;

public class Bitstream {
    public int buffer;
    public int bits;
    public byte[] read;
    public int readOffset;
    public int doffset;
    public int dlength;

    public Bitstream(byte[] src, int srcOffset, int srcLength) {
        this.read = src;
        this.readOffset = srcOffset;
        this.dlength = srcLength;
    }

    public boolean overflow() {
        return this.doffset - this.bits / 8 > this.dlength;
    }

    public int peek(int numBits) {
        if (numBits == 0) {
            return 0;
        }
        if (numBits > this.bits) {
            while (this.bits <= 24) {
                if (this.doffset < this.dlength) {
                    this.buffer |= Utilities.read8(this.read, this.readOffset + this.doffset) << 24 - this.bits;
                }
                ++this.doffset;
                this.bits += 8;
            }
        }
        return this.buffer >>> 32 - numBits;
    }

    public void remove(int numBits) {
        this.buffer <<= numBits;
        this.bits -= numBits;
    }

    public int read(int numBits) {
        int result = this.peek(numBits);
        this.remove(numBits);
        return result;
    }

    public int read_offset() {
        int result = this.doffset;
        for (int nbits = this.bits; nbits >= 8; nbits -= 8) {
            --result;
        }
        return result;
    }

    public int flush() {
        while (this.bits >= 8) {
            --this.doffset;
            this.bits -= 8;
        }
        this.buffer = 0;
        this.bits = 0;
        return this.doffset;
    }
}

