/*
 * Decompiled with CFR 0.152.
 */
package libchdr.codec;

import io.nayuki.flac.decode.AbstractFlacLowLevelInput;
import io.nayuki.flac.decode.FlacDecoder;
import java.io.IOException;
import jpcsp.util.Utilities;
import libchdr.Chd;
import libchdr.ChdHeader;
import libchdr.codec.ICodecInterface;

public class Flac
implements ICodecInterface {
    protected FlacDecoder flacDecoder;
    protected FlacInput flacInput;
    protected static final int numChannels = 2;
    private final byte[] magic = new byte[]{102, 76, 97, 67};
    private final byte[] dummyMetadata = new byte[]{-128, 0, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, -60, 66, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected final int[][] samples = new int[2][65536];

    @Override
    public ChdHeader.ChdError init(Chd.CodecData codec, int hunkbytes) {
        this.flacInput = new FlacInput();
        this.flacInput.setData(this.magic, 0, this.magic.length);
        try {
            this.flacDecoder = new FlacDecoder(this.flacInput);
        }
        catch (IOException e) {
            return ChdHeader.ChdError.CHDERR_DECOMPRESSION_ERROR;
        }
        return ChdHeader.ChdError.CHDERR_NONE;
    }

    @Override
    public void free(Chd.CodecData codec) {
    }

    @Override
    public ChdHeader.ChdError decompress(Chd.CodecData codec, byte[] src, int srcOffset, int complen, byte[] dest, int destOffset, int destlen) {
        boolean endianSwap;
        Chd.FlacCodecData flac = (Chd.FlacCodecData)codec;
        if (Utilities.read8(src, srcOffset + 0) == 76) {
            endianSwap = !flac.nativeEndian;
        } else if (Utilities.read8(src, srcOffset + 0) == 66) {
            endianSwap = flac.nativeEndian;
        } else {
            return ChdHeader.ChdError.CHDERR_DECOMPRESSION_ERROR;
        }
        try {
            this.decompressDummyMetadata(this.getBlocksize(destlen));
            this.flacInput.setData(src, srcOffset + 1, complen - 1);
            int sampleCount = this.flacDecoder.readAudioBlock(this.samples, 0);
            this.storeSamples(this.samples, sampleCount, dest, destOffset, destlen, endianSwap);
        }
        catch (IOException e) {
            return ChdHeader.ChdError.CHDERR_DECOMPRESSION_ERROR;
        }
        return ChdHeader.ChdError.CHDERR_NONE;
    }

    @Override
    public ChdHeader.ChdError config(Chd.CodecData codec, int param, Object config) {
        return ChdHeader.ChdError.CHDERR_NONE;
    }

    protected void decompressDummyMetadata(int blockSize) throws IOException {
        this.dummyMetadata[4] = (byte)((blockSize *= 2) >> 8);
        this.dummyMetadata[5] = (byte)blockSize;
        this.dummyMetadata[6] = this.dummyMetadata[4];
        this.dummyMetadata[7] = this.dummyMetadata[5];
        this.flacInput.setData(this.dummyMetadata, 0, this.dummyMetadata.length);
        while (this.flacDecoder.readAndHandleMetadataBlock() != null) {
        }
    }

    protected int getBlockSize(int bytes, int target) {
        int blocksize;
        for (blocksize = bytes / 4; blocksize > target; blocksize /= 2) {
        }
        return blocksize;
    }

    private int getBlocksize(int bytes) {
        return this.getBlockSize(bytes, 2048);
    }

    protected void storeSamples(int[][] samples, int sampleCount, byte[] dest, int destOffset, int destLength, boolean endianSwap) {
        int destIndex = 0;
        for (int sample = 0; sample < sampleCount; ++sample) {
            for (int channel = 0; channel < 2; ++channel) {
                int value = samples[channel][sample];
                if (destIndex >= destLength) continue;
                if (endianSwap) {
                    dest[destOffset + destIndex] = (byte)value;
                    dest[destOffset + destIndex + 1] = (byte)(value >> 8);
                } else {
                    dest[destOffset + destIndex] = (byte)(value >> 8);
                    dest[destOffset + destIndex + 1] = (byte)value;
                }
                destIndex += 2;
            }
        }
    }

    protected static class FlacInput
    extends AbstractFlacLowLevelInput {
        private byte[] data;
        private int dataOffset;
        private int dataLength;
        private int position;

        protected FlacInput() {
        }

        @Override
        public long getLength() {
            return this.dataLength;
        }

        @Override
        public void seekTo(long pos) throws IOException {
            this.position = (int)pos;
        }

        @Override
        protected int readUnderlying(byte[] buf, int off, int len) throws IOException {
            int readLength = Math.min(len, this.dataLength - this.position);
            System.arraycopy(this.data, this.dataOffset + this.position, buf, off, readLength);
            this.position += readLength;
            return readLength;
        }

        public void setData(byte[] data, int dataOffset, int dataLength) {
            this.data = data;
            this.dataOffset = dataOffset;
            this.dataLength = dataLength;
            this.position = 0;
            this.positionChanged(this.position);
        }
    }
}

