/*
 * Decompiled with CFR 0.152.
 */
package libchdr.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import libchdr.ChdHeader;
import libchdr.codec.BaseCodec;
import org.tukaani.xz.LZMAInputStream;

public class Lzma
extends BaseCodec {
    private static final int lc = 3;
    private static final int lp = 0;
    private static final int pb = 2;
    private static final byte propsByte = 93;
    private static final int dictSize = 0x7FFFFFF0;

    @Override
    protected ChdHeader.ChdError decompress(byte[] src, int srcOffset, int complen, byte[] dest, int destOffset, int destlen) {
        return Lzma.lzmaDecompress(src, srcOffset, complen, dest, destOffset, destlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChdHeader.ChdError lzmaDecompress(byte[] src, int srcOffset, int complen, byte[] dest, int destOffset, int destlen) {
        LZMAInputStream lzmaInputStream = null;
        try {
            lzmaInputStream = new LZMAInputStream((InputStream)new ByteArrayInputStream(src, srcOffset, complen), (long)destlen & 0xFFFFFFFFL, 93, 0x7FFFFFF0);
            while (destlen > 0) {
                int readLength = lzmaInputStream.read(dest, destOffset, destlen);
                if (readLength <= 0) {
                    ChdHeader.ChdError chdError = ChdHeader.ChdError.CHDERR_DECOMPRESSION_ERROR;
                    return chdError;
                }
                destOffset += readLength;
                destlen -= readLength;
            }
        }
        catch (IOException e) {
            ChdHeader.ChdError chdError = ChdHeader.ChdError.CHDERR_DECOMPRESSION_ERROR;
            return chdError;
        }
        finally {
            if (lzmaInputStream != null) {
                try {
                    lzmaInputStream.close();
                }
                catch (IOException e) {
                    return ChdHeader.ChdError.CHDERR_DECOMPRESSION_ERROR;
                }
            }
        }
        return ChdHeader.ChdError.CHDERR_NONE;
    }
}

