/*
 * Decompiled with CFR 0.152.
 */
package libkirk;

import jpcsp.crypto.KeyVault;
import libkirk.AES;
import libkirk.EC;
import libkirk.SHA1;
import libkirk.Utilities;

public class KirkEngine {
    public static final int KIRK_OPERATION_SUCCESS = 0;
    public static final int KIRK_NOT_ENABLED = 1;
    public static final int KIRK_INVALID_MODE = 2;
    public static final int KIRK_HEADER_HASH_INVALID = 3;
    public static final int KIRK_DATA_HASH_INVALID = 4;
    public static final int KIRK_SIG_CHECK_INVALID = 5;
    public static final int KIRK_UNK_1 = 6;
    public static final int KIRK_UNK_2 = 7;
    public static final int KIRK_UNK_3 = 8;
    public static final int KIRK_UNK_4 = 9;
    public static final int KIRK_UNK_5 = 10;
    public static final int KIRK_UNK_6 = 11;
    public static final int KIRK_NOT_INITIALIZED = 12;
    public static final int KIRK_INVALID_OPERATION = 13;
    public static final int KIRK_INVALID_SEED_CODE = 14;
    public static final int KIRK_INVALID_SIZE = 15;
    public static final int KIRK_DATA_SIZE_ZERO = 16;
    public static final int KIRK_CMD_ENCRYPT_PRIVATE = 0;
    public static final int KIRK_CMD_DECRYPT_PRIVATE = 1;
    public static final int KIRK_CMD_ENCRYPT_SIGN = 2;
    public static final int KIRK_CMD_DECRYPT_SIGN = 3;
    public static final int KIRK_CMD_ENCRYPT_IV_0 = 4;
    public static final int KIRK_CMD_ENCRYPT_IV_FUSE = 5;
    public static final int KIRK_CMD_ENCRYPT_IV_USER = 6;
    public static final int KIRK_CMD_DECRYPT_IV_0 = 7;
    public static final int KIRK_CMD_DECRYPT_IV_FUSE = 8;
    public static final int KIRK_CMD_DECRYPT_IV_USER = 9;
    public static final int KIRK_CMD_PRIV_SIGN_CHECK = 10;
    public static final int KIRK_CMD_SHA1_HASH = 11;
    public static final int KIRK_CMD_ECDSA_GEN_KEYS = 12;
    public static final int KIRK_CMD_ECDSA_MULTIPLY_POINT = 13;
    public static final int KIRK_CMD_PRNG = 14;
    public static final int KIRK_CMD_INIT = 15;
    public static final int KIRK_CMD_ECDSA_SIGN = 16;
    public static final int KIRK_CMD_ECDSA_VERIFY = 17;
    public static final int KIRK_CMD_CERT_VERIFY = 18;
    public static final int KIRK_MODE_CMD1 = 1;
    public static final int KIRK_MODE_CMD2 = 2;
    public static final int KIRK_MODE_CMD3 = 3;
    public static final int KIRK_MODE_ENCRYPT_CBC = 4;
    public static final int KIRK_MODE_DECRYPT_CBC = 5;
    public static final byte[] kirk1_key = new byte[]{-104, -55, 64, -105, 92, 29, 16, -24, 127, -26, 14, -93, -3, 3, -88, -70};
    public static final byte[] kirk16_key = new byte[]{71, 94, 9, -12, -94, 55, -38, -101, -17, -1, 59, -64, 119, 20, 61, -118};
    public static final byte[] ec_p = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final byte[] ec_a = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 1, -1, -1, -1, -1, -1, -1, -1, -4};
    public static final byte[] ec_b2 = new byte[]{-90, -117, -19, -61, 52, 24, 2, -100, 29, 60, -29, 59, -102, 50, 31, -52, -69, -98, 15, 11};
    public static final byte[] ec_N2 = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -75, -82, 60, 82, 62, 99, -108, 79, 33, 39};
    public static final byte[] Gx2 = new byte[]{18, -114, -60, 37, 100, -121, -3, -113, -33, 100, -30, 67, 123, -64, -95, -10, -43, -81, -34, 44};
    public static final byte[] Gy2 = new byte[]{89, 88, 85, 126, -79, -37, 0, 18, 96, 66, 85, 36, -37, -61, 121, -43, -84, 95, 74, -33};
    public static final byte[] ec_b1 = new byte[]{101, -47, 72, -116, 3, 89, -30, 52, -83, -55, 91, -45, -112, -128, 20, -67, -111, -91, 37, -7};
    public static final byte[] ec_N1 = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, -75, -58, 23, -14, -112, -22, -31, -37, -83, -113};
    public static final byte[] Gx1 = new byte[]{34, 89, -84, -18, 21, 72, -100, -80, -106, -88, -126, -16, -82, 28, -7, -3, -114, -27, -8, -6};
    public static final byte[] Gy1 = new byte[]{96, 67, 88, 69, 109, 10, 28, -78, -112, -115, -23, 15, 39, -41, 92, -126, -66, -63, 8, -64};
    public static final byte[] Px1 = new byte[]{-19, -100, -27, -126, 52, -26, 26, 83, -58, -123, -42, 77, 81, -48, 35, 107, -61, -75, -44, -71};
    public static final byte[] Py1 = new byte[]{4, -99, -15, -96, 117, -64, -32, 79, -77, 68, -123, -117, 97, -73, -101, 105, -90, 61, 44, 57};
    private static int g_fuse90;
    private static int g_fuse94;
    private static final AES.AES_ctx aes_kirk1;
    private static final byte[] PRNG_DATA;
    private static boolean is_kirk_initialized;
    private static final boolean noRandomData = false;

    public static int kirk_init(long fuseId) {
        if (Utilities.log.isDebugEnabled()) {
            Utilities.log.debug((Object)String.format("kirk_init fuseId=0x%X", fuseId));
        }
        AES.init();
        return KirkEngine.kirk_init2("Lazy Dev should have initialized!".getBytes(), 33, (int)fuseId, (int)(fuseId >> 32));
    }

    private static int kirk_init2(byte[] rnd_seed, int seed_size, int fuseid_90, int fuseid_94) {
        byte[] temp = new byte[260];
        KIRK_SHA1_HEADER header = new KIRK_SHA1_HEADER();
        byte[] key = new byte[]{7, -85, -17, -8, -106, -116, -13, -42, 20, -32, -21, -78, -99, -117, 78, 116};
        if (seed_size > 0) {
            byte[] seedbuf = new byte[seed_size + 4];
            KIRK_SHA1_HEADER seedheader = new KIRK_SHA1_HEADER();
            seedheader.data_size = seed_size;
            seedheader.write(seedbuf, 0);
            Utilities.memcpy(seedbuf, 4, rnd_seed, seed_size);
            KirkEngine.kirk_CMD11(PRNG_DATA, seedbuf, seed_size + 4);
        }
        Utilities.memcpy(temp, 4, PRNG_DATA, 20);
        Utilities.write32(temp, 24, Utilities.curtime());
        Utilities.memcpy(temp, 28, key, 16);
        header.data_size = 256;
        header.write(temp, 0);
        KirkEngine.kirk_CMD11(PRNG_DATA, temp, 260);
        g_fuse90 = fuseid_90;
        g_fuse94 = fuseid_94;
        AES.AES_set_key(aes_kirk1, kirk1_key, 128);
        is_kirk_initialized = true;
        return 0;
    }

    private static byte[] kirk_4_7_get_key(int key_type) {
        if (key_type < 0 || key_type >= KeyVault.keyvault.length) {
            return null;
        }
        byte[] key = new byte[16];
        int[] intKey = KeyVault.keyvault[key_type];
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)intKey[i];
        }
        return key;
    }

    public static int kirk_CMD0(byte[] outbuff, byte[] inbuff, int size, boolean generate_trash) {
        return KirkEngine.kirk_CMD0(outbuff, 0, inbuff, 0, size, generate_trash);
    }

    public static int kirk_CMD0(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size, boolean generate_trash) {
        int chk_size;
        KIRK_CMD1_HEADER header = new KIRK_CMD1_HEADER();
        header_keys keys = new header_keys();
        AES.AES_ctx k1 = new AES.AES_ctx();
        AES.AES_ctx cmac_key = new AES.AES_ctx();
        byte[] cmac_header_hash = new byte[16];
        byte[] cmac_data_hash = new byte[16];
        if (!is_kirk_initialized) {
            return 12;
        }
        Utilities.memcpy(outbuff, outoffset, inbuff, inoffset, size);
        header.read(outbuff, outoffset);
        keys.read(outbuff, outoffset);
        if (header.mode != 1) {
            return 2;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_ENCRYPT_PRIVATE) %s", 0, header));
        }
        if (generate_trash) {
            KirkEngine.kirk_CMD14(outbuff, outoffset + 144, header.data_offset);
        }
        if ((chk_size = header.data_size) % 16 != 0) {
            chk_size += 16 - chk_size % 16;
        }
        AES.AES_set_key(k1, keys.AES, 128);
        AES.AES_cbc_encrypt(k1, inbuff, inoffset + 144 + header.data_offset, outbuff, outoffset + 144 + header.data_offset, chk_size);
        AES.AES_set_key(cmac_key, keys.CMAC, 128);
        AES.AES_CMAC(cmac_key, outbuff, outoffset + 96, 48, cmac_header_hash);
        AES.AES_CMAC(cmac_key, outbuff, outoffset + 96, 48 + chk_size + header.data_offset, cmac_data_hash);
        Utilities.memcpy(header.CMAC_header_hash, cmac_header_hash, 16);
        Utilities.memcpy(header.CMAC_data_hash, cmac_data_hash, 16);
        AES.AES_cbc_encrypt(aes_kirk1, inbuff, outbuff, 32);
        return 0;
    }

    public static int kirk_CMD1(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD1(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD1(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_CMD1_HEADER header = new KIRK_CMD1_HEADER(inbuff, inoffset);
        header_keys keys = new header_keys();
        AES.AES_ctx k1 = new AES.AES_ctx();
        if (size < 144) {
            return 15;
        }
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 1) {
            return 2;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_DECRYPT_PRIVATE) %s", 1, header));
        }
        AES.AES_cbc_decrypt(aes_kirk1, inbuff, inoffset, keys, 32);
        if (header.ecdsa_hash == 1) {
            SHA1.SHA_CTX sha = new SHA1.SHA_CTX();
            KIRK_CMD1_ECDSA_HEADER eheader = new KIRK_CMD1_ECDSA_HEADER(inbuff, inoffset);
            byte[] kirk1_pub = new byte[40];
            byte[] header_hash = new byte[20];
            byte[] data_hash = new byte[20];
            EC.ecdsa_set_curve(ec_p, ec_a, ec_b1, ec_N1, Gx1, Gy1);
            Utilities.memcpy(kirk1_pub, Px1, 20);
            Utilities.memcpy(kirk1_pub, 20, Py1, 20);
            EC.ecdsa_set_pub(kirk1_pub);
            SHA1.SHAInit(sha);
            SHA1.SHAUpdate(sha, inbuff, inoffset + 96, 48);
            SHA1.SHAFinal(header_hash, sha);
            if (!EC.ecdsa_verify(header_hash, eheader.header_sig_r, eheader.header_sig_s)) {
                return 3;
            }
            SHA1.SHAInit(sha);
            SHA1.SHAUpdate(sha, inbuff, inoffset + 96, size - 96);
            SHA1.SHAFinal(data_hash, sha);
            if (!EC.ecdsa_verify(data_hash, eheader.data_sig_r, eheader.data_sig_s)) {
                return 4;
            }
        } else {
            int ret = KirkEngine.kirk_CMD10(inbuff, inoffset, size);
            if (ret != 0 && Utilities.log.isDebugEnabled()) {
                Utilities.log.debug((Object)String.format("Kirk KIRK_CMD_DECRYPT_PRIVATE ignoring that CMAC hashes were not matching (ret=0x%X)", ret));
            }
        }
        AES.AES_set_key(k1, keys.AES, 128);
        AES.AES_cbc_decrypt(k1, inbuff, inoffset + 144 + header.data_offset, outbuff, outoffset, header.data_size);
        return 0;
    }

    public static int kirk_CMD2(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD2(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD2(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_CMD1_HEADER header = new KIRK_CMD1_HEADER(inbuff, inoffset);
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 1 && header.mode != 2 && header.mode != 3) {
            return 2;
        }
        if (header.data_size == 0) {
            return 16;
        }
        Utilities.log.warn((Object)String.format("Kirk unimplemented cmd=0x%X(KIRK_CMD_ENCRYPT_SIGN) %s: %s", 2, header, jpcsp.util.Utilities.getMemoryDump(inbuff, inoffset + 144 + header.data_offset, header.data_size)));
        int ret = KirkEngine.kirk_CMD10(inbuff, inoffset, size);
        if (ret != 0 && Utilities.log.isDebugEnabled()) {
            Utilities.log.debug((Object)String.format("Kirk KIRK_CMD_ENCRYPT_SIGN ignoring that CMAC hashes were not matching (ret=0x%X)", ret));
        }
        header.mode = 3;
        header.write(outbuff, outoffset);
        Utilities.memcpy(outbuff, outoffset + 144 + header.data_offset, inbuff, inoffset + 144 + header.data_offset, header.data_size);
        return 0;
    }

    public static int kirk_CMD3(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD3(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD3(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_CMD1_HEADER header = new KIRK_CMD1_HEADER(inbuff, inoffset);
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 1 && header.mode != 2 && header.mode != 3) {
            return 2;
        }
        if (header.data_size == 0) {
            return 16;
        }
        Utilities.log.warn((Object)String.format("Kirk unimplemented cmd=0x%X(KIRK_CMD_DECRYPT_SIGN) %s: %s", 3, header, jpcsp.util.Utilities.getMemoryDump(inbuff, inoffset + 144 + header.data_offset, header.data_size)));
        int ret = KirkEngine.kirk_CMD10(inbuff, inoffset, size);
        if (ret != 0 && Utilities.log.isDebugEnabled()) {
            Utilities.log.debug((Object)String.format("Kirk KIRK_CMD_DECRYPT_SIGN ignoring that CMAC hashes were not matching (ret=0x%X)", ret));
        }
        Utilities.memcpy(outbuff, outoffset, inbuff, inoffset + 144 + header.data_offset, header.data_size);
        return 0;
    }

    public static int kirk_CMD4(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD4(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD4(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_AES128CBC_HEADER header = new KIRK_AES128CBC_HEADER(inbuff, inoffset);
        AES.AES_ctx aesKey = new AES.AES_ctx();
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 4) {
            return 2;
        }
        if (header.data_size == 0) {
            return 16;
        }
        byte[] key = KirkEngine.kirk_4_7_get_key(header.keyseed);
        if (key == null) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_ENCRYPT_IV_0) %s", 4, header));
        }
        AES.AES_set_key(aesKey, key, 128);
        AES.AES_cbc_encrypt(aesKey, inbuff, inoffset + 20, outbuff, outoffset + 20, header.data_size);
        header.mode = 5;
        header.write(outbuff, outoffset);
        return 0;
    }

    public static int kirk_CMD5(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD5(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD5(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_AES128CBC_HEADER header = new KIRK_AES128CBC_HEADER(inbuff, inoffset);
        AES.AES_ctx aesKey = new AES.AES_ctx();
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 4) {
            return 2;
        }
        if (header.data_size == 0) {
            return 16;
        }
        byte[] key = null;
        if (header.keyseed == 256) {
            key = new byte[16];
        }
        if (key == null) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_ENCRYPT_IV_FUSE) %s", 5, header));
        }
        AES.AES_set_key(aesKey, key, 128);
        AES.AES_cbc_encrypt(aesKey, inbuff, inoffset + 20, outbuff, outoffset + 20, header.data_size);
        return 0;
    }

    public static int kirk_CMD7(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD7(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD7(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_AES128CBC_HEADER header = new KIRK_AES128CBC_HEADER(inbuff, inoffset);
        AES.AES_ctx aesKey = new AES.AES_ctx();
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 5) {
            return 2;
        }
        if (header.data_size == 0) {
            return 16;
        }
        byte[] key = KirkEngine.kirk_4_7_get_key(header.keyseed);
        if (key == null) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_DECRYPT_IV_0) %s", 7, header));
        }
        AES.AES_set_key(aesKey, key, 128);
        AES.AES_cbc_decrypt(aesKey, inbuff, inoffset + 20, outbuff, outoffset, header.data_size);
        return 0;
    }

    public static int kirk_CMD8(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD8(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD8(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_AES128CBC_HEADER header = new KIRK_AES128CBC_HEADER(inbuff, inoffset);
        AES.AES_ctx aesKey = new AES.AES_ctx();
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 5) {
            return 2;
        }
        if (header.data_size == 0) {
            return 16;
        }
        byte[] key = null;
        if (header.keyseed == 256) {
            key = new byte[16];
        }
        if (key == null) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_DECRYPT_IV_FUSE) %s", 8, header));
        }
        AES.AES_set_key(aesKey, key, 128);
        AES.AES_cbc_decrypt(aesKey, inbuff, inoffset + 20, outbuff, outoffset, header.data_size);
        return 0;
    }

    public static int kirk_CMD10(byte[] inbuff, int insize) {
        return KirkEngine.kirk_CMD10(inbuff, 0, insize);
    }

    public static int kirk_CMD10(byte[] inbuff, int inoffset, int insize) {
        KIRK_CMD1_HEADER header = new KIRK_CMD1_HEADER(inbuff, inoffset);
        header_keys keys = new header_keys();
        byte[] cmac_header_hash = new byte[16];
        byte[] cmac_data_hash = new byte[16];
        AES.AES_ctx cmac_key = new AES.AES_ctx();
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.mode != 1 && header.mode != 2 && header.mode != 3) {
            return 2;
        }
        if (header.data_size == 0) {
            return 16;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_PRIV_SIGN_CHECK) %s", 10, header));
        }
        if (header.mode == 1) {
            AES.AES_cbc_decrypt(aes_kirk1, inbuff, inoffset, keys, 32);
            AES.AES_set_key(cmac_key, keys.CMAC, 128);
            AES.AES_CMAC(cmac_key, inbuff, inoffset + 96, 48, cmac_header_hash);
            int chk_size = Utilities.alignUp(header.data_size, 15);
            AES.AES_CMAC(cmac_key, inbuff, inoffset + 96, 48 + chk_size + header.data_offset, cmac_data_hash);
            if (Utilities.memcmp(cmac_header_hash, header.CMAC_header_hash, 16) != 0) {
                return 3;
            }
            if (Utilities.memcmp(cmac_data_hash, header.CMAC_data_hash, 16) != 0) {
                return 4;
            }
            return 0;
        }
        Utilities.log.warn((Object)String.format("KIRK_MODE_CMD%d not implemented: %s", header.mode, header));
        return 5;
    }

    public static int kirk_CMD11(byte[] outbuff, byte[] inbuff, int size) {
        return KirkEngine.kirk_CMD11(outbuff, 0, inbuff, 0, size);
    }

    public static int kirk_CMD11(byte[] outbuff, int outoffset, byte[] inbuff, int inoffset, int size) {
        KIRK_SHA1_HEADER header = new KIRK_SHA1_HEADER(inbuff, inoffset);
        SHA1.SHA_CTX sha = new SHA1.SHA_CTX();
        if (!is_kirk_initialized) {
            return 12;
        }
        if (header.data_size == 0 || size == 0) {
            return 16;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_SHA1_HASH) %s", 11, header));
        }
        SHA1.SHAInit(sha);
        SHA1.SHAUpdate(sha, inbuff, 4, header.data_size);
        SHA1.SHAFinal(outbuff, outoffset, sha);
        return 0;
    }

    public static int kirk_CMD12(byte[] outbuff, int outsize) {
        return KirkEngine.kirk_CMD12(outbuff, 0, outsize);
    }

    public static int kirk_CMD12(byte[] outbuff, int outoffset, int outsize) {
        byte[] k = new byte[21];
        KIRK_CMD12_BUFFER keypair = new KIRK_CMD12_BUFFER();
        if (outsize != 60) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_ECDSA_GEN_KEYS)", 12));
        }
        EC.ecdsa_set_curve(ec_p, ec_a, ec_b2, ec_N2, Gx2, Gy2);
        KirkEngine.kirk_CMD14(k, 1, 20);
        EC.ec_priv_to_pub(k, keypair.public_key);
        Utilities.memcpy(keypair.private_key, k, 1, 20);
        keypair.write(outbuff, outoffset);
        return 0;
    }

    public static int kirk_CMD13(byte[] outbuff, int outsize, byte[] inbuff, int insize) {
        return KirkEngine.kirk_CMD13(outbuff, 0, outsize, inbuff, 0, insize);
    }

    public static int kirk_CMD13(byte[] outbuff, int outoffset, int outsize, byte[] inbuff, int inoffset, int insize) {
        byte[] k = new byte[21];
        KIRK_CMD13_BUFFER pointmult = new KIRK_CMD13_BUFFER(inbuff, inoffset);
        if (outsize != 40 && outsize != 60) {
            return 15;
        }
        if (insize != 60) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_ECDSA_MULTIPLY_POINT) %s", 13, pointmult));
        }
        EC.ecdsa_set_curve(ec_p, ec_a, ec_b2, ec_N2, Gx2, Gy2);
        EC.ecdsa_set_pub(pointmult.public_key);
        Utilities.memcpy(k, 1, pointmult.multiplier, 20);
        EC.ec_pub_mult(k, outbuff, outoffset);
        return 0;
    }

    public static int kirk_CMD14(byte[] outbuff, int outsize) {
        return KirkEngine.kirk_CMD14(outbuff, 0, outsize);
    }

    public static int kirk_CMD14(byte[] outbuff, int outoffset, int outsize) {
        byte[] temp = new byte[260];
        KIRK_SHA1_HEADER header = new KIRK_SHA1_HEADER();
        byte[] key = new byte[]{-89, 46, 76, -74, -61, 52, -33, -123, 112, 1, 73, -4, -64, -121, -60, 119};
        if (outsize <= 0) {
            return 0;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_PRNG)", 14));
        }
        Utilities.memcpy(temp, 4, PRNG_DATA, 20);
        Utilities.write32(temp, 24, Utilities.curtime());
        Utilities.memcpy(temp, 28, key, 16);
        header.data_size = 256;
        header.write(temp, 0);
        KirkEngine.kirk_CMD11(PRNG_DATA, temp, 260);
        while (outsize != 0) {
            int blockrem = outsize % 20;
            int block = outsize / 20;
            if (block != 0) {
                Utilities.memcpy(outbuff, outoffset, PRNG_DATA, 20);
                KirkEngine.kirk_CMD14(outbuff, outoffset += 20, outsize -= 20);
                continue;
            }
            if (blockrem == 0) continue;
            Utilities.memcpy(outbuff, outoffset, PRNG_DATA, blockrem);
            outsize -= blockrem;
        }
        return 0;
    }

    public static int kirk_CMD15(byte[] outbuff, int outsize, byte[] inbuff, int insize) {
        return KirkEngine.kirk_CMD15(outbuff, 0, outsize, inbuff, 0, insize);
    }

    public static int kirk_CMD15(byte[] outbuff, int outoffset, int outsize, byte[] inbuff, int inoffset, int insize) {
        if (outsize != 28 || insize < 8) {
            return 0;
        }
        long input = jpcsp.util.Utilities.endianSwap64(Utilities.read64(inbuff, inoffset));
        long output = input + 1L;
        outoffset = Utilities.write64(outbuff, outoffset, output);
        outoffset = Utilities.write32(outbuff, outoffset, 305419896);
        outoffset = Utilities.write32(outbuff, outoffset, 305419896);
        outoffset = Utilities.write32(outbuff, outoffset, 305419896);
        outoffset = Utilities.write32(outbuff, outoffset, 305419896);
        outoffset = Utilities.write32(outbuff, outoffset, 305419896);
        return 0;
    }

    public static void decrypt_kirk16_private(byte[] dA_out, byte[] dA_enc) {
        KirkEngine.decrypt_kirk16_private(dA_out, 0, dA_enc, 0);
    }

    public static void decrypt_kirk16_private(byte[] dA_out, int dA_outoffset, byte[] dA_enc, int dA_encoffset) {
        int i;
        kirk16_data keydata = new kirk16_data();
        byte[] subkey_1 = new byte[16];
        byte[] subkey_2 = new byte[16];
        AES.AES_ctx aes_ctx = new AES.AES_ctx();
        keydata.fuseid[7] = (byte)(g_fuse90 & 0xFF);
        keydata.fuseid[6] = (byte)(g_fuse90 >> 8 & 0xFF);
        keydata.fuseid[5] = (byte)(g_fuse90 >> 16 & 0xFF);
        keydata.fuseid[4] = (byte)(g_fuse90 >> 24 & 0xFF);
        keydata.fuseid[3] = (byte)(g_fuse94 & 0xFF);
        keydata.fuseid[2] = (byte)(g_fuse94 >> 8 & 0xFF);
        keydata.fuseid[1] = (byte)(g_fuse94 >> 16 & 0xFF);
        keydata.fuseid[0] = (byte)(g_fuse94 >> 24 & 0xFF);
        AES.rijndael_set_key(aes_ctx, kirk16_key, 128);
        for (i = 0; i < 16; ++i) {
            subkey_2[i] = subkey_1[i] = keydata.fuseid[i % 8];
        }
        for (i = 0; i < 3; ++i) {
            AES.rijndael_encrypt(aes_ctx, subkey_1, subkey_1);
            AES.rijndael_decrypt(aes_ctx, subkey_2, subkey_2);
        }
        AES.rijndael_set_key(aes_ctx, subkey_1, 128);
        for (i = 0; i < 3; ++i) {
            for (int k = 0; k < 3; ++k) {
                AES.rijndael_encrypt(aes_ctx, subkey_2, subkey_2);
            }
            Utilities.memcpy(keydata.mesh, i * 16, subkey_2, 16);
        }
        AES.rijndael_set_key(aes_ctx, keydata.mesh, 32, 128);
        for (i = 0; i < 2; ++i) {
            AES.rijndael_encrypt(aes_ctx, keydata.mesh, 16, keydata.mesh, 16);
        }
        AES.rijndael_set_key(aes_ctx, keydata.mesh, 16, 128);
        AES.AES_cbc_decrypt(aes_ctx, dA_enc, dA_encoffset, dA_out, dA_outoffset, 32);
    }

    public static void encrypt_kirk16_private(byte[] dA_out, byte[] dA_dec) {
        KirkEngine.encrypt_kirk16_private(dA_out, 0, dA_dec, 0);
    }

    public static void encrypt_kirk16_private(byte[] dA_out, int dA_outoffset, byte[] dA_dec, int dA_decoffset) {
        int i;
        kirk16_data keydata = new kirk16_data();
        byte[] subkey_1 = new byte[16];
        byte[] subkey_2 = new byte[16];
        AES.AES_ctx aes_ctx = new AES.AES_ctx();
        keydata.fuseid[7] = (byte)(g_fuse90 & 0xFF);
        keydata.fuseid[6] = (byte)(g_fuse90 >> 8 & 0xFF);
        keydata.fuseid[5] = (byte)(g_fuse90 >> 16 & 0xFF);
        keydata.fuseid[4] = (byte)(g_fuse90 >> 24 & 0xFF);
        keydata.fuseid[3] = (byte)(g_fuse94 & 0xFF);
        keydata.fuseid[2] = (byte)(g_fuse94 >> 8 & 0xFF);
        keydata.fuseid[1] = (byte)(g_fuse94 >> 16 & 0xFF);
        keydata.fuseid[0] = (byte)(g_fuse94 >> 24 & 0xFF);
        AES.rijndael_set_key(aes_ctx, kirk16_key, 128);
        for (i = 0; i < 16; ++i) {
            subkey_2[i] = subkey_1[i] = keydata.fuseid[i % 8];
        }
        for (i = 0; i < 3; ++i) {
            AES.rijndael_encrypt(aes_ctx, subkey_1, subkey_1);
            AES.rijndael_decrypt(aes_ctx, subkey_2, subkey_2);
        }
        AES.rijndael_set_key(aes_ctx, subkey_1, 128);
        for (i = 0; i < 3; ++i) {
            for (int k = 0; k < 3; ++k) {
                AES.rijndael_encrypt(aes_ctx, subkey_2, subkey_2);
            }
            Utilities.memcpy(keydata.mesh, i * 16, subkey_2, 16);
        }
        AES.rijndael_set_key(aes_ctx, keydata.mesh, 32, 128);
        for (i = 0; i < 2; ++i) {
            AES.rijndael_encrypt(aes_ctx, keydata.mesh, 16, keydata.mesh, 16);
        }
        AES.rijndael_set_key(aes_ctx, keydata.mesh, 16, 128);
        AES.AES_cbc_encrypt(aes_ctx, dA_dec, dA_decoffset, dA_out, dA_outoffset, 32);
    }

    public static int kirk_CMD16(byte[] outbuff, int outsize, byte[] inbuff, int insize) {
        return KirkEngine.kirk_CMD16(outbuff, 0, outsize, inbuff, 0, insize);
    }

    public static int kirk_CMD16(byte[] outbuff, int outoffset, int outsize, byte[] inbuff, int inoffset, int insize) {
        byte[] dec_private = new byte[32];
        KIRK_CMD16_BUFFER signbuf = new KIRK_CMD16_BUFFER(inbuff, inoffset);
        ECDSA_SIG sig = new ECDSA_SIG();
        if (insize != 52) {
            return 15;
        }
        if (outsize != 40 && outsize != 52) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_ECDSA_SIGN) %s", 16, signbuf));
        }
        KirkEngine.decrypt_kirk16_private(dec_private, signbuf.enc_private);
        Utilities.memset(dec_private, 20, 0, 12);
        EC.ecdsa_set_curve(ec_p, ec_a, ec_b2, ec_N2, Gx2, Gy2);
        EC.ecdsa_set_priv(dec_private);
        EC.ecdsa_sign(signbuf.message_hash, sig.r, sig.s);
        sig.write(outbuff, outoffset);
        return 0;
    }

    public static int kirk_CMD17(byte[] inbuff, int insize) {
        return KirkEngine.kirk_CMD17(inbuff, 0, insize);
    }

    public static int kirk_CMD17(byte[] inbuff, int inoffset, int insize) {
        KIRK_CMD17_BUFFER sig = new KIRK_CMD17_BUFFER(inbuff, inoffset);
        if (insize != 100) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_ECDSA_VERIFY) %s", 17, sig));
        }
        EC.ecdsa_set_curve(ec_p, ec_a, ec_b2, ec_N2, Gx2, Gy2);
        EC.ecdsa_set_pub(sig.public_key);
        if (EC.ecdsa_verify(sig.message_hash, sig.signature.r, sig.signature.s)) {
            return 0;
        }
        return 5;
    }

    public static int kirk_CMD18(byte[] inbuff, int insize) {
        return KirkEngine.kirk_CMD18(inbuff, 0, insize);
    }

    public static int kirk_CMD18(byte[] inbuff, int inoffset, int insize) {
        if (insize != 184) {
            return 15;
        }
        if (Utilities.log.isTraceEnabled()) {
            Utilities.log.trace((Object)String.format("Kirk cmd=0x%X(KIRK_CMD_CERT_VERIFY) %s", 18, Utilities.toString(inbuff, inoffset, insize)));
        }
        return 0;
    }

    public static int sceUtilsBufferCopyWithRange(byte[] outbuff, int outsize, byte[] inbuff, int insize, int cmd) {
        return KirkEngine.sceUtilsBufferCopyWithRange(outbuff, 0, outsize, inbuff, 0, insize, cmd);
    }

    public static int sceUtilsBufferCopyWithRange(byte[] outbuff, int outoffset, int outsize, byte[] inbuff, int inoffset, int insize, int cmd) {
        switch (cmd) {
            case 0: {
                return KirkEngine.kirk_CMD0(outbuff, outoffset, inbuff, inoffset, insize, true);
            }
            case 1: {
                return KirkEngine.kirk_CMD1(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 2: {
                return KirkEngine.kirk_CMD2(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 3: {
                return KirkEngine.kirk_CMD3(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 4: {
                return KirkEngine.kirk_CMD4(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 5: {
                return KirkEngine.kirk_CMD5(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 7: {
                return KirkEngine.kirk_CMD7(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 8: {
                return KirkEngine.kirk_CMD8(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 10: {
                return KirkEngine.kirk_CMD10(inbuff, inoffset, insize);
            }
            case 11: {
                return KirkEngine.kirk_CMD11(outbuff, outoffset, inbuff, inoffset, insize);
            }
            case 12: {
                return KirkEngine.kirk_CMD12(outbuff, outoffset, outsize);
            }
            case 13: {
                return KirkEngine.kirk_CMD13(outbuff, outoffset, outsize, inbuff, inoffset, insize);
            }
            case 14: {
                return KirkEngine.kirk_CMD14(outbuff, outoffset, outsize);
            }
            case 15: {
                return KirkEngine.kirk_CMD15(outbuff, outoffset, outsize, inbuff, inoffset, insize);
            }
            case 16: {
                return KirkEngine.kirk_CMD16(outbuff, outoffset, outsize, inbuff, inoffset, insize);
            }
            case 17: {
                return KirkEngine.kirk_CMD17(inbuff, inoffset, insize);
            }
            case 18: {
                return KirkEngine.kirk_CMD18(inbuff, inoffset, insize);
            }
        }
        Utilities.log.error((Object)String.format("sceUtilsBufferCopyWithRange unimplemented Kirk cmd=0x%X", cmd));
        return -1;
    }

    static {
        aes_kirk1 = new AES.AES_ctx();
        PRNG_DATA = new byte[20];
    }

    public static class header_keys {
        public static final int SIZEOF = 32;
        public final byte[] AES = new byte[16];
        public final byte[] CMAC = new byte[16];

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.AES);
            offset = Utilities.read(buffer, offset, this.CMAC);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.AES);
            offset = Utilities.write(buffer, offset, this.CMAC);
            return offset;
        }

        public String toString() {
            return String.format("AES=%s, CMAC=%s", Utilities.toString(this.AES), Utilities.toString(this.CMAC));
        }
    }

    public static class kirk16_data {
        public final byte[] fuseid = new byte[8];
        public final byte[] mesh = new byte[64];

        public String toString() {
            return String.format("fuseid=%s, mesh=%s", Utilities.toString(this.fuseid), Utilities.toString(this.mesh));
        }
    }

    public static class KIRK_CMD17_BUFFER {
        public static final int SIZEOF = 100;
        public final ECDSA_POINT public_key = new ECDSA_POINT();
        public final byte[] message_hash = new byte[20];
        public final ECDSA_SIG signature = new ECDSA_SIG();

        public KIRK_CMD17_BUFFER(byte[] buffer, int offset) {
            this.read(buffer, offset);
        }

        public int read(byte[] buffer, int offset) {
            offset = this.public_key.read(buffer, offset);
            offset = Utilities.read(buffer, offset, this.message_hash);
            offset = this.signature.read(buffer, offset);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = this.public_key.write(buffer, offset);
            offset = Utilities.write(buffer, offset, this.message_hash);
            offset = this.signature.read(buffer, offset);
            return offset;
        }

        public String toString() {
            return String.format("public_key=[%s], message_hash=%s, signature=[%s]", this.public_key, Utilities.toString(this.message_hash), this.signature);
        }
    }

    public static class KIRK_CMD16_BUFFER {
        public static final int SIZEOF = 52;
        public final byte[] enc_private = new byte[32];
        public final byte[] message_hash = new byte[20];

        public KIRK_CMD16_BUFFER(byte[] buffer, int offset) {
            this.read(buffer, offset);
        }

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.enc_private);
            offset = Utilities.read(buffer, offset, this.message_hash);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.enc_private);
            offset = Utilities.write(buffer, offset, this.message_hash);
            return offset;
        }

        public String toString() {
            return String.format("enc_private=%s, message_hash=%s", Utilities.toString(this.enc_private), Utilities.toString(this.message_hash));
        }
    }

    public static class KIRK_CMD13_BUFFER {
        public static final int SIZEOF = 60;
        public final byte[] multiplier = new byte[20];
        public final ECDSA_POINT public_key = new ECDSA_POINT();

        public KIRK_CMD13_BUFFER(byte[] buffer, int offset) {
            this.read(buffer, offset);
        }

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.multiplier);
            offset = this.public_key.read(buffer, offset);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.multiplier);
            offset = this.public_key.write(buffer, offset);
            return offset;
        }

        public String toString() {
            return String.format("multiplier=%s, public_key=[%s]", Utilities.toString(this.multiplier), this.public_key);
        }
    }

    public static class KIRK_SHA1_HEADER {
        public static final int SIZEOF = 4;
        public int data_size;

        public KIRK_SHA1_HEADER() {
        }

        public KIRK_SHA1_HEADER(byte[] buffer, int offset) {
            this.read(buffer, offset);
        }

        public int read(byte[] buffer, int offset) {
            this.data_size = Utilities.read32(buffer, offset);
            return offset += 4;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write32(buffer, offset, this.data_size);
            return offset;
        }

        public String toString() {
            return String.format("data_size=0x%X", this.data_size);
        }
    }

    public static class KIRK_CMD12_BUFFER {
        public static final int SIZEOF = 60;
        public final byte[] private_key = new byte[20];
        public final ECDSA_POINT public_key = new ECDSA_POINT();

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.private_key);
            offset = this.public_key.read(buffer, offset);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.private_key);
            offset = this.public_key.write(buffer, offset);
            return offset;
        }

        public String toString() {
            return String.format("private_key=%s, public_key=[%s]", Utilities.toString(this.private_key), this.public_key);
        }
    }

    public static class KIRK_AES128CBC_HEADER {
        public static final int SIZEOF = 20;
        public int mode;
        public int unk_4;
        public int unk_8;
        public int keyseed;
        public int data_size;

        public KIRK_AES128CBC_HEADER(byte[] buffer, int offset) {
            this.read(buffer, offset);
        }

        public int read(byte[] buffer, int offset) {
            this.mode = Utilities.read32(buffer, offset);
            this.unk_4 = Utilities.read32(buffer, offset += 4);
            this.unk_8 = Utilities.read32(buffer, offset += 4);
            this.keyseed = Utilities.read32(buffer, offset += 4);
            this.data_size = Utilities.read32(buffer, offset += 4);
            return offset += 4;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write32(buffer, offset, this.mode);
            offset = Utilities.write32(buffer, offset, this.unk_4);
            offset = Utilities.write32(buffer, offset, this.unk_8);
            offset = Utilities.write32(buffer, offset, this.keyseed);
            offset = Utilities.write32(buffer, offset, this.data_size);
            return offset;
        }

        public String toString() {
            return String.format("mode=0x%X, unk_4=0x%X, unk_8=0x%X, keyseed=0x%02X, data_size=0x%X", this.mode, this.unk_4, this.unk_8, this.keyseed, this.data_size);
        }
    }

    public static class KIRK_CMD1_ECDSA_HEADER {
        public static final int SIZEOF = 144;
        public final byte[] AES_key = new byte[16];
        public final byte[] header_sig_r = new byte[20];
        public final byte[] header_sig_s = new byte[20];
        public final byte[] data_sig_r = new byte[20];
        public final byte[] data_sig_s = new byte[32];
        public int mode;
        public int ecdsa_hash;
        public final byte[] unk3 = new byte[11];
        public int data_size;
        public int data_offset;
        public final byte[] unk4 = new byte[8];
        public final byte[] unk5 = new byte[16];

        public KIRK_CMD1_ECDSA_HEADER() {
        }

        public KIRK_CMD1_ECDSA_HEADER(byte[] buffer, int offset) {
            this.read(buffer, offset);
        }

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.AES_key);
            offset = Utilities.read(buffer, offset, this.header_sig_r);
            offset = Utilities.read(buffer, offset, this.header_sig_s);
            offset = Utilities.read(buffer, offset, this.data_sig_r);
            offset = Utilities.read(buffer, offset, this.data_sig_s);
            this.mode = Utilities.read32(buffer, offset);
            this.ecdsa_hash = Utilities.read8(buffer, offset += 4);
            ++offset;
            offset = Utilities.read(buffer, offset, this.unk3);
            this.data_size = Utilities.read32(buffer, offset);
            this.data_offset = Utilities.read32(buffer, offset += 4);
            offset += 4;
            offset = Utilities.read(buffer, offset, this.unk4);
            offset = Utilities.read(buffer, offset, this.unk5);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.AES_key);
            offset = Utilities.write(buffer, offset, this.header_sig_r);
            offset = Utilities.write(buffer, offset, this.header_sig_s);
            offset = Utilities.write(buffer, offset, this.data_sig_r);
            offset = Utilities.write(buffer, offset, this.data_sig_s);
            offset = Utilities.write32(buffer, offset, this.mode);
            offset = Utilities.write8(buffer, offset, this.ecdsa_hash);
            offset = Utilities.write(buffer, offset, this.unk3);
            offset = Utilities.write32(buffer, offset, this.data_size);
            offset = Utilities.write32(buffer, offset, this.data_offset);
            offset = Utilities.write(buffer, offset, this.unk4);
            offset = Utilities.write(buffer, offset, this.unk5);
            return offset;
        }

        public String toString() {
            return String.format("AES_key=%s, header_sig_r=%s, header_sig_s=%s, data_sig_r=%s, data_sig_s=%s, mode = 0x%X, ecdsa_hash = 0x%X, unk3=%s, data_size = 0x%X, data_offset = 0x%X, unk4=%s, unk5=%s", Utilities.toString(this.AES_key), Utilities.toString(this.header_sig_r), Utilities.toString(this.header_sig_s), Utilities.toString(this.data_sig_r), Utilities.toString(this.data_sig_s), this.mode, this.ecdsa_hash, Utilities.toString(this.unk3), this.data_size, this.data_offset, Utilities.toString(this.unk4), Utilities.toString(this.unk5));
        }
    }

    public static class KIRK_CMD1_HEADER {
        public static final int SIZEOF = 144;
        public final byte[] AES_key = new byte[16];
        public final byte[] CMAC_key = new byte[16];
        public final byte[] CMAC_header_hash = new byte[16];
        public final byte[] CMAC_data_hash = new byte[16];
        public final byte[] unused = new byte[32];
        public int mode;
        public int ecdsa_hash;
        public final byte[] unk3 = new byte[11];
        public int data_size;
        public int data_offset;
        public final byte[] unk4 = new byte[8];
        public final byte[] unk5 = new byte[16];

        public KIRK_CMD1_HEADER() {
        }

        public KIRK_CMD1_HEADER(byte[] buffer, int offset) {
            this.read(buffer, offset);
        }

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.AES_key);
            offset = Utilities.read(buffer, offset, this.CMAC_key);
            offset = Utilities.read(buffer, offset, this.CMAC_header_hash);
            offset = Utilities.read(buffer, offset, this.CMAC_data_hash);
            offset = Utilities.read(buffer, offset, this.unused);
            this.mode = Utilities.read32(buffer, offset);
            this.ecdsa_hash = Utilities.read8(buffer, offset += 4);
            ++offset;
            offset = Utilities.read(buffer, offset, this.unk3);
            this.data_size = Utilities.read32(buffer, offset);
            this.data_offset = Utilities.read32(buffer, offset += 4);
            offset += 4;
            offset = Utilities.read(buffer, offset, this.unk4);
            offset = Utilities.read(buffer, offset, this.unk5);
            if ((this.mode & 0xFFFFFF) == 0) {
                this.mode = Integer.reverseBytes(this.mode);
            }
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.AES_key);
            offset = Utilities.write(buffer, offset, this.CMAC_key);
            offset = Utilities.write(buffer, offset, this.CMAC_header_hash);
            offset = Utilities.write(buffer, offset, this.CMAC_data_hash);
            offset = Utilities.write(buffer, offset, this.unused);
            offset = Utilities.write32(buffer, offset, this.mode);
            offset = Utilities.write8(buffer, offset, this.ecdsa_hash);
            offset = Utilities.write(buffer, offset, this.unk3);
            offset = Utilities.write32(buffer, offset, this.data_size);
            offset = Utilities.write32(buffer, offset, this.data_offset);
            offset = Utilities.write(buffer, offset, this.unk4);
            offset = Utilities.write(buffer, offset, this.unk5);
            return offset;
        }

        public String toString() {
            return String.format("AES_key=%s, CMAC_key=%s, CMAC_header_hash=%s, CMAC_data_hash=%s, unused=%s, mode=%d, ecdsa_hash=%d, unk3=%s, data_size=0x%X, data_offset=0x%X, unk4=%s, unk5=%s", Utilities.toString(this.AES_key), Utilities.toString(this.CMAC_key), Utilities.toString(this.CMAC_header_hash), Utilities.toString(this.CMAC_data_hash), Utilities.toString(this.unused), this.mode, this.ecdsa_hash, Utilities.toString(this.unk3), this.data_size, this.data_offset, Utilities.toString(this.unk4), Utilities.toString(this.unk5));
        }
    }

    public static class ECDSA_POINT {
        public static final int SIZEOF = 40;
        public final byte[] x = new byte[20];
        public final byte[] y = new byte[20];

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.x);
            offset = Utilities.read(buffer, offset, this.y);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.x);
            offset = Utilities.write(buffer, offset, this.y);
            return offset;
        }

        public String toString() {
            return String.format("x=%s, y=%s", Utilities.toString(this.x), Utilities.toString(this.y));
        }
    }

    public static class ECDSA_SIG {
        public static final int SIZEOF = 40;
        public final byte[] r = new byte[20];
        public final byte[] s = new byte[20];

        public int read(byte[] buffer, int offset) {
            offset = Utilities.read(buffer, offset, this.r);
            offset = Utilities.read(buffer, offset, this.s);
            return offset;
        }

        public int write(byte[] buffer, int offset) {
            offset = Utilities.write(buffer, offset, this.r);
            offset = Utilities.write(buffer, offset, this.s);
            return offset;
        }

        public String toString() {
            return String.format("r=%s, s =%s", Utilities.toString(this.r), Utilities.toString(this.s));
        }
    }
}

