/*
 * Decompiled with CFR 0.152.
 */
package libkirk;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import libkirk.Utilities;

public class SHA1 {
    public static final int SHS_DIGESTSIZE = 20;

    public static void SHAInit(SHA_CTX shsInfo) {
        try {
            shsInfo.md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            Utilities.log.error((Object)"SHAInit", (Throwable)e);
        }
    }

    public static void SHAUpdate(SHA_CTX shsInfo, byte[] buffer, int count) {
        SHA1.SHAUpdate(shsInfo, buffer, 0, count);
    }

    public static void SHAUpdate(SHA_CTX shsInfo, byte[] buffer, int offset, int count) {
        shsInfo.md.update(buffer, offset, count);
    }

    public static void SHAFinal(byte[] output, SHA_CTX shsInfo) {
        SHA1.SHAFinal(output, 0, shsInfo);
    }

    public static void SHAFinal(byte[] output, int offset, SHA_CTX shsInfo) {
        byte[] digest = shsInfo.md.digest();
        System.arraycopy(digest, 0, output, offset, 20);
    }

    public static class SHA_CTX {
        public final int[] digest = new int[5];
        public int countLo;
        public int countHi;
        public final int[] data = new int[16];
        public int Endianness;
        private MessageDigest md;
    }
}

