/*
 * Decompiled with CFR 0.152.
 */
package io.nayuki.flac.decode;

import io.nayuki.flac.decode.AbstractFlacLowLevelInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;

public final class SeekableFileFlacInput
extends AbstractFlacLowLevelInput {
    private RandomAccessFile raf;

    public SeekableFileFlacInput(File file) throws IOException {
        Objects.requireNonNull(file);
        this.raf = new RandomAccessFile(file, "r");
    }

    @Override
    public long getLength() {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekTo(long pos) throws IOException {
        this.raf.seek(pos);
        this.positionChanged(pos);
    }

    @Override
    protected int readUnderlying(byte[] buf, int off, int len) throws IOException {
        return this.raf.read(buf, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
            super.close();
        }
    }
}

