/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.FpuState;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.VfpuState;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.CompilerClassLoader;
import jpcsp.Allegrex.compiler.CompilerLocalVarParameterReader;
import jpcsp.Allegrex.compiler.CompilerParameterReader;
import jpcsp.Allegrex.compiler.CompilerTypeInformation;
import jpcsp.Allegrex.compiler.CompilerTypeManager;
import jpcsp.Allegrex.compiler.ICompilerContext;
import jpcsp.Allegrex.compiler.IExecutable;
import jpcsp.Allegrex.compiler.Profiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Allegrex.compiler.SequenceSWCodeInstruction;
import jpcsp.Allegrex.compiler.StackPopException;
import jpcsp.Allegrex.compiler.VfpuPfxDstState;
import jpcsp.Allegrex.compiler.VfpuPfxSrcState;
import jpcsp.Allegrex.compiler.VfpuPfxState;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeInstruction;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeManager;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeSequence;
import jpcsp.Allegrex.compiler.nativeCode.Nop;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.DebugMemory;
import jpcsp.HLE.HLEModuleFunction;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.HLE.HLEUidClass;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TErrorPointer32;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.TPointer8;
import jpcsp.HLE.TPointerFunction;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules.reboot;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.Processor;
import jpcsp.State;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.FastMemory;
import jpcsp.memory.SafeFastMemory;
import jpcsp.util.ClassAnalyzer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CompilerContext
implements ICompilerContext {
    protected static Logger log = Compiler.log;
    private CompilerClassLoader classLoader;
    private CodeBlock codeBlock;
    private int numberInstructionsToBeSkipped;
    private boolean skipDelaySlot;
    private MethodVisitor mv;
    private CodeInstruction codeInstruction;
    private static final boolean storeCpuLocal = true;
    private static final boolean storeMemoryIntLocal = false;
    private static final int LOCAL_CPU = 0;
    private static final int LOCAL_INSTRUCTION_COUNT = 1;
    private static final int LOCAL_MEMORY_INT = 2;
    private static final int LOCAL_TMP1 = 3;
    private static final int LOCAL_TMP2 = 4;
    private static final int LOCAL_TMP3 = 5;
    private static final int LOCAL_TMP4 = 6;
    private static final int LOCAL_TMP_VD0 = 7;
    private static final int LOCAL_TMP_VD1 = 8;
    private static final int LOCAL_TMP_VD2 = 9;
    private static final int LOCAL_MAX = 10;
    private static final int LOCAL_FIRST_SAVED_PARAMETER = 10;
    private static final int LOCAL_NUMBER_SAVED_PARAMETERS = 8;
    private static final int LOCAL_MAX_WITH_SAVED_PARAMETERS = 18;
    private static final int DEFAULT_MAX_STACK_SIZE = 11;
    private static final int SYSCALL_MAX_STACK_SIZE = 100;
    private static final int LOCAL_ERROR_POINTER = 5;
    private boolean enableIntructionCounting = false;
    public Set<Integer> analysedAddresses = new HashSet<Integer>();
    public Stack<Integer> blocksToBeAnalysed = new Stack();
    private int currentInstructionCount;
    private int preparedRegisterForStore = -1;
    private boolean memWritePrepared = false;
    private boolean hiloPrepared = false;
    private int methodMaxInstructions;
    private NativeCodeManager nativeCodeManager;
    private final VfpuPfxSrcState vfpuPfxsState = new VfpuPfxSrcState();
    private final VfpuPfxSrcState vfpuPfxtState = new VfpuPfxSrcState();
    private final VfpuPfxDstState vfpuPfxdState = new VfpuPfxDstState();
    private Label interpretPfxLabel = null;
    private boolean pfxVdOverlap = false;
    public static final String runtimeContextInternalName = Type.getInternalName(RuntimeContext.class);
    public static final String runtimeContextLLEInternalName = Type.getInternalName(RuntimeContextLLE.class);
    private static final String processorDescriptor = Type.getDescriptor(Processor.class);
    private static final String cpuDescriptor = Type.getDescriptor(CpuState.class);
    private static final String cpuInternalName = Type.getInternalName(CpuState.class);
    private static final String instructionsInternalName = Type.getInternalName(Instructions.class);
    private static final String instructionInternalName = Type.getInternalName(Common.Instruction.class);
    private static final String instructionDescriptor = Type.getDescriptor(Common.Instruction.class);
    private static final String sceKernalThreadInfoInternalName = Type.getInternalName(SceKernelThreadInfo.class);
    private static final String sceKernalThreadInfoDescriptor = Type.getDescriptor(SceKernelThreadInfo.class);
    private static final String stringDescriptor = Type.getDescriptor(String.class);
    private static final String memoryDescriptor = Type.getDescriptor(Memory.class);
    private static final String memoryInternalName = Type.getInternalName(Memory.class);
    private static final String profilerInternalName = Type.getInternalName(Profiler.class);
    public static final String executableDescriptor = Type.getDescriptor(IExecutable.class);
    public static final String executableInternalName = Type.getInternalName(IExecutable.class);
    public static final String arraycopyDescriptor = "(" + Type.getDescriptor(Object.class) + "I" + Type.getDescriptor(Object.class) + "II)V";
    private static Set<Integer> fastSyscalls;
    private int instanceIndex;
    private NativeCodeSequence preparedCallNativeCodeBlock = null;
    private int maxStackSize = 11;
    private int maxLocalSize = 10;
    private boolean parametersSavedToLocals;
    private CompilerTypeManager compilerTypeManager;

    public CompilerContext(CompilerClassLoader classLoader, int instanceIndex) {
        Compiler compiler = Compiler.getInstance();
        this.classLoader = classLoader;
        this.instanceIndex = instanceIndex;
        this.nativeCodeManager = compiler.getNativeCodeManager();
        this.methodMaxInstructions = compiler.getDefaultMethodMaxInstructions();
        this.compilerTypeManager = compiler.getCompilerTypeManager();
        if (Profiler.isProfilerEnabled()) {
            this.enableIntructionCounting = true;
        }
        if (fastSyscalls == null) {
            fastSyscalls = new TreeSet<Integer>();
            this.addFastSyscall(987073420);
            this.addFastSyscall(286125210);
            this.addFastSyscall(-926083700);
            this.addFastSyscall(-1167355166);
            this.addFastSyscall(-513696388);
            this.addFastSyscall(-613183691);
            this.addFastSyscall(-2101586057);
            this.addFastSyscall(916379037);
            this.addFastSyscall(-1242112889);
            this.addFastSyscall(-522813112);
            this.addFastSyscall(884603550);
            this.addFastSyscall(-461487900);
            this.addFastSyscall(526865069);
            this.addFastSyscall(1957582890);
            this.addFastSyscall(1755605909);
        }
    }

    private void addFastSyscall(int nid) {
        int syscallCode = NIDMapper.getInstance().getSyscallByNid(nid);
        if (syscallCode >= 0) {
            fastSyscalls.add(syscallCode);
        }
    }

    public CompilerClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(CompilerClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public CodeBlock getCodeBlock() {
        return this.codeBlock;
    }

    public void setCodeBlock(CodeBlock codeBlock) {
        this.codeBlock = codeBlock;
    }

    public NativeCodeManager getNativeCodeManager() {
        return this.nativeCodeManager;
    }

    @Override
    public void invokeStaticMethod(String classInternalName, String methodName, String methodDescriptor) {
        this.mv.visitMethodInsn(184, classInternalName, methodName, methodDescriptor, false);
    }

    private void loadCpu() {
        this.mv.visitVarInsn(25, 0);
    }

    @Override
    public void loadProcessor() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "processor", processorDescriptor);
    }

    private void loadMemory() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "memory", memoryDescriptor);
    }

    private void loadMMIO() {
        this.invokeStaticMethod(runtimeContextLLEInternalName, "getMMIO", "()" + memoryDescriptor);
    }

    private void loadModule(String moduleName) {
        this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), moduleName + "Module", "Ljpcsp/HLE/modules/" + moduleName + ";");
    }

    private void loadFpr() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "fpr", "[F");
    }

    @Override
    public void loadVprFloat() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "vprFloat", "[F");
    }

    @Override
    public void loadVprInt() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "vprInt", "[I");
    }

    @Override
    public void loadRegister(int reg) {
        if (reg == 0) {
            this.loadImm(0);
        } else {
            this.loadCpu();
            this.mv.visitFieldInsn(180, cpuInternalName, this.getGprFieldName(reg), "I");
        }
    }

    @Override
    public void loadFRegister(int reg) {
        this.loadFpr();
        this.loadImm(reg);
        this.mv.visitInsn(48);
    }

    private Float getPfxSrcCstValue(VfpuPfxSrcState pfxSrcState, int n) {
        if (pfxSrcState == null || pfxSrcState.isUnknown() || !pfxSrcState.pfxSrc.enabled || !pfxSrcState.pfxSrc.cst[n]) {
            return null;
        }
        float value = 0.0f;
        switch (pfxSrcState.pfxSrc.swz[n]) {
            case 0: {
                value = pfxSrcState.pfxSrc.abs[n] ? 3.0f : 0.0f;
                break;
            }
            case 1: {
                value = pfxSrcState.pfxSrc.abs[n] ? 0.33333334f : 1.0f;
                break;
            }
            case 2: {
                value = pfxSrcState.pfxSrc.abs[n] ? 0.25f : 2.0f;
                break;
            }
            case 3: {
                float f = value = pfxSrcState.pfxSrc.abs[n] ? 0.16666667f : 0.5f;
            }
        }
        if (pfxSrcState.pfxSrc.neg[n]) {
            value = 0.0f - value;
        }
        if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
            log.trace((Object)String.format("PFX    %08X - getPfxSrcCstValue %d -> %f", this.getCodeInstruction().getAddress(), n, Float.valueOf(value)));
        }
        return Float.valueOf(value);
    }

    private void convertVFloatToInt() {
        this.invokeStaticMethod(Type.getInternalName(Float.class), "floatToRawIntBits", "(F)I");
    }

    private void convertVIntToFloat() {
        this.invokeStaticMethod(Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
    }

    private void applyPfxSrcPostfix(VfpuPfxSrcState pfxSrcState, int n, boolean isFloat) {
        if (pfxSrcState == null || pfxSrcState.isUnknown() || !pfxSrcState.pfxSrc.enabled) {
            return;
        }
        if (pfxSrcState.pfxSrc.abs[n]) {
            if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
                log.trace((Object)String.format("PFX    %08X - applyPfxSrcPostfix abs(%d)", this.getCodeInstruction().getAddress(), n));
            }
            if (isFloat) {
                this.invokeStaticMethod(Type.getInternalName(Math.class), "abs", "(F)F");
            } else {
                this.loadImm(Integer.MAX_VALUE);
                this.mv.visitInsn(126);
            }
        }
        if (pfxSrcState.pfxSrc.neg[n]) {
            if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
                log.trace((Object)String.format("PFX    %08X - applyPfxSrcPostfix neg(%d)", this.getCodeInstruction().getAddress(), n));
            }
            if (isFloat) {
                this.mv.visitInsn(118);
            } else {
                this.loadImm(Integer.MIN_VALUE);
                this.mv.visitInsn(130);
            }
        }
    }

    private int getPfxSrcIndex(VfpuPfxSrcState pfxSrcState, int n) {
        if (pfxSrcState == null || pfxSrcState.isUnknown() || !pfxSrcState.pfxSrc.enabled || pfxSrcState.pfxSrc.cst[n]) {
            return n;
        }
        if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
            log.trace((Object)String.format("PFX    %08X - getPfxSrcIndex %d -> %d", this.getCodeInstruction().getAddress(), n, pfxSrcState.pfxSrc.swz[n]));
        }
        return pfxSrcState.pfxSrc.swz[n];
    }

    private void loadVRegister(int m, int c, int r, boolean isFloat) {
        int index = VfpuState.getVprIndex(m, c, r);
        if (isFloat) {
            this.loadVprFloat();
            this.loadImm(index);
            this.mv.visitInsn(48);
        } else {
            this.loadVprInt();
            this.loadImm(index);
            this.mv.visitInsn(46);
        }
    }

    private void loadCstValue(Float cstValue, boolean isFloat) {
        if (isFloat) {
            this.mv.visitLdcInsn((Object)Float.valueOf(cstValue.floatValue()));
        } else {
            this.loadImm(Float.floatToRawIntBits(cstValue.floatValue()));
        }
    }

    private void loadVRegister(int vsize, int reg, int n, VfpuPfxSrcState pfxSrcState, boolean isFloat) {
        if (log.isTraceEnabled() && pfxSrcState != null && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
            log.trace((Object)String.format("PFX    %08X - loadVRegister %d, %d, %d", this.getCodeInstruction().getAddress(), vsize, reg, n));
        }
        int m = reg >> 2 & 7;
        int i = reg >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = reg >> 5 & 3;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                this.loadVRegister(m, i, s, isFloat);
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
            case 2: {
                int s = (reg & 0x40) >> 5;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                int index = this.getPfxSrcIndex(pfxSrcState, n);
                if ((reg & 0x20) != 0) {
                    this.loadVRegister(m, s + index, i, isFloat);
                } else {
                    this.loadVRegister(m, i, s + index, isFloat);
                }
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
            case 3: {
                int s = (reg & 0x40) >> 6;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                int index = this.getPfxSrcIndex(pfxSrcState, n);
                if ((reg & 0x20) != 0) {
                    this.loadVRegister(m, s + index, i, isFloat);
                } else {
                    this.loadVRegister(m, i, s + index, isFloat);
                }
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
            case 4: {
                int s = (reg & 0x40) >> 5;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                int index = this.getPfxSrcIndex(pfxSrcState, n + s & 3);
                if ((reg & 0x20) != 0) {
                    this.loadVRegister(m, index, i, isFloat);
                } else {
                    this.loadVRegister(m, i, index, isFloat);
                }
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
        }
    }

    public void prepareRegisterForStore(int reg) {
        if (this.preparedRegisterForStore < 0) {
            this.loadCpu();
            this.preparedRegisterForStore = reg;
        }
    }

    private String getGprFieldName(int reg) {
        return Common.gprNames[reg].replace('$', '_');
    }

    public void storeRegister(int reg) {
        if (this.preparedRegisterForStore == reg) {
            this.mv.visitFieldInsn(181, cpuInternalName, this.getGprFieldName(reg), "I");
            this.preparedRegisterForStore = -1;
        } else {
            this.loadCpu();
            this.mv.visitInsn(95);
            this.mv.visitFieldInsn(181, cpuInternalName, this.getGprFieldName(reg), "I");
        }
    }

    @Override
    public void storeRegister(int reg, int constantValue) {
        if (this.preparedRegisterForStore == reg) {
            this.preparedRegisterForStore = -1;
        } else {
            this.loadCpu();
        }
        this.loadImm(constantValue);
        this.mv.visitFieldInsn(181, cpuInternalName, this.getGprFieldName(reg), "I");
    }

    public void prepareFRegisterForStore(int reg) {
        if (this.preparedRegisterForStore < 0) {
            this.loadFpr();
            this.loadImm(reg);
            this.preparedRegisterForStore = reg;
        }
    }

    public void storeFRegister(int reg) {
        if (this.preparedRegisterForStore == reg) {
            this.mv.visitInsn(81);
            this.preparedRegisterForStore = -1;
        } else {
            this.loadFpr();
            this.mv.visitInsn(95);
            this.loadImm(reg);
            this.mv.visitInsn(95);
            this.mv.visitInsn(81);
        }
    }

    @Override
    public boolean hasNoPfx() {
        if (this.vfpuPfxdState != null && this.vfpuPfxdState.isKnown() && this.vfpuPfxdState.pfxDst.enabled) {
            return false;
        }
        if (this.vfpuPfxsState != null && this.vfpuPfxsState.isKnown() && this.vfpuPfxsState.pfxSrc.enabled) {
            return false;
        }
        return this.vfpuPfxtState == null || !this.vfpuPfxtState.isKnown() || !this.vfpuPfxtState.pfxSrc.enabled;
    }

    private boolean isPfxDstMasked(VfpuPfxDstState pfxDstState, int n) {
        if (pfxDstState == null || pfxDstState.isUnknown() || !pfxDstState.pfxDst.enabled) {
            return false;
        }
        return pfxDstState.pfxDst.msk[n];
    }

    private void applyPfxDstPostfix(VfpuPfxDstState pfxDstState, int n, boolean isFloat) {
        if (pfxDstState == null || pfxDstState.isUnknown() || !pfxDstState.pfxDst.enabled) {
            return;
        }
        switch (pfxDstState.pfxDst.sat[n]) {
            case 1: {
                if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
                    log.trace((Object)String.format("PFX    %08X - applyPfxDstPostfix %d [0:1]", this.getCodeInstruction().getAddress(), n));
                }
                if (!isFloat) {
                    this.convertVIntToFloat();
                }
                this.mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                this.invokeStaticMethod(Type.getInternalName(Math.class), "min", "(FF)F");
                this.mv.visitLdcInsn((Object)Float.valueOf(0.0f));
                this.invokeStaticMethod(Type.getInternalName(Math.class), "max", "(FF)F");
                if (isFloat) break;
                this.convertVFloatToInt();
                break;
            }
            case 3: {
                if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
                    log.trace((Object)String.format("PFX    %08X - applyPfxDstPostfix %d [-1:1]", this.getCodeInstruction().getAddress(), n));
                }
                if (!isFloat) {
                    this.convertVIntToFloat();
                }
                this.mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                this.invokeStaticMethod(Type.getInternalName(Math.class), "min", "(FF)F");
                this.mv.visitLdcInsn((Object)Float.valueOf(-1.0f));
                this.invokeStaticMethod(Type.getInternalName(Math.class), "max", "(FF)F");
                if (isFloat) break;
                this.convertVFloatToInt();
            }
        }
    }

    private void prepareVRegisterForStore(int m, int c, int r, boolean isFloat) {
        int index = VfpuState.getVprIndex(m, c, r);
        if (isFloat) {
            this.loadVprInt();
            this.loadImm(index);
            this.loadVprFloat();
            this.loadImm(index);
        } else {
            this.loadVprFloat();
            this.loadImm(index);
            this.loadVprInt();
            this.loadImm(index);
        }
    }

    public void prepareVRegisterForStore(int vsize, int reg, int n, VfpuPfxDstState pfxDstState, boolean isFloat) {
        if (this.preparedRegisterForStore < 0) {
            if (!this.isPfxDstMasked(pfxDstState, n)) {
                int m = reg >> 2 & 7;
                int i = reg >> 0 & 3;
                switch (vsize) {
                    case 1: {
                        int s = reg >> 5 & 3;
                        this.prepareVRegisterForStore(m, i, s, isFloat);
                        break;
                    }
                    case 2: {
                        int s = (reg & 0x40) >> 5;
                        if ((reg & 0x20) != 0) {
                            this.prepareVRegisterForStore(m, s + n, i, isFloat);
                            break;
                        }
                        this.prepareVRegisterForStore(m, i, s + n, isFloat);
                        break;
                    }
                    case 3: {
                        int s = (reg & 0x40) >> 6;
                        if ((reg & 0x20) != 0) {
                            this.prepareVRegisterForStore(m, s + n, i, isFloat);
                            break;
                        }
                        this.prepareVRegisterForStore(m, i, s + n, isFloat);
                        break;
                    }
                    case 4: {
                        int s = (reg & 0x40) >> 5;
                        if ((reg & 0x20) != 0) {
                            this.prepareVRegisterForStore(m, n + s & 3, i, isFloat);
                            break;
                        }
                        this.prepareVRegisterForStore(m, i, n + s & 3, isFloat);
                    }
                }
            }
            this.preparedRegisterForStore = reg;
        }
    }

    private void storeVRegister(int vsize, int reg, int n, VfpuPfxDstState pfxDstState, boolean isFloat) {
        if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
            log.trace((Object)String.format("PFX    %08X - storeVRegister %d, %d, %d", this.getCodeInstruction().getAddress(), vsize, reg, n));
        }
        if (this.preparedRegisterForStore == reg) {
            if (this.isPfxDstMasked(pfxDstState, n)) {
                if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
                    log.trace((Object)String.format("PFX    %08X - storeVRegister %d masked", this.getCodeInstruction().getAddress(), n));
                }
                this.mv.visitInsn(87);
            } else {
                this.applyPfxDstPostfix(pfxDstState, n, isFloat);
                if (isFloat) {
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(81);
                    this.convertVFloatToInt();
                    this.mv.visitInsn(79);
                } else {
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(79);
                    this.convertVIntToFloat();
                    this.mv.visitInsn(81);
                }
            }
            this.preparedRegisterForStore = -1;
        } else {
            log.error((Object)"storeVRegister with non-prepared register is not supported");
        }
    }

    public void loadFcr31() {
        this.loadCpu();
        this.mv.visitFieldInsn(180, cpuInternalName, "fcr31", Type.getDescriptor(FpuState.Fcr31.class));
    }

    public void loadVcr() {
        this.loadCpu();
        this.mv.visitFieldInsn(180, cpuInternalName, "vcr", Type.getDescriptor(VfpuState.Vcr.class));
    }

    @Override
    public void loadHilo() {
        this.loadCpu();
        this.mv.visitFieldInsn(180, cpuInternalName, "hilo", Type.getDescriptor(Long.TYPE));
    }

    @Override
    public void prepareHiloForStore() {
        this.loadCpu();
        this.hiloPrepared = true;
    }

    @Override
    public void storeHilo() {
        if (!this.hiloPrepared) {
            this.loadCpu();
            this.mv.visitInsn(91);
            this.mv.visitInsn(87);
        }
        this.mv.visitFieldInsn(181, cpuInternalName, "hilo", Type.getDescriptor(Long.TYPE));
        this.hiloPrepared = false;
    }

    @Override
    public void loadFcr31c() {
        this.loadFcr31();
        this.mv.visitFieldInsn(180, Type.getInternalName(FpuState.Fcr31.class), "c", "Z");
    }

    @Override
    public void prepareFcr31cForStore() {
        this.loadFcr31();
    }

    @Override
    public void storeFcr31c() {
        this.mv.visitFieldInsn(181, Type.getInternalName(FpuState.Fcr31.class), "c", "Z");
    }

    public void loadVcrCc() {
        this.loadVcrCc(this.codeInstruction.getOpcode() >> 18 & 7);
    }

    @Override
    public void loadVcrCc(int cc) {
        this.loadVcr();
        this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), "cc", "[Z");
        this.loadImm(cc);
        this.mv.visitInsn(51);
    }

    @Override
    public void loadLocalVar(int localVar) {
        this.mv.visitVarInsn(21, localVar);
    }

    private void storeLocalVar(int localVar) {
        this.mv.visitVarInsn(54, localVar);
    }

    private void loadInstruction(Common.Instruction insn) {
        String classInternalName = instructionsInternalName;
        if (insn == Common.UNK) {
            classInternalName = Type.getInternalName(Common.class);
        }
        this.mv.visitFieldInsn(178, classInternalName, insn.name().replace('.', '_').replace(' ', '_'), instructionDescriptor);
    }

    @Override
    public void storePc() {
        this.loadCpu();
        this.loadImm(this.codeInstruction.getAddress());
        this.mv.visitFieldInsn(181, cpuInternalName, "pc", "I");
    }

    public void loadPc() {
        this.loadCpu();
        this.mv.visitFieldInsn(180, cpuInternalName, "pc", "I");
    }

    private void visitContinueToAddress(int returnAddress, boolean returnOnUnknownAddress) {
        Label continueLabel = new Label();
        Label isReturnAddress = new Label();
        this.mv.visitInsn(89);
        this.loadImm(returnAddress);
        this.visitJump(159, isReturnAddress);
        if (returnOnUnknownAddress) {
            this.visitJump();
        } else {
            this.loadImm(returnAddress);
            this.invokeStaticMethod(runtimeContextInternalName, "jump", "(II)V");
            this.mv.visitJumpInsn(167, continueLabel);
        }
        this.mv.visitLabel(isReturnAddress);
        this.mv.visitInsn(87);
        this.mv.visitLabel(continueLabel);
    }

    private void visitContinueToAddressInRegister(int reg) {
        Label continueLabel = new Label();
        Label isReturnAddress = new Label();
        this.mv.visitInsn(89);
        this.loadRegister(reg);
        this.visitJump(159, isReturnAddress);
        this.loadRegister(reg);
        this.invokeStaticMethod(runtimeContextInternalName, "jump", "(II)V");
        this.mv.visitJumpInsn(167, continueLabel);
        this.mv.visitLabel(isReturnAddress);
        this.mv.visitInsn(87);
        this.mv.visitLabel(continueLabel);
    }

    public void visitJump() {
        this.flushInstructionCount(true, false);
        this.checkSync();
        this.endMethod();
        this.mv.visitInsn(172);
    }

    public void prepareCall(int address, int returnAddress, int returnRegister) {
        this.preparedCallNativeCodeBlock = null;
        if (!Profiler.isProfilerEnabled()) {
            this.preparedCallNativeCodeBlock = this.nativeCodeManager.getCompiledNativeCodeBlock(address);
        }
        if (this.preparedCallNativeCodeBlock == null && returnRegister != 0) {
            this.prepareRegisterForStore(returnRegister);
            this.loadImm(returnAddress);
            this.storeRegister(returnRegister);
        }
    }

    public void visitCall(int address, int returnAddress, int returnRegister, boolean returnRegisterModified, boolean returnOnUnknownAddress) {
        this.flushInstructionCount(false, false);
        if (this.preparedCallNativeCodeBlock != null) {
            if (!this.preparedCallNativeCodeBlock.getNativeCodeSequenceClass().equals(Nop.class)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Inlining call at 0x%08X to %s", this.getCodeInstruction().getAddress(), this.preparedCallNativeCodeBlock));
                }
                this.visitNativeCodeSequence(this.preparedCallNativeCodeBlock, address, null);
            }
        } else {
            this.invokeStaticMethod(CompilerContext.getClassName(address, this.instanceIndex), this.getStaticExecMethodName(), this.getStaticExecMethodDesc());
            this.visitContinueToAddress(returnAddress, returnOnUnknownAddress);
        }
        this.preparedCallNativeCodeBlock = null;
    }

    public void visitCall(int returnAddress, int returnRegister) {
        this.flushInstructionCount(false, false);
        if (returnRegister != 0) {
            this.storeRegister(returnRegister, returnAddress);
        }
        this.invokeStaticMethod(runtimeContextInternalName, "call", "(I)I");
        this.visitContinueToAddress(returnAddress, false);
    }

    public void visitCall(int address, String methodName) {
        this.flushInstructionCount(false, false);
        this.invokeStaticMethod(CompilerContext.getClassName(address, this.instanceIndex), methodName, "()V");
    }

    public void visitIntepreterCall(int opcode, Common.Instruction insn) {
        this.loadInstruction(insn);
        this.loadProcessor();
        this.loadImm(opcode);
        this.mv.visitMethodInsn(182, instructionInternalName, "interpret", "(" + processorDescriptor + "I)V", false);
    }

    private boolean isFastSyscall(int code) {
        return fastSyscalls.contains(code);
    }

    private void loadParameter(CompilerParameterReader parameterReader, HLEModuleFunction func, Class<?> parameterType, Annotation[] parameterAnnotations, Label afterSyscallLabel, Label catchSceKernelErrorException) {
        int n;
        if (parameterType == Processor.class) {
            this.loadProcessor();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == CpuState.class) {
            this.loadCpu();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == Integer.TYPE) {
            parameterReader.loadNextInt();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == Float.TYPE) {
            parameterReader.loadNextFloat();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == Long.TYPE) {
            parameterReader.loadNextLong();
            parameterReader.incrementCurrentStackSize(2);
        } else if (parameterType == Boolean.TYPE) {
            parameterReader.loadNextInt();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == String.class) {
            parameterReader.loadNextInt();
            int maxLength = 16384;
            Label label = parameterAnnotations;
            int n2 = ((Annotation[])label).length;
            for (n = 0; n < n2; ++n) {
                Annotation parameterAnnotation = label[n];
                if (!(parameterAnnotation instanceof StringInfo)) continue;
                StringInfo stringInfo = (StringInfo)parameterAnnotation;
                maxLength = stringInfo.maxLength();
                break;
            }
            this.loadImm(maxLength);
            this.invokeStaticMethod(runtimeContextInternalName, "readStringNZ", "(II)" + Type.getDescriptor(String.class));
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == PspString.class) {
            parameterReader.loadNextInt();
            int maxLength = 16384;
            boolean canBeNull2 = false;
            Label label = parameterAnnotations;
            n = ((Annotation[])label).length;
            for (int parameterAnnotation = 0; parameterAnnotation < n; ++parameterAnnotation) {
                Annotation parameterAnnotation2 = label[parameterAnnotation];
                if (parameterAnnotation2 instanceof StringInfo) {
                    StringInfo stringInfo = (StringInfo)parameterAnnotation2;
                    maxLength = stringInfo.maxLength();
                }
                if (!(parameterAnnotation2 instanceof CanBeNull)) continue;
                canBeNull2 = true;
            }
            this.loadImm(maxLength);
            this.loadImm(canBeNull2);
            this.invokeStaticMethod(runtimeContextInternalName, "readPspStringNZ", "(IIZ)" + Type.getDescriptor(PspString.class));
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == TPointer.class || parameterType == TPointer8.class || parameterType == TPointer16.class || parameterType == TPointer32.class || parameterType == TPointer64.class || parameterType == TErrorPointer32.class || parameterType == TPointerFunction.class) {
            this.mv.visitTypeInsn(187, Type.getInternalName(parameterType));
            this.mv.visitInsn(89);
            if (this.useMMIO()) {
                this.loadMMIO();
            } else {
                this.loadMemory();
            }
            parameterReader.loadNextInt();
            boolean canBeNull = false;
            Label canBeNull2 = parameterAnnotations;
            int n3 = ((Annotation[])canBeNull2).length;
            for (n = 0; n < n3; ++n) {
                Annotation parameterAnnotation = canBeNull2[n];
                if (!(parameterAnnotation instanceof CanBeNull)) continue;
                canBeNull = true;
                break;
            }
            if (this.checkMemoryAccess() && afterSyscallLabel != null && !this.useMMIO()) {
                Label addressGood = new Label();
                if (canBeNull) {
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(153, addressGood);
                }
                this.mv.visitInsn(89);
                this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryPointer", "(I)Z");
                this.mv.visitJumpInsn(154, addressGood);
                this.storeRegister(2, -2147483389);
                parameterReader.popAllStack(4);
                this.mv.visitJumpInsn(167, afterSyscallLabel);
                this.mv.visitLabel(addressGood);
            }
            if (parameterType == TPointer8.class || parameterType == TPointer16.class || parameterType == TPointer32.class || parameterType == TPointer64.class) {
                this.loadImm(canBeNull);
                this.mv.visitMethodInsn(183, Type.getInternalName(parameterType), "<init>", "(" + memoryDescriptor + "IZ)V", false);
            } else {
                this.mv.visitMethodInsn(183, Type.getInternalName(parameterType), "<init>", "(" + memoryDescriptor + "I)V", false);
            }
            if (parameterType == TErrorPointer32.class) {
                parameterReader.setHasErrorPointer(true);
                this.mv.visitInsn(89);
                this.mv.visitVarInsn(58, 5);
            }
            parameterReader.incrementCurrentStackSize();
        } else if (pspAbstractMemoryMappedStructure.class.isAssignableFrom(parameterType)) {
            parameterReader.loadNextInt();
            boolean canBeNull = false;
            Label addressGood = parameterAnnotations;
            int n4 = ((Annotation[])addressGood).length;
            for (n = 0; n < n4; ++n) {
                Annotation parameterAnnotation = addressGood[n];
                if (!(parameterAnnotation instanceof CanBeNull)) continue;
                canBeNull = true;
                break;
            }
            if (this.checkMemoryAccess() && afterSyscallLabel != null) {
                addressGood = new Label();
                if (canBeNull) {
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(153, addressGood);
                }
                this.mv.visitInsn(89);
                this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryPointer", "(I)Z");
                this.mv.visitJumpInsn(154, addressGood);
                this.storeRegister(2, -2147483389);
                parameterReader.popAllStack(1);
                this.mv.visitJumpInsn(167, afterSyscallLabel);
                this.mv.visitLabel(addressGood);
            }
            this.mv.visitTypeInsn(187, Type.getInternalName(parameterType));
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, Type.getInternalName(parameterType), "<init>", "()V", false);
            this.mv.visitInsn(90);
            this.mv.visitInsn(95);
            this.loadMemory();
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, Type.getInternalName(parameterType), "read", "(" + memoryDescriptor + "I)V", false);
            parameterReader.incrementCurrentStackSize();
        } else {
            HLEUidClass hleUidClass = parameterType.getAnnotation(HLEUidClass.class);
            if (hleUidClass != null) {
                int errorValueOnNotFound = hleUidClass.errorValueOnNotFound();
                this.mv.visitLdcInsn((Object)parameterType.getName());
                parameterReader.loadNextInt();
                this.invokeStaticMethod(Type.getInternalName(HLEUidObjectMapping.class), "getObject", "(" + Type.getDescriptor(String.class) + "I)" + Type.getDescriptor(Object.class));
                if (afterSyscallLabel != null) {
                    Label foundUid = new Label();
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(199, foundUid);
                    this.storeRegister(2, errorValueOnNotFound);
                    parameterReader.popAllStack(1);
                    this.mv.visitJumpInsn(167, afterSyscallLabel);
                    this.mv.visitLabel(foundUid);
                }
                this.mv.visitTypeInsn(192, Type.getInternalName(parameterType));
                parameterReader.incrementCurrentStackSize();
            } else {
                log.error((Object)String.format("Unsupported sycall parameter type '%s'", parameterType.getName()));
                Emulator.PauseEmuWithStatus(32);
            }
        }
        Method methodToCheck = null;
        if (afterSyscallLabel != null) {
            for (Annotation parameterAnnotation : parameterAnnotations) {
                if (!(parameterAnnotation instanceof CheckArgument)) continue;
                CheckArgument checkArgument = (CheckArgument)parameterAnnotation;
                try {
                    methodToCheck = func.getHLEModule().getClass().getMethod(checkArgument.value(), parameterType);
                }
                catch (Exception e) {
                    log.error((Object)String.format("CheckArgument method '%s' not found in %s", checkArgument.value(), func.getModuleName()), (Throwable)e);
                }
                break;
            }
        }
        if (methodToCheck != null) {
            this.loadModule(func.getModuleName());
            this.mv.visitInsn(95);
            Label tryStart = new Label();
            Label tryEnd = new Label();
            this.mv.visitTryCatchBlock(tryStart, tryEnd, catchSceKernelErrorException, Type.getInternalName(SceKernelErrorException.class));
            this.mv.visitLabel(tryStart);
            this.mv.visitMethodInsn(182, Type.getInternalName(methodToCheck.getDeclaringClass()), methodToCheck.getName(), "(" + Type.getDescriptor(parameterType) + ")" + Type.getDescriptor(parameterType), false);
            this.mv.visitLabel(tryEnd);
        }
        parameterReader.incrementCurrentParameterIndex();
    }

    private void storeReturnValue(HLEModuleFunction func, Class<?> returnType) {
        if (returnType != Void.TYPE) {
            if (returnType == Integer.TYPE) {
                this.storeRegister(2);
            } else if (returnType == Boolean.TYPE) {
                this.storeRegister(2);
            } else if (returnType == Long.TYPE) {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn((Object)0xFFFFFFFFL);
                this.mv.visitInsn(127);
                this.mv.visitInsn(136);
                this.storeRegister(2);
                this.loadImm(32);
                this.mv.visitInsn(123);
                this.mv.visitInsn(136);
                this.storeRegister(3);
            } else if (returnType == Float.TYPE) {
                this.storeFRegister(0);
            } else {
                HLEUidClass hleUidClass = returnType.getAnnotation(HLEUidClass.class);
                if (hleUidClass != null) {
                    if (hleUidClass.moduleMethodUidGenerator().length() <= 0) {
                        this.mv.visitLdcInsn((Object)returnType.getName());
                        this.mv.visitInsn(95);
                        this.invokeStaticMethod(Type.getInternalName(HLEUidObjectMapping.class), "createUidForObject", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")I");
                        this.storeRegister(2);
                    } else {
                        this.mv.visitLdcInsn((Object)returnType.getName());
                        this.mv.visitInsn(95);
                        this.loadModule(func.getModuleName());
                        this.mv.visitMethodInsn(182, Type.getInternalName(func.getHLEModuleMethod().getDeclaringClass()), hleUidClass.moduleMethodUidGenerator(), "()I", false);
                        this.mv.visitInsn(95);
                        this.invokeStaticMethod(Type.getInternalName(HLEUidObjectMapping.class), "addObjectMap", "(" + Type.getDescriptor(String.class) + "I" + Type.getDescriptor(Object.class) + ")I");
                        this.storeRegister(2);
                    }
                } else {
                    log.error((Object)String.format("Unsupported sycall return value type '%s'", returnType.getName()));
                }
            }
        }
    }

    private void loadModuleLoggger(HLEModuleFunction func) {
        this.mv.visitFieldInsn(178, Type.getInternalName(func.getHLEModuleMethod().getDeclaringClass()), "log", Type.getDescriptor(Logger.class));
    }

    private void logSyscall(HLEModuleFunction func, String logPrefix, String logCheckFunction, String logFunction) {
        this.loadModuleLoggger(func);
        this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), logCheckFunction, "()Z", false);
        Label loggingDisabled = new Label();
        this.mv.visitJumpInsn(153, loggingDisabled);
        this.loadModuleLoggger(func);
        StringBuilder formatString = new StringBuilder();
        if (logPrefix != null) {
            formatString.append(logPrefix);
        }
        formatString.append(func.getFunctionName());
        ClassAnalyzer.ParameterInfo[] parameters = new ClassAnalyzer().getParameters(func.getFunctionName(), func.getHLEModuleMethod().getDeclaringClass());
        if (parameters != null) {
            Class<?> parameterType;
            ClassAnalyzer.ParameterInfo parameter;
            int paramIndex;
            this.loadImm(parameters.length);
            this.mv.visitTypeInsn(189, Type.getInternalName(Object.class));
            CompilerParameterReader parameterReader = new CompilerParameterReader(this);
            Annotation[][] paramsAnotations = func.getHLEModuleMethod().getParameterAnnotations();
            int objectArrayIndex = 0;
            for (paramIndex = 0; paramIndex < parameters.length; ++paramIndex) {
                parameter = parameters[paramIndex];
                parameterType = parameter.type;
                CompilerTypeInformation typeInformation = this.compilerTypeManager.getCompilerTypeInformation(parameterType);
                this.mv.visitInsn(89);
                this.loadImm(objectArrayIndex);
                formatString.append(paramIndex > 0 ? ", " : " ");
                formatString.append(parameter.name);
                formatString.append("=");
                formatString.append(typeInformation.formatString);
                if (typeInformation.boxingTypeInternalName != null) {
                    this.mv.visitTypeInsn(187, typeInformation.boxingTypeInternalName);
                    this.mv.visitInsn(89);
                }
                this.loadParameter(parameterReader, func, parameterType, paramsAnotations[paramIndex], null, null);
                if (typeInformation.boxingTypeInternalName != null) {
                    this.mv.visitMethodInsn(183, typeInformation.boxingTypeInternalName, "<init>", typeInformation.boxingMethodDescriptor, false);
                }
                this.mv.visitInsn(83);
                ++objectArrayIndex;
            }
            this.mv.visitLdcInsn((Object)formatString.toString());
            this.mv.visitInsn(95);
            this.invokeStaticMethod(Type.getInternalName(String.class), "format", "(" + Type.getDescriptor(String.class) + "[" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(String.class));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), logFunction, "(" + Type.getDescriptor(Object.class) + ")V", false);
            parameterReader = new CompilerParameterReader(this);
            for (paramIndex = 0; paramIndex < parameters.length; ++paramIndex) {
                parameter = parameters[paramIndex];
                parameterType = parameter.type;
                BufferInfo.LengthInfo lengthInfo = BufferInfo.defaultLengthInfo;
                int length = -1;
                BufferInfo.Usage usage = BufferInfo.defaultUsage;
                int maxDumpLength = -1;
                for (Annotation parameterAnnotation : paramsAnotations[paramIndex]) {
                    if (!(parameterAnnotation instanceof BufferInfo)) continue;
                    BufferInfo bufferInfo = (BufferInfo)parameterAnnotation;
                    lengthInfo = bufferInfo.lengthInfo();
                    length = bufferInfo.length();
                    usage = bufferInfo.usage();
                    maxDumpLength = bufferInfo.maxDumpLength();
                }
                boolean parameterRead = false;
                if (!(usage != BufferInfo.Usage.in && usage != BufferInfo.Usage.inout || lengthInfo == BufferInfo.LengthInfo.unknown && parameterType != TPointer16.class && parameterType != TPointer32.class && parameterType != TPointer64.class)) {
                    this.loadModuleLoggger(func);
                    this.loadImm(1);
                    this.mv.visitTypeInsn(189, Type.getInternalName(Object.class));
                    this.mv.visitInsn(89);
                    this.loadImm(0);
                    Label done = new Label();
                    Label addressNull = new Label();
                    parameterReader.loadNextInt();
                    parameterRead = true;
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(153, addressNull);
                    String format = String.format("%s[%s]:%%s", new Object[]{parameter.name, usage});
                    boolean useMemoryDump = true;
                    switch (lengthInfo) {
                        case fixedLength: {
                            this.loadImm(length);
                            break;
                        }
                        case nextNextParameter: {
                            parameterReader.skipNextInt();
                            ++paramIndex;
                            parameterReader.loadNextInt();
                            ++paramIndex;
                            break;
                        }
                        case nextParameter: {
                            parameterReader.loadNextInt();
                            ++paramIndex;
                            break;
                        }
                        case previousParameter: {
                            parameterReader.rewindPreviousInt();
                            parameterReader.rewindPreviousInt();
                            parameterReader.loadNextInt();
                            parameterReader.skipNextInt();
                            break;
                        }
                        case variableLength: {
                            this.mv.visitInsn(89);
                            this.loadMemory();
                            this.mv.visitInsn(95);
                            this.mv.visitMethodInsn(182, memoryInternalName, "read32", "(I)I", false);
                            break;
                        }
                        case unknown: {
                            useMemoryDump = false;
                            format = String.format("%s[%s]: 0x%%X", new Object[]{parameter.name, usage});
                            this.loadMemory();
                            this.mv.visitInsn(95);
                            if (parameterType == TPointer64.class) {
                                this.mv.visitMethodInsn(182, memoryInternalName, "read64", "(I)J", false);
                                this.mv.visitTypeInsn(187, Type.getInternalName(Long.class));
                                this.mv.visitInsn(89);
                                this.mv.visitInsn(94);
                                this.mv.visitInsn(88);
                                this.mv.visitMethodInsn(183, Type.getInternalName(Long.class), "<init>", "(J)V", false);
                                break;
                            }
                            if (parameterType == TPointer16.class) {
                                this.mv.visitMethodInsn(182, memoryInternalName, "read16", "(I)I", false);
                                this.mv.visitTypeInsn(187, Type.getInternalName(Integer.class));
                                this.mv.visitInsn(90);
                                this.mv.visitInsn(95);
                                this.mv.visitMethodInsn(183, Type.getInternalName(Integer.class), "<init>", "(I)V", false);
                                break;
                            }
                            this.mv.visitMethodInsn(182, memoryInternalName, "read32", "(I)I", false);
                            this.mv.visitTypeInsn(187, Type.getInternalName(Integer.class));
                            this.mv.visitInsn(90);
                            this.mv.visitInsn(95);
                            this.mv.visitMethodInsn(183, Type.getInternalName(Integer.class), "<init>", "(I)V", false);
                            break;
                        }
                        default: {
                            log.error((Object)String.format("Unimplemented lengthInfo=%s", new Object[]{lengthInfo}));
                        }
                    }
                    if (useMemoryDump) {
                        if (maxDumpLength >= 0) {
                            this.loadImm(maxDumpLength);
                            this.invokeStaticMethod(Type.getInternalName(Math.class), "min", "(II)I");
                        }
                        this.invokeStaticMethod(Type.getInternalName(Utilities.class), "getMemoryDump", "(II)" + Type.getDescriptor(String.class));
                    }
                    this.mv.visitInsn(83);
                    this.mv.visitLdcInsn((Object)format);
                    this.mv.visitInsn(95);
                    this.invokeStaticMethod(Type.getInternalName(String.class), "format", "(" + Type.getDescriptor(String.class) + "[" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(String.class));
                    this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), logFunction, "(" + Type.getDescriptor(Object.class) + ")V", false);
                    this.mv.visitJumpInsn(167, done);
                    this.mv.visitLabel(addressNull);
                    this.mv.visitInsn(87);
                    this.mv.visitInsn(88);
                    this.mv.visitInsn(88);
                    this.mv.visitLabel(done);
                }
                if (parameterRead) continue;
                if (parameterType == Long.TYPE) {
                    parameterReader.skipNextLong();
                    continue;
                }
                if (parameterType == Float.TYPE) {
                    parameterReader.skipNextFloat();
                    continue;
                }
                parameterReader.skipNextInt();
            }
        } else {
            this.mv.visitLdcInsn((Object)formatString.toString());
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), logFunction, "(" + Type.getDescriptor(Object.class) + ")V", false);
        }
        this.mv.visitLabel(loggingDisabled);
    }

    private String getLogCheckFunction(String loggingLevel) {
        String logCheckFunction = "isInfoEnabled";
        if ("trace".equals(loggingLevel)) {
            logCheckFunction = "isTraceEnabled";
        } else if ("debug".equals(loggingLevel)) {
            logCheckFunction = "isDebugEnabled";
        }
        return logCheckFunction;
    }

    private String getLoggingLevel(HLEModuleFunction func) {
        String loggingLevel = func.getLoggingLevel();
        if (loggingLevel != null && func.isUnimplemented() && this.codeBlock.isHLEFunction() && "warn".equals(loggingLevel)) {
            loggingLevel = "debug";
        }
        return loggingLevel;
    }

    private void logSyscallStart(HLEModuleFunction func) {
        String loggingLevel = this.getLoggingLevel(func);
        if (loggingLevel != null) {
            String prefix = null;
            if (func.isUnimplemented() && !this.codeBlock.isHLEFunction()) {
                prefix = "Unimplemented ";
            }
            this.logSyscall(func, prefix, this.getLogCheckFunction(loggingLevel), loggingLevel);
        }
    }

    private void logSyscallEnd(HLEModuleFunction func, boolean isErrorCode) {
        ClassAnalyzer.ParameterInfo[] parameters;
        String loggingLevel = this.getLoggingLevel(func);
        if (loggingLevel == null) {
            return;
        }
        String logCheckFunction = this.getLogCheckFunction(loggingLevel);
        this.loadModuleLoggger(func);
        this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), logCheckFunction, "()Z", false);
        Label notDebug = new Label();
        this.mv.visitJumpInsn(153, notDebug);
        boolean isReturningVoid = func.getHLEModuleMethod().getReturnType() == Void.TYPE;
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, Type.getInternalName(Integer.class));
        this.mv.visitInsn(90);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(183, Type.getInternalName(Integer.class), "<init>", "(I)V", false);
        this.loadImm(1);
        this.mv.visitTypeInsn(189, Type.getInternalName(Object.class));
        this.mv.visitInsn(90);
        this.mv.visitInsn(95);
        this.loadImm(0);
        this.mv.visitInsn(95);
        this.mv.visitInsn(83);
        String prefix = func.isUnimplemented() && !this.codeBlock.isHLEFunction() ? "Unimplemented " : "";
        this.mv.visitLdcInsn((Object)String.format("%s%s returning %s%s", prefix, func.getFunctionName(), isErrorCode ? "errorCode " : "", isReturningVoid ? "void" : "0x%X"));
        this.mv.visitInsn(95);
        this.invokeStaticMethod(Type.getInternalName(String.class), "format", "(" + Type.getDescriptor(String.class) + "[" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(String.class));
        this.loadModuleLoggger(func);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), loggingLevel, "(" + Type.getDescriptor(Object.class) + ")V", false);
        if (!isErrorCode && (parameters = new ClassAnalyzer().getParameters(func.getFunctionName(), func.getHLEModuleMethod().getDeclaringClass())) != null) {
            CompilerParameterReader parameterReader = this.parametersSavedToLocals ? new CompilerLocalVarParameterReader(this, 10) : new CompilerParameterReader(this);
            Annotation[][] paramsAnotations = func.getHLEModuleMethod().getParameterAnnotations();
            for (int paramIndex = 0; paramIndex < parameters.length; ++paramIndex) {
                ClassAnalyzer.ParameterInfo parameter = parameters[paramIndex];
                Class<?> parameterType = parameter.type;
                BufferInfo.LengthInfo lengthInfo = BufferInfo.defaultLengthInfo;
                int length = -1;
                BufferInfo.Usage usage = BufferInfo.defaultUsage;
                int maxDumpLength = -1;
                boolean debugMemory = false;
                for (Annotation parameterAnnotation : paramsAnotations[paramIndex]) {
                    if (parameterAnnotation instanceof BufferInfo) {
                        BufferInfo bufferInfo = (BufferInfo)parameterAnnotation;
                        lengthInfo = bufferInfo.lengthInfo();
                        length = bufferInfo.length();
                        usage = bufferInfo.usage();
                        maxDumpLength = bufferInfo.maxDumpLength();
                        continue;
                    }
                    if (!(parameterAnnotation instanceof DebugMemory)) continue;
                    debugMemory = true;
                }
                boolean parameterRead = false;
                if (!(usage != BufferInfo.Usage.out && usage != BufferInfo.Usage.inout || lengthInfo == BufferInfo.LengthInfo.unknown && parameterType != TPointer16.class && parameterType != TPointer32.class && parameterType != TPointer64.class)) {
                    this.loadModuleLoggger(func);
                    this.loadImm(1);
                    this.mv.visitTypeInsn(189, Type.getInternalName(Object.class));
                    this.mv.visitInsn(89);
                    this.loadImm(0);
                    Label done = new Label();
                    Label addressNull = new Label();
                    parameterReader.loadNextInt();
                    parameterRead = true;
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(153, addressNull);
                    String format = String.format("%s[%s]:%%s", new Object[]{parameter.name, usage});
                    boolean useMemoryDump = true;
                    switch (lengthInfo) {
                        case fixedLength: {
                            this.loadImm(length);
                            break;
                        }
                        case nextNextParameter: {
                            parameterReader.skipNextInt();
                            ++paramIndex;
                            parameterReader.loadNextInt();
                            ++paramIndex;
                            break;
                        }
                        case nextParameter: {
                            parameterReader.loadNextInt();
                            ++paramIndex;
                            break;
                        }
                        case previousParameter: {
                            parameterReader.rewindPreviousInt();
                            parameterReader.rewindPreviousInt();
                            parameterReader.loadNextInt();
                            parameterReader.skipNextInt();
                            break;
                        }
                        case variableLength: {
                            this.mv.visitInsn(89);
                            this.loadMemory();
                            this.mv.visitInsn(95);
                            this.mv.visitMethodInsn(182, memoryInternalName, "read32", "(I)I", false);
                            break;
                        }
                        case returnValue: {
                            this.loadRegister(2);
                            break;
                        }
                        case unknown: {
                            useMemoryDump = false;
                            format = String.format("%s[%s]: 0x%%X", new Object[]{parameter.name, usage});
                            this.loadMemory();
                            this.mv.visitInsn(95);
                            if (parameterType == TPointer64.class) {
                                if (debugMemory) {
                                    this.mv.visitInsn(89);
                                    this.loadImm(8);
                                    this.invokeStaticMethod(runtimeContextInternalName, "debugMemory", "(II)V");
                                }
                                this.mv.visitMethodInsn(182, memoryInternalName, "read64", "(I)J", false);
                                this.mv.visitTypeInsn(187, Type.getInternalName(Long.class));
                                this.mv.visitInsn(89);
                                this.mv.visitInsn(94);
                                this.mv.visitInsn(88);
                                this.mv.visitMethodInsn(183, Type.getInternalName(Long.class), "<init>", "(J)V", false);
                                break;
                            }
                            if (parameterType == TPointer16.class) {
                                if (debugMemory) {
                                    this.mv.visitInsn(89);
                                    this.loadImm(2);
                                    this.invokeStaticMethod(runtimeContextInternalName, "debugMemory", "(II)V");
                                }
                                this.mv.visitMethodInsn(182, memoryInternalName, "read16", "(I)I", false);
                                this.mv.visitTypeInsn(187, Type.getInternalName(Integer.class));
                                this.mv.visitInsn(90);
                                this.mv.visitInsn(95);
                                this.mv.visitMethodInsn(183, Type.getInternalName(Integer.class), "<init>", "(I)V", false);
                                break;
                            }
                            if (debugMemory) {
                                this.mv.visitInsn(89);
                                this.loadImm(4);
                                this.invokeStaticMethod(runtimeContextInternalName, "debugMemory", "(II)V");
                            }
                            this.mv.visitMethodInsn(182, memoryInternalName, "read32", "(I)I", false);
                            this.mv.visitTypeInsn(187, Type.getInternalName(Integer.class));
                            this.mv.visitInsn(90);
                            this.mv.visitInsn(95);
                            this.mv.visitMethodInsn(183, Type.getInternalName(Integer.class), "<init>", "(I)V", false);
                            break;
                        }
                        default: {
                            log.error((Object)String.format("Unimplemented lengthInfo=%s", new Object[]{lengthInfo}));
                        }
                    }
                    if (useMemoryDump) {
                        if (debugMemory) {
                            this.mv.visitInsn(92);
                            this.invokeStaticMethod(runtimeContextInternalName, "debugMemory", "(II)V");
                        }
                        if (maxDumpLength >= 0) {
                            this.loadImm(maxDumpLength);
                            this.invokeStaticMethod(Type.getInternalName(Math.class), "min", "(II)I");
                        }
                        this.invokeStaticMethod(Type.getInternalName(Utilities.class), "getMemoryDump", "(II)" + Type.getDescriptor(String.class));
                    }
                    this.mv.visitInsn(83);
                    this.mv.visitLdcInsn((Object)format);
                    this.mv.visitInsn(95);
                    this.invokeStaticMethod(Type.getInternalName(String.class), "format", "(" + Type.getDescriptor(String.class) + "[" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(String.class));
                    this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), loggingLevel, "(" + Type.getDescriptor(Object.class) + ")V", false);
                    this.mv.visitJumpInsn(167, done);
                    this.mv.visitLabel(addressNull);
                    this.mv.visitInsn(87);
                    this.mv.visitInsn(88);
                    this.mv.visitInsn(88);
                    this.mv.visitLabel(done);
                }
                if (parameterRead) continue;
                if (parameterType == Long.TYPE) {
                    parameterReader.skipNextLong();
                    continue;
                }
                if (parameterType == Float.TYPE) {
                    parameterReader.skipNextFloat();
                    continue;
                }
                parameterReader.skipNextInt();
            }
        }
        this.mv.visitLabel(notDebug);
    }

    private boolean isCodeInstructionInKernelMemory() {
        if (this.codeInstruction == null) {
            return false;
        }
        if (reboot.enableReboot) {
            return true;
        }
        return this.codeInstruction.getAddress() < 0x8800000;
    }

    private void visitSyscall(HLEModuleFunction func, boolean fastSyscall) {
        this.maxStackSize = 100;
        boolean needFirmwareVersionCheck = true;
        if (func.getFirmwareVersion() >= 999) {
            needFirmwareVersionCheck = false;
        } else if (this.isCodeInstructionInKernelMemory()) {
            needFirmwareVersionCheck = false;
        } else {
            SceModule module = Managers.modules.getModuleByAddress(this.codeInstruction.getAddress());
            if (module != null && module.pspfilename != null && module.pspfilename.startsWith("flash0:")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("syscall from a flash0 module(%s, '%s'), no firmware version check", module, module.pspfilename));
                }
                needFirmwareVersionCheck = false;
            }
        }
        Label unsupportedVersionLabel = null;
        if (needFirmwareVersionCheck) {
            unsupportedVersionLabel = new Label();
            this.loadImm(func.getFirmwareVersion());
            this.mv.visitFieldInsn(178, runtimeContextInternalName, "firmwareVersion", "I");
            this.mv.visitJumpInsn(163, unsupportedVersionLabel);
        }
        if (!fastSyscall) {
            this.saveParametersToLocals();
        }
        if (!fastSyscall) {
            this.invokeStaticMethod(runtimeContextInternalName, "preSyscall", "()V");
        }
        Label afterSyscallLabel = new Label();
        if (func.checkInsideInterrupt()) {
            this.invokeStaticMethod(Type.getInternalName(IntrManager.class), "getInstance", "()" + Type.getDescriptor(IntrManager.class));
            this.mv.visitMethodInsn(182, Type.getInternalName(IntrManager.class), "isInsideInterrupt", "()Z", false);
            Label notInsideInterrupt = new Label();
            this.mv.visitJumpInsn(153, notInsideInterrupt);
            this.loadModuleLoggger(func);
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "isDebugEnabled", "()Z", false);
            Label notDebug = new Label();
            this.mv.visitJumpInsn(153, notDebug);
            this.loadModuleLoggger(func);
            this.mv.visitLdcInsn((Object)String.format("%s returning errorCode 0x%08X (ERROR_KERNEL_CANNOT_BE_CALLED_FROM_INTERRUPT)", func.getFunctionName(), -2147352476));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "debug", "(" + Type.getDescriptor(Object.class) + ")V", false);
            this.mv.visitLabel(notDebug);
            this.storeRegister(2, -2147352476);
            this.mv.visitJumpInsn(167, afterSyscallLabel);
            this.mv.visitLabel(notInsideInterrupt);
        }
        if (func.checkDispatchThreadEnabled()) {
            this.loadModule("ThreadManForUser");
            this.mv.visitMethodInsn(182, Type.getInternalName(ThreadManForUser.class), "isDispatchThreadEnabled", "()Z", false);
            Label returnError = new Label();
            this.mv.visitJumpInsn(153, returnError);
            this.loadProcessor();
            this.mv.visitMethodInsn(182, Type.getInternalName(Processor.class), "isInterruptsEnabled", "()Z", false);
            Label noError = new Label();
            this.mv.visitJumpInsn(154, noError);
            this.mv.visitLabel(returnError);
            this.loadModuleLoggger(func);
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "isDebugEnabled", "()Z", false);
            Label notDebug = new Label();
            this.mv.visitJumpInsn(153, notDebug);
            this.loadModuleLoggger(func);
            this.mv.visitLdcInsn((Object)String.format("%s returning errorCode 0x%08X (ERROR_KERNEL_WAIT_CAN_NOT_WAIT)", func.getFunctionName(), -2147352153));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "debug", "(" + Type.getDescriptor(Object.class) + ")V", false);
            this.mv.visitLabel(notDebug);
            this.storeRegister(2, -2147352153);
            this.mv.visitJumpInsn(167, afterSyscallLabel);
            this.mv.visitLabel(noError);
        }
        this.logSyscallStart(func);
        if (func.hasStackUsage()) {
            this.loadMemory();
            this.loadRegister(29);
            this.loadImm(func.getStackUsage());
            this.mv.visitInsn(100);
            this.loadImm(0);
            this.loadImm(func.getStackUsage());
            this.mv.visitMethodInsn(182, memoryInternalName, "memset", "(IBI)V", false);
        }
        CompilerParameterReader parameterReader = new CompilerParameterReader(this);
        this.loadModule(func.getModuleName());
        parameterReader.incrementCurrentStackSize();
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchSceKernelErrorException = new Label();
        this.mv.visitTryCatchBlock(tryStart, tryEnd, catchSceKernelErrorException, Type.getInternalName(SceKernelErrorException.class));
        Class<?>[] parameterTypes = func.getHLEModuleMethod().getParameterTypes();
        Class<?> returnType = func.getHLEModuleMethod().getReturnType();
        StringBuilder methodDescriptor = new StringBuilder();
        methodDescriptor.append("(");
        Annotation[][] paramsAnotations = func.getHLEModuleMethod().getParameterAnnotations();
        int paramIndex = 0;
        for (Class<?> parameterType : parameterTypes) {
            methodDescriptor.append(Type.getDescriptor(parameterType));
            this.loadParameter(parameterReader, func, parameterType, paramsAnotations[paramIndex], afterSyscallLabel, catchSceKernelErrorException);
            ++paramIndex;
        }
        methodDescriptor.append(")");
        methodDescriptor.append(Type.getDescriptor(returnType));
        this.mv.visitLabel(tryStart);
        this.mv.visitMethodInsn(182, Type.getInternalName(func.getHLEModuleMethod().getDeclaringClass()), func.getFunctionName(), methodDescriptor.toString(), false);
        this.storeReturnValue(func, returnType);
        if (parameterReader.hasErrorPointer()) {
            this.mv.visitVarInsn(25, 5);
            this.loadImm(0);
            this.mv.visitMethodInsn(182, Type.getInternalName(TErrorPointer32.class), "setValue", "(I)V", false);
        }
        this.loadRegister(2);
        this.logSyscallEnd(func, false);
        this.mv.visitInsn(87);
        this.mv.visitLabel(tryEnd);
        this.mv.visitJumpInsn(167, afterSyscallLabel);
        this.mv.visitLabel(catchSceKernelErrorException);
        this.mv.visitFieldInsn(180, Type.getInternalName(SceKernelErrorException.class), "errorCode", "I");
        this.logSyscallEnd(func, true);
        if (parameterReader.hasErrorPointer()) {
            this.mv.visitVarInsn(25, 5);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, Type.getInternalName(TErrorPointer32.class), "setValue", "(I)V", false);
            this.storeRegister(2, 0);
        } else {
            this.storeRegister(2);
        }
        CodeInstruction previousInstruction = this.codeBlock.getCodeInstruction(this.codeInstruction.getAddress() - 4);
        if (previousInstruction != null && previousInstruction.getInsn() == Instructions.JR) {
            int jumpRegister = previousInstruction.getOpcode() >> 21 & 0x1F;
            this.loadRegister(jumpRegister);
        }
        this.mv.visitLabel(afterSyscallLabel);
        if (fastSyscall) {
            this.invokeStaticMethod(runtimeContextInternalName, "postSyscallFast", "()V");
        } else {
            this.invokeStaticMethod(runtimeContextInternalName, "postSyscall", "()V");
        }
        if (needFirmwareVersionCheck) {
            Label afterVersionCheckLabel = new Label();
            this.mv.visitJumpInsn(167, afterVersionCheckLabel);
            this.mv.visitLabel(unsupportedVersionLabel);
            this.loadModuleLoggger(func);
            this.mv.visitLdcInsn((Object)String.format("%s is not supported in firmware version %d, it requires at least firmware version %d", func.getFunctionName(), RuntimeContext.firmwareVersion, func.getFirmwareVersion()));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "warn", "(" + Type.getDescriptor(Object.class) + ")V", false);
            this.storeRegister(2, -1);
            this.mv.visitLabel(afterVersionCheckLabel);
        }
        if (func.canModifyCode()) {
            this.mv.visitTypeInsn(187, Type.getInternalName(StackPopException.class));
            this.mv.visitInsn(90);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(183, Type.getInternalName(StackPopException.class), "<init>", "(I)V", false);
            this.mv.visitInsn(191);
        }
    }

    public void visitSyscall(int opcode) {
        this.flushInstructionCount(false, false);
        this.loadImm(this.getCodeInstruction().getAddress());
        this.mv.visitFieldInsn(179, runtimeContextInternalName, "syscallRa", "I");
        int code = opcode >> 6 & 0xFFFFF;
        NIDMapper nidMapper = NIDMapper.getInstance();
        int syscallAddr = nidMapper.getAddressBySyscall(code);
        if (syscallAddr != 0) {
            if (log.isDebugEnabled()) {
                String name = nidMapper.getNameBySyscall(code);
                if (name != null) {
                    log.debug((Object)String.format("Calling overwritten HLE method '%s' instead of syscall", name));
                } else {
                    log.debug((Object)String.format("Calling NID 0x%08X from module '%s'", nidMapper.getNidBySyscall(code), nidMapper.getModuleNameBySyscall(code)));
                }
            }
            this.invokeStaticMethod(CompilerContext.getClassName(syscallAddr, this.instanceIndex), this.getStaticExecMethodName(), this.getStaticExecMethodDesc());
            this.mv.visitInsn(87);
        } else {
            boolean lleSyscall;
            HLEModuleFunction func = HLEModuleManager.getInstance().getFunctionFromSyscallCode(code);
            boolean fastSyscall = this.isFastSyscall(code);
            boolean bl = lleSyscall = func == null && RuntimeContextLLE.isLLEActive();
            if (!fastSyscall && !lleSyscall) {
                this.storePc();
            }
            boolean destroyTempRegisters = true;
            if (code == 21) {
                destroyTempRegisters = false;
            }
            if (func == null) {
                boolean inDelaySlot = this.getCodeInstruction() != null ? this.getCodeInstruction().isDelaySlot() : false;
                this.loadImm(code);
                this.loadImm(inDelaySlot);
                if (lleSyscall) {
                    this.invokeStaticMethod(runtimeContextInternalName, "syscallLLE", "(IZ)I");
                } else if (fastSyscall) {
                    this.invokeStaticMethod(runtimeContextInternalName, "syscallFast", "(IZ)I");
                } else {
                    this.invokeStaticMethod(runtimeContextInternalName, "syscall", "(IZ)I");
                }
                if (this.getCodeInstruction() != null) {
                    if (inDelaySlot) {
                        this.visitContinueToAddressInRegister(31);
                    } else {
                        this.visitContinueToAddress(this.getCodeInstruction().getAddress() + 4, false);
                    }
                } else {
                    this.mv.visitInsn(87);
                }
            } else {
                this.visitSyscall(func, fastSyscall);
                if (func.getNid() == -1 || func.getNid() == -1) {
                    destroyTempRegisters = false;
                }
            }
            if (destroyTempRegisters && !lleSyscall) {
                int deadbeef = -559038737;
                this.storeRegister(4, deadbeef);
                this.storeRegister(5, deadbeef);
                this.storeRegister(6, deadbeef);
                this.storeRegister(7, deadbeef);
                this.storeRegister(8, deadbeef);
                this.storeRegister(9, deadbeef);
                this.storeRegister(10, deadbeef);
                this.storeRegister(11, deadbeef);
                this.storeRegister(12, deadbeef);
                this.storeRegister(13, deadbeef);
                this.storeRegister(14, deadbeef);
                this.storeRegister(15, deadbeef);
                this.storeRegister(24, deadbeef);
                this.storeRegister(25, deadbeef);
                this.prepareHiloForStore();
                this.mv.visitLdcInsn((Object)-2401053088876216593L);
                this.storeHilo();
            }
        }
        this.loadImm(0);
        this.mv.visitFieldInsn(179, runtimeContextInternalName, "syscallRa", "I");
        if (this.getCodeBlock().getLength() == 1 || this.getCodeBlock().getCodeInstruction(this.codeInstruction.getAddress() - 4) == null) {
            this.loadImm(this.codeInstruction.getAddress() + 4);
            this.visitJump();
        }
    }

    public void startClass(ClassVisitor cv) {
        cv.visitSource(this.getCodeBlock().getClassName() + ".java", null);
    }

    public void startSequenceMethod() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "cpu", cpuDescriptor);
        this.mv.visitVarInsn(58, 0);
        if (this.enableIntructionCounting) {
            this.currentInstructionCount = 0;
            this.mv.visitInsn(3);
            this.storeLocalVar(1);
        }
        this.startNonBranchingCodeSequence();
    }

    public void endSequenceMethod() {
        this.flushInstructionCount(false, true);
        this.mv.visitInsn(177);
    }

    public void checkSync() {
        Label doNotWantSync = new Label();
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "wantSync", "Z");
        this.mv.visitJumpInsn(153, doNotWantSync);
        this.storePc();
        this.invokeStaticMethod(runtimeContextInternalName, "sync", "()V");
        this.mv.visitLabel(doNotWantSync);
    }

    private void saveParametersToLocals() {
        for (int i = 0; i < 8; ++i) {
            this.loadRegister(4 + i);
            this.storeLocalVar(10 + i);
        }
        this.maxLocalSize = 18;
        this.parametersSavedToLocals = true;
    }

    private void startHLEMethod() {
        HLEModuleFunction func = Utilities.getHLEFunctionByAddress(this.codeBlock.getStartAddress());
        this.codeBlock.setHLEFunction(func);
        if (this.codeBlock.isHLEFunction()) {
            this.saveParametersToLocals();
            this.logSyscallStart(this.codeBlock.getHLEFunction());
        }
    }

    private void endHLEMethod() {
        if (this.codeBlock.isHLEFunction()) {
            this.loadRegister(2);
            this.logSyscallEnd(this.codeBlock.getHLEFunction(), false);
            this.mv.visitInsn(87);
        }
    }

    private void startInternalMethod() {
        Label notReplacedLabel = new Label();
        this.mv.visitFieldInsn(178, this.codeBlock.getClassName(), this.getReplaceFieldName(), executableDescriptor);
        this.mv.visitJumpInsn(198, notReplacedLabel);
        this.mv.visitFieldInsn(178, this.codeBlock.getClassName(), this.getReplaceFieldName(), executableDescriptor);
        this.mv.visitMethodInsn(185, executableInternalName, this.getExecMethodName(), this.getExecMethodDesc(), true);
        this.mv.visitInsn(172);
        this.mv.visitLabel(notReplacedLabel);
        if (Profiler.isProfilerEnabled()) {
            this.loadImm(this.getCodeBlock().getStartAddress());
            this.invokeStaticMethod(profilerInternalName, "addCall", "(I)V");
        }
        if (RuntimeContext.debugCodeBlockCalls) {
            this.loadImm(this.getCodeBlock().getStartAddress());
            this.invokeStaticMethod(runtimeContextInternalName, "debugCodeBlockStart", "(I)V");
        }
    }

    public void startMethod() {
        this.startInternalMethod();
        this.startSequenceMethod();
        this.startHLEMethod();
    }

    private void flushInstructionCount(boolean local, boolean last) {
        if (this.enableIntructionCounting) {
            if (local) {
                if (this.currentInstructionCount > 0) {
                    this.mv.visitIincInsn(1, this.currentInstructionCount);
                }
            } else {
                this.mv.visitFieldInsn(178, runtimeContextInternalName, "currentThread", sceKernalThreadInfoDescriptor);
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(180, sceKernalThreadInfoInternalName, "runClocks", "J");
                this.loadLocalVar(1);
                if (this.currentInstructionCount > 0) {
                    this.loadImm(this.currentInstructionCount);
                    this.mv.visitInsn(96);
                }
                if (Profiler.isProfilerEnabled()) {
                    this.mv.visitInsn(89);
                    this.loadImm(this.getCodeBlock().getStartAddress());
                    this.invokeStaticMethod(profilerInternalName, "addInstructionCount", "(II)V");
                }
                this.mv.visitInsn(133);
                this.mv.visitInsn(97);
                this.mv.visitFieldInsn(181, sceKernalThreadInfoInternalName, "runClocks", "J");
                if (!last) {
                    this.mv.visitInsn(3);
                    this.storeLocalVar(1);
                }
            }
            this.currentInstructionCount = 0;
        }
    }

    private void endInternalMethod() {
        if (RuntimeContext.debugCodeBlockCalls) {
            this.mv.visitInsn(89);
            this.loadImm(this.getCodeBlock().getStartAddress());
            this.mv.visitInsn(95);
            this.invokeStaticMethod(runtimeContextInternalName, "debugCodeBlockEnd", "(II)V");
        }
    }

    public void endMethod() {
        this.endInternalMethod();
        this.endHLEMethod();
        this.flushInstructionCount(false, true);
    }

    public void beforeInstruction(CodeInstruction codeInstruction) {
        if (this.enableIntructionCounting) {
            if (codeInstruction.isBranchTarget()) {
                this.flushInstructionCount(true, false);
            }
            ++this.currentInstructionCount;
        }
        codeInstruction.getLabel(false);
    }

    private void startNonBranchingCodeSequence() {
        this.vfpuPfxsState.reset();
        this.vfpuPfxtState.reset();
        this.vfpuPfxdState.reset();
    }

    private boolean isNonBranchingCodeSequence(CodeInstruction codeInstruction) {
        return !codeInstruction.isBranchTarget() && !codeInstruction.isBranching();
    }

    private boolean previousInstructionModifiesInterruptState(CodeInstruction codeInstruction) {
        CodeInstruction previousInstruction = this.getCodeBlock().getCodeInstruction(codeInstruction.getAddress() - 4);
        if (previousInstruction == null) {
            return false;
        }
        return previousInstruction.hasFlags(65536);
    }

    private void startInstructionLLE(CodeInstruction codeInstruction) {
        if (codeInstruction.isDelaySlot()) {
            return;
        }
        if (!codeInstruction.isBranchTarget() && !this.previousInstructionModifiesInterruptState(codeInstruction)) {
            return;
        }
        Label noPendingInterrupt = new Label();
        this.mv.visitFieldInsn(178, runtimeContextLLEInternalName, "pendingInterruptIPbitsMain", "I");
        this.mv.visitJumpInsn(153, noPendingInterrupt);
        int returnAddress = codeInstruction.getAddress();
        this.loadImm(returnAddress);
        this.invokeStaticMethod(runtimeContextLLEInternalName, "checkPendingInterruptException", "(I)I");
        this.visitContinueToAddress(returnAddress, false);
        this.mv.visitLabel(noPendingInterrupt);
    }

    public void startInstruction(CodeInstruction codeInstruction) {
        int lineNumber = codeInstruction.getAddress() - this.getCodeBlock().getLowestAddress();
        if (lineNumber >= 0 && lineNumber <= 65535) {
            this.mv.visitLineNumber(lineNumber, codeInstruction.getLabel());
        }
        if (Memory.getInstance() instanceof DebuggerMemory || RuntimeContextLLE.isLLEActive() || RuntimeContextLLE.hasMMIO()) {
            this.storePc();
        }
        if (RuntimeContextLLE.isLLEActive()) {
            this.startInstructionLLE(codeInstruction);
        }
        if (RuntimeContext.enableDebugger) {
            this.loadImm(codeInstruction.getAddress());
            this.invokeStaticMethod(runtimeContextInternalName, "syncDebugger", "(I)V");
        }
        if (!this.isNonBranchingCodeSequence(codeInstruction)) {
            this.startNonBranchingCodeSequence();
        }
        if (codeInstruction.hasFlags(2048)) {
            this.disablePfxSrc(this.vfpuPfxtState);
        }
    }

    private void disablePfxSrc(VfpuPfxSrcState pfxSrcState) {
        pfxSrcState.pfxSrc.enabled = false;
        pfxSrcState.setKnown(true);
    }

    private void disablePfxDst(VfpuPfxDstState pfxDstState) {
        pfxDstState.pfxDst.enabled = false;
        pfxDstState.setKnown(true);
    }

    public void endInstruction() {
        if (this.codeInstruction != null) {
            if (this.codeInstruction.hasFlags(256)) {
                this.disablePfxSrc(this.vfpuPfxsState);
            }
            if (this.codeInstruction.hasFlags(512)) {
                this.disablePfxSrc(this.vfpuPfxtState);
            }
            if (this.codeInstruction.hasFlags(1024)) {
                this.disablePfxDst(this.vfpuPfxdState);
            }
        }
    }

    public void startJump(int targetAddress) {
        if (targetAddress <= this.getCodeInstruction().getAddress()) {
            this.checkSync();
            if (Profiler.isProfilerEnabled()) {
                this.loadImm(this.getCodeInstruction().getAddress());
                this.invokeStaticMethod(profilerInternalName, "addBackBranch", "(I)V");
            }
        }
    }

    public void visitJump(int opcode, CodeInstruction target) {
        this.visitJump(opcode, target.getLabel());
    }

    public void visitJump(int opcode, Label label) {
        this.flushInstructionCount(true, false);
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitJump(int opcode, int address) {
        this.flushInstructionCount(true, false);
        if (opcode == 167) {
            this.loadImm(address);
            this.visitJump();
        } else {
            Label jumpTarget = new Label();
            Label notJumpTarget = new Label();
            this.mv.visitJumpInsn(opcode, jumpTarget);
            this.mv.visitJumpInsn(167, notJumpTarget);
            this.mv.visitLabel(jumpTarget);
            this.loadImm(address);
            this.visitJump();
            this.mv.visitLabel(notJumpTarget);
        }
    }

    public static String getClassName(int address, int instanceIndex) {
        return String.format("_S1_%d_0x%08X", instanceIndex, address);
    }

    public static int getClassAddress(String name) {
        String hexAddress = name.substring(name.lastIndexOf("0x") + 2);
        if (hexAddress.length() == 8) {
            return (int)Long.parseLong(hexAddress, 16);
        }
        return Integer.parseInt(hexAddress, 16);
    }

    public static int getClassInstanceIndex(String name) {
        int startIndex = name.indexOf("_", 1);
        int endIndex = name.lastIndexOf("_");
        String instanceIndex = name.substring(startIndex + 1, endIndex);
        return Integer.parseInt(instanceIndex);
    }

    public String getExecMethodName() {
        return "exec";
    }

    public String getExecMethodDesc() {
        return "()I";
    }

    public String getReplaceFieldName() {
        return "e";
    }

    public String getReplaceMethodName() {
        return "setExecutable";
    }

    public String getReplaceMethodDesc() {
        return "(" + executableDescriptor + ")V";
    }

    public String getGetMethodName() {
        return "getExecutable";
    }

    public String getGetMethodDesc() {
        return "()" + executableDescriptor;
    }

    public String getStaticExecMethodName() {
        return "s";
    }

    public String getStaticExecMethodDesc() {
        return "()I";
    }

    public boolean isAutomaticMaxLocals() {
        return false;
    }

    public int getMaxLocals() {
        return this.maxLocalSize;
    }

    public boolean isAutomaticMaxStack() {
        return false;
    }

    public int getMaxStack() {
        return this.maxStackSize;
    }

    public void visitPauseEmuWithStatus(MethodVisitor mv, int status) {
        this.loadImm(status);
        this.invokeStaticMethod(runtimeContextInternalName, "pauseEmuWithStatus", "(I)V");
    }

    public void visitLogError(MethodVisitor mv, String message) {
        mv.visitLdcInsn((Object)message);
        this.invokeStaticMethod(runtimeContextInternalName, "logError", "(" + stringDescriptor + ")V");
    }

    @Override
    public MethodVisitor getMethodVisitor() {
        return this.mv;
    }

    public void setMethodVisitor(MethodVisitor mv) {
        this.mv = mv;
    }

    @Override
    public CodeInstruction getCodeInstruction() {
        return this.codeInstruction;
    }

    @Override
    public CodeInstruction getCodeInstruction(int address) {
        return this.getCodeBlock().getCodeInstruction(address);
    }

    public void setCodeInstruction(CodeInstruction codeInstruction) {
        this.codeInstruction = codeInstruction;
    }

    @Override
    public int getSaValue() {
        return this.codeInstruction.getSaValue();
    }

    @Override
    public int getRsRegisterIndex() {
        return this.codeInstruction.getRsRegisterIndex();
    }

    @Override
    public int getRtRegisterIndex() {
        return this.codeInstruction.getRtRegisterIndex();
    }

    @Override
    public int getRdRegisterIndex() {
        return this.codeInstruction.getRdRegisterIndex();
    }

    @Override
    public void loadRs() {
        this.loadRegister(this.getRsRegisterIndex());
    }

    @Override
    public void loadRt() {
        this.loadRegister(this.getRtRegisterIndex());
    }

    @Override
    public void loadRd() {
        this.loadRegister(this.getRdRegisterIndex());
    }

    @Override
    public void loadSaValue() {
        this.loadImm(this.getSaValue());
    }

    public void loadRegisterIndex(int registerIndex) {
        this.loadImm(registerIndex);
    }

    public void loadRsIndex() {
        this.loadRegisterIndex(this.getRsRegisterIndex());
    }

    public void loadRtIndex() {
        this.loadRegisterIndex(this.getRtRegisterIndex());
    }

    public void loadRdIndex() {
        this.loadRegisterIndex(this.getRdRegisterIndex());
    }

    public void loadFdIndex() {
        this.loadRegisterIndex(this.getFdRegisterIndex());
    }

    public void loadFsIndex() {
        this.loadRegisterIndex(this.getFsRegisterIndex());
    }

    public void loadFtIndex() {
        this.loadRegisterIndex(this.getFtRegisterIndex());
    }

    @Override
    public int getImm16(boolean signedImm) {
        return this.codeInstruction.getImm16(signedImm);
    }

    @Override
    public int getImm14(boolean signedImm) {
        return this.codeInstruction.getImm14(signedImm);
    }

    @Override
    public void loadImm16(boolean signedImm) {
        this.loadImm(this.getImm16(signedImm));
    }

    @Override
    public void loadImm(int imm) {
        switch (imm) {
            case -1: {
                this.mv.visitInsn(2);
                break;
            }
            case 0: {
                this.mv.visitInsn(3);
                break;
            }
            case 1: {
                this.mv.visitInsn(4);
                break;
            }
            case 2: {
                this.mv.visitInsn(5);
                break;
            }
            case 3: {
                this.mv.visitInsn(6);
                break;
            }
            case 4: {
                this.mv.visitInsn(7);
                break;
            }
            case 5: {
                this.mv.visitInsn(8);
                break;
            }
            default: {
                if (-128 <= imm && imm < 127) {
                    this.mv.visitIntInsn(16, imm);
                    break;
                }
                if (Short.MIN_VALUE <= imm && imm < Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, imm);
                    break;
                }
                this.mv.visitLdcInsn((Object)imm);
            }
        }
    }

    public void loadImm(boolean imm) {
        this.mv.visitInsn(imm ? 4 : 3);
    }

    public void loadPspNaNInt() {
        this.mv.visitFieldInsn(178, Type.getInternalName(VfpuState.class), "pspNaNint", "I");
    }

    @Override
    public void compileInterpreterInstruction() {
        this.visitIntepreterCall(this.codeInstruction.getOpcode(), this.codeInstruction.getInsn());
    }

    @Override
    public void compileRTRSIMM(String method, boolean signedImm) {
        this.loadCpu();
        this.loadRtIndex();
        this.loadRsIndex();
        this.loadImm16(signedImm);
        this.mv.visitMethodInsn(182, cpuInternalName, method, "(III)V", false);
    }

    @Override
    public void compileRDRT(String method) {
        this.loadCpu();
        this.loadRdIndex();
        this.loadRtIndex();
        this.mv.visitMethodInsn(182, cpuInternalName, method, "(II)V", false);
    }

    @Override
    public void compileFDFSFT(String method) {
        this.loadCpu();
        this.loadFdIndex();
        this.loadFsIndex();
        this.loadFtIndex();
        this.mv.visitMethodInsn(182, cpuInternalName, method, "(III)V", false);
    }

    @Override
    public void storeRd() {
        this.storeRegister(this.getRdRegisterIndex());
    }

    @Override
    public void storeRd(int constantValue) {
        this.storeRegister(this.getRdRegisterIndex(), constantValue);
    }

    @Override
    public void storeRt() {
        this.storeRegister(this.getRtRegisterIndex());
    }

    @Override
    public void storeRt(int constantValue) {
        this.storeRegister(this.getRtRegisterIndex(), constantValue);
    }

    @Override
    public boolean isRdRegister0() {
        return this.getRdRegisterIndex() == 0;
    }

    @Override
    public boolean isRtRegister0() {
        return this.getRtRegisterIndex() == 0;
    }

    @Override
    public boolean isRsRegister0() {
        return this.getRsRegisterIndex() == 0;
    }

    @Override
    public void prepareRdForStore() {
        this.prepareRegisterForStore(this.getRdRegisterIndex());
    }

    @Override
    public void prepareRtForStore() {
        this.prepareRegisterForStore(this.getRtRegisterIndex());
    }

    private void loadMemoryInt() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "memoryInt", "[I");
    }

    private boolean useMMIO() {
        if (this.codeInstruction == null) {
            return false;
        }
        return this.codeInstruction.useMMIO();
    }

    @Override
    public void memRead32(int registerIndex, int offset, boolean align32) {
        if (this.useMMIO()) {
            this.loadMMIO();
        } else if (!RuntimeContext.hasMemoryInt()) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.prepareMemIndex(registerIndex, offset, true, 32, align32);
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            this.mv.visitMethodInsn(182, memoryInternalName, "read32", "(I)I", false);
        } else {
            this.mv.visitInsn(46);
        }
    }

    @Override
    public void memRead16(int registerIndex, int offset) {
        if (this.useMMIO()) {
            this.loadMMIO();
        } else if (!RuntimeContext.hasMemoryInt()) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            this.mv.visitMethodInsn(182, memoryInternalName, "read16", "(I)I", false);
        } else {
            if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryRead16", "(II)I");
                this.loadImm(1);
                this.mv.visitInsn(124);
            } else {
                this.loadImm(3);
                this.mv.visitInsn(120);
                this.loadImm(4);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(89);
            this.loadImm(1);
            this.mv.visitInsn(126);
            this.loadImm(4);
            this.mv.visitInsn(120);
            this.storeTmp1();
            this.loadImm(1);
            this.mv.visitInsn(124);
            this.mv.visitInsn(46);
            this.loadTmp1();
            this.mv.visitInsn(124);
            this.loadImm(65535);
            this.mv.visitInsn(126);
        }
    }

    @Override
    public void memRead8(int registerIndex, int offset) {
        if (this.useMMIO()) {
            this.loadMMIO();
        } else if (!RuntimeContext.hasMemoryInt()) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            this.mv.visitMethodInsn(182, memoryInternalName, "read8", "(I)I", false);
        } else {
            if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryRead8", "(II)I");
            } else {
                this.loadImm(3);
                this.mv.visitInsn(120);
                this.loadImm(3);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(89);
            this.loadImm(3);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            this.loadImm(2);
            this.mv.visitInsn(124);
            this.mv.visitInsn(46);
            this.loadTmp1();
            this.mv.visitInsn(124);
            this.loadImm(255);
            this.mv.visitInsn(126);
        }
    }

    private void prepareMemIndex(int registerIndex, int offset, boolean isRead, int width, boolean align32) {
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (!this.useMMIO() && RuntimeContext.hasMemoryInt()) {
            if (registerIndex == 29) {
                if (this.isCodeInstructionInKernelMemory()) {
                    this.loadImm(3);
                    this.mv.visitInsn(120);
                    this.loadImm(5);
                    this.mv.visitInsn(124);
                } else {
                    this.loadImm(2);
                    this.mv.visitInsn(124);
                }
            } else if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                String checkMethodName = String.format("checkMemory%s%d", isRead ? "Read" : "Write", width);
                this.invokeStaticMethod(runtimeContextInternalName, checkMethodName, "(II)I");
                this.loadImm(2);
                this.mv.visitInsn(124);
            } else {
                this.loadImm(3);
                this.mv.visitInsn(120);
                this.loadImm(5);
                this.mv.visitInsn(124);
            }
        } else if (align32) {
            this.loadImm(-4);
            this.mv.visitInsn(126);
        }
    }

    @Override
    public void prepareMemWrite32(int registerIndex, int offset, boolean align32) {
        if (this.useMMIO()) {
            this.loadMMIO();
        } else if (!RuntimeContext.hasMemoryInt()) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.prepareMemIndex(registerIndex, offset, false, 32, align32);
        this.memWritePrepared = true;
    }

    @Override
    public void memWrite32(int registerIndex, int offset, boolean align32) {
        if (!this.memWritePrepared) {
            if (this.useMMIO()) {
                this.loadMMIO();
            } else if (!RuntimeContext.hasMemoryInt()) {
                this.loadMemory();
            } else {
                this.loadMemoryInt();
            }
            this.mv.visitInsn(95);
            this.loadRegister(registerIndex);
            if (offset != 0) {
                this.loadImm(offset);
                this.mv.visitInsn(96);
            }
            if (align32) {
                this.loadImm(-4);
                this.mv.visitInsn(126);
            }
            if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryWrite32", "(II)I");
            }
            this.mv.visitInsn(95);
        }
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            this.mv.visitMethodInsn(182, memoryInternalName, "write32", "(II)V", false);
        } else {
            this.mv.visitInsn(79);
        }
        this.memWritePrepared = false;
    }

    @Override
    public void prepareMemWrite16(int registerIndex, int offset) {
        if (this.useMMIO()) {
            this.loadMMIO();
        } else if (!RuntimeContext.hasMemoryInt()) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (!this.useMMIO() && RuntimeContext.hasMemoryInt() && this.checkMemoryAccess()) {
            this.loadImm(this.codeInstruction.getAddress());
            this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryWrite16", "(II)I");
        }
        this.memWritePrepared = true;
    }

    @Override
    public void memWrite16(int registerIndex, int offset) {
        if (!this.memWritePrepared) {
            if (this.useMMIO()) {
                this.loadMMIO();
            } else if (!RuntimeContext.hasMemoryInt()) {
                this.loadMemory();
            } else {
                this.loadMemoryInt();
            }
            this.mv.visitInsn(95);
            this.loadRegister(registerIndex);
            if (offset != 0) {
                this.loadImm(offset);
                this.mv.visitInsn(96);
            }
            if (RuntimeContext.hasMemoryInt() && this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryWrite16", "(II)I");
            }
            this.mv.visitInsn(95);
        }
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            this.mv.visitMethodInsn(182, memoryInternalName, "write16", "(IS)V", false);
        } else {
            this.loadImm(65535);
            this.mv.visitInsn(126);
            this.storeTmp2();
            this.mv.visitInsn(89);
            this.loadImm(2);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            if (this.checkMemoryAccess()) {
                this.loadImm(2);
                this.mv.visitInsn(122);
            } else {
                this.loadImm(3);
                this.mv.visitInsn(120);
                this.loadImm(5);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(92);
            this.mv.visitInsn(46);
            this.loadImm(65535);
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.loadImm(-1);
            this.mv.visitInsn(130);
            this.mv.visitInsn(126);
            this.loadTmp2();
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.mv.visitInsn(128);
            this.mv.visitInsn(79);
        }
        this.memWritePrepared = false;
    }

    @Override
    public void prepareMemWrite8(int registerIndex, int offset) {
        if (this.useMMIO()) {
            this.loadMMIO();
        } else if (!RuntimeContext.hasMemoryInt()) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (!this.useMMIO() && RuntimeContext.hasMemoryInt() && this.checkMemoryAccess()) {
            this.loadImm(this.codeInstruction.getAddress());
            this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryWrite8", "(II)I");
        }
        this.memWritePrepared = true;
    }

    @Override
    public void memWrite8(int registerIndex, int offset) {
        if (!this.memWritePrepared) {
            if (this.useMMIO()) {
                this.loadMMIO();
            } else if (!RuntimeContext.hasMemoryInt()) {
                this.loadMemory();
            } else {
                this.loadMemoryInt();
            }
            this.mv.visitInsn(95);
            this.loadRegister(registerIndex);
            if (offset != 0) {
                this.loadImm(offset);
                this.mv.visitInsn(96);
            }
            if (RuntimeContext.hasMemoryInt() && this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryWrite8", "(II)I");
            }
            this.mv.visitInsn(95);
        }
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            this.mv.visitMethodInsn(182, memoryInternalName, "write8", "(IB)V", false);
        } else {
            this.loadImm(255);
            this.mv.visitInsn(126);
            this.storeTmp2();
            this.mv.visitInsn(89);
            this.loadImm(3);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            if (this.checkMemoryAccess()) {
                this.loadImm(2);
                this.mv.visitInsn(122);
            } else {
                this.loadImm(3);
                this.mv.visitInsn(120);
                this.loadImm(5);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(92);
            this.mv.visitInsn(46);
            this.loadImm(255);
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.loadImm(-1);
            this.mv.visitInsn(130);
            this.mv.visitInsn(126);
            this.loadTmp2();
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.mv.visitInsn(128);
            this.mv.visitInsn(79);
        }
        this.memWritePrepared = false;
    }

    @Override
    public void memWriteZero8(int registerIndex, int offset) {
        if (this.useMMIO()) {
            this.loadMMIO();
        } else if (!RuntimeContext.hasMemoryInt()) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (!this.useMMIO() && RuntimeContext.hasMemoryInt() && this.checkMemoryAccess()) {
            this.loadImm(this.codeInstruction.getAddress());
            this.invokeStaticMethod(runtimeContextInternalName, "checkMemoryWrite8", "(II)I");
        }
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            this.loadImm(0);
            this.mv.visitMethodInsn(182, memoryInternalName, "write8", "(IB)V", false);
        } else {
            this.mv.visitInsn(89);
            this.loadImm(3);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            if (this.checkMemoryAccess()) {
                this.loadImm(2);
                this.mv.visitInsn(122);
            } else {
                this.loadImm(3);
                this.mv.visitInsn(120);
                this.loadImm(5);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(92);
            this.mv.visitInsn(46);
            this.loadImm(255);
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.loadImm(-1);
            this.mv.visitInsn(130);
            this.mv.visitInsn(126);
            this.mv.visitInsn(79);
        }
    }

    @Override
    public void compileSyscall() {
        this.visitSyscall(this.codeInstruction.getOpcode());
    }

    @Override
    public void convertUnsignedIntToLong() {
        this.mv.visitInsn(133);
        this.mv.visitLdcInsn((Object)0xFFFFFFFFL);
        this.mv.visitInsn(127);
    }

    public int getMethodMaxInstructions() {
        return this.methodMaxInstructions;
    }

    public void setMethodMaxInstructions(int methodMaxInstructions) {
        this.methodMaxInstructions = methodMaxInstructions;
    }

    private boolean checkMemoryAccess() {
        if (!RuntimeContext.hasMemoryInt()) {
            return false;
        }
        return RuntimeContext.memory instanceof SafeFastMemory;
    }

    public void compileDelaySlotAsBranchTarget(CodeInstruction codeInstruction) {
        if (codeInstruction.getInsn() == Instructions.NOP) {
            return;
        }
        boolean skipDelaySlotInstruction = true;
        CodeInstruction previousInstruction = this.getCodeBlock().getCodeInstruction(codeInstruction.getAddress() - 4);
        if (previousInstruction != null && Compiler.isEndBlockInsn(previousInstruction.getAddress(), previousInstruction.getOpcode(), previousInstruction.getInsn())) {
            skipDelaySlotInstruction = false;
        }
        Label afterDelaySlot = null;
        if (skipDelaySlotInstruction) {
            afterDelaySlot = new Label();
            this.mv.visitJumpInsn(167, afterDelaySlot);
        }
        codeInstruction.compile(this, this.mv);
        if (skipDelaySlotInstruction) {
            this.mv.visitLabel(afterDelaySlot);
        }
    }

    public void compileExecuteInterpreter(int startAddress) {
        this.loadImm(startAddress);
        this.invokeStaticMethod(runtimeContextInternalName, "executeInterpreter", "(I)I");
        this.endMethod();
        this.mv.visitInsn(172);
    }

    private void visitNativeCodeSequence(NativeCodeSequence nativeCodeSequence, int address, NativeCodeInstruction nativeCodeInstruction) {
        StringBuilder methodSignature = new StringBuilder("(");
        int numberParameters = nativeCodeSequence.getNumberParameters();
        for (int i = 0; i < numberParameters; ++i) {
            this.loadImm(nativeCodeSequence.getParameterValue(i, address));
            methodSignature.append("I");
        }
        if (nativeCodeSequence.isMethodReturning()) {
            methodSignature.append(")I");
        } else {
            methodSignature.append(")V");
        }
        this.invokeStaticMethod(Type.getInternalName(nativeCodeSequence.getNativeCodeSequenceClass()), nativeCodeSequence.getMethodName(), methodSignature.toString());
        if (nativeCodeInstruction != null && nativeCodeInstruction.isBranching()) {
            this.startJump(nativeCodeInstruction.getBranchingTo());
            CodeInstruction targetInstruction = this.getCodeBlock().getCodeInstruction(nativeCodeInstruction.getBranchingTo());
            if (targetInstruction != null) {
                this.visitJump(167, targetInstruction);
            } else {
                this.visitJump(167, nativeCodeInstruction.getBranchingTo());
            }
        }
    }

    public void compileNativeCodeSequence(NativeCodeSequence nativeCodeSequence, NativeCodeInstruction nativeCodeInstruction) {
        this.storePc();
        this.visitNativeCodeSequence(nativeCodeSequence, nativeCodeInstruction.getAddress(), nativeCodeInstruction);
        if (nativeCodeSequence.isReturning()) {
            this.loadRegister(31);
            this.endInternalMethod();
            this.mv.visitInsn(172);
        } else if (nativeCodeSequence.isMethodReturning()) {
            this.endInternalMethod();
            this.mv.visitInsn(172);
        }
        if (this.getCodeBlock().getLength() == nativeCodeSequence.getNumOpcodes() && !nativeCodeSequence.hasBranchInstruction()) {
            this.nativeCodeManager.setCompiledNativeCodeBlock(this.getCodeBlock().getStartAddress(), nativeCodeSequence);
            if (log.isDebugEnabled() || nativeCodeSequence.getNativeCodeSequenceClass().equals(Nop.class)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Replacing CodeBlock at 0x%08X (%08X-0x%08X, length %d) by %s", this.getCodeBlock().getStartAddress(), this.getCodeBlock().getLowestAddress(), this.codeBlock.getHighestAddress(), this.codeBlock.getLength(), nativeCodeSequence));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Replacing CodeBlock at 0x%08X by Native Code '%s'", this.getCodeBlock().getStartAddress(), nativeCodeSequence.getName()));
            }
        } else {
            int endAddress = this.getCodeInstruction().getAddress() + (nativeCodeSequence.getNumOpcodes() - 1) * 4;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Replacing CodeSequence at 0x%08X-0x%08X by Native Code %s", this.getCodeInstruction().getAddress(), endAddress, nativeCodeSequence));
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Replacing CodeSequence at 0x%08X-0x%08X by Native Code '%s'", this.getCodeInstruction().getAddress(), endAddress, nativeCodeSequence.getName()));
            }
        }
    }

    public int getNumberInstructionsToBeSkipped() {
        return this.numberInstructionsToBeSkipped;
    }

    public boolean isSkipDelaySlot() {
        return this.skipDelaySlot;
    }

    @Override
    public void skipInstructions(int numberInstructionsToBeSkipped, boolean skipDelaySlot) {
        this.numberInstructionsToBeSkipped = numberInstructionsToBeSkipped;
        this.skipDelaySlot = skipDelaySlot;
    }

    @Override
    public int getFdRegisterIndex() {
        return this.codeInstruction.getFdRegisterIndex();
    }

    @Override
    public int getFsRegisterIndex() {
        return this.codeInstruction.getFsRegisterIndex();
    }

    @Override
    public int getFtRegisterIndex() {
        return this.codeInstruction.getFtRegisterIndex();
    }

    @Override
    public void loadFd() {
        this.loadFRegister(this.getFdRegisterIndex());
    }

    @Override
    public void loadFs() {
        this.loadFRegister(this.getFsRegisterIndex());
    }

    @Override
    public void loadFt() {
        this.loadFRegister(this.getFtRegisterIndex());
    }

    @Override
    public void prepareFdForStore() {
        this.prepareFRegisterForStore(this.getFdRegisterIndex());
    }

    @Override
    public void prepareFtForStore() {
        this.prepareFRegisterForStore(this.getFtRegisterIndex());
    }

    @Override
    public void storeFd() {
        this.storeFRegister(this.getFdRegisterIndex());
    }

    @Override
    public void storeFt() {
        this.storeFRegister(this.getFtRegisterIndex());
    }

    @Override
    public void loadFCr() {
        this.loadFRegister(this.getCrValue());
    }

    @Override
    public void prepareFCrForStore() {
        this.prepareFRegisterForStore(this.getCrValue());
    }

    @Override
    public void prepareVcrCcForStore(int cc) {
        if (this.preparedRegisterForStore < 0) {
            this.loadVcr();
            this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), "cc", "[Z");
            this.loadImm(cc);
            this.preparedRegisterForStore = cc;
        }
    }

    @Override
    public void storeVcrCc(int cc) {
        if (this.preparedRegisterForStore == cc) {
            this.mv.visitInsn(84);
            this.preparedRegisterForStore = -1;
        } else {
            this.loadVcr();
            this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), "cc", "[Z");
            this.mv.visitInsn(95);
            this.loadImm(cc);
            this.mv.visitInsn(95);
            this.mv.visitInsn(84);
        }
    }

    @Override
    public int getCrValue() {
        return this.codeInstruction.getCrValue();
    }

    @Override
    public void storeFCr() {
        this.storeFRegister(this.getCrValue());
    }

    @Override
    public int getVdRegisterIndex() {
        return this.codeInstruction.getVdRegisterIndex();
    }

    @Override
    public int getVsRegisterIndex() {
        return this.codeInstruction.getVsRegisterIndex();
    }

    @Override
    public int getVtRegisterIndex() {
        return this.codeInstruction.getVtRegisterIndex();
    }

    @Override
    public int getVsize() {
        return this.codeInstruction.getVsize();
    }

    @Override
    public void loadVs(int n) {
        this.loadVRegister(this.getVsize(), this.getVsRegisterIndex(), n, this.vfpuPfxsState, true);
    }

    @Override
    public void loadVsInt(int n) {
        this.loadVRegister(this.getVsize(), this.getVsRegisterIndex(), n, this.vfpuPfxsState, false);
    }

    @Override
    public void loadVt(int n) {
        this.loadVRegister(this.getVsize(), this.getVtRegisterIndex(), n, this.vfpuPfxtState, true);
    }

    @Override
    public void loadVtInt(int n) {
        this.loadVRegister(this.getVsize(), this.getVtRegisterIndex(), n, this.vfpuPfxtState, false);
    }

    @Override
    public void loadVt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVtRegisterIndex(), n, this.vfpuPfxtState, true);
    }

    @Override
    public void loadVtInt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVtRegisterIndex(), n, this.vfpuPfxtState, false);
    }

    @Override
    public void loadVt(int vsize, int vt, int n) {
        this.loadVRegister(vsize, vt, n, this.vfpuPfxtState, true);
    }

    @Override
    public void loadVtInt(int vsize, int vt, int n) {
        this.loadVRegister(vsize, vt, n, this.vfpuPfxtState, false);
    }

    @Override
    public void loadVd(int n) {
        this.loadVRegister(this.getVsize(), this.getVdRegisterIndex(), n, null, true);
    }

    @Override
    public void loadVdInt(int n) {
        this.loadVRegister(this.getVsize(), this.getVdRegisterIndex(), n, null, false);
    }

    @Override
    public void loadVd(int vsize, int n) {
        this.loadVRegister(vsize, this.getVdRegisterIndex(), n, null, true);
    }

    @Override
    public void loadVdInt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVdRegisterIndex(), n, null, false);
    }

    @Override
    public void loadVd(int vsize, int vd, int n) {
        this.loadVRegister(vsize, vd, n, null, true);
    }

    @Override
    public void loadVdInt(int vsize, int vd, int n) {
        this.loadVRegister(vsize, vd, n, null, false);
    }

    @Override
    public void prepareVdForStore(int n) {
        this.prepareVdForStore(this.getVsize(), n);
    }

    @Override
    public void prepareVdForStore(int vsize, int n) {
        this.prepareVdForStore(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void prepareVdForStore(int vsize, int vd, int n) {
        if (!this.pfxVdOverlap || n >= vsize - 1) {
            this.prepareVRegisterForStore(vsize, vd, n, this.vfpuPfxdState, true);
        }
    }

    @Override
    public void prepareVdForStoreInt(int n) {
        this.prepareVdForStoreInt(this.getVsize(), n);
    }

    @Override
    public void prepareVdForStoreInt(int vsize, int n) {
        this.prepareVdForStoreInt(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void prepareVdForStoreInt(int vsize, int vd, int n) {
        if (!this.pfxVdOverlap || n >= vsize - 1) {
            this.prepareVRegisterForStore(vsize, vd, n, this.vfpuPfxdState, false);
        }
    }

    @Override
    public void prepareVtForStore(int n) {
        this.prepareVRegisterForStore(this.getVsize(), this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void prepareVtForStore(int vsize, int n) {
        this.prepareVRegisterForStore(vsize, this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void prepareVtForStoreInt(int n) {
        this.prepareVRegisterForStore(this.getVsize(), this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void prepareVtForStoreInt(int vsize, int n) {
        this.prepareVRegisterForStore(vsize, this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void storeVd(int n) {
        this.storeVd(this.getVsize(), n);
    }

    @Override
    public void storeVdInt(int n) {
        this.storeVdInt(this.getVsize(), n);
    }

    @Override
    public void storeVd(int vsize, int n) {
        this.storeVd(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void storeVdInt(int vsize, int n) {
        this.storeVdInt(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void storeVd(int vsize, int vd, int n) {
        if (this.pfxVdOverlap && n < vsize - 1) {
            this.storeFTmpVd(n, true);
        } else {
            this.storeVRegister(vsize, vd, n, this.vfpuPfxdState, true);
        }
    }

    @Override
    public void storeVdInt(int vsize, int vd, int n) {
        if (this.pfxVdOverlap && n < vsize - 1) {
            this.storeFTmpVd(n, false);
        } else {
            this.storeVRegister(vsize, vd, n, this.vfpuPfxdState, false);
        }
    }

    @Override
    public void storeVt(int n) {
        this.storeVRegister(this.getVsize(), this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void storeVtInt(int n) {
        this.storeVRegister(this.getVsize(), this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void storeVt(int vsize, int n) {
        this.storeVRegister(vsize, this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void storeVtInt(int vsize, int n) {
        this.storeVRegister(vsize, this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void storeVt(int vsize, int vt, int n) {
        this.storeVRegister(vsize, vt, n, null, true);
    }

    @Override
    public void storeVtInt(int vsize, int vt, int n) {
        this.storeVRegister(vsize, vt, n, null, false);
    }

    @Override
    public void prepareVtForStore(int vsize, int vt, int n) {
        this.prepareVRegisterForStore(vsize, vt, n, null, true);
    }

    @Override
    public void prepareVtForStoreInt(int vsize, int vt, int n) {
        this.prepareVRegisterForStore(vsize, vt, n, null, false);
    }

    @Override
    public int getImm7() {
        return this.codeInstruction.getImm7();
    }

    @Override
    public int getImm5() {
        return this.codeInstruction.getImm5();
    }

    @Override
    public int getImm4() {
        return this.codeInstruction.getImm4();
    }

    @Override
    public int getImm3() {
        return this.codeInstruction.getImm3();
    }

    @Override
    public void loadVs(int vsize, int n) {
        this.loadVRegister(vsize, this.getVsRegisterIndex(), n, this.vfpuPfxsState, true);
    }

    @Override
    public void loadVsInt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVsRegisterIndex(), n, this.vfpuPfxsState, false);
    }

    @Override
    public void loadVs(int vsize, int vs, int n) {
        this.loadVRegister(vsize, vs, n, this.vfpuPfxsState, true);
    }

    @Override
    public void loadVsInt(int vsize, int vs, int n) {
        this.loadVRegister(vsize, vs, n, this.vfpuPfxsState, false);
    }

    @Override
    public void loadTmp1() {
        this.loadLocalVar(3);
    }

    @Override
    public void loadTmp2() {
        this.loadLocalVar(4);
    }

    @Override
    public void loadLTmp1() {
        this.mv.visitVarInsn(22, 3);
    }

    @Override
    public void loadFTmp1() {
        this.mv.visitVarInsn(23, 3);
    }

    @Override
    public void loadFTmp2() {
        this.mv.visitVarInsn(23, 4);
    }

    @Override
    public void loadFTmp3() {
        this.mv.visitVarInsn(23, 5);
    }

    @Override
    public void loadFTmp4() {
        this.mv.visitVarInsn(23, 6);
    }

    private void loadFTmpVd(int n, boolean isFloat) {
        int opcode;
        int n2 = opcode = isFloat ? 23 : 21;
        if (n == 0) {
            this.mv.visitVarInsn(opcode, 7);
        } else if (n == 1) {
            this.mv.visitVarInsn(opcode, 8);
        } else {
            this.mv.visitVarInsn(opcode, 9);
        }
    }

    @Override
    public void storeTmp1() {
        this.storeLocalVar(3);
    }

    @Override
    public void storeTmp2() {
        this.storeLocalVar(4);
    }

    @Override
    public void storeLTmp1() {
        this.mv.visitVarInsn(55, 3);
    }

    @Override
    public void storeFTmp1() {
        this.mv.visitVarInsn(56, 3);
    }

    @Override
    public void storeFTmp2() {
        this.mv.visitVarInsn(56, 4);
    }

    @Override
    public void storeFTmp3() {
        this.mv.visitVarInsn(56, 5);
    }

    @Override
    public void storeFTmp4() {
        this.mv.visitVarInsn(56, 6);
    }

    private void storeFTmpVd(int n, boolean isFloat) {
        int opcode;
        int n2 = opcode = isFloat ? 56 : 54;
        if (n == 0) {
            this.mv.visitVarInsn(opcode, 7);
        } else if (n == 1) {
            this.mv.visitVarInsn(opcode, 8);
        } else {
            this.mv.visitVarInsn(opcode, 9);
        }
    }

    @Override
    public VfpuPfxDstState getPfxdState() {
        return this.vfpuPfxdState;
    }

    @Override
    public VfpuPfxSrcState getPfxsState() {
        return this.vfpuPfxsState;
    }

    @Override
    public VfpuPfxSrcState getPfxtState() {
        return this.vfpuPfxtState;
    }

    private void startPfxCompiled(VfpuPfxState vfpuPfxState, String name, String descriptor, String internalName, boolean isFloat) {
        if (vfpuPfxState.isUnknown()) {
            if (this.interpretPfxLabel == null) {
                this.interpretPfxLabel = new Label();
            }
            this.loadVcr();
            this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), name, descriptor);
            this.mv.visitFieldInsn(180, internalName, "enabled", "Z");
            this.mv.visitJumpInsn(154, this.interpretPfxLabel);
        }
    }

    @Override
    public void startPfxCompiled() {
        this.startPfxCompiled(true);
    }

    @Override
    public void startPfxCompiled(boolean isFloat) {
        this.interpretPfxLabel = null;
        if (this.codeInstruction.hasFlags(256)) {
            this.startPfxCompiled(this.vfpuPfxsState, "pfxs", Type.getDescriptor(VfpuState.Vcr.PfxSrc.class), Type.getInternalName(VfpuState.Vcr.PfxSrc.class), isFloat);
        }
        if (this.codeInstruction.hasFlags(512)) {
            this.startPfxCompiled(this.vfpuPfxtState, "pfxt", Type.getDescriptor(VfpuState.Vcr.PfxSrc.class), Type.getInternalName(VfpuState.Vcr.PfxSrc.class), isFloat);
        }
        if (this.codeInstruction.hasFlags(1024)) {
            this.startPfxCompiled(this.vfpuPfxdState, "pfxd", Type.getDescriptor(VfpuState.Vcr.PfxDst.class), Type.getInternalName(VfpuState.Vcr.PfxDst.class), isFloat);
        }
        this.pfxVdOverlap = false;
        if (this.getCodeInstruction().hasFlags(1280)) {
            this.pfxVdOverlap |= this.isVsVdOverlap();
        }
        if (this.getCodeInstruction().hasFlags(1536)) {
            this.pfxVdOverlap |= this.isVtVdOverlap();
        }
        if (this.getCodeInstruction().getInsn() == Instructions.VMMOV && this.pfxVdOverlap) {
            log.error((Object)String.format("pfxVdOverlap for %s", this.getCodeInstruction()));
        }
    }

    @Override
    public void endPfxCompiled() {
        this.endPfxCompiled(true);
    }

    @Override
    public void endPfxCompiled(boolean isFloat) {
        this.endPfxCompiled(this.getVsize(), isFloat);
    }

    @Override
    public void endPfxCompiled(int vsize) {
        this.endPfxCompiled(vsize, true);
    }

    @Override
    public void endPfxCompiled(int vsize, boolean isFloat) {
        this.endPfxCompiled(vsize, isFloat, true);
    }

    @Override
    public void endPfxCompiled(int vsize, boolean isFloat, boolean doFlush) {
        if (doFlush) {
            this.flushPfxCompiled(vsize, this.getVdRegisterIndex(), isFloat);
        }
        if (this.interpretPfxLabel != null) {
            Label continueLabel = new Label();
            this.mv.visitJumpInsn(167, continueLabel);
            this.mv.visitLabel(this.interpretPfxLabel);
            this.compileInterpreterInstruction();
            this.mv.visitLabel(continueLabel);
            this.interpretPfxLabel = null;
        }
        this.pfxVdOverlap = false;
    }

    @Override
    public void flushPfxCompiled(int vsize, int vd, boolean isFloat) {
        if (this.pfxVdOverlap) {
            this.pfxVdOverlap = false;
            for (int n = 0; n < vsize - 1; ++n) {
                if (isFloat) {
                    this.prepareVdForStore(vsize, vd, n);
                } else {
                    this.prepareVdForStoreInt(vsize, vd, n);
                }
                this.loadFTmpVd(n, isFloat);
                if (isFloat) {
                    this.storeVd(vsize, vd, n);
                    continue;
                }
                this.storeVdInt(vsize, vd, n);
            }
            this.pfxVdOverlap = true;
        }
    }

    @Override
    public boolean isPfxConsumed(int flag) {
        CodeInstruction codeInstruction;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("PFX -> %08X: %s", this.getCodeInstruction().getAddress(), this.getCodeInstruction().getInsn().disasm(this.getCodeInstruction().getAddress(), this.getCodeInstruction().getOpcode())));
        }
        int address = this.getCodeInstruction().getAddress();
        do {
            codeInstruction = this.getCodeBlock().getCodeInstruction(address += 4);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("PFX    %08X: %s", codeInstruction.getAddress(), codeInstruction.getInsn().disasm(codeInstruction.getAddress(), codeInstruction.getOpcode())));
            }
            if (codeInstruction != null && this.isNonBranchingCodeSequence(codeInstruction)) continue;
            return false;
        } while (!codeInstruction.hasFlags(flag));
        return codeInstruction.hasFlags(4096) && !codeInstruction.hasFlags(1);
    }

    private boolean isVxVdOverlap(VfpuPfxSrcState pfxSrcState, int registerIndex) {
        if (!pfxSrcState.isKnown()) {
            return false;
        }
        int vsize = this.getVsize();
        int vd = this.getVdRegisterIndex();
        if (registerIndex != vd) {
            if (vsize != 3) {
                return false;
            }
            if ((registerIndex & 0x3F) != (vd & 0x3F)) {
                return false;
            }
        }
        if (!pfxSrcState.pfxSrc.enabled) {
            return true;
        }
        for (int n = 0; n < vsize; ++n) {
            if (pfxSrcState.pfxSrc.cst[n] || pfxSrcState.pfxSrc.swz[n] == n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVsVdOverlap() {
        return this.isVxVdOverlap(this.vfpuPfxsState, this.getVsRegisterIndex());
    }

    @Override
    public boolean isVtVdOverlap() {
        return this.isVxVdOverlap(this.vfpuPfxtState, this.getVtRegisterIndex());
    }

    private boolean canUseVFPUInt(int vsize) {
        if (this.vfpuPfxsState.isKnown() && this.vfpuPfxsState.pfxSrc.enabled) {
            for (int i = 0; i < vsize; ++i) {
                if (this.vfpuPfxsState.pfxSrc.swz[i] == i) continue;
                return false;
            }
        }
        return !this.vfpuPfxdState.isKnown() || !this.vfpuPfxdState.pfxDst.enabled;
    }

    @Override
    public void compileVFPUInstr(Object cstBefore, int opcode, String mathFunction) {
        int vsize = this.getVsize();
        boolean useVt = this.getCodeInstruction().hasFlags(512);
        if (mathFunction == null && opcode == 0 && !useVt && cstBefore == null && this.canUseVFPUInt(vsize)) {
            this.startPfxCompiled(false);
            for (int n = 0; n < vsize; ++n) {
                this.prepareVdForStoreInt(n);
                this.loadVsInt(n);
                this.storeVdInt(n);
            }
            this.endPfxCompiled(vsize, false);
        } else {
            this.startPfxCompiled(true);
            for (int n = 0; n < vsize; ++n) {
                this.prepareVdForStore(n);
                if (cstBefore != null) {
                    this.mv.visitLdcInsn(cstBefore);
                }
                this.loadVs(n);
                if (useVt) {
                    this.loadVt(n);
                }
                if (mathFunction != null) {
                    if ("abs".equals(mathFunction)) {
                        this.invokeStaticMethod(Type.getInternalName(Math.class), mathFunction, "(F)F");
                    } else if ("max".equals(mathFunction) || "min".equals(mathFunction)) {
                        this.invokeStaticMethod(Type.getInternalName(Math.class), mathFunction, "(FF)F");
                    } else {
                        this.mv.visitInsn(141);
                        this.invokeStaticMethod(Type.getInternalName(Math.class), mathFunction, "(D)D");
                        this.mv.visitInsn(144);
                    }
                }
                Label doneStore = null;
                if (opcode != 0) {
                    Label doneOpcode = null;
                    if (opcode == 110 && cstBefore == null) {
                        doneOpcode = new Label();
                        doneStore = new Label();
                        Label notZeroByZero = new Label();
                        Label notZeroByZeroPop = new Label();
                        this.mv.visitInsn(92);
                        this.mv.visitInsn(11);
                        this.mv.visitInsn(150);
                        this.mv.visitJumpInsn(154, notZeroByZeroPop);
                        this.mv.visitInsn(11);
                        this.mv.visitInsn(150);
                        this.mv.visitJumpInsn(154, notZeroByZero);
                        this.convertVFloatToInt();
                        this.loadImm(Integer.MIN_VALUE);
                        this.mv.visitInsn(126);
                        this.mv.visitInsn(95);
                        this.convertVFloatToInt();
                        this.loadImm(Integer.MIN_VALUE);
                        this.mv.visitInsn(126);
                        this.mv.visitInsn(130);
                        this.storeTmp1();
                        this.mv.visitInsn(94);
                        this.mv.visitInsn(88);
                        this.loadPspNaNInt();
                        this.loadTmp1();
                        this.mv.visitInsn(128);
                        int preparedRegister = this.preparedRegisterForStore;
                        this.storeVdInt(n);
                        this.preparedRegisterForStore = preparedRegister;
                        this.mv.visitJumpInsn(167, doneStore);
                        this.mv.visitLabel(notZeroByZeroPop);
                        this.mv.visitInsn(87);
                        this.mv.visitLabel(notZeroByZero);
                    }
                    this.mv.visitInsn(opcode);
                    if (doneOpcode != null) {
                        this.mv.visitLabel(doneOpcode);
                    }
                }
                this.storeVd(n);
                if (doneStore == null) continue;
                this.mv.visitLabel(doneStore);
            }
            this.endPfxCompiled(vsize, true);
        }
    }

    public void visitHook(NativeCodeSequence nativeCodeSequence) {
        this.invokeStaticMethod(Type.getInternalName(nativeCodeSequence.getNativeCodeSequenceClass()), nativeCodeSequence.getMethodName(), "()V");
    }

    @Override
    public boolean compileVFPULoad(int registerIndex, int offset, int vt, int count) {
        if (!RuntimeContext.hasMemoryInt()) {
            return false;
        }
        if ((vt & 0x20) != 0) {
            return false;
        }
        this.loadMemoryInt();
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (this.checkMemoryAccess()) {
            this.loadImm(this.getCodeInstruction().getAddress());
            this.invokeStaticMethod(Type.getInternalName(RuntimeContext.class), "checkMemoryRead32", "(II)I");
            this.loadImm(2);
            this.mv.visitInsn(124);
        } else {
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.loadImm(5);
            this.mv.visitInsn(124);
        }
        this.loadVprInt();
        int vprIndex = VfpuState.getVprIndex(vt >> 2 & 7, vt & 3, (vt & 0x40) >> 6);
        this.loadImm(vprIndex);
        this.loadImm(count);
        this.invokeStaticMethod(Type.getInternalName(System.class), "arraycopy", arraycopyDescriptor);
        for (int i = 0; i < count; ++i) {
            this.loadVprFloat();
            this.loadImm(vprIndex + i);
            this.loadVprInt();
            this.loadImm(vprIndex + i);
            this.mv.visitInsn(46);
            this.convertVIntToFloat();
            this.mv.visitInsn(81);
        }
        return true;
    }

    @Override
    public boolean compileVFPUStore(int registerIndex, int offset, int vt, int count) {
        if (!RuntimeContext.hasMemoryInt()) {
            return false;
        }
        if ((vt & 0x20) != 0) {
            return false;
        }
        this.loadVprInt();
        int vprIndex = VfpuState.getVprIndex(vt >> 2 & 7, vt & 3, (vt & 0x40) >> 6);
        this.loadImm(vprIndex);
        this.loadMemoryInt();
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (this.checkMemoryAccess()) {
            this.loadImm(this.getCodeInstruction().getAddress());
            this.invokeStaticMethod(Type.getInternalName(RuntimeContext.class), "checkMemoryWrite32", "(II)I");
            this.loadImm(2);
            this.mv.visitInsn(124);
        } else {
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.loadImm(5);
            this.mv.visitInsn(124);
        }
        this.loadImm(count);
        this.invokeStaticMethod(Type.getInternalName(System.class), "arraycopy", arraycopyDescriptor);
        return true;
    }

    public void optimizeSequence(List<CodeInstruction> codeInstructions) {
        CodeInstruction codeInstruction;
        if (!RuntimeContext.hasMemoryInt()) {
            return;
        }
        if (Profiler.isProfilerEnabled()) {
            return;
        }
        if (State.debugger != null) {
            return;
        }
        int decreaseSpInstruction = -1;
        int stackSize = 0;
        int currentInstructionIndex = 0;
        int maxSpOffset = Integer.MAX_VALUE;
        int swSequenceCount = 0;
        int[] storeSpInstructions = null;
        int[] storeSpRegisters = null;
        LinkedList<CodeInstruction> storeSpCodeInstructions = null;
        boolean[] modifiedRegisters = new boolean[32];
        Arrays.fill(modifiedRegisters, false);
        Iterator<CodeInstruction> iterator = codeInstructions.iterator();
        while (!(!iterator.hasNext() || (codeInstruction = iterator.next()).isBranching() || codeInstruction.hasFlags(4) || codeInstruction.isBranchTarget() && this.codeBlock.getStartAddress() != codeInstruction.getAddress())) {
            int simm16;
            int rt;
            int rs;
            Common.Instruction insn = codeInstruction.getInsn();
            if (decreaseSpInstruction >= 0 && insn == Instructions.SW) {
                rs = codeInstruction.getRsRegisterIndex();
                rt = codeInstruction.getRtRegisterIndex();
                if (rs == 29) {
                    simm16 = codeInstruction.getImm16(true);
                    if (!modifiedRegisters[rt]) {
                        int index;
                        if (simm16 >= 0 && simm16 < stackSize && (simm16 & 3) == 0 && simm16 < maxSpOffset && storeSpInstructions[index = simm16 >> 2] < 0) {
                            storeSpCodeInstructions.add(codeInstruction);
                            storeSpInstructions[index] = currentInstructionIndex;
                            storeSpRegisters[index] = rt;
                            ++swSequenceCount;
                        }
                    } else {
                        maxSpOffset = Math.min(maxSpOffset, simm16);
                    }
                }
            }
            if (insn == Instructions.ADDI || insn == Instructions.ADDIU) {
                rs = codeInstruction.getRsRegisterIndex();
                rt = codeInstruction.getRtRegisterIndex();
                simm16 = codeInstruction.getImm16(true);
                if (rt == 29 && rs == 29 && simm16 < 0) {
                    if (decreaseSpInstruction >= 0) break;
                    decreaseSpInstruction = currentInstructionIndex;
                    stackSize = -codeInstruction.getImm16(true);
                    storeSpInstructions = new int[stackSize >> 2];
                    Arrays.fill(storeSpInstructions, -1);
                    storeSpRegisters = new int[storeSpInstructions.length];
                    Arrays.fill(storeSpRegisters, -1);
                    storeSpCodeInstructions = new LinkedList<CodeInstruction>();
                } else if (rs == 29 && simm16 >= 0) {
                    maxSpOffset = Math.min(maxSpOffset, simm16);
                }
            } else if (insn == Instructions.ADD || insn == Instructions.ADDU) {
                rs = codeInstruction.getRsRegisterIndex();
                rt = codeInstruction.getRtRegisterIndex();
                if (rs == 29 || rt == 29) {
                    break;
                }
            } else if (insn == Instructions.LW || insn == Instructions.SWC1 || insn == Instructions.LWC1) {
                rs = codeInstruction.getRsRegisterIndex();
                int simm162 = codeInstruction.getImm16(true);
                if (rs == 29 && simm162 >= 0) {
                    maxSpOffset = Math.min(maxSpOffset, simm162);
                }
            } else if (insn == Instructions.SVQ || insn == Instructions.LVQ) {
                rs = codeInstruction.getRsRegisterIndex();
                int simm14 = codeInstruction.getImm14(true);
                if (rs == 29 && simm14 >= 0) {
                    maxSpOffset = Math.min(maxSpOffset, simm14);
                }
            }
            if (codeInstruction.hasFlags(8192)) {
                modifiedRegisters[codeInstruction.getRtRegisterIndex()] = true;
            }
            if (codeInstruction.hasFlags(16384)) {
                modifiedRegisters[codeInstruction.getRdRegisterIndex()] = true;
            }
            if (maxSpOffset <= 0) break;
            ++currentInstructionIndex;
        }
        if (swSequenceCount > 1) {
            int[] offsets = new int[swSequenceCount];
            int[] registers = new int[swSequenceCount];
            int index = 0;
            for (int i = 0; i < storeSpInstructions.length && index < swSequenceCount; ++i) {
                if (storeSpInstructions[i] < 0) continue;
                offsets[index] = i << 2;
                registers[index] = storeSpRegisters[i];
                ++index;
            }
            codeInstructions.removeAll(storeSpCodeInstructions);
            SequenceSWCodeInstruction sequenceSWCodeInstruction = new SequenceSWCodeInstruction(29, offsets, registers);
            sequenceSWCodeInstruction.setAddress(((CodeInstruction)storeSpCodeInstructions.get(0)).getAddress());
            codeInstructions.add(decreaseSpInstruction + 1, sequenceSWCodeInstruction);
        }
    }

    private boolean compileSWsequenceZR(int baseRegister, int[] offsets, int[] registers) {
        int copyLength;
        int i;
        for (i = 0; i < registers.length; ++i) {
            if (registers[i] == 0) continue;
            return false;
        }
        for (i = 1; i < offsets.length; ++i) {
            if (offsets[i] == offsets[i - 1] + 4) continue;
            return false;
        }
        int offset = offsets[0];
        int length = offsets.length;
        do {
            copyLength = Math.min(length, FastMemory.zero.length);
            this.mv.visitFieldInsn(178, Type.getInternalName(FastMemory.class), "zero", "[I");
            this.loadImm(0);
            this.loadMemoryInt();
            this.prepareMemIndex(baseRegister, offset, false, 32, false);
            this.loadImm(copyLength);
            this.invokeStaticMethod(Type.getInternalName(System.class), "arraycopy", arraycopyDescriptor);
            offset += copyLength;
        } while ((length -= copyLength) > 0);
        return true;
    }

    private boolean compileSWLWsequence(int baseRegister, int[] offsets, int[] registers, boolean isLW) {
        if (this.useMMIO() || !RuntimeContext.hasMemoryInt()) {
            return false;
        }
        if (Profiler.isProfilerEnabled()) {
            return false;
        }
        if (State.debugger != null) {
            return false;
        }
        if (!isLW && this.compileSWsequenceZR(baseRegister, offsets, registers)) {
            return true;
        }
        int offset = offsets[0];
        this.prepareMemIndex(baseRegister, offset, isLW, 32, false);
        this.storeTmp1();
        for (int i = 0; i < offsets.length; ++i) {
            int rt = registers[i];
            if (offset != offsets[i]) {
                this.mv.visitIincInsn(3, offsets[i] - offset >> 2);
                offset = offsets[i];
            }
            if (isLW) {
                if (rt == 0) continue;
                this.prepareRegisterForStore(rt);
                this.loadMemoryInt();
                this.loadTmp1();
                this.mv.visitInsn(46);
                this.storeRegister(rt);
                continue;
            }
            this.loadMemoryInt();
            this.loadTmp1();
            this.loadRegister(rt);
            this.mv.visitInsn(79);
        }
        return true;
    }

    @Override
    public boolean compileSWsequence(int baseRegister, int[] offsets, int[] registers) {
        return this.compileSWLWsequence(baseRegister, offsets, registers, false);
    }

    @Override
    public boolean compileLWsequence(int baseRegister, int[] offsets, int[] registers) {
        return this.compileSWLWsequence(baseRegister, offsets, registers, true);
    }

    public void compileEret() {
        this.invokeStaticMethod(runtimeContextInternalName, "executeEret", "()I");
        this.visitJump();
    }

    @Override
    public void compileBreak() {
        this.storePc();
        this.compileInterpreterInstruction();
        boolean isEndingCodeBlock = false;
        if (this.getCodeBlock().getHighestAddress() == this.codeInstruction.getAddress()) {
            isEndingCodeBlock = true;
        } else if (this.getCodeBlock().getHighestAddress() == this.codeInstruction.getAddress() + 4 && this.getCodeInstruction(this.codeInstruction.getAddress() + 4).getInsn() == Instructions.NOP) {
            isEndingCodeBlock = true;
        }
        if (isEndingCodeBlock) {
            this.loadPc();
            this.visitJump();
        }
    }
}

