/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.IExecutable;
import jpcsp.Allegrex.compiler.Profiler;
import jpcsp.Allegrex.compiler.ResetException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Allegrex.compiler.RuntimeSyncThread;
import jpcsp.Allegrex.compiler.RuntimeThread;
import jpcsp.Allegrex.compiler.StackPopException;
import jpcsp.Allegrex.compiler.StopThreadException;
import jpcsp.Allegrex.compiler.StopThreadRuntimeException;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SyscallHandler;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules.reboot;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.Processor;
import jpcsp.State;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.mediaengine.MEProcessor;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.mmio.MMIOHandlerDisplayController;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.sound.SoundChannel;
import jpcsp.util.CpuDurationStatistics;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class RuntimeContext {
    public static Logger log = Logger.getLogger((String)"runtime");
    private static boolean compilerEnabled = true;
    public static float[] fpr;
    public static float[] vprFloat;
    public static int[] vprInt;
    public static int[] memoryInt;
    public static Processor processor;
    public static CpuState cpu;
    public static int syscallRa;
    public static Memory memory;
    public static boolean enableDebugger;
    public static final String debuggerName = "syncDebugger";
    public static boolean debugCodeBlockCalls;
    public static final String debugCodeBlockStart = "debugCodeBlockStart";
    public static final String debugCodeBlockEnd = "debugCodeBlockEnd";
    private static final int debugCodeBlockNumberOfParameters = 6;
    private static final Map<Integer, Integer> debugCodeBlocks;
    public static final boolean debugCodeInstruction = false;
    public static final String debugCodeInstructionName = "debugCodeInstruction";
    public static final boolean debugMemoryRead = false;
    public static final boolean debugMemoryWrite = false;
    public static final boolean debugMemoryReadWriteNoSP = true;
    public static final boolean enableInstructionTypeCounting = false;
    public static final String instructionTypeCount = "instructionTypeCount";
    public static final String logError = "logError";
    public static final String pauseEmuWithStatus = "pauseEmuWithStatus";
    public static final boolean enableLineNumbers = true;
    public static final boolean checkCodeModification = false;
    private static final boolean invalidateAllCodeBlocks = false;
    private static final int idleSleepMicros = 1000;
    private static final Map<Integer, CodeBlock> codeBlocks;
    private static int codeBlocksLowestAddress;
    private static int codeBlocksHighestAddress;
    private static IExecutable[] fastExecutableLookup;
    private static CodeBlockList[] fastCodeBlockLookup;
    private static final int fastCodeBlockLookupShift = 8;
    private static final int fastCodeBlockSize = 64;
    private static final Map<SceKernelThreadInfo, RuntimeThread> threads;
    private static final Map<SceKernelThreadInfo, RuntimeThread> toBeStoppedThreads;
    private static final Map<SceKernelThreadInfo, RuntimeThread> alreadyStoppedThreads;
    private static final List<Thread> alreadySwitchedStoppedThreads;
    private static final Map<SceKernelThreadInfo, RuntimeThread> toBeDeletedThreads;
    public static volatile SceKernelThreadInfo currentThread;
    private static volatile RuntimeThread currentRuntimeThread;
    private static final Object waitForEnd;
    private static volatile Emulator emulator;
    private static volatile boolean isIdle;
    private static volatile boolean reset;
    public static CpuDurationStatistics idleDuration;
    private static Map<Common.Instruction, Integer> instructionTypeCounts;
    public static final boolean enableDaemonThreadSync = true;
    public static final String syncName = "sync";
    public static volatile boolean wantSync;
    private static RuntimeSyncThread runtimeSyncThread;
    private static RuntimeThread syscallRuntimeThread;
    private static sceDisplay sceDisplayModule;
    private static final Object idleSyncObject;
    public static int firmwareVersion;
    private static boolean isHomebrew;
    public static boolean javaThreadScheduling;
    private static int haltCount;

    private static void setCompilerEnabled(boolean enabled) {
        compilerEnabled = enabled;
    }

    public static boolean isCompilerEnabled() {
        return compilerEnabled;
    }

    public static void execute(Common.Instruction insn, int opcode) {
        insn.interpret(processor, opcode);
    }

    private static int jumpCall(int address) throws Exception {
        int returnValue;
        IExecutable executable = RuntimeContext.getExecutable(address);
        if (executable == null) {
            String msg = String.format("jumpCall - Cannot find executable 0x%08X", address);
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        int sp = RuntimeContext.cpu._sp;
        RuntimeThread stackThread = currentRuntimeThread;
        if (stackThread != null && stackThread.isStackMaxSize()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("jumpCall stack already reached maxSize, returning 0x%08X", address));
            }
            throw new StackPopException(address);
        }
        try {
            if (stackThread != null) {
                stackThread.increaseStackSize();
            }
            returnValue = executable.exec();
        }
        catch (StackOverflowError e) {
            log.error((Object)String.format("StackOverflowError stackSize=%d", stackThread.getStackSize()));
            throw e;
        }
        finally {
            if (stackThread != null) {
                stackThread.decreaseStackSize();
            }
        }
        if (stackThread != null && stackThread.isStackMaxSize() && RuntimeContext.cpu._sp > sp) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("jumpCall returning 0x%08X with $sp=0x%08X, start $sp=0x%08X", returnValue, RuntimeContext.cpu._sp, sp));
            }
            throw new StackPopException(returnValue);
        }
        if (debugCodeBlockCalls && log.isDebugEnabled()) {
            log.debug((Object)String.format("jumpCall returning 0x%08X, $v0=0x%08X", returnValue, RuntimeContext.cpu._v0));
        }
        return returnValue;
    }

    public static void jump(int address, int returnAddress) throws Exception {
        if (debugCodeBlockCalls && log.isDebugEnabled()) {
            log.debug((Object)String.format("jump starting address=0x%08X, returnAddress=0x%08X, $sp=0x%08X", address, returnAddress, RuntimeContext.cpu._sp));
        }
        int sp = RuntimeContext.cpu._sp;
        while ((address & 0x1FFFFFFF) != (returnAddress & 0x1FFFFFFF)) {
            try {
                address = RuntimeContext.jumpCall(address);
            }
            catch (StackPopException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("jump catching StackPopException 0x%08X with $sp=0x%08X, start $sp=0x%08X", e.getRa(), RuntimeContext.cpu._sp, sp));
                }
                if ((e.getRa() & 0x1FFFFFFF) == (returnAddress & 0x1FFFFFFF)) break;
                throw e;
            }
        }
        if (debugCodeBlockCalls && log.isDebugEnabled()) {
            log.debug((Object)String.format("jump returning address=0x%08X, returnAddress=0x%08X, $sp=0x%08X", address, returnAddress, RuntimeContext.cpu._sp));
        }
    }

    public static int call(int address) throws Exception {
        if (debugCodeBlockCalls && log.isDebugEnabled()) {
            log.debug((Object)String.format("call address=0x%08X, $ra=0x%08X", address, RuntimeContext.cpu._ra));
        }
        if (address == -2006974464 || address == -1996750848) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Rebooting at address 0x%08X", address));
            }
            Emulator.getInstance().onReboot();
        }
        int returnValue = RuntimeContext.jumpCall(address);
        return returnValue;
    }

    public static int executeInterpreter(int address) throws Exception {
        Memory mmio;
        if (debugCodeBlockCalls && log.isDebugEnabled()) {
            log.debug((Object)String.format("executeInterpreter address=0x%08X", address));
        }
        boolean useMMIO = false;
        if ((!Memory.isAddressGood(address) || Compiler.getInstance().isUsingMMIO(address)) && (mmio = RuntimeContextLLE.getMMIO()) != null) {
            useMMIO = true;
            cpu.setMemory(mmio);
        }
        boolean interpret = true;
        RuntimeContext.cpu.pc = address;
        int returnValue = 0;
        while (interpret) {
            processor.interpret();
            Common.Instruction insn = processor.getInstruction();
            if (insn.hasFlags(64)) {
                if (useMMIO) {
                    cpu.setMemory(memory);
                }
                RuntimeContext.cpu.pc = RuntimeContext.jumpCall(RuntimeContext.cpu.pc);
                if (!useMMIO) continue;
                cpu.setMemory(RuntimeContextLLE.getMMIO());
                continue;
            }
            if (!insn.hasOneFlag(131200) || insn.hasFlags(32)) continue;
            interpret = false;
            returnValue = RuntimeContext.cpu.pc;
        }
        if (useMMIO) {
            cpu.setMemory(memory);
        }
        return returnValue;
    }

    public static void execute(int opcode) {
        Common.Instruction insn = Decoder.instruction(opcode);
        RuntimeContext.execute(insn, opcode);
    }

    private static String getDebugCodeBlockStart(CpuState cpu, int address) {
        Integer numberOfParametersValue;
        int syscallOpcode;
        Common.Instruction syscallInstruction;
        StringBuilder s = new StringBuilder("Starting CodeBlock 0x");
        Utilities.addAddressHex(s, address);
        int syscallAddress = address + 4;
        if (Memory.isAddressGood(syscallAddress) && (syscallInstruction = Decoder.instruction(syscallOpcode = cpu.memory.read32(syscallAddress))) == Instructions.SYSCALL) {
            String syscallDisasm = syscallInstruction.disasm(syscallAddress, syscallOpcode);
            s.append(syscallDisasm.substring(19));
        }
        int numberOfParameters = 6;
        if (!debugCodeBlocks.isEmpty() && (numberOfParametersValue = debugCodeBlocks.get(address)) != null) {
            numberOfParameters = numberOfParametersValue;
        }
        if (numberOfParameters > 0) {
            int maxRegisterParameters = Math.min(numberOfParameters, 8);
            for (int i = 0; i < maxRegisterParameters; ++i) {
                int register = 4 + i;
                int parameterValue = cpu.getRegister(register);
                s.append(", ");
                s.append(Common.gprNames[register]);
                s.append("=0x");
                if (Memory.isAddressGood(parameterValue)) {
                    Utilities.addAddressHex(s, parameterValue);
                    continue;
                }
                Utilities.addHex(s, parameterValue);
            }
        }
        s.append(", $ra=0x");
        Utilities.addAddressHex(s, cpu._ra);
        s.append(", $sp=0x");
        Utilities.addAddressHex(s, cpu._sp);
        return s.toString();
    }

    public static void debugCodeBlockStart(int address) {
        if (!debugCodeBlocks.isEmpty() && debugCodeBlocks.containsKey(address)) {
            if (log.isInfoEnabled()) {
                log.info((Object)RuntimeContext.getDebugCodeBlockStart(cpu, address));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)RuntimeContext.getDebugCodeBlockStart(cpu, address));
        }
    }

    public static void debugCodeBlockStart(CpuState cpu, int address) {
        if (!debugCodeBlocks.isEmpty() && debugCodeBlocks.containsKey(address)) {
            if (log.isInfoEnabled()) {
                log.info((Object)RuntimeContext.getDebugCodeBlockStart(cpu, address));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)RuntimeContext.getDebugCodeBlockStart(cpu, address));
        }
    }

    public static void debugCodeBlockEnd(int address, int returnAddress) {
        if (log.isDebugEnabled()) {
            RuntimeContext.debugCodeBlockEnd(cpu, address, returnAddress);
        }
    }

    public static void debugCodeBlockEnd(CpuState cpu, int address, int returnAddress) {
        if (log.isDebugEnabled()) {
            StringBuilder s = new StringBuilder("Returning from CodeBlock 0x");
            Utilities.addAddressHex(s, address);
            s.append(" to 0x");
            Utilities.addAddressHex(s, returnAddress);
            s.append(", $sp=0x");
            Utilities.addAddressHex(s, cpu._sp);
            s.append(", $v0=0x");
            Utilities.addAddressHex(s, cpu._v0);
            log.debug((Object)s.toString());
        }
    }

    public static void debugCodeInstruction(int address, int opcode) {
        if (log.isTraceEnabled()) {
            RuntimeContext.cpu.pc = address;
            Common.Instruction insn = Decoder.instruction(opcode);
            StringBuilder s = new StringBuilder("Executing 0x");
            Utilities.addAddressHex(s, address);
            s.append(insn.hasFlags(1) ? " I - " : " C - ");
            s.append(insn.disasm(address, opcode));
            log.trace((Object)s.toString());
        }
    }

    private static void initialiseDebugger() {
        enableDebugger = State.debugger != null || memory instanceof DebuggerMemory;
    }

    public static boolean initialise() {
        if (!compilerEnabled) {
            return false;
        }
        if (runtimeSyncThread == null) {
            runtimeSyncThread = new RuntimeSyncThread();
            runtimeSyncThread.setName("Sync Daemon");
            runtimeSyncThread.setDaemon(true);
            runtimeSyncThread.start();
        }
        RuntimeContext.updateMemory();
        RuntimeContext.initialiseDebugger();
        Profiler.initialise();
        sceDisplayModule = Modules.sceDisplayModule;
        fastExecutableLookup = new IExecutable[MemoryMap.SIZE_RAM >> 2];
        fastCodeBlockLookup = new CodeBlockList[MemoryMap.SIZE_RAM >> 8];
        return true;
    }

    public static boolean canExecuteCallback(SceKernelThreadInfo callbackThread) {
        RuntimeThread currentRuntimeThread;
        if (!compilerEnabled) {
            return true;
        }
        if (callbackThread == null) {
            return true;
        }
        if (Modules.ThreadManForUserModule.isIdleThread(callbackThread)) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        return currentThread instanceof RuntimeThread && callbackThread == (currentRuntimeThread = (RuntimeThread)currentThread).getThreadInfo();
    }

    private static void checkPendingCallbacks() {
        if (Modules.ThreadManForUserModule.checkPendingActions()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("A pending action has been executed for the thread", new Object[0]));
            }
            wantSync = true;
        }
        Modules.ThreadManForUserModule.checkPendingCallbacks();
    }

    public static void executeCallback() {
        int pc = RuntimeContext.cpu.pc;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Start of Callback 0x%08X", pc));
        }
        RuntimeContext.switchRealThread(Modules.ThreadManForUserModule.getCurrentThread());
        boolean callbackExited = RuntimeContext.executeFunction(pc);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("End of Callback 0x%08X", pc));
        }
        if (RuntimeContext.cpu.pc == ThreadManForUser.CALLBACK_EXIT_HANDLER_ADDRESS || callbackExited) {
            Modules.ThreadManForUserModule.hleKernelExitCallback(Emulator.getProcessor());
            wantSync = true;
        }
        RuntimeContext.update();
    }

    private static void updateStaticVariables() {
        emulator = Emulator.getInstance();
        processor = Emulator.getProcessor();
        cpu = RuntimeContext.processor.cpu;
        if (cpu != null) {
            fpr = RuntimeContext.processor.cpu.fpr;
            vprFloat = RuntimeContext.processor.cpu.vprFloat;
            vprInt = RuntimeContext.processor.cpu.vprInt;
        }
    }

    public static void updateMemory() {
        memory = Emulator.getMemory();
        memoryInt = memory.getMemoryInt(0);
    }

    public static void update() {
        SceKernelThreadInfo newThread;
        if (!compilerEnabled) {
            return;
        }
        RuntimeContext.updateStaticVariables();
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if ((currentThread == null || IntrManager.getInstance().canExecuteInterruptNow()) && (newThread = threadMan.getCurrentThread()) != null && newThread != currentThread) {
            RuntimeContext.switchThread(newThread);
        }
    }

    private static void switchRealThread(SceKernelThreadInfo threadInfo) {
        RuntimeThread thread = threads.get(threadInfo);
        if (thread == null) {
            thread = new RuntimeThread(threadInfo);
            threads.put(threadInfo, thread);
            thread.start();
        }
        currentThread = threadInfo;
        currentRuntimeThread = thread;
        isIdle = false;
    }

    private static void switchThread(SceKernelThreadInfo threadInfo) {
        if (log.isDebugEnabled()) {
            String name = threadInfo == null ? "Idle" : threadInfo.name;
            if (currentThread == null) {
                log.debug((Object)("Switching to Thread " + name));
            } else {
                log.debug((Object)("Switching from Thread " + RuntimeContext.currentThread.name + " to " + name));
            }
        }
        if (threadInfo == null || Modules.ThreadManForUserModule.isIdleThread(threadInfo)) {
            isIdle = true;
            currentThread = null;
            currentRuntimeThread = null;
        } else if (toBeStoppedThreads.containsKey(threadInfo)) {
            isIdle = true;
            currentThread = null;
            currentRuntimeThread = null;
        } else {
            RuntimeContext.switchRealThread(threadInfo);
        }
    }

    private static void syncIdle() throws StopThreadException {
        if (isIdle) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            Scheduler scheduler = Emulator.getScheduler();
            log.debug((Object)"Starting Idle State...");
            idleDuration.start();
            while (isIdle) {
                RuntimeContext.checkStoppedThread();
                idleDuration.end();
                RuntimeContext.syncEmulator(true);
                idleDuration.start();
                RuntimeContext.syncPause();
                RuntimeContext.checkPendingCallbacks();
                scheduler.step();
                if (threadMan.isIdleThread(threadMan.getCurrentThread())) {
                    threadMan.checkCallbacks();
                    threadMan.hleRescheduleCurrentThread();
                }
                if (!isIdle) continue;
                RuntimeContext.idleSleepInterruptable();
            }
            idleDuration.end();
            log.debug((Object)"Ending Idle State");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void idleSleepInterruptable() {
        Scheduler scheduler = Emulator.getScheduler();
        long delay = scheduler.getNextActionDelay(1000L);
        if (delay > 0L) {
            int intDelay = delay >= 1000L ? 1000 : (int)delay;
            try {
                Object object = idleSyncObject;
                synchronized (object) {
                    idleSyncObject.wait(intDelay / 1000, intDelay % 1000 * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void syncThreadImmediately() throws StopThreadException {
        Thread currentThread = Thread.currentThread();
        if (currentRuntimeThread != null && currentThread != currentRuntimeThread && !alreadySwitchedStoppedThreads.contains(currentThread)) {
            currentRuntimeThread.continueRuntimeExecution();
            if (currentThread instanceof RuntimeThread) {
                RuntimeThread runtimeThread = (RuntimeThread)currentThread;
                if (!alreadyStoppedThreads.containsValue(runtimeThread)) {
                    log.debug((Object)"Waiting to be scheduled...");
                    runtimeThread.suspendRuntimeExecution();
                    log.debug((Object)"Scheduled, restarting...");
                    RuntimeContext.checkStoppedThread();
                    RuntimeContext.updateStaticVariables();
                } else {
                    alreadySwitchedStoppedThreads.add(currentThread);
                }
            }
        }
        RuntimeContext.checkPendingCallbacks();
    }

    private static void syncThread() throws StopThreadException {
        RuntimeContext.syncIdle();
        if (toBeDeletedThreads.containsValue(RuntimeContext.getRuntimeThread())) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        if (log.isDebugEnabled()) {
            log.debug((Object)("syncThread currentThread=" + currentThread.getName() + ", currentRuntimeThread=" + currentRuntimeThread.getName()));
        }
        RuntimeContext.syncThreadImmediately();
    }

    public static RuntimeThread getRuntimeThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof RuntimeThread) {
            return (RuntimeThread)currentThread;
        }
        return null;
    }

    private static boolean isStoppedThread() {
        if (toBeStoppedThreads.isEmpty()) {
            return false;
        }
        RuntimeThread runtimeThread = RuntimeContext.getRuntimeThread();
        return runtimeThread != null && toBeStoppedThreads.containsValue(runtimeThread) && !alreadyStoppedThreads.containsValue(runtimeThread);
    }

    private static void checkStoppedThread() throws StopThreadException {
        if (RuntimeContext.isStoppedThread()) {
            throw new StopThreadException("Stopping Thread " + Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncPause() throws StopThreadException {
        if (Emulator.pause) {
            Emulator.getClock().pause();
            try {
                Emulator emulator = RuntimeContext.emulator;
                synchronized (emulator) {
                    while (Emulator.pause) {
                        RuntimeContext.checkStoppedThread();
                        RuntimeContext.emulator.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                Emulator.getClock().resume();
            }
        }
    }

    public static void syncDebugger(int pc) throws StopThreadException {
        RuntimeContext.processor.cpu.pc = pc;
        if (State.debugger != null) {
            RuntimeContext.syncDebugger();
            RuntimeContext.syncPause();
        } else if (Emulator.pause) {
            RuntimeContext.syncPause();
        }
    }

    private static void syncDebugger() {
        if (State.debugger != null) {
            State.debugger.step();
        }
    }

    private static void syncEmulator(boolean immediately) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("syncEmulator immediately=" + immediately));
        }
        Modules.sceGe_userModule.step();
        Modules.sceDisplayModule.step(immediately);
    }

    private static void syncFast() {
        Modules.sceDisplayModule.step();
    }

    public static void sync() throws StopThreadException {
        do {
            wantSync = false;
            if (!IntrManager.getInstance().canExecuteInterruptNow() && javaThreadScheduling) {
                RuntimeContext.syncFast();
                continue;
            }
            RuntimeContext.syncPause();
            Emulator.getScheduler().step();
            if (processor.isInterruptsEnabled()) {
                Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
            }
            RuntimeContext.syncThread();
            RuntimeContext.syncEmulator(false);
            RuntimeContext.syncDebugger();
            RuntimeContext.syncPause();
            RuntimeContext.checkStoppedThread();
        } while (wantSync);
    }

    public static void preSyscall() throws StopThreadException {
        if (IntrManager.getInstance().canExecuteInterruptNow()) {
            syscallRuntimeThread = RuntimeContext.getRuntimeThread();
            if (syscallRuntimeThread != null) {
                syscallRuntimeThread.setInSyscall(true);
            }
            RuntimeContext.checkStoppedThread();
            RuntimeContext.syncPause();
        }
    }

    public static void postSyscall() throws StopThreadException {
        if (!IntrManager.getInstance().canExecuteInterruptNow()) {
            RuntimeContext.postSyscallFast();
        } else {
            RuntimeContext.checkStoppedThread();
            RuntimeContext.sync();
            if (syscallRuntimeThread != null) {
                syscallRuntimeThread.setInSyscall(false);
            }
        }
    }

    public static int hleSyscall(int result) throws StopThreadRuntimeException {
        if (result >= 0) {
            try {
                RuntimeContext.postSyscall();
            }
            catch (StopThreadException e) {
                throw new StopThreadRuntimeException(e.getMessage());
            }
        }
        return result;
    }

    public static void postSyscallFast() {
        RuntimeContext.syncFast();
    }

    public static void postSyscallLLE() {
        Modules.sceDisplayModule.step();
        RuntimeContext.checkSync();
    }

    public static int syscallFast(int code, boolean inDelaySlot) throws Exception {
        int continueAddress = SyscallHandler.syscall(code, inDelaySlot);
        RuntimeContext.postSyscallFast();
        return continueAddress;
    }

    public static int syscall(int code, boolean inDelaySlot) throws Exception {
        RuntimeContext.preSyscall();
        int continueAddress = SyscallHandler.syscall(code, inDelaySlot);
        RuntimeContext.postSyscall();
        return continueAddress;
    }

    public static int syscallLLE(int code, boolean inDelaySlot) throws Exception {
        int continueAddress = SyscallHandler.syscall(code, inDelaySlot);
        RuntimeContext.postSyscallLLE();
        return continueAddress;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void execWithReturnAddress(IExecutable executable, int returnAddress) throws Exception {
        while (true) {
            try {
                int address = executable.exec();
                if (address == returnAddress) return;
                RuntimeContext.jump(address, returnAddress);
                return;
            }
            catch (StackPopException e) {
                log.debug((Object)"Stack exceeded maximum size, shrinking to top level");
                executable = RuntimeContext.getExecutable(e.getRa());
                if (executable != null) continue;
                throw e;
            }
            catch (ResetException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Processor has to been reset to pc=0x%08X", e.getPc()));
                }
                if ((executable = RuntimeContext.getExecutable(e.getPc())) == null) throw e;
                continue;
            }
            break;
        }
    }

    public static boolean executeFunction(int address) {
        IExecutable executable = RuntimeContext.getExecutable(address);
        if (executable == null) {
            return false;
        }
        int newPc = 0;
        int returnAddress = RuntimeContext.cpu._ra;
        boolean exception = false;
        try {
            RuntimeContext.execWithReturnAddress(executable, returnAddress);
            newPc = returnAddress;
        }
        catch (StopThreadException stopThreadException) {
        }
        catch (StopThreadRuntimeException stopThreadRuntimeException) {
        }
        catch (Exception e) {
            log.error((Object)"Catched Throwable in executeCallback:", (Throwable)e);
            exception = true;
        }
        RuntimeContext.cpu.pc = newPc;
        RuntimeContext.cpu.npc = newPc;
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runThread(RuntimeThread thread) {
        block16: {
            RuntimeContext.setLog4jMDC();
            SoundChannel.setThreadInitContext();
            thread.setInSyscall(true);
            if (RuntimeContext.isStoppedThread()) {
                SoundChannel.clearThreadInitContext();
                return;
            }
            thread.suspendRuntimeExecution();
            if (RuntimeContext.isStoppedThread()) {
                SoundChannel.clearThreadInitContext();
                return;
            }
            thread.onThreadStart();
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            IExecutable executable = RuntimeContext.getExecutable(RuntimeContext.processor.cpu.pc);
            thread.setInSyscall(false);
            try {
                RuntimeContext.updateStaticVariables();
                threadMan.checkPendingCallbacks();
                RuntimeContext.execWithReturnAddress(executable, ThreadManForUser.THREAD_EXIT_HANDLER_ADDRESS);
                threadMan.hleKernelExitThread(RuntimeContext.processor.cpu._v0);
            }
            catch (StopThreadException stopThreadException) {
            }
            catch (StopThreadRuntimeException stopThreadRuntimeException) {
            }
            catch (Throwable e) {
                if (Emulator.exitCalled()) break block16;
                log.error((Object)"Catched Throwable in RuntimeThread:", e);
                e.printStackTrace();
            }
        }
        SoundChannel.clearThreadInitContext();
        SceKernelThreadInfo threadInfo = thread.getThreadInfo();
        alreadyStoppedThreads.put(threadInfo, thread);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of Thread " + threadInfo.name + " - stopped"));
        }
        thread.setInSyscall(true);
        threads.remove(threadInfo);
        toBeStoppedThreads.remove(threadInfo);
        toBeDeletedThreads.remove(threadInfo);
        if (!reset) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("End of Thread " + threadInfo.name + " - sync"));
                }
                RuntimeContext.syncIdle();
                RuntimeContext.syncThreadImmediately();
            }
            catch (StopThreadException stopThreadException) {
            }
            catch (StopThreadRuntimeException stopThreadRuntimeException) {
                // empty catch block
            }
        }
        alreadyStoppedThreads.remove(threadInfo);
        alreadySwitchedStoppedThreads.remove(thread);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of Thread " + thread.getName()));
        }
        Object object = waitForEnd;
        synchronized (object) {
            waitForEnd.notify();
        }
    }

    private static void computeCodeBlocksRange() {
        codeBlocksLowestAddress = Integer.MAX_VALUE;
        codeBlocksHighestAddress = Integer.MIN_VALUE;
        for (CodeBlock codeBlock : codeBlocks.values()) {
            if (codeBlock.isInternal()) continue;
            int lowestAddress = codeBlock.getLowestAddress() & 0x1FFFFFFF;
            int highestAddress = codeBlock.getHighestAddress() & 0x1FFFFFFF;
            codeBlocksLowestAddress = Math.min(codeBlocksLowestAddress, lowestAddress);
            codeBlocksHighestAddress = Math.max(codeBlocksHighestAddress, highestAddress);
        }
    }

    public static void addCodeBlock(int address, CodeBlock codeBlock) {
        int maskedAddress = address & 0x1FFFFFFF;
        CodeBlock previousCodeBlock = codeBlocks.put(maskedAddress, codeBlock);
        if (!codeBlock.isInternal()) {
            int lowestAddress = codeBlock.getLowestAddress() & 0x1FFFFFFF;
            int highestAddress = codeBlock.getHighestAddress() & 0x1FFFFFFF;
            if (previousCodeBlock != null) {
                RuntimeContext.computeCodeBlocksRange();
                int fastExecutableLoopukIndex = maskedAddress - 0x8000000 >> 2;
                if (fastExecutableLoopukIndex >= 0 && fastExecutableLoopukIndex < fastExecutableLookup.length) {
                    RuntimeContext.fastExecutableLookup[fastExecutableLoopukIndex] = null;
                }
            } else {
                codeBlocksLowestAddress = Math.min(codeBlocksLowestAddress, lowestAddress);
                codeBlocksHighestAddress = Math.max(codeBlocksHighestAddress, highestAddress);
            }
            int startIndex = lowestAddress - 0x8000000 >> 8;
            int endIndex = highestAddress - 0x8000000 >> 8;
            for (int i = startIndex; i <= endIndex; ++i) {
                int size;
                int addr;
                CodeBlockList codeBlockList;
                if (i < 0 || i >= fastCodeBlockLookup.length || (codeBlockList = fastCodeBlockLookup[i]) == null) continue;
                if (previousCodeBlock != null) {
                    codeBlockList.remove(previousCodeBlock);
                }
                if (!codeBlock.isOverlappingWithAddressRange(addr = (i << 8) + 0x8000000, size = 256)) continue;
                codeBlockList.add(codeBlock);
            }
        }
    }

    public static CodeBlock getCodeBlock(int address) {
        return codeBlocks.get(address & 0x1FFFFFFF);
    }

    public static boolean hasCodeBlock(int address) {
        return codeBlocks.containsKey(address & 0x1FFFFFFF);
    }

    public static Map<Integer, CodeBlock> getCodeBlocks() {
        return codeBlocks;
    }

    public static void removeCodeBlocks(int address, int size) {
        int[] addressesToBeRemoved = null;
        for (CodeBlock codeBlock : codeBlocks.values()) {
            if (!codeBlock.isOverlappingWithAddressRange(address, size)) continue;
            addressesToBeRemoved = Utilities.add(addressesToBeRemoved, codeBlock.getStartAddress());
        }
        if (addressesToBeRemoved != null) {
            for (Iterator<CodeBlock> iterator : addressesToBeRemoved) {
                CodeBlock codeBlock = codeBlocks.remove(iterator & 0x1FFFFFFF);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("removeCodeBlocks address=0x%08X, size=0x%X, removing %s", address, size, codeBlock));
            }
        }
    }

    public static IExecutable getExecutable(int address) {
        int maskedAddress = address & 0x1FFFFFFF;
        int fastExecutableLoopukIndex = maskedAddress - 0x8000000 >> 2;
        IExecutable executable = fastExecutableLoopukIndex >= 0 && fastExecutableLoopukIndex < fastExecutableLookup.length ? fastExecutableLookup[fastExecutableLoopukIndex] : null;
        if (executable == null) {
            CodeBlock codeBlock = RuntimeContext.getCodeBlock(address);
            executable = codeBlock == null ? Compiler.getInstance().compile(address) : codeBlock.getExecutable();
            if (fastExecutableLoopukIndex >= 0 && fastExecutableLoopukIndex < fastExecutableLookup.length) {
                RuntimeContext.fastExecutableLookup[fastExecutableLoopukIndex] = executable;
            }
        }
        return executable;
    }

    public static void start() {
        Settings.getInstance().registerSettingsListener("RuntimeContext", "emu.compiler", new CompilerEnabledSettingsListerner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run() {
        if (Emulator.exitCalled()) {
            return;
        }
        if (!RuntimeContext.initialise()) {
            compilerEnabled = false;
            return;
        }
        log.info((Object)"Using Compiler");
        while (!toBeStoppedThreads.isEmpty()) {
            RuntimeContext.wakeupToBeStoppedThreads();
            Utilities.sleep(1000);
        }
        reset = false;
        if (currentRuntimeThread == null) {
            try {
                RuntimeContext.syncIdle();
            }
            catch (StopThreadException e) {
                return;
            }
            catch (StopThreadRuntimeException e) {
                return;
            }
            if (currentRuntimeThread == null) {
                log.error((Object)"RuntimeContext.run: nothing to run!");
                Emulator.PauseEmuWithStatus(-1);
                return;
            }
        }
        RuntimeContext.update();
        if (RuntimeContext.processor.cpu.pc == 0) {
            Emulator.PauseEmuWithStatus(-1);
            return;
        }
        currentRuntimeThread.continueRuntimeExecution();
        while (!threads.isEmpty() && !reset) {
            Object object = waitForEnd;
            synchronized (object) {
                try {
                    waitForEnd.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        log.debug((Object)"End of run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RuntimeThread> wakeupToBeStoppedThreads() {
        LinkedList<RuntimeThread> threadList = new LinkedList<RuntimeThread>();
        Object object = toBeStoppedThreads;
        synchronized (object) {
            for (Map.Entry<SceKernelThreadInfo, RuntimeThread> entry : toBeStoppedThreads.entrySet()) {
                threadList.add(entry.getValue());
            }
        }
        for (RuntimeThread runtimeThread : threadList) {
            Thread.State threadState = runtimeThread.getState();
            log.debug((Object)("Thread " + runtimeThread.getName() + ", State=" + (Object)((Object)threadState)));
            if (threadState == Thread.State.TERMINATED) {
                toBeStoppedThreads.remove(runtimeThread.getThreadInfo());
                continue;
            }
            if (threadState != Thread.State.WAITING) continue;
            runtimeThread.continueRuntimeExecution();
        }
        object = Emulator.getInstance();
        synchronized (object) {
            Emulator.getInstance().notifyAll();
        }
        return threadList;
    }

    public static void onThreadDeleted(SceKernelThreadInfo thread) {
        RuntimeThread runtimeThread = threads.get(thread);
        if (runtimeThread != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting Thread " + thread.toString()));
            }
            toBeStoppedThreads.put(thread, runtimeThread);
            if (runtimeThread.isInSyscall() && Thread.currentThread() != runtimeThread) {
                toBeDeletedThreads.put(thread, runtimeThread);
                log.debug((Object)("Continue Thread " + runtimeThread.getName()));
                runtimeThread.continueRuntimeExecution();
            }
        }
    }

    public static void onThreadExit(SceKernelThreadInfo thread) {
        RuntimeThread runtimeThread = threads.get(thread);
        if (runtimeThread != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exiting Thread " + thread.toString()));
            }
            toBeStoppedThreads.put(thread, runtimeThread);
            threads.remove(thread);
        }
    }

    public static void onThreadStart(SceKernelThreadInfo thread) {
        toBeStoppedThreads.remove(thread);
        toBeDeletedThreads.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopAllThreads() {
        Map<SceKernelThreadInfo, RuntimeThread> map = threads;
        synchronized (map) {
            toBeStoppedThreads.putAll(threads);
            threads.clear();
        }
        List<RuntimeThread> threadList = RuntimeContext.wakeupToBeStoppedThreads();
        boolean waitForThreads = true;
        while (waitForThreads) {
            waitForThreads = false;
            for (RuntimeThread runtimeThread : threadList) {
                if (runtimeThread.isInSyscall()) continue;
                waitForThreads = true;
                break;
            }
            if (!waitForThreads) continue;
            Utilities.sleep(1000);
        }
    }

    public static void exit() {
        if (compilerEnabled) {
            log.debug((Object)"RuntimeContext.exit");
            RuntimeContext.stopAllThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        if (compilerEnabled) {
            log.debug((Object)"RuntimeContext.reset");
            RuntimeContext.onReboot();
            currentThread = null;
            currentRuntimeThread = null;
            reset = true;
            RuntimeContext.stopAllThreads();
            Object object = waitForEnd;
            synchronized (object) {
                waitForEnd.notify();
            }
        }
    }

    public static void onReboot() {
        RuntimeContext.invalidateAllCodeBlocks();
        haltCount = 0;
    }

    private static void invalidateAllCodeBlocks() {
        for (CodeBlock codeBlock : codeBlocks.values()) {
            codeBlock.free();
        }
        codeBlocks.clear();
        if (fastExecutableLookup != null) {
            Arrays.fill(fastExecutableLookup, null);
        }
        if (fastCodeBlockLookup != null) {
            Arrays.fill(fastCodeBlockLookup, null);
        }
        Compiler.getInstance().reset();
    }

    public static void invalidateAll() {
        if (compilerEnabled) {
            log.debug((Object)"RuntimeContext.invalidateAll advanced");
            RuntimeContext.initialiseDebugger();
            Compiler compiler = Compiler.getInstance();
            for (CodeBlock codeBlock : codeBlocks.values()) {
                boolean isNoLongerValid = codeBlock.isNoLongerValid();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("invalidateAll %s: isNoLongerValid %b", codeBlock, isNoLongerValid));
                }
                if (!isNoLongerValid) continue;
                compiler.invalidateCodeBlock(codeBlock);
            }
        }
    }

    private static void invalidateRangeFullCheck(int addr, int size) {
        Compiler compiler = Compiler.getInstance();
        for (CodeBlock codeBlock : codeBlocks.values()) {
            if (size == 16384 && codeBlock.getHighestAddress() >= addr) {
                compiler.checkCodeBlockValidity(codeBlock);
                continue;
            }
            if (!codeBlock.isOverlappingWithAddressRange(addr, size)) continue;
            compiler.checkCodeBlockValidity(codeBlock);
        }
    }

    private static CodeBlockList fillFastCodeBlockList(int index) {
        int startAddr = (index << 8) + 0x8000000;
        int size = 256;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Creating new fastCodeBlockList for 0x%08X", startAddr));
        }
        CodeBlockList codeBlockList = new CodeBlockList();
        for (CodeBlock codeBlock : codeBlocks.values()) {
            if (!codeBlock.isOverlappingWithAddressRange(startAddr, size)) continue;
            codeBlockList.add(codeBlock);
        }
        RuntimeContext.fastCodeBlockLookup[index] = codeBlockList;
        return codeBlockList;
    }

    public static void invalidateRange(int addr, int size) {
        if (compilerEnabled) {
            addr &= 0x1FFFFFFF;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("RuntimeContext.invalidateRange(addr=0x%08X, size=%d)", addr, size));
            }
            if (addr + size < codeBlocksLowestAddress || addr > codeBlocksHighestAddress) {
                return;
            }
            if (size == 64) {
                int startIndex = addr - 0x8000000 >> 8;
                int endIndex = addr + size - 0x8000000 >> 8;
                if (startIndex >= 0 && endIndex < fastCodeBlockLookup.length) {
                    for (int index = startIndex; index <= endIndex; ++index) {
                        CodeBlockList codeBlockList = fastCodeBlockLookup[index];
                        if (codeBlockList == null) {
                            codeBlockList = RuntimeContext.fillFastCodeBlockList(index);
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Reusing fastCodeBlockList for 0x%08X (size=%d)", addr, codeBlockList.size()));
                        }
                        Compiler compiler = Compiler.getInstance();
                        for (CodeBlock codeBlock : codeBlockList) {
                            if (!codeBlock.isOverlappingWithAddressRange(addr, size)) continue;
                            compiler.checkCodeBlockValidity(codeBlock);
                        }
                    }
                } else {
                    RuntimeContext.invalidateRangeFullCheck(addr, size);
                }
            } else {
                RuntimeContext.invalidateRangeFullCheck(addr, size);
            }
        }
    }

    public static void instructionTypeCount(Common.Instruction insn, int opcode) {
        int count = 0;
        if (instructionTypeCounts.containsKey(insn)) {
            count = instructionTypeCounts.get(insn);
        }
        instructionTypeCounts.put(insn, ++count);
    }

    public static void pauseEmuWithStatus(int status) throws StopThreadException {
        Emulator.PauseEmuWithStatus(status);
        RuntimeContext.syncPause();
    }

    public static void logError(String message) {
        log.error((Object)message);
    }

    public static boolean checkMemoryPointer(int address) {
        return Memory.isAddressGood(address) || Memory.isRawAddressGood(Memory.normalizeAddress(address));
    }

    public static String readStringNZ(int address, int maxLength) {
        if (address == 0) {
            return null;
        }
        return Utilities.readStringNZ(address, maxLength);
    }

    public static PspString readPspStringNZ(int address, int maxLength, boolean canBeNull) {
        return new PspString(address, maxLength, canBeNull);
    }

    public static int checkMemoryRead32(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x1FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            if (memory.read32AllowedInvalidAddress(rawAddress)) {
                rawAddress = 0;
            } else {
                int normalizedAddress = Memory.normalizeAddress(address);
                if (Memory.isRawAddressGood(normalizedAddress)) {
                    rawAddress = normalizedAddress;
                } else {
                    RuntimeContext.processor.cpu.pc = pc;
                    memory.invalidMemoryAddress(address, "read32", 4);
                    RuntimeContext.syncPause();
                    rawAddress = 0;
                }
            }
        }
        return rawAddress;
    }

    public static int checkMemoryRead16(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x1FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = Memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "read16", 4);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        return rawAddress;
    }

    public static int checkMemoryRead8(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x1FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = Memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "read8", 4);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        return rawAddress;
    }

    public static int checkMemoryWrite32(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x1FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = Memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "write32", 8);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        sceDisplayModule.write32(rawAddress);
        return rawAddress;
    }

    public static int checkMemoryWrite16(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x1FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = Memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "write16", 8);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        sceDisplayModule.write16(rawAddress);
        return rawAddress;
    }

    public static int checkMemoryWrite8(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x1FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = Memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "write8", 8);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        sceDisplayModule.write8(rawAddress);
        return rawAddress;
    }

    public static void debugMemoryReadWrite(int address, int value, int pc, boolean isRead, int width) {
        if (log.isTraceEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("0x%08X - ", pc));
            if (isRead) {
                message.append(String.format("read%d(0x%08X)=0x", width, address));
                if (width == 8) {
                    message.append(String.format("%02X", memory.read8(address)));
                } else if (width == 16) {
                    message.append(String.format("%04X", memory.read16(address)));
                } else if (width == 32) {
                    message.append(String.format("%08X (%f)", memory.read32(address), Float.valueOf(Float.intBitsToFloat(memory.read32(address)))));
                }
            } else {
                message.append(String.format("write%d(0x%08X, 0x", width, address));
                if (width == 8) {
                    message.append(String.format("%02X", value));
                } else if (width == 16) {
                    message.append(String.format("%04X", value));
                } else if (width == 32) {
                    message.append(String.format("%08X (%f)", value, Float.valueOf(Float.intBitsToFloat(value))));
                }
                message.append(")");
            }
            log.trace((Object)message.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interruptIdleSleep() {
        Object object = idleSyncObject;
        synchronized (object) {
            idleSyncObject.notifyAll();
        }
    }

    public static void onNextScheduleModified() {
        RuntimeContext.checkSync();
        RuntimeContext.interruptIdleSleep();
    }

    public static void checkSync() {
        long delay;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("checkSync wantSync=%b, now=0x%X", wantSync, Scheduler.getNow()));
        }
        if (!wantSync && (delay = Emulator.getScheduler().getNextActionDelay(1000L)) <= 0L) {
            wantSync = true;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("checkSync wantSync=%b, now=0x%X", wantSync, Scheduler.getNow()));
            }
        }
    }

    public static void checkSyncWithSleep() {
        long delay = Emulator.getScheduler().getNextActionDelay(1000L);
        if (delay > 0L) {
            if (ExternalGE.isActive() || Modules.sceDisplayModule.isUsingSoftwareRenderer()) {
                RuntimeContext.idleSleepInterruptable();
            } else {
                Utilities.sleep(Math.min((int)delay, 1000));
            }
        } else if (wantSync) {
            Utilities.sleep(1000);
        } else {
            wantSync = true;
        }
    }

    public static boolean syncDaemonStep() {
        RuntimeContext.checkSyncWithSleep();
        return true;
    }

    public static void exitSyncDaemon() {
        runtimeSyncThread = null;
    }

    public static void setIsHomebrew(boolean isHomebrew) {
        RuntimeContext.isHomebrew = isHomebrew;
    }

    public static boolean isHomebrew() {
        return isHomebrew;
    }

    public static void onCodeModification(int pc, int opcode) {
        RuntimeContext.cpu.pc = pc;
        log.error((Object)String.format("Code instruction at 0x%08X has been modified, expected 0x%08X, current 0x%08X", pc, opcode, memory.read32(pc)));
        Emulator.PauseEmuWithStatus(8);
    }

    public static void debugMemory(int address, int length) {
        if (memory instanceof DebuggerMemory) {
            DebuggerMemory debuggerMemory = (DebuggerMemory)memory;
            debuggerMemory.addRangeReadWriteBreakpoint(address, address + length - 1);
        }
    }

    public static void debugCodeBlock(int address, int numberOfArguments) {
        if (debugCodeBlockCalls) {
            debugCodeBlocks.put(address, numberOfArguments);
        }
    }

    public static void setFirmwareVersion(int firmwareVersion) {
        RuntimeContext.firmwareVersion = firmwareVersion;
    }

    public static boolean hasMemoryInt() {
        return memoryInt != null;
    }

    public static boolean hasMemoryInt(int address) {
        return RuntimeContext.hasMemoryInt() && Memory.isAddressGood(address);
    }

    public static boolean hasMemoryInt(TPointer address) {
        return RuntimeContext.hasMemoryInt() && address.getMemory() == memory;
    }

    public static int[] getMemoryInt() {
        return memoryInt;
    }

    public static int getPc() {
        return RuntimeContextLLE.getProcessor().cpu.pc;
    }

    public static int executeEret() throws Exception {
        int epc = RuntimeContext.processor.cpu.doERET(processor);
        reboot.setLog4jMDC(processor);
        reboot.dumpAllThreads();
        return epc;
    }

    public static void executeHalt(Processor processor) throws StopThreadException {
        if (RuntimeContextLLE.hasMMIO()) {
            if (processor.cp0.isMediaEngineCpu()) {
                ((MEProcessor)processor).halt();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Allegrex halt pendingInterruptIPbitsMain=0x%X", RuntimeContextLLE.pendingInterruptIPbitsMain));
                }
                reboot.dumpAllThreads();
                switch (haltCount) {
                    case 0: {
                        MMIOHandlerDisplayController.getInstance().triggerVblankInterrupt();
                        break;
                    }
                    case 1: {
                        MMIOHandlerDisplayController.getInstance().triggerVblankInterrupt();
                        break;
                    }
                    case 2: {
                        MMIOHandlerDisplayController.getInstance().triggerVblankInterrupt();
                        break;
                    }
                    case 3: {
                        MMIOHandlerDisplayController.setMaxVblankInterrupts(-1);
                        MMIOHandlerDisplayController.getInstance().triggerVblankInterrupt();
                        break;
                    }
                }
                ++haltCount;
                RuntimeContext.idle();
            }
        } else {
            log.error((Object)"Allegrex halt");
            Emulator.PauseEmuWithStatus(512);
        }
    }

    public static void idle() throws StopThreadException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("idle wantSync=%b", wantSync));
        }
        if (!javaThreadScheduling) {
            if (!toBeStoppedThreads.isEmpty()) {
                wantSync = true;
            }
            Emulator.getScheduler().step();
        }
        if (wantSync) {
            RuntimeContext.sync();
        } else {
            RuntimeContext.idleSleepInterruptable();
        }
    }

    public static void onLLEInterrupt() {
        RuntimeContext.interruptIdleSleep();
    }

    public static void setLog4jMDC() {
        RuntimeContext.setLog4jMDC(Thread.currentThread().getName());
    }

    public static void setLog4jMDC(String threadName) {
        RuntimeContext.setLog4jMDC(threadName, 0);
    }

    public static void setLog4jMDC(String threadName, int threadUid) {
        MDC.put((String)"LLE-thread-name", (Object)threadName);
        if (threadUid != 0) {
            MDC.put((String)"LLE-thread-uid", (Object)String.format("0x%X", threadUid));
            MDC.put((String)"LLE-thread", (Object)String.format("%s_0x%X", threadName, threadUid));
        } else {
            MDC.put((String)"LLE-thread-uid", (Object)"");
            MDC.put((String)"LLE-thread", (Object)threadName);
        }
    }

    static {
        enableDebugger = true;
        debugCodeBlockCalls = false;
        debugCodeBlocks = new HashMap<Integer, Integer>();
        codeBlocks = Collections.synchronizedMap(new HashMap());
        codeBlocksLowestAddress = Integer.MAX_VALUE;
        codeBlocksHighestAddress = Integer.MIN_VALUE;
        threads = Collections.synchronizedMap(new HashMap());
        toBeStoppedThreads = Collections.synchronizedMap(new HashMap());
        alreadyStoppedThreads = Collections.synchronizedMap(new HashMap());
        alreadySwitchedStoppedThreads = Collections.synchronizedList(new ArrayList());
        toBeDeletedThreads = Collections.synchronizedMap(new HashMap());
        currentThread = null;
        currentRuntimeThread = null;
        waitForEnd = new Object();
        isIdle = false;
        reset = false;
        idleDuration = new CpuDurationStatistics("Idle Time");
        instructionTypeCounts = Collections.synchronizedMap(new HashMap());
        wantSync = false;
        runtimeSyncThread = null;
        idleSyncObject = new Object();
        isHomebrew = false;
        javaThreadScheduling = true;
        haltCount = 0;
    }

    private static class CodeBlockList
    extends LinkedList<CodeBlock> {
        private static final long serialVersionUID = 7370950118403866860L;

        private CodeBlockList() {
        }
    }

    private static class CompilerEnabledSettingsListerner
    extends AbstractBoolSettingsListener {
        private CompilerEnabledSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            RuntimeContext.setCompilerEnabled(value);
        }
    }
}

