/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.Processor;
import jpcsp.format.DeferredStub;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SyscallHandler {
    private static Logger log = Modules.log;
    public static boolean ignoreUnmappedImports = false;
    public static final int syscallUnmappedImport = 1048575;
    public static final int syscallLoadCoreUnmappedImport = 21;
    private static IgnoreUnmappedImportsSettingsListerner ignoreUnmappedImportsSettingsListerner;

    private static boolean isEnableIgnoreUnmappedImports() {
        return ignoreUnmappedImports;
    }

    private static void setEnableIgnoreUnmappedImports(boolean enable) {
        ignoreUnmappedImports = enable;
        if (enable) {
            log.info((Object)"Ignore Unmapped Imports enabled");
        }
    }

    private static void logMem(Memory mem, int address, String registerName) {
        if (Memory.isAddressGood(address)) {
            log.error((Object)String.format("Memory at %s:%s", registerName, Utilities.getMemoryDump(address, 64)));
        }
    }

    private static int unsupportedSyscall(int code) {
        if (ignoreUnmappedImportsSettingsListerner == null) {
            ignoreUnmappedImportsSettingsListerner = new IgnoreUnmappedImportsSettingsListerner();
            Settings.getInstance().registerSettingsListener("SyscallHandler", "emu.ignoreUnmappedImports", ignoreUnmappedImportsSettingsListerner);
        }
        NIDMapper nidMapper = NIDMapper.getInstance();
        CpuState cpu = Emulator.getProcessor().cpu;
        int result = cpu._ra;
        if (code == 1048575) {
            String description = String.format("0x%08X", cpu.pc);
            block0: for (SceModule module : Managers.modules.values()) {
                for (DeferredStub deferredStub : module.unresolvedImports) {
                    if (deferredStub.getImportAddress() != cpu.pc && deferredStub.getImportAddress() != cpu.pc - 4) continue;
                    description = deferredStub.toString();
                    continue block0;
                }
            }
            if (SyscallHandler.isEnableIgnoreUnmappedImports()) {
                log.warn((Object)String.format("IGNORING: Unmapped import at %s - $a0=0x%08X $a1=0x%08X $a2=0x%08X", description, cpu._a0, cpu._a1, cpu._a2));
            } else {
                log.error((Object)String.format("Unmapped import at %s:", description));
                log.error((Object)String.format("Registers: $a0=0x%08X, $a1=0x%08X, $a2=0x%08X, $a3=0x%08X", cpu._a0, cpu._a1, cpu._a2, cpu._a3));
                log.error((Object)String.format("           $t0=0x%08X, $t1=0x%08X, $t2=0x%08X, $t3=0x%08X", cpu._t0, cpu._t1, cpu._t2, cpu._t3));
                log.error((Object)String.format("           $ra=0x%08X, $sp=0x%08X", cpu._ra, cpu._sp));
                Memory mem = Emulator.getMemory();
                log.error((Object)String.format("Caller code:", new Object[0]));
                for (int i = -96; i <= 40; i += 4) {
                    int address = cpu._ra + i;
                    int opcode = mem.read32(address);
                    Common.Instruction insn = Decoder.instruction(opcode);
                    String disasm = insn.disasm(address, opcode);
                    log.error((Object)String.format("%c 0x%08X:[%08X]: %s", Character.valueOf(i == -8 ? (char)'>' : ' '), address, opcode, disasm));
                }
                SyscallHandler.logMem(mem, cpu._a0, Common.gprNames[4]);
                SyscallHandler.logMem(mem, cpu._a1, Common.gprNames[5]);
                SyscallHandler.logMem(mem, cpu._a2, Common.gprNames[6]);
                SyscallHandler.logMem(mem, cpu._a3, Common.gprNames[7]);
                SyscallHandler.logMem(mem, cpu._t0, Common.gprNames[8]);
                SyscallHandler.logMem(mem, cpu._t1, Common.gprNames[9]);
                SyscallHandler.logMem(mem, cpu._t2, Common.gprNames[10]);
                SyscallHandler.logMem(mem, cpu._t3, Common.gprNames[11]);
                Emulator.PauseEmu();
            }
            cpu._v0 = 0;
        } else if (code == 21) {
            String description = String.format("0x%08X", cpu.pc);
            block3: for (SceModule module : Managers.modules.values()) {
                for (DeferredStub deferredStub : module.unresolvedImports) {
                    if (deferredStub.getImportAddress() != cpu.pc && deferredStub.getImportAddress() != cpu.pc - 4) continue;
                    description = deferredStub.toString();
                    continue block3;
                }
            }
            if (SyscallHandler.isEnableIgnoreUnmappedImports()) {
                log.warn((Object)String.format("IGNORING: Unmapped import at %s - $a0=0x%08X $a1=0x%08X $a2=0x%08X", description, cpu._a0, cpu._a1, cpu._a2));
            } else {
                log.error((Object)String.format("Unmapped import at %s:", description));
                log.error((Object)String.format("Registers: $a0=0x%08X, $a1=0x%08X, $a2=0x%08X, $a3=0x%08X", cpu._a0, cpu._a1, cpu._a2, cpu._a3));
                log.error((Object)String.format("           $t0=0x%08X, $t1=0x%08X, $t2=0x%08X, $t3=0x%08X", cpu._t0, cpu._t1, cpu._t2, cpu._t3));
                log.error((Object)String.format("           $ra=0x%08X, $sp=0x%08X", cpu._ra, cpu._sp));
                Memory mem = Emulator.getMemory();
                log.error((Object)String.format("Caller code:", new Object[0]));
                for (int i = -96; i <= 40; i += 4) {
                    int address = cpu._ra + i;
                    int opcode = mem.read32(address);
                    Common.Instruction insn = Decoder.instruction(opcode);
                    String disasm = insn.disasm(address, opcode);
                    log.error((Object)String.format("%c 0x%08X:[%08X]: %s", Character.valueOf(i == -8 ? (char)'>' : ' '), address, opcode, disasm));
                }
                SyscallHandler.logMem(mem, cpu._a0, Common.gprNames[4]);
                SyscallHandler.logMem(mem, cpu._a1, Common.gprNames[5]);
                SyscallHandler.logMem(mem, cpu._a2, Common.gprNames[6]);
                SyscallHandler.logMem(mem, cpu._a3, Common.gprNames[7]);
                SyscallHandler.logMem(mem, cpu._t0, Common.gprNames[8]);
                SyscallHandler.logMem(mem, cpu._t1, Common.gprNames[9]);
                SyscallHandler.logMem(mem, cpu._t2, Common.gprNames[10]);
                SyscallHandler.logMem(mem, cpu._t3, Common.gprNames[11]);
                Emulator.PauseEmu();
            }
            cpu._v0 = 0;
        } else {
            int address = nidMapper.getAddressBySyscall(code);
            if (address != 0) {
                if (log.isDebugEnabled()) {
                    String name = nidMapper.getNameBySyscall(code);
                    int nid = nidMapper.getNidBySyscall(code);
                    if (name != null) {
                        log.debug((Object)String.format("Jumping to 0x%08X instead of overwritten syscall %s[0x%08X]", address, name, nid));
                    } else {
                        log.debug((Object)String.format("Jumping to 0x%08X for syscall NID 0x%08X from module '%s'", address, nid, nidMapper.getModuleNameBySyscall(code)));
                    }
                }
                RuntimeContext.executeFunction(address);
            } else {
                String name = nidMapper.getNameBySyscall(code);
                if (name != null) {
                    log.error((Object)String.format("HLE Function %s not activated by default for Firmware Version %d", name, Emulator.getInstance().getFirmwareVersion()));
                } else {
                    int nid = nidMapper.getNidBySyscall(code);
                    if (nid != 0) {
                        log.error((Object)String.format("NID 0x%08X not activated by default for Firmware Version %d", nid, Emulator.getInstance().getFirmwareVersion()));
                    } else {
                        log.error((Object)String.format("Unknown syscall 0x%05X", code));
                    }
                }
            }
        }
        return result;
    }

    public static int syscall(int code, boolean inDelaySlot) {
        if (RuntimeContextLLE.isLLEActive()) {
            Processor processor = Emulator.getProcessor();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("0x%08X - %s", processor.cpu.pc, Common.disasmSYSCALL(processor.cpu.memory, code)));
            }
            return RuntimeContextLLE.triggerSyscallException(processor, code, inDelaySlot);
        }
        return SyscallHandler.unsupportedSyscall(code);
    }

    private static class IgnoreUnmappedImportsSettingsListerner
    extends AbstractBoolSettingsListener {
        private IgnoreUnmappedImportsSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            SyscallHandler.setEnableIgnoreUnmappedImports(value);
        }
    }
}

