/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointerBase;
import jpcsp.Memory;

public class TPointer32
extends TPointerBase {
    public static final TPointer32 NULL = new TPointer32();

    private TPointer32() {
    }

    public TPointer32(Memory memory, int address) {
        super(memory, address, false);
    }

    public TPointer32(Memory memory, int address, boolean canBeNull) {
        super(memory, address, canBeNull);
    }

    public TPointer32(TPointer pointer) {
        super(pointer.getMemory(), pointer.getAddress(), false);
    }

    public TPointer32(TPointer pointer, int offset) {
        super(pointer.getMemory(), pointer.getAddress() + offset, false);
    }

    public TPointer32 forceNonNull() {
        this.pointer.forceNonNull();
        return this;
    }

    public int getValue() {
        return this.getValue(0);
    }

    public void setValue(int value) {
        this.setValue(0, value);
    }

    public void setValue(boolean value) {
        this.setValue(0, value);
    }

    public int getValue(int offset) {
        return this.pointer.getValue32(offset);
    }

    public void setValue(int offset, int value) {
        if (this.canSetValue()) {
            this.pointer.setValue32(offset, value);
        }
    }

    public void setValue(int offset, boolean value) {
        if (this.canSetValue()) {
            this.pointer.setValue32(offset, value);
        }
    }

    public TPointer getPointer() {
        return this.getPointer(0);
    }

    public TPointer getPointer(int offset) {
        if (this.isNull()) {
            return TPointer.NULL;
        }
        return new TPointer(this.getNewPointerMemory(), this.getValue(offset));
    }

    public TPointer32 getPointer32() {
        return this.getPointer32(0);
    }

    public TPointer32 getPointer32(int offset) {
        if (this.isNull()) {
            return NULL;
        }
        return new TPointer32(this.getNewPointerMemory(), this.getValue(offset));
    }

    public void setPointer(TPointer pointer) {
        this.setValue(pointer.getAddress());
    }

    public void setPointer(int offset, TPointer pointer) {
        this.setValue(offset, pointer.getAddress());
    }

    public TPointer32 add(int addressOffset) {
        if (this.isNotNull()) {
            this.pointer.add(addressOffset);
        }
        return this;
    }

    public TPointer32 sub(int addressOffset) {
        if (this.isNotNull()) {
            this.pointer.sub(addressOffset);
        }
        return this;
    }

    public void incrValue(int value) {
        this.incrValue(0, value);
    }

    public void incrValue(int offset, int value) {
        if (this.canSetValue()) {
            this.pointer.setValue32(offset, this.pointer.getValue32(offset) + value);
        }
    }

    public void decrValue(int value) {
        this.decrValue(0, value);
    }

    public void decrValue(int offset, int value) {
        this.incrValue(offset, -value);
    }
}

