/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.BaseCacheVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class WriteCacheVirtualFile
extends BaseCacheVirtualFile
implements IState {
    private static final int STATE_VERSION = 0;
    private boolean compareAtWrite;

    public WriteCacheVirtualFile(Logger log, IVirtualFile vFile) {
        super(log, vFile);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Creating WriteCacheVirtualFile 0x%X, vFile=%s", this.hashCode(), vFile));
        }
    }

    public WriteCacheVirtualFile(Logger log, IVirtualFile vFile, boolean compareAtWrite) {
        super(log, vFile);
        this.compareAtWrite = compareAtWrite;
    }

    @Override
    public synchronized int ioRead(TPointer outputPointer, int outputLength) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("ioRead position=0x%X, length=0x%X", this.vFile.getPosition(), outputLength));
        }
        if (this.blocks.isEmpty()) {
            return this.vFile.ioRead(outputPointer, outputLength);
        }
        long position = this.vFile.getPosition();
        int outputOffset = 0;
        int totalReadLength = 0;
        for (BaseCacheVirtualFile.Block block : this.blocks) {
            if (block.isAfter(position)) {
                int length = Math.min(outputLength, (int)(block.start - position));
                int readLength = this.vFile.ioRead(new TPointer(outputPointer, outputOffset), length);
                if (readLength < 0) {
                    return readLength;
                }
                outputOffset += readLength;
                outputLength -= readLength;
                totalReadLength += readLength;
                position = this.vFile.getPosition();
            }
            if (block.isContaining(position)) {
                int before = (int)(position - block.start);
                int length = Math.min(outputLength, block.getLength() - before);
                outputPointer.setArray(outputOffset, block.data, before, length);
                outputOffset += length;
                outputLength -= length;
                totalReadLength += length;
                position = this.vFile.ioLseek(position + (long)length);
            } else if (block.isAfter(position)) break;
            if (outputLength != 0) continue;
            break;
        }
        if (outputLength > 0) {
            int readLength = this.vFile.ioRead(new TPointer(outputPointer, outputOffset), outputLength);
            if (readLength < 0) {
                return readLength;
            }
            totalReadLength += readLength;
        }
        return totalReadLength;
    }

    @Override
    public synchronized int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("ioRead position=0x%X, length=0x%X", this.vFile.getPosition(), outputLength));
        }
        if (this.blocks.isEmpty()) {
            return this.vFile.ioRead(outputBuffer, outputOffset, outputLength);
        }
        long position = this.vFile.getPosition();
        int totalReadLength = 0;
        for (BaseCacheVirtualFile.Block block : this.blocks) {
            if (block.isAfter(position)) {
                int length = Math.min(outputLength, (int)(block.start - position));
                int readLength = this.vFile.ioRead(outputBuffer, outputOffset, length);
                if (readLength < 0) {
                    return readLength;
                }
                outputOffset += readLength;
                outputLength -= readLength;
                totalReadLength += readLength;
                position = this.vFile.getPosition();
            }
            if (block.isContaining(position)) {
                int before = (int)(position - block.start);
                int length = Math.min(outputLength, block.getLength() - before);
                System.arraycopy(block.data, before, outputBuffer, outputOffset, length);
                outputOffset += length;
                outputLength -= length;
                totalReadLength += length;
                position = this.vFile.ioLseek(position + (long)length);
            } else if (block.isAfter(position)) break;
            if (outputLength != 0) continue;
            break;
        }
        if (outputLength > 0) {
            int readLength = this.vFile.ioRead(outputBuffer, outputOffset, outputLength);
            if (readLength < 0) {
                return readLength;
            }
            totalReadLength += readLength;
        }
        return totalReadLength;
    }

    @Override
    public synchronized int ioWrite(TPointer inputPointer, int inputLength) {
        long position = this.vFile.getPosition();
        byte[] data = inputPointer.getArray8(inputLength);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("ioWrite position=0x%X, length=0x%X, %s", position, inputLength, Utilities.getMemoryDump(data)));
        }
        boolean ignoreWrite = false;
        if (this.compareAtWrite) {
            byte[] targetData = new byte[inputLength];
            this.vFile.ioRead(targetData, 0, inputLength);
            ignoreWrite = Utilities.equals(data, 0, targetData, 0, inputLength);
        } else {
            this.vFile.ioLseek(position + (long)inputLength);
        }
        if (!ignoreWrite) {
            BaseCacheVirtualFile.Block block = new BaseCacheVirtualFile.Block(position, position + (long)inputLength, data);
            this.addBlock(block);
        }
        return inputLength;
    }

    @Override
    public synchronized int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        long position = this.vFile.getPosition();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("ioWrite position=0x%X, length=0x%X, %s", position, inputLength, Utilities.getMemoryDump(inputBuffer, inputOffset, inputLength)));
        }
        boolean ignoreWrite = false;
        if (this.compareAtWrite) {
            byte[] targetData = new byte[inputLength];
            this.vFile.ioRead(targetData, 0, inputLength);
            ignoreWrite = Utilities.equals(inputBuffer, inputOffset, targetData, 0, inputLength);
        } else {
            this.vFile.ioLseek(position + (long)inputLength);
        }
        if (!ignoreWrite) {
            byte[] data = new byte[inputLength];
            System.arraycopy(inputBuffer, inputOffset, data, 0, inputLength);
            BaseCacheVirtualFile.Block block = new BaseCacheVirtualFile.Block(position, position + (long)inputLength, data);
            this.addBlock(block);
        }
        return inputLength;
    }

    private void writeBlocks() {
        for (BaseCacheVirtualFile.Block block : this.blocks) {
            int result;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("WriteCacheVirtualFile.flushCachedData %s", block));
            }
            if ((result = block.ioWrite(this.vFile)) >= 0) continue;
            this.log.error((Object)String.format("WriteCacheVirtualFile.flushCachedData failed 0x%08X for %s", result, block));
        }
    }

    @Override
    public synchronized void flushCachedData() {
        super.flushCachedData();
        this.writeBlocks();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.compareAtWrite = stream.readBoolean();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeBoolean(this.compareAtWrite);
        super.write(stream);
    }

    @Override
    public String toString() {
        return String.format("WriteCacheVirtualFile %s", this.vFile);
    }
}

