/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.fat.FatFileInfo;
import jpcsp.HLE.VFS.fat.FatUtils;
import jpcsp.HLE.VFS.fat.FatVirtualFile;
import jpcsp.hardware.MemoryStick;

public class Fat32VirtualFile
extends FatVirtualFile {
    private final int[] rootDirectoryClusters = new int[1];

    public Fat32VirtualFile(String deviceName, IVirtualFileSystem vfs) {
        super(deviceName, vfs, (int)(MemoryStick.getTotalSize() / 512L));
    }

    @Override
    protected int getClusterMask() {
        return 0xFFFFFFF;
    }

    @Override
    protected int getFatEOC() {
        return 0xFFFFFFF;
    }

    @Override
    protected int getSectorsPerCluster() {
        return 64;
    }

    @Override
    protected int getFatSectors(int totalSectors, int sectorsPerCluster) {
        int totalClusters = totalSectors / sectorsPerCluster + 1;
        int fatSectors = totalClusters / 128 + 1;
        return fatSectors;
    }

    @Override
    protected void readBIOSParameterBlock() {
        FatUtils.storeSectorInt16(this.currentSector, 11, 512);
        FatUtils.storeSectorInt8(this.currentSector, 13, this.getSectorsPerCluster());
        FatUtils.storeSectorInt16(this.currentSector, 14, 32);
        FatUtils.storeSectorInt8(this.currentSector, 16, 2);
        FatUtils.storeSectorInt16(this.currentSector, 17, 0);
        FatUtils.storeSectorInt16(this.currentSector, 19, 0);
        FatUtils.storeSectorInt8(this.currentSector, 21, 248);
        FatUtils.storeSectorInt16(this.currentSector, 22, 0);
        FatUtils.storeSectorInt16(this.currentSector, 24, 63);
        FatUtils.storeSectorInt16(this.currentSector, 26, 255);
        FatUtils.storeSectorInt32(this.currentSector, 28, 0);
        FatUtils.storeSectorInt32(this.currentSector, 32, this.totalSectors);
        int fatSectors = this.getFatSectors(this.totalSectors, this.getSectorsPerCluster());
        FatUtils.storeSectorInt32(this.currentSector, 36, fatSectors);
        FatUtils.storeSectorInt16(this.currentSector, 40, 0);
        FatUtils.storeSectorInt16(this.currentSector, 42, 0);
        int rootDirFirstCluster = 2;
        FatUtils.storeSectorInt32(this.currentSector, 44, 2);
        FatUtils.storeSectorInt16(this.currentSector, 48, this.getFsInfoSectorNumber());
        FatUtils.storeSectorInt16(this.currentSector, 50, 6);
        FatUtils.storeSectorInt8(this.currentSector, 64, 0);
        FatUtils.storeSectorInt8(this.currentSector, 66, 41);
        FatUtils.storeSectorInt32(this.currentSector, 67, 0);
        FatUtils.storeSectorString(this.currentSector, 71, "", 11);
        FatUtils.storeSectorString(this.currentSector, 82, "FAT32", 8);
    }

    @Override
    protected void readFatSector(int fatIndex) {
        this.readEmptySector();
        int offset = fatIndex * 512 >> 2;
        int maxSize = Math.min(512, this.fatClusterMap.length - offset << 2);
        int i = 0;
        int j = 0;
        while (i < maxSize) {
            FatUtils.storeSectorInt32(this.currentSector, i, this.fatClusterMap[offset + j]);
            i += 4;
            ++j;
        }
    }

    @Override
    protected void writeFatSector(int fatIndex) {
        int offset = fatIndex * 512 >> 2;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fat32VirtualFile.writeFatSector fatIndex=0x%X, offset=0x%X", fatIndex, offset));
        }
        int i = 0;
        int j = 0;
        while (i < 512) {
            int fatEntry = FatUtils.readSectorInt32(this.currentSector, i);
            if (fatEntry != this.fatClusterMap[offset + j]) {
                this.writeFatSectorEntry(offset + j, fatEntry);
            }
            i += 4;
            ++j;
        }
    }

    @Override
    protected int getFirstDataClusterOffset() {
        return 0;
    }

    @Override
    protected int getFirstFreeCluster() {
        int clusterNumber = super.getFirstFreeCluster();
        for (int i = 0; i < this.rootDirectoryClusters.length; ++i) {
            this.rootDirectoryClusters[i] = clusterNumber++;
        }
        return clusterNumber;
    }

    @Override
    protected void setRootDirectory(FatFileInfo rootDirectory) {
        for (int i = 0; i < this.rootDirectoryClusters.length; ++i) {
            this.setFatFileInfoMap(this.rootDirectoryClusters[i], rootDirectory);
            int nextCluster = i < this.rootDirectoryClusters.length - 1 ? this.rootDirectoryClusters[i + 1] : this.getFatEOC();
            this.setFatClusterMap(this.rootDirectoryClusters[i], nextCluster);
        }
        rootDirectory.setClusters(this.rootDirectoryClusters);
    }
}

