/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualCache;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.InvalidVirtualFile;
import jpcsp.HLE.VFS.ReadCacheVirtualFile;
import jpcsp.HLE.VFS.fat.FatBuilder;
import jpcsp.HLE.VFS.fat.FatFileInfo;
import jpcsp.HLE.VFS.fat.FatUtils;
import jpcsp.HLE.VFS.fat.FatVirtualFileSystem;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public abstract class FatVirtualFile
implements IVirtualFile,
IVirtualCache,
IState {
    public static Logger log = Logger.getLogger((String)"fat");
    private static final boolean useSynchronizeVFS = true;
    private static final int STATE_VERSION = 0;
    public static final int sectorSize = 512;
    protected static final int firstClusterNumber = 2;
    protected final byte[] currentSector = new byte[512];
    private static final byte[] emptySector = new byte[512];
    private String deviceName;
    private IVirtualFileSystem vfs;
    private long position;
    protected int totalSectors;
    protected int fatSectors;
    protected int[] fatClusterMap;
    private FatFileInfo[] fatFileInfoMap;
    private FatBuilder builder;
    private int fatSectorNumber = 32;
    private int fsInfoSectorNumber = 1;
    protected FatFileInfo rootDirectory;
    protected int rootDirectoryStartSectorNumber = -1;
    protected int rootDirectoryEndSectorNumber = -1;
    private final byte[] secondFat;
    private IVirtualFile baseVirtualFile;

    protected FatVirtualFile(String deviceName, IVirtualFileSystem vfs, int totalSectors) {
        this.deviceName = deviceName;
        this.vfs = vfs;
        this.baseVirtualFile = this;
        this.totalSectors = totalSectors;
        this.fatSectors = this.getFatSectors(totalSectors, this.getSectorsPerCluster());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("totalSectors=0x%X, fatSectors=0x%X", totalSectors, this.fatSectors));
        }
        this.secondFat = new byte[this.fatSectors * 512];
        this.reset();
    }

    protected abstract int getClusterMask();

    protected abstract int getSectorsPerCluster();

    protected abstract int getFatEOC();

    protected abstract int getFatSectors(int var1, int var2);

    protected abstract void readBIOSParameterBlock();

    protected abstract int getFirstDataClusterOffset();

    protected abstract void setRootDirectory(FatFileInfo var1);

    public void setBaseVirtualFile(IVirtualFile baseVirtualFile) {
        this.baseVirtualFile = baseVirtualFile;
    }

    protected int getFirstFreeCluster() {
        return 2 + this.getFirstDataClusterOffset() / this.getSectorsPerCluster();
    }

    protected int getClusterSize() {
        return 512 * this.getSectorsPerCluster();
    }

    public int getFsInfoSectorNumber() {
        return this.fsInfoSectorNumber;
    }

    public void setFsInfoSectorNumber(int fsInfoSectorNumber) {
        this.fsInfoSectorNumber = fsInfoSectorNumber;
    }

    public int getFatSectorNumber() {
        return this.fatSectorNumber;
    }

    public void setFatSectorNumber(int fatSectorNumber) {
        this.fatSectorNumber = fatSectorNumber;
    }

    private void reset() {
        int usedSectors = 32 + this.fatSectors * 2;
        int maxNumberClusters = (this.totalSectors - (usedSectors += this.getFirstDataClusterOffset())) / this.getSectorsPerCluster();
        this.fatClusterMap = new int[maxNumberClusters];
        this.fatClusterMap[0] = 0xFFFFFFF8 & this.getClusterMask();
        this.fatClusterMap[1] = 0xFFFFFFFF & this.getClusterMask();
        this.fatFileInfoMap = new FatFileInfo[maxNumberClusters];
        Arrays.fill(this.secondFat, (byte)0);
        this.builder = new FatBuilder(this, this.vfs, maxNumberClusters);
    }

    public void scan() {
        this.builder.scan(this.deviceName);
    }

    private void extendClusterMap(int clusterNumber) {
        int extend = clusterNumber + 1 - this.fatClusterMap.length;
        if (extend > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("extendClusterMap clusterNumber=0x%X, extend=0x%X", clusterNumber, extend));
            }
            this.fatClusterMap = Utilities.extendArray(this.fatClusterMap, extend);
            this.fatFileInfoMap = FatUtils.extendArray(this.fatFileInfoMap, extend);
        }
    }

    public void setFatFileInfoMap(FatFileInfo fileInfo) {
        int[] clusters;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("setFatFileInfoMap %s", fileInfo));
        }
        if ((clusters = fileInfo.getClusters()) != null) {
            for (int i = 0; i < clusters.length; ++i) {
                this.setFatFileInfoMap(clusters[i], fileInfo);
            }
        }
    }

    public void setFatFileInfoMap(int clusterNumber, FatFileInfo fileInfo) {
        if (clusterNumber >= this.fatFileInfoMap.length) {
            this.extendClusterMap(clusterNumber);
        }
        this.fatFileInfoMap[clusterNumber] = fileInfo;
    }

    public void setFatClusterMap(int clusterNumber, int value) {
        if (clusterNumber >= this.fatClusterMap.length) {
            this.extendClusterMap(clusterNumber);
        }
        this.fatClusterMap[clusterNumber] = value;
    }

    private int getClusterNumber(int sectorNumber) {
        sectorNumber -= this.fatSectorNumber;
        sectorNumber -= 2 * this.fatSectors;
        return 2 + (sectorNumber -= this.getFirstDataClusterOffset()) / this.getSectorsPerCluster();
    }

    private int getSectorOffsetInCluster(int sectorNumber) {
        sectorNumber -= this.fatSectorNumber;
        sectorNumber -= 2 * this.fatSectors;
        return (sectorNumber -= this.getFirstDataClusterOffset()) % this.getSectorsPerCluster();
    }

    protected String getOEMName() {
        return "";
    }

    private void readBootSector() {
        this.readEmptySector();
        FatUtils.storeSectorInt8(this.currentSector, 0, 235);
        FatUtils.storeSectorInt8(this.currentSector, 1, 88);
        FatUtils.storeSectorInt8(this.currentSector, 2, 144);
        FatUtils.storeSectorString(this.currentSector, 3, this.getOEMName(), 8);
        this.readBIOSParameterBlock();
        FatUtils.storeSectorInt8(this.currentSector, 510, 85);
        FatUtils.storeSectorInt8(this.currentSector, 511, 170);
    }

    private void readFsInfoSector() {
        this.readEmptySector();
        FatUtils.storeSectorInt8(this.currentSector, 0, 82);
        FatUtils.storeSectorInt8(this.currentSector, 1, 82);
        FatUtils.storeSectorInt8(this.currentSector, 2, 97);
        FatUtils.storeSectorInt8(this.currentSector, 3, 65);
        FatUtils.storeSectorInt8(this.currentSector, 484, 114);
        FatUtils.storeSectorInt8(this.currentSector, 485, 114);
        FatUtils.storeSectorInt8(this.currentSector, 486, 65);
        FatUtils.storeSectorInt8(this.currentSector, 487, 97);
        FatUtils.storeSectorInt32(this.currentSector, 488, -1);
        FatUtils.storeSectorInt32(this.currentSector, 492, -1);
        FatUtils.storeSectorInt8(this.currentSector, 510, 85);
        FatUtils.storeSectorInt8(this.currentSector, 511, 170);
    }

    protected abstract void readFatSector(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDataSector(int sectorNumber, int clusterNumber, int sectorOffsetInCluster, FatFileInfo fileInfo) {
        this.readEmptySector();
        if (fileInfo == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("readDataSector unknown sectorNumber=0x%X, clusterNumber=0x%X", sectorNumber, clusterNumber));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readDataSector clusterNumber=0x%X(sector=0x%X), fileInfo=%s", clusterNumber, sectorOffsetInCluster, fileInfo));
        }
        if (fileInfo.isDirectory()) {
            int byteOffset;
            byte[] directoryData = fileInfo.getFileData();
            if (directoryData == null) {
                directoryData = this.builder.buildDirectoryData(fileInfo);
                fileInfo.setFileData(directoryData);
            }
            if ((byteOffset = sectorOffsetInCluster * 512) < directoryData.length) {
                int length = Math.min(directoryData.length - byteOffset, 512);
                System.arraycopy(directoryData, byteOffset, this.currentSector, 0, length);
            }
        } else {
            IVirtualFile vFile = fileInfo.getVirtualFile(this.vfs);
            if (vFile == null) {
                log.error((Object)String.format("readDataSector cannot read file %s", fileInfo));
                return;
            }
            long byteOffset = (long)sectorOffsetInCluster * 512L;
            int[] clusters = fileInfo.getClusters();
            if (clusters != null) {
                for (int i = 0; i < clusters.length && clusters[i] != clusterNumber; ++i) {
                    byteOffset += (long)(this.getSectorsPerCluster() * 512);
                }
            }
            if (byteOffset < fileInfo.getFileSize()) {
                int readLength;
                int length = (int)Math.min(fileInfo.getFileSize() - byteOffset, 512L);
                IVirtualFile iVirtualFile = vFile;
                synchronized (iVirtualFile) {
                    if (vFile.ioLseek(byteOffset) != byteOffset) {
                        log.error((Object)String.format("readDataSector cannot seek file '%s' to 0x%X", fileInfo, byteOffset));
                        return;
                    }
                    readLength = vFile.ioRead(this.currentSector, 0, length);
                }
                if (readLength != length) {
                    log.error((Object)String.format("readDataSector cannot read sector readLength=0x%X(max length=0x%X, byteOffset=0x%X, fileSize=0x%X)", readLength, length, byteOffset, fileInfo.getFileSize()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("readDataSector readLength=0x%X(max length=0x%X, byteOffset=0x%X, fileSize=0x%X)", readLength, length, byteOffset, fileInfo.getFileSize()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("readDataSector trying to read at offset 0x%X past end of file", byteOffset, fileInfo));
            }
        }
    }

    private void readRootDirectory(int sectorNumber) {
        this.readDataSector(this.rootDirectoryStartSectorNumber, 0, sectorNumber, this.rootDirectory);
    }

    private void readDataSector(int sectorNumber) {
        this.readEmptySector();
        int clusterNumber = this.getClusterNumber(sectorNumber);
        if (clusterNumber >= this.fatFileInfoMap.length) {
            return;
        }
        FatFileInfo fileInfo = this.fatFileInfoMap[clusterNumber];
        int sectorOffsetInCluster = this.getSectorOffsetInCluster(sectorNumber);
        this.readDataSector(sectorNumber, clusterNumber, sectorOffsetInCluster, fileInfo);
    }

    private void readSecondFatSector(int fatIndex) {
        System.arraycopy(this.secondFat, fatIndex * 512, this.currentSector, 0, 512);
    }

    protected void readEmptySector() {
        System.arraycopy(emptySector, 0, this.currentSector, 0, 512);
    }

    private void readSector(int sectorNumber) {
        if (sectorNumber == 0) {
            this.readBootSector();
        } else if (sectorNumber == this.fsInfoSectorNumber) {
            this.readFsInfoSector();
        } else if (sectorNumber < this.fatSectorNumber) {
            this.readEmptySector();
        } else if (sectorNumber >= this.fatSectorNumber && sectorNumber < this.fatSectorNumber + this.fatSectors) {
            this.readFatSector(sectorNumber - this.fatSectorNumber);
        } else if (sectorNumber >= this.fatSectorNumber + this.fatSectors && sectorNumber < this.fatSectorNumber + 2 * this.fatSectors) {
            this.readSecondFatSector(sectorNumber - this.fatSectorNumber - this.fatSectors);
        } else if (sectorNumber >= this.rootDirectoryStartSectorNumber && sectorNumber <= this.rootDirectoryEndSectorNumber) {
            this.readRootDirectory(sectorNumber - this.rootDirectoryStartSectorNumber);
        } else {
            this.readDataSector(sectorNumber);
        }
    }

    private void writeBootSector() {
        log.warn((Object)String.format("Writing to the MemoryStick boot sector!", new Object[0]));
        this.writeEmptySector();
    }

    private void writeFsInfoSector() {
        log.warn((Object)String.format("Writing to the MemoryStick FsInfo sector!", new Object[0]));
        this.writeEmptySector();
    }

    protected void writeFatSectorEntry(int clusterNumber, int value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeFatSectorEntry[0x%X]=0x%08X", clusterNumber, value));
        }
        this.fatClusterMap[clusterNumber] = value;
    }

    protected abstract void writeFatSector(int var1);

    private static String getFileNameLFN(byte[] lfn) {
        boolean last = false;
        byte[] fileNameBytes = null;
        int sequenceNumber = 1;
        while (!last) {
            for (int i = 0; i < lfn.length; i += 32) {
                if ((lfn[i + 0] & 0x1F) != sequenceNumber) continue;
                if ((lfn[i + 0] & 0x40) != 0) {
                    last = true;
                }
                fileNameBytes = Utilities.extendArray(fileNameBytes, lfn, i + 1, 10);
                fileNameBytes = Utilities.extendArray(fileNameBytes, lfn, i + 14, 12);
                fileNameBytes = Utilities.extendArray(fileNameBytes, lfn, i + 28, 4);
                break;
            }
            ++sequenceNumber;
        }
        if (fileNameBytes == null) {
            return "";
        }
        for (int i = 0; i < fileNameBytes.length; i += 2) {
            if (fileNameBytes[i] != false || fileNameBytes[i + 1] != false) continue;
            return new String(fileNameBytes, 0, i, pspAbstractMemoryMappedStructure.charset16);
        }
        return new String(fileNameBytes, pspAbstractMemoryMappedStructure.charset16);
    }

    public static String getFileName(byte[] sector, int offset, byte[] lfn) {
        String fileName;
        if (lfn != null) {
            fileName = FatVirtualFile.getFileNameLFN(lfn);
        } else {
            String name = FatUtils.readSectorString(sector, offset + 0, 8);
            String ext = FatUtils.readSectorString(sector, offset + 8, 3);
            fileName = ext.length() == 0 ? name : name + '.' + ext;
        }
        return fileName;
    }

    public static boolean isLongFileNameDirectoryEntry(byte[] directoryData, int offset) {
        return directoryData[offset + 11] == 15;
    }

    private long getByteOffset(FatFileInfo fileInfo, int sectorNumber) {
        int clusterNumber = this.getClusterNumber(sectorNumber);
        int sectorOffsetInCluster = this.getSectorOffsetInCluster(sectorNumber);
        long byteOffset = (long)sectorOffsetInCluster * 512L;
        int[] clusters = fileInfo.getClusters();
        if (clusters != null) {
            for (int i = 0; i < clusters.length && clusters[i] != clusterNumber; ++i) {
                byteOffset += (long)this.getClusterSize();
            }
        }
        return byteOffset;
    }

    private static boolean isEmpty(byte[] sector, int offset) {
        for (int i = offset; i < 512; ++i) {
            if (sector[i] == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFileSector(FatFileInfo fileInfo, long byteOffset, byte[] sector) {
        int length;
        IVirtualFile vFile = fileInfo.getVirtualFile(this.vfs);
        if (vFile == null) {
            log.warn((Object)String.format("writeFileSector cannot write file '%s'", fileInfo));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeFileSector byteOffset=0x%X for %s", byteOffset, fileInfo));
        }
        if ((length = (int)Math.min(fileInfo.getFileSize() - byteOffset, 512L)) < 0 || !FatVirtualFile.isEmpty(sector, length)) {
            log.warn((Object)String.format("writeFileSector writing past end of file '%s'", fileInfo));
            return false;
        }
        IVirtualFile iVirtualFile = vFile;
        synchronized (iVirtualFile) {
            if (vFile.ioLseek(byteOffset) != byteOffset) {
                log.warn((Object)String.format("writeFileSector cannot seek file '%s' to 0x%X", fileInfo, byteOffset));
                return false;
            }
            int writeLength = vFile.ioWrite(sector, 0, length);
            if (writeLength != length) {
                log.warn((Object)String.format("writeFileSector cannot write file 0x%X bytes to file '%s': result 0x%X", length, fileInfo, writeLength));
                return false;
            }
        }
        return true;
    }

    private void writeDataSector(int sectorNumber, int clusterNumber, int sectorOffsetInCluster, FatFileInfo fileInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeDataSector clusterNumber=0x%X(sector=0x%X), fileInfo=%s", clusterNumber, sectorOffsetInCluster, fileInfo));
        }
        if (fileInfo.isDirectory()) {
            byte[] directoryData = fileInfo.getFileData();
            if (directoryData == null) {
                directoryData = this.builder.buildDirectoryData(fileInfo);
                fileInfo.setFileData(directoryData);
            }
            int byteOffset = sectorOffsetInCluster * 512;
            int sectorLength = 512;
            directoryData = Utilities.copyToArrayAndExtend(directoryData, byteOffset, this.currentSector, 0, sectorLength);
            fileInfo.setFileData(directoryData);
        } else {
            this.writeFileSector(fileInfo, this.getByteOffset(fileInfo, sectorNumber), this.currentSector);
        }
    }

    private void writeRootDirectory(int sectorNumber) {
        this.writeDataSector(this.rootDirectoryStartSectorNumber, 0, sectorNumber, this.rootDirectory);
    }

    private void writeDataSector(int sectorNumber) {
        int clusterNumber = this.getClusterNumber(sectorNumber);
        int sectorOffsetInCluster = this.getSectorOffsetInCluster(sectorNumber);
        FatFileInfo fileInfo = this.fatFileInfoMap[clusterNumber];
        this.writeDataSector(sectorNumber, clusterNumber, sectorOffsetInCluster, fileInfo);
    }

    private void writeSecondFatSector(int fatIndex) {
        System.arraycopy(this.currentSector, 0, this.secondFat, fatIndex * 512, 512);
    }

    private void writeEmptySector() {
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    private void writeSector(int sectorNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeSector 0x%X", sectorNumber));
        }
        if (sectorNumber == 0) {
            this.writeBootSector();
        } else if (sectorNumber == this.fsInfoSectorNumber) {
            this.writeFsInfoSector();
        } else if (sectorNumber < this.fatSectorNumber) {
            this.writeEmptySector();
        } else if (sectorNumber >= this.fatSectorNumber && sectorNumber < this.fatSectorNumber + this.fatSectors) {
            this.writeFatSector(sectorNumber - this.fatSectorNumber);
        } else if (sectorNumber >= this.fatSectorNumber + this.fatSectors && sectorNumber < this.fatSectorNumber + 2 * this.fatSectors) {
            this.writeSecondFatSector(sectorNumber - this.fatSectorNumber - this.fatSectors);
        } else if (sectorNumber >= this.rootDirectoryStartSectorNumber && sectorNumber <= this.rootDirectoryEndSectorNumber) {
            this.writeRootDirectory(sectorNumber - this.rootDirectoryStartSectorNumber);
        } else {
            this.writeDataSector(sectorNumber);
        }
    }

    @Override
    public synchronized int ioRead(TPointer outputPointer, int outputLength) {
        int readLength = 0;
        int outputOffset = 0;
        while (outputLength > 0) {
            int sectorNumber = FatUtils.getSectorNumber(this.position);
            this.readSector(sectorNumber);
            int sectorOffset = FatUtils.getSectorOffset(this.position);
            int sectorLength = 512 - sectorOffset;
            int length = Math.min(sectorLength, outputLength);
            outputPointer.setArray(outputOffset, this.currentSector, sectorOffset, length);
            outputLength -= length;
            outputOffset += length;
            this.position += (long)length;
            readLength += length;
        }
        return readLength;
    }

    @Override
    public synchronized int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength = 0;
        while (outputLength > 0) {
            int sectorNumber = FatUtils.getSectorNumber(this.position);
            this.readSector(sectorNumber);
            int sectorOffset = FatUtils.getSectorOffset(this.position);
            int sectorLength = 512 - sectorOffset;
            int length = Math.min(sectorLength, outputLength);
            System.arraycopy(this.currentSector, sectorOffset, outputBuffer, outputOffset, length);
            outputLength -= length;
            outputOffset += length;
            this.position += (long)length;
            readLength += length;
        }
        return readLength;
    }

    @Override
    public synchronized int ioWrite(TPointer inputPointer, int inputLength) {
        return inputLength;
    }

    @Override
    public synchronized int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return inputLength;
    }

    @Override
    public synchronized long ioLseek(long offset) {
        this.position = offset;
        return this.position;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return -1;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public IVirtualFile duplicate() {
        return null;
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.noDelayTimings;
    }

    @Override
    public synchronized int ioClose() {
        this.closeCachedFiles();
        this.vfs.ioExit();
        this.vfs = null;
        return 0;
    }

    @Override
    public synchronized void read(StateInputStream stream) throws IOException {
        int i;
        stream.readVersion(0);
        this.deviceName = stream.readString();
        this.position = stream.readLong();
        this.totalSectors = stream.readInt();
        this.fatSectors = stream.readInt();
        this.fatClusterMap = stream.readIntsWithLength();
        this.fatFileInfoMap = new FatFileInfo[this.fatClusterMap.length];
        LinkedList<FatFileInfo> fatFileInfoList = new LinkedList<FatFileInfo>();
        while ((i = stream.readInt()) >= 0) {
            int alreadyReadIndex = stream.readInt();
            if (alreadyReadIndex < 0) {
                FatFileInfo fatFileInfo;
                this.fatFileInfoMap[i] = fatFileInfo = new FatFileInfo();
                fatFileInfo.read(stream);
                fatFileInfoList.add(fatFileInfo);
                continue;
            }
            this.fatFileInfoMap[i] = this.fatFileInfoMap[alreadyReadIndex];
        }
        for (FatFileInfo fatFileInfo : fatFileInfoList) {
            fatFileInfo.read(stream, this);
        }
    }

    @Override
    public synchronized void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeString(this.deviceName);
        stream.writeLong(this.position);
        stream.writeInt(this.totalSectors);
        stream.writeInt(this.fatSectors);
        stream.writeIntsWithLength(this.fatClusterMap);
        HashMap<FatFileInfo, Integer> alreadyWritten = new HashMap<FatFileInfo, Integer>();
        LinkedList<FatFileInfo> fatFileInfoList = new LinkedList<FatFileInfo>();
        for (int i = 0; i < this.fatFileInfoMap.length; ++i) {
            FatFileInfo fatFileInfo = this.fatFileInfoMap[i];
            if (fatFileInfo == null) continue;
            stream.writeInt(i);
            Integer alreadyWrittenIndex = (Integer)alreadyWritten.get(fatFileInfo);
            if (alreadyWrittenIndex != null) {
                stream.writeInt(alreadyWrittenIndex);
                continue;
            }
            stream.writeInt(-1);
            fatFileInfo.write(stream);
            alreadyWritten.put(fatFileInfo, i);
            fatFileInfoList.add(fatFileInfo);
        }
        stream.writeInt(-1);
        for (FatFileInfo fatFileInfo : fatFileInfoList) {
            fatFileInfo.write(stream, this);
        }
    }

    private int getFatFileInfoMapIndex(FatFileInfo info) {
        if (info != null) {
            for (int i = 0; i < this.fatFileInfoMap.length; ++i) {
                if (info != this.fatFileInfoMap[i]) continue;
                return i;
            }
        }
        return -1;
    }

    private FatFileInfo getFatFileInfoFromMapIndex(int index) {
        if (index < 0 || index >= this.fatFileInfoMap.length) {
            return null;
        }
        return this.fatFileInfoMap[index];
    }

    public FatFileInfo readFatFileInfo(StateInputStream stream) throws IOException {
        int mapIndex = stream.readInt();
        return this.getFatFileInfoFromMapIndex(mapIndex);
    }

    public void writeFatFileInfo(StateOutputStream stream, FatFileInfo info) throws IOException {
        int mapIndex = this.getFatFileInfoMapIndex(info);
        stream.writeInt(mapIndex);
    }

    @Override
    public void invalidateCachedData() {
    }

    private void readAllDirectories(String dirName, IVirtualFileSystem vfs) {
        String[] names = vfs.ioDopen(dirName);
        if (names == null || names.length == 0) {
            return;
        }
        SceIoStat stat = new SceIoStat();
        SceIoDirent dir = new SceIoDirent(stat, null);
        for (int i = 0; i < names.length; ++i) {
            boolean directory;
            if (".".equals(names[i]) || "..".equals(names[i])) continue;
            dir.filename = names[i];
            if (vfs.ioDread(dirName, dir) < 0 || !(directory = Utilities.hasFlag(dir.stat.attr, 16))) continue;
            if (dirName == null) {
                this.readAllDirectories(dir.filename, vfs);
                continue;
            }
            this.readAllDirectories(dirName + "/" + dir.filename, vfs);
        }
    }

    private void setFatFileInfoMapRecursive(FatVirtualFileSystem fatVirtualFileSystem, int clusterNumber, FatFileInfo parentDirectory) {
        FatFileInfo[] fatFileInfos = fatVirtualFileSystem.getDirectoryEntries(clusterNumber);
        if (fatFileInfos != null) {
            String dirName = null;
            if (parentDirectory != null) {
                dirName = parentDirectory.getFullFileName();
            }
            for (FatFileInfo fatFileInfo : fatFileInfos) {
                int directoryClusterNumber;
                fatFileInfo.setParentDirectory(parentDirectory);
                fatFileInfo.setDirName(dirName);
                parentDirectory.addChild(fatFileInfo);
                this.setFatFileInfoMap(fatFileInfo);
                if (!fatFileInfo.isDirectory() || (directoryClusterNumber = fatFileInfo.getFirstCluster()) == 0) continue;
                this.setFatFileInfoMapRecursive(fatVirtualFileSystem, directoryClusterNumber, fatFileInfo);
            }
        }
    }

    @Override
    public synchronized void flushCachedData() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("flushCachedData: rebuilding the FAT", new Object[0]));
        }
        ReadCacheVirtualFile directoriesVirtualFile = new ReadCacheVirtualFile(log, this.baseVirtualFile);
        FatVirtualFileSystem fatVirtualFileSystem = new FatVirtualFileSystem(this.deviceName, directoriesVirtualFile);
        this.readAllDirectories(null, fatVirtualFileSystem);
        directoriesVirtualFile.setProxyVirtualFile(new InvalidVirtualFile());
        this.closeCachedFiles();
        this.reset();
        System.arraycopy(fatVirtualFileSystem.getFatClusterMap(), 0, this.fatClusterMap, 0, this.fatClusterMap.length);
        int rootDirectoryClusterNumber = fatVirtualFileSystem.getRootDirectoryClusterNumber();
        FatFileInfo rootDirectory = new FatFileInfo(this.getDeviceName(), null, null, true, false, null, 0L);
        rootDirectory.addCluster(rootDirectoryClusterNumber);
        this.setFatFileInfoMapRecursive(fatVirtualFileSystem, rootDirectoryClusterNumber, rootDirectory);
        this.setFatFileInfoMap(rootDirectory);
    }

    @Override
    public synchronized void closeCachedFiles() {
        for (FatFileInfo fatFileInfo : this.fatFileInfoMap) {
            if (fatFileInfo == null) continue;
            fatFileInfo.closeVirtualFile();
        }
    }

    public String toString() {
        return String.format("%s%s", this.deviceName == null ? "" : this.deviceName, this.vfs);
    }
}

