/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.ThreadWaitingListFIFO;
import jpcsp.HLE.kernel.managers.ThreadWaitingListPriority;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;

public abstract class ThreadWaitingList {
    protected List<Integer> waitingThreads = new LinkedList<Integer>();
    protected int waitType;
    protected int waitId;

    public static ThreadWaitingList createThreadWaitingList(int waitType, int waitId, int attr, int attrPrioriyFlag) {
        if ((attr & attrPrioriyFlag) == attrPrioriyFlag) {
            return new ThreadWaitingListPriority(waitType, waitId);
        }
        return new ThreadWaitingListFIFO(waitType, waitId);
    }

    protected ThreadWaitingList(int waitType, int waitId) {
        this.waitType = waitType;
        this.waitId = waitId;
    }

    public int getNumWaitingThreads() {
        return this.waitingThreads.size();
    }

    public abstract void addWaitingThread(SceKernelThreadInfo var1);

    public void removeWaitingThread(SceKernelThreadInfo thread) {
        this.waitingThreads.remove((Object)thread.uid);
    }

    public SceKernelThreadInfo getNextWaitingThread(SceKernelThreadInfo baseThread) {
        if (baseThread == null) {
            return this.getFirstWaitingThread();
        }
        int index = this.waitingThreads.indexOf(baseThread.uid);
        if (index < 0 || index + 1 >= this.getNumWaitingThreads()) {
            return null;
        }
        int uid = this.waitingThreads.get(index + 1);
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getThreadById(uid);
        if (thread == null) {
            this.waitingThreads.remove(index + 1);
            return this.getNextWaitingThread(baseThread);
        }
        if (!thread.isWaitingForType(this.waitType) || thread.waitId != this.waitId) {
            this.waitingThreads.remove(index + 1);
            return this.getNextWaitingThread(baseThread);
        }
        return thread;
    }

    public SceKernelThreadInfo getFirstWaitingThread() {
        if (this.getNumWaitingThreads() <= 0) {
            return null;
        }
        int uid = this.waitingThreads.get(0);
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getThreadById(uid);
        if (thread == null) {
            this.waitingThreads.remove(0);
            return this.getFirstWaitingThread();
        }
        if (!thread.isWaitingForType(this.waitType) || thread.waitId != this.waitId) {
            this.waitingThreads.remove(0);
            return this.getFirstWaitingThread();
        }
        return thread;
    }

    public void removeAllWaitingThreads() {
        this.waitingThreads.clear();
    }
}

