/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;

public class SceIoStat
extends pspAbstractMemoryMappedStructure {
    public static final int SIZEOF = 88;
    public int mode;
    public int attr;
    public long size;
    public ScePspDateTime ctime;
    public ScePspDateTime atime;
    public ScePspDateTime mtime;
    private int[] reserved = new int[]{0, 0, 0, 0, 0, 0};

    public SceIoStat() {
    }

    public SceIoStat(int mode, int attr, long size, ScePspDateTime ctime, ScePspDateTime atime, ScePspDateTime mtime) {
        this.init(mode, attr, size, ctime, atime, mtime);
    }

    public void init(int mode, int attr, long size, ScePspDateTime ctime, ScePspDateTime atime, ScePspDateTime mtime) {
        this.mode = mode;
        this.attr = attr;
        this.size = size;
        this.ctime = ctime;
        this.atime = atime;
        this.mtime = mtime;
    }

    public void setReserved(int index, int value) {
        this.reserved[index] = value;
    }

    public int getReserved(int index) {
        return this.reserved[index];
    }

    public void setStartSector(int value) {
        this.setReserved(0, value);
    }

    public int getStartSector() {
        return this.getReserved(0);
    }

    @Override
    protected void read() {
        this.mode = this.read32();
        this.attr = this.read32();
        this.size = this.read64();
        this.ctime = new ScePspDateTime();
        this.atime = new ScePspDateTime();
        this.mtime = new ScePspDateTime();
        this.read(this.ctime);
        this.read(this.atime);
        this.read(this.mtime);
        this.read32Array(this.reserved);
    }

    @Override
    protected void write() {
        this.write32(this.mode);
        this.write32(this.attr);
        this.write64(this.size);
        this.write(this.ctime);
        this.write(this.atime);
        this.write(this.mtime);
        this.write32Array(this.reserved);
    }

    @Override
    public int sizeof() {
        return 88;
    }

    @Override
    public String toString() {
        return String.format("SceIoStat[mode=0x%X, attr=0x%X, size=0x%X, ctime=%s, atime=%s, mtime=%s]", this.mode, this.attr, this.size, this.ctime, this.atime, this.mtime);
    }
}

